/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.view;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.view.ViewCompat;
import dji.v5.ux.core.base.charts.animation.ChartAnimationListener;
import dji.v5.ux.core.base.charts.animation.ChartDataAnimator;
import dji.v5.ux.core.base.charts.animation.ChartDataAnimatorV14;
import dji.v5.ux.core.base.charts.animation.ChartDataAnimatorV8;
import dji.v5.ux.core.base.charts.animation.ChartViewportAnimator;
import dji.v5.ux.core.base.charts.animation.ChartViewportAnimatorV14;
import dji.v5.ux.core.base.charts.animation.ChartViewportAnimatorV8;
import dji.v5.ux.core.base.charts.computator.ChartComputator;
import dji.v5.ux.core.base.charts.gesture.ChartTouchHandler;
import dji.v5.ux.core.base.charts.gesture.ContainerScrollType;
import dji.v5.ux.core.base.charts.gesture.ZoomType;
import dji.v5.ux.core.base.charts.listener.ViewportChangeListener;
import dji.v5.ux.core.base.charts.model.SelectedValue;
import dji.v5.ux.core.base.charts.model.Viewport;
import dji.v5.ux.core.base.charts.renderer.AxesRenderer;
import dji.v5.ux.core.base.charts.renderer.ChartRenderer;
import dji.v5.ux.core.base.charts.util.ChartUtils;
import dji.v5.ux.core.base.charts.view.Chart;

public abstract class AbstractChartView
extends View
implements Chart {
    protected ChartComputator chartComputator = new ChartComputator();
    protected AxesRenderer axesRenderer;
    protected ChartTouchHandler touchHandler;
    protected ChartRenderer chartRenderer;
    protected ChartDataAnimator dataAnimator;
    protected ChartViewportAnimator viewportAnimator;
    protected boolean isInteractive = true;
    protected boolean isContainerScrollEnabled = false;
    protected ContainerScrollType containerScrollType;

    protected AbstractChartView(Context context) {
        this(context, null, 0);
    }

    protected AbstractChartView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    protected AbstractChartView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.touchHandler = new ChartTouchHandler(context, this);
        this.axesRenderer = new AxesRenderer(context, this);
        if (Build.VERSION.SDK_INT < 14) {
            this.dataAnimator = new ChartDataAnimatorV8(this);
            this.viewportAnimator = new ChartViewportAnimatorV8(this);
        } else {
            this.viewportAnimator = new ChartViewportAnimatorV14(this);
            this.dataAnimator = new ChartDataAnimatorV14(this);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.chartComputator.setContentRect(this.getWidth(), this.getHeight(), this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        this.chartRenderer.onChartSizeChanged();
        this.axesRenderer.onChartSizeChanged();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isEnabled()) {
            this.axesRenderer.drawInBackground(canvas);
            int clipRestoreCount = canvas.save();
            canvas.clipRect(this.chartComputator.getContentRectMinusAllMargins());
            this.chartRenderer.draw(canvas);
            canvas.restoreToCount(clipRestoreCount);
            this.chartRenderer.drawUnclipped(canvas);
            this.axesRenderer.drawInForeground(canvas);
        } else {
            canvas.drawColor(ChartUtils.DEFAULT_COLOR);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.isInteractive) {
            boolean needInvalidate = this.isContainerScrollEnabled ? this.touchHandler.handleTouchEvent(event, this.getParent(), this.containerScrollType) : this.touchHandler.handleTouchEvent(event);
            if (needInvalidate) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
            return true;
        }
        return false;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.isInteractive && this.touchHandler.computeScroll()) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    @Override
    public void startDataAnimation() {
        this.dataAnimator.startAnimation(Long.MIN_VALUE);
    }

    @Override
    public void startDataAnimation(long duration) {
        this.dataAnimator.startAnimation(duration);
    }

    @Override
    public void cancelDataAnimation() {
        this.dataAnimator.cancelAnimation();
    }

    @Override
    public void animationDataUpdate(float scale) {
        this.getChartData().update(scale);
        this.chartRenderer.onChartViewportChanged();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void animationDataFinished() {
        this.getChartData().finish();
        this.chartRenderer.onChartViewportChanged();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void setDataAnimationListener(ChartAnimationListener animationListener) {
        this.dataAnimator.setChartAnimationListener(animationListener);
    }

    @Override
    public void setViewportAnimationListener(ChartAnimationListener animationListener) {
        this.viewportAnimator.setChartAnimationListener(animationListener);
    }

    @Override
    public void setViewportChangeListener(ViewportChangeListener viewportChangeListener) {
        this.chartComputator.setViewportChangeListener(viewportChangeListener);
    }

    @Override
    public ChartRenderer getChartRenderer() {
        return this.chartRenderer;
    }

    @Override
    public void setChartRenderer(ChartRenderer renderer) {
        this.chartRenderer = renderer;
        this.resetRendererAndTouchHandler();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public AxesRenderer getAxesRenderer() {
        return this.axesRenderer;
    }

    @Override
    public ChartComputator getChartComputator() {
        return this.chartComputator;
    }

    @Override
    public ChartTouchHandler getTouchHandler() {
        return this.touchHandler;
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    public void setInteractive(boolean isInteractive) {
        this.isInteractive = isInteractive;
    }

    @Override
    public boolean isZoomEnabled() {
        return this.touchHandler.isZoomEnabled();
    }

    @Override
    public void setZoomEnabled(boolean isZoomEnabled) {
        this.touchHandler.setZoomEnabled(isZoomEnabled);
    }

    @Override
    public boolean isScrollEnabled() {
        return this.touchHandler.isScrollEnabled();
    }

    @Override
    public void setScrollEnabled(boolean isScrollEnabled) {
        this.touchHandler.setScrollEnabled(isScrollEnabled);
    }

    @Override
    public void moveTo(float x, float y) {
        Viewport scrollViewport = this.computeScrollViewport(x, y);
        this.setCurrentViewport(scrollViewport);
    }

    @Override
    public void moveToWithAnimation(float x, float y) {
        Viewport scrollViewport = this.computeScrollViewport(x, y);
        this.setCurrentViewportWithAnimation(scrollViewport);
    }

    private Viewport computeScrollViewport(float x, float y) {
        Viewport maxViewport = this.getMaximumViewport();
        Viewport currentViewport = this.getCurrentViewport();
        Viewport scrollViewport = new Viewport(currentViewport);
        if (maxViewport.contains(x, y)) {
            float width = currentViewport.width();
            float height = currentViewport.height();
            float halfWidth = width / 2.0f;
            float halfHeight = height / 2.0f;
            float left = x - halfWidth;
            float top = y + halfHeight;
            left = Math.max(maxViewport.left, Math.min(left, maxViewport.right - width));
            top = Math.max(maxViewport.bottom + height, Math.min(top, maxViewport.top));
            scrollViewport.set(left, top, left + width, top - height);
        }
        return scrollViewport;
    }

    @Override
    public boolean isValueTouchEnabled() {
        return this.touchHandler.isValueTouchEnabled();
    }

    @Override
    public void setValueTouchEnabled(boolean isValueTouchEnabled) {
        this.touchHandler.setValueTouchEnabled(isValueTouchEnabled);
    }

    @Override
    public ZoomType getZoomType() {
        return this.touchHandler.getZoomType();
    }

    @Override
    public void setZoomType(ZoomType zoomType) {
        this.touchHandler.setZoomType(zoomType);
    }

    @Override
    public float getMaxZoom() {
        return this.chartComputator.getMaxZoom();
    }

    @Override
    public void setMaxZoom(float maxZoom) {
        this.chartComputator.setMaxZoom(maxZoom);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public float getZoomLevel() {
        Viewport maxViewport = this.getMaximumViewport();
        Viewport currentViewport = this.getCurrentViewport();
        return Math.max(maxViewport.width() / currentViewport.width(), maxViewport.height() / currentViewport.height());
    }

    @Override
    public void setZoomLevel(float x, float y, float zoomLevel) {
        Viewport zoomViewport = this.computeZoomViewport(x, y, zoomLevel);
        this.setCurrentViewport(zoomViewport);
    }

    @Override
    public void setZoomLevelWithAnimation(float x, float y, float zoomLevel) {
        Viewport zoomViewport = this.computeZoomViewport(x, y, zoomLevel);
        this.setCurrentViewportWithAnimation(zoomViewport);
    }

    private Viewport computeZoomViewport(float x, float y, float zoomLevel) {
        Viewport maxViewport = this.getMaximumViewport();
        Viewport zoomViewport = new Viewport(this.getMaximumViewport());
        if (maxViewport.contains(x, y)) {
            if (zoomLevel < 1.0f) {
                zoomLevel = 1.0f;
            } else if (zoomLevel > this.getMaxZoom()) {
                zoomLevel = this.getMaxZoom();
            }
            float newWidth = zoomViewport.width() / zoomLevel;
            float newHeight = zoomViewport.height() / zoomLevel;
            float halfWidth = newWidth / 2.0f;
            float halfHeight = newHeight / 2.0f;
            float left = x - halfWidth;
            float right = x + halfWidth;
            float top = y + halfHeight;
            float bottom = y - halfHeight;
            if (left < maxViewport.left) {
                left = maxViewport.left;
                right = left + newWidth;
            } else if (right > maxViewport.right) {
                right = maxViewport.right;
                left = right - newWidth;
            }
            if (top > maxViewport.top) {
                top = maxViewport.top;
                bottom = top - newHeight;
            } else if (bottom < maxViewport.bottom) {
                bottom = maxViewport.bottom;
                top = bottom + newHeight;
            }
            ZoomType zoomType = this.getZoomType();
            if (ZoomType.HORIZONTAL_AND_VERTICAL == zoomType) {
                zoomViewport.set(left, top, right, bottom);
            } else if (ZoomType.HORIZONTAL == zoomType) {
                zoomViewport.left = left;
                zoomViewport.right = right;
            } else if (ZoomType.VERTICAL == zoomType) {
                zoomViewport.top = top;
                zoomViewport.bottom = bottom;
            }
        }
        return zoomViewport;
    }

    @Override
    public Viewport getMaximumViewport() {
        return this.chartRenderer.getMaximumViewport();
    }

    @Override
    public void setMaximumViewport(Viewport maxViewport) {
        this.chartRenderer.setMaximumViewport(maxViewport);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void setCurrentViewportWithAnimation(Viewport targetViewport) {
        if (null != targetViewport) {
            this.viewportAnimator.cancelAnimation();
            this.viewportAnimator.startAnimation(this.getCurrentViewport(), targetViewport);
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void setCurrentViewportWithAnimation(Viewport targetViewport, long duration) {
        if (null != targetViewport) {
            this.viewportAnimator.cancelAnimation();
            this.viewportAnimator.startAnimation(this.getCurrentViewport(), targetViewport, duration);
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public Viewport getCurrentViewport() {
        return this.getChartRenderer().getCurrentViewport();
    }

    @Override
    public void setCurrentViewport(Viewport targetViewport) {
        if (null != targetViewport) {
            this.chartRenderer.setCurrentViewport(targetViewport);
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void resetViewports() {
        this.chartRenderer.setMaximumViewport(null);
        this.chartRenderer.setCurrentViewport(null);
    }

    @Override
    public boolean isViewportCalculationEnabled() {
        return this.chartRenderer.isViewportCalculationEnabled();
    }

    @Override
    public void setViewportCalculationEnabled(boolean isEnabled) {
        this.chartRenderer.setViewportCalculationEnabled(isEnabled);
    }

    @Override
    public boolean isValueSelectionEnabled() {
        return this.touchHandler.isValueSelectionEnabled();
    }

    @Override
    public void setValueSelectionEnabled(boolean isValueSelectionEnabled) {
        this.touchHandler.setValueSelectionEnabled(isValueSelectionEnabled);
    }

    @Override
    public void selectValue(SelectedValue selectedValue) {
        this.chartRenderer.selectValue(selectedValue);
        this.callTouchListener();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public SelectedValue getSelectedValue() {
        return this.chartRenderer.getSelectedValue();
    }

    @Override
    public boolean isContainerScrollEnabled() {
        return this.isContainerScrollEnabled;
    }

    @Override
    public void setContainerScrollEnabled(boolean isContainerScrollEnabled, ContainerScrollType containerScrollType) {
        this.isContainerScrollEnabled = isContainerScrollEnabled;
        this.containerScrollType = containerScrollType;
    }

    protected void onChartDataChange() {
        this.chartComputator.resetContentRect();
        this.chartRenderer.onChartDataChanged();
        this.axesRenderer.onChartDataChanged();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    protected void resetRendererAndTouchHandler() {
        this.chartRenderer.resetRenderer();
        this.axesRenderer.resetRenderer();
        this.touchHandler.resetTouchHandler();
    }

    public boolean canScrollHorizontally(int direction) {
        if ((double)this.getZoomLevel() <= 1.0) {
            return false;
        }
        Viewport currentViewport = this.getCurrentViewport();
        Viewport maximumViewport = this.getMaximumViewport();
        if (direction < 0) {
            return currentViewport.left > maximumViewport.left;
        }
        return currentViewport.right < maximumViewport.right;
    }
}

