/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.annotation.ColorInt;
import dji.v5.ux.R;

public class ProgressRingView
extends View {
    private RectF boundaries;
    private Paint paint;
    private Animation indeterminateAnimation;
    private Shader progressGradient;
    private boolean indeterminate;
    private int ringColor = -1;
    private int height;
    private int width;

    public ProgressRingView(Context context) {
        super(context, null, 0);
    }

    public ProgressRingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressRingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.boundaries = new RectF();
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(Paint.Cap.SQUARE);
        this.paint.setColor(this.ringColor);
        if (!this.isInEditMode()) {
            this.indeterminateAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.uxsdk_anim_rotate);
            this.indeterminateAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    ProgressRingView.this.indeterminate = true;
                    if (ProgressRingView.this.progressGradient != null) {
                        ProgressRingView.this.paint.setShader(ProgressRingView.this.progressGradient);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ProgressRingView.this.paint.setShader(null);
                    ProgressRingView.this.invalidate();
                }
            });
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float padding;
        super.onSizeChanged(w, h, oldw, oldh);
        float strokeWidth = (float)w * 0.08f;
        this.paint.setStrokeWidth(strokeWidth / 2.0f);
        this.width = w;
        this.height = h;
        this.initProgressGradient(w, h);
        this.boundaries.top = padding = strokeWidth / 2.0f;
        this.boundaries.left = padding;
        this.boundaries.bottom = (float)this.getMeasuredWidth() - padding;
        this.boundaries.right = (float)this.getMeasuredHeight() - padding;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.boundaries, 0.0f, 360.0f, false, this.paint);
    }

    public void setRingColor(@ColorInt int color2) {
        this.ringColor = color2;
        this.paint.setColor(color2);
        this.initProgressGradient(this.width, this.height);
        this.invalidate();
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        if (indeterminate == this.indeterminate) {
            return;
        }
        this.indeterminate = indeterminate;
        if (indeterminate) {
            this.startAnimation(this.indeterminateAnimation);
        } else {
            this.clearAnimation();
            this.indeterminateAnimation.cancel();
            this.indeterminateAnimation.reset();
        }
    }

    private void initProgressGradient(int w, int h) {
        this.progressGradient = null;
        float cx = (float)w / 2.0f;
        float cy = (float)h / 2.0f;
        int[] colors = new int[]{this.ringColor, 0, 0};
        float[] positions = new float[]{0.0f, 0.7f, 1.0f};
        this.progressGradient = new SweepGradient(cx, cy, colors, positions);
    }
}

