/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.iso;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.CameraISO;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.visualcamera.iso.CameraConfigISOAndEIWidgetModel;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;

public class CameraConfigISOAndEIWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private static final String TAG = "ConfigISOAndEIWidget";
    private CameraConfigISOAndEIWidgetModel widgetModel;
    private TextView isoTitleTextView;
    private TextView isoValueTextView;

    public CameraConfigISOAndEIWidget(@NonNull Context context) {
        super(context);
    }

    public CameraConfigISOAndEIWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraConfigISOAndEIWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CameraConfigISOAndEIWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_base_camera_info, (ViewGroup)this);
        this.isoTitleTextView = (TextView)this.findViewById(R.id.textview_title);
        this.isoValueTextView = (TextView)this.findViewById(R.id.textview_value);
        if (!this.isInEditMode()) {
            this.widgetModel = new CameraConfigISOAndEIWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.reactToUpdateTitle());
        this.addReaction(this.widgetModel.getISOAndEIValue().observeOn(SchedulerProvider.ui()).subscribe(this::updateValue));
    }

    private Disposable reactToUpdateTitle() {
        return Flowable.combineLatest(this.widgetModel.isEIMode(), this.widgetModel.getISO(), Pair::new).observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateTitle((Boolean)values.first, (CameraISO)values.second), UxErrorHandle.logErrorConsumer(TAG, "react to update title: "));
    }

    private void updateTitle(boolean isEIMode, CameraISO iso) {
        if (isEIMode) {
            this.isoTitleTextView.setText(R.string.uxsdk_ei_title);
        } else if (iso == CameraISO.ISO_AUTO) {
            this.isoTitleTextView.setText(R.string.uxsdk_exposure_auto_iso_title);
        } else if (iso == CameraISO.ISO_FIXED) {
            this.isoTitleTextView.setText(R.string.uxsdk_exposure_locked_iso_title);
        } else {
            this.isoTitleTextView.setText(R.string.uxsdk_exposure_iso_title);
        }
    }

    private void updateValue(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            this.isoValueTextView.setText(R.string.uxsdk_string_default_value);
        } else {
            this.isoValueTextView.setText((CharSequence)value);
        }
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_base_camera_info_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void setISOAndEITitleTextAppearance(@StyleRes int textAppearance) {
        this.isoTitleTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getISOAndEITitleTextColors() {
        return this.isoTitleTextView.getTextColors();
    }

    @ColorInt
    public int getISOAndEITitleTextColor() {
        return this.isoTitleTextView.getCurrentTextColor();
    }

    public void setISOAndEITitleTextColor(@NonNull ColorStateList colorStateList) {
        this.isoTitleTextView.setTextColor(colorStateList);
    }

    public void setISOAndEITitleTextColor(@ColorInt int color2) {
        this.isoTitleTextView.setTextColor(color2);
    }

    @Dimension
    public float getISOAndEITitleTextSize() {
        return this.isoTitleTextView.getTextSize();
    }

    public void setISOAndEITitleTextSize(@Dimension float textSize) {
        this.isoTitleTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getISOAndEITitleTextBackground() {
        return this.isoTitleTextView.getBackground();
    }

    public void setISOAndEITitleTextBackground(@DrawableRes int resourceId) {
        this.isoTitleTextView.setBackgroundResource(resourceId);
    }

    public void setISOAndEITitleTextBackground(@Nullable Drawable drawable2) {
        this.isoTitleTextView.setBackground(drawable2);
    }

    public void setISOAndEIValueTextAppearance(@StyleRes int textAppearance) {
        this.isoValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getISOAndEIValueTextColors() {
        return this.isoValueTextView.getTextColors();
    }

    @ColorInt
    public int getISOAndEIValueTextColor() {
        return this.isoValueTextView.getCurrentTextColor();
    }

    public void setISOAndEIValueTextColor(@NonNull ColorStateList colorStateList) {
        this.isoValueTextView.setTextColor(colorStateList);
    }

    public void setISOAndEIValueTextColor(@ColorInt int color2) {
        this.isoValueTextView.setTextColor(color2);
    }

    @Dimension
    public float getISOAndEIValueTextSize() {
        return this.isoValueTextView.getTextSize();
    }

    public void setISOAndEIValueTextSize(@Dimension float textSize) {
        this.isoValueTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getISOAndEIValueTextBackground() {
        return this.isoValueTextView.getBackground();
    }

    public void setISOAndEIValueTextBackground(@DrawableRes int resourceId) {
        this.isoValueTextView.setBackgroundResource(resourceId);
    }

    public void setISOAndEIValueTextBackground(@Nullable Drawable drawable2) {
        this.isoValueTextView.setBackground(drawable2);
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        Drawable isoAndEIValueTextBackgroundDrawable;
        int isoAndEIValueTextColor;
        float isoAndEIValueTextSize;
        int isoAndEIValueTextAppearanceId;
        Drawable isoAndEITitleTextBackgroundDrawable;
        int isoAndEITitleTextColor;
        float isoAndEITitleTextSize;
        int isoAndEITitleTextAppearanceId;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraConfigISOAndEIWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.CameraConfigISOAndEIWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.CameraConfigISOAndEIWidget_uxsdk_lensType, 0)));
        }
        if ((isoAndEITitleTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigISOAndEIWidget_uxsdk_isoAndEITitleTextAppearance, -1)) != -1) {
            this.setISOAndEITitleTextAppearance(isoAndEITitleTextAppearanceId);
        }
        if ((isoAndEITitleTextSize = typedArray.getDimension(R.styleable.CameraConfigISOAndEIWidget_uxsdk_isoAndEITitleTextSize, -1.0f)) != -1.0f) {
            this.setISOAndEITitleTextSize(DisplayUtil.pxToSp((Context)context, (float)isoAndEITitleTextSize));
        }
        if ((isoAndEITitleTextColor = typedArray.getColor(R.styleable.CameraConfigISOAndEIWidget_uxsdk_isoAndEITitleTextColor, 0)) != 0) {
            this.setISOAndEITitleTextColor(isoAndEITitleTextColor);
        }
        if ((isoAndEITitleTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigISOAndEIWidget_uxsdk_isoAndEITitleBackgroundDrawable)) != null) {
            this.setISOAndEITitleTextBackground(isoAndEITitleTextBackgroundDrawable);
        }
        if ((isoAndEIValueTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigISOAndEIWidget_uxsdk_isoAndEIValueTextAppearance, -1)) != -1) {
            this.setISOAndEIValueTextAppearance(isoAndEIValueTextAppearanceId);
        }
        if ((isoAndEIValueTextSize = typedArray.getDimension(R.styleable.CameraConfigISOAndEIWidget_uxsdk_isoAndEIValueTextSize, -1.0f)) != -1.0f) {
            this.setISOAndEIValueTextSize(DisplayUtil.pxToSp((Context)context, (float)isoAndEIValueTextSize));
        }
        if ((isoAndEIValueTextColor = typedArray.getColor(R.styleable.CameraConfigISOAndEIWidget_uxsdk_isoAndEIValueTextColor, 0)) != 0) {
            this.setISOAndEIValueTextColor(isoAndEIValueTextColor);
        }
        if ((isoAndEIValueTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigISOAndEIWidget_uxsdk_isoAndEIValueBackgroundDrawable)) != null) {
            this.setISOAndEIValueTextBackground(isoAndEIValueTextBackgroundDrawable);
        }
        typedArray.recycle();
    }
}

