/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.sample.showcase.widgetlist;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import dji.v5.ux.R;
import dji.v5.ux.sample.showcase.widgetlist.WidgetListItemAdapter;
import dji.v5.ux.sample.showcase.widgetlist.WidgetsActivity;

public class WidgetListFragment
extends Fragment {
    public static final String TAG = "WidgetListFragment";
    protected RecyclerView widgetRecyclerView;
    private OnWidgetItemSelectedListener onWidgetItemSelectedListener;
    private int selectedPosition = -1;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.uxsdk_fragment_widget_list, container, false);
        this.widgetRecyclerView = (RecyclerView)rootView.findViewById(R.id.recyclerview_widgets);
        this.widgetRecyclerView.setHasFixedSize(true);
        LinearLayoutManager widgetLayoutManager = new LinearLayoutManager(this.getContext());
        this.widgetRecyclerView.setLayoutManager((RecyclerView.LayoutManager)widgetLayoutManager);
        WidgetListItemAdapter widgetAdapter = new WidgetListItemAdapter(((WidgetsActivity)this.getActivity()).widgetListItems, this.onWidgetItemSelectedListener);
        this.widgetRecyclerView.setAdapter((RecyclerView.Adapter)widgetAdapter);
        return rootView;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.onWidgetItemSelectedListener = (OnWidgetItemSelectedListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context.toString() + " must implement OnWidgetItemSelectedListener");
        }
    }

    public void updateSelectedView(int position) {
        if (position != this.selectedPosition) {
            ((WidgetListItemAdapter.WidgetListItemViewHolder)this.widgetRecyclerView.findViewHolderForAdapterPosition(position)).setSelected(true, this.getResources());
            if (this.selectedPosition >= 0) {
                ((WidgetListItemAdapter.WidgetListItemViewHolder)this.widgetRecyclerView.findViewHolderForAdapterPosition(this.selectedPosition)).setSelected(false, this.getResources());
            }
            this.selectedPosition = position;
        }
    }

    public static interface OnWidgetItemSelectedListener {
        public void onWidgetItemSelected(int var1);
    }
}

