/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.maps;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.mapkit.core.Mapkit;
import dji.v5.ux.mapkit.core.MapkitOptions;
import dji.v5.ux.mapkit.core.maps.DJIEmptyMapView;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.maps.DJIMapViewInternal;
import dji.v5.ux.mapkit.core.providers.MapProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class DJIMapView
extends FrameLayout {
    private static final String TAG = LogUtils.getTag((String)DJIMapView.class.getSimpleName());
    private DJIMapViewInternal internalMapView;
    private static final int MAP_PROVIDER_MAPLibre = 3;

    public DJIMapView(@NonNull Context context) {
        this(context, null);
    }

    public DJIMapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DJIMapView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.DJIMapView);
        int defaultProvider = typedArray.getInt(R.styleable.DJIMapView_defaultProvider, 3);
        MapkitOptions.Builder builder = new MapkitOptions.Builder();
        builder.addMapProvider(defaultProvider);
        this.initialise((Activity)context, builder.build());
        typedArray.recycle();
    }

    public DJIMapView(Activity activity, MapkitOptions options) {
        super((Context)activity);
        this.initialise(activity, options);
    }

    private void initialise(@NonNull Activity activity, @NonNull MapkitOptions options) {
        List<Integer> providerList = options.getProviderList();
        for (int i = 0; i < providerList.size(); ++i) {
            String className = Mapkit.getMapProviderClassName(providerList.get(i));
            try {
                Class<?> c = Class.forName(className);
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                Object object = constructor.newInstance(new Object[0]);
                this.internalMapView = ((MapProvider)object).dispatchMapViewRequest((Context)activity, options);
                if (this.internalMapView == null) continue;
                break;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                LogUtils.e((String)TAG, (Object[])new Object[]{e.getMessage()});
            }
        }
        if (this.internalMapView != null) {
            this.addView((View)this.internalMapView);
        } else {
            this.internalMapView = new DJIEmptyMapView();
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.uxsdk_map_provider_init_failed), (int)1).show();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        this.internalMapView.onCreate(savedInstanceState);
    }

    public void onStart() {
        this.internalMapView.onStart();
    }

    public void onResume() {
        this.internalMapView.onResume();
    }

    public void onPause() {
        this.internalMapView.onPause();
    }

    public void onStop() {
        this.internalMapView.onStop();
    }

    public void onDestroy() {
        this.internalMapView.onDestroy();
    }

    public void onSaveInstanceState(Bundle outState) {
        this.internalMapView.onSaveInstanceState(outState);
    }

    public void onLowMemory() {
        this.internalMapView.onLowMemory();
    }

    public void getDJIMapAsync(@NonNull OnDJIMapReadyCallback callback) {
        this.internalMapView.getDJIMapAsync(callback);
    }

    public DJIMapViewInternal getInternalMapView() {
        return this.internalMapView;
    }

    public static interface OnDJIMapReadyCallback {
        public void onDJIMapReady(DJIMap var1);
    }
}

