/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.flightparam;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.value.flightcontroller.GoHomePathMode;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;

public class GoHomeModeWidgetModel
extends WidgetModel {
    private final DataProcessor<GoHomePathMode> goHomePathModeDataProcessor = DataProcessor.create(GoHomePathMode.UNKNOWN);
    private final DataProcessor<ProductType> productTypeProcessor = DataProcessor.create(ProductType.UNKNOWN);

    protected GoHomeModeWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)ProductKey.KeyProductType), this.productTypeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyGoHomePathMode), this.goHomePathModeDataProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @NonNull
    public Flowable<GoHomePathMode> goHomePathModeFlowable() {
        return this.goHomePathModeDataProcessor.toFlowable();
    }

    @NonNull
    Flowable<ProductType> getProductTypeFlowable() {
        return this.productTypeProcessor.toFlowable();
    }

    boolean isSupportGoHomeMode() {
        return this.productTypeProcessor.getValue() == ProductType.DJI_MAVIC_3_ENTERPRISE_SERIES;
    }

    public Flowable<GoHomePathMode> setGoHomePathMode(GoHomePathMode value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyGoHomePathMode), value).toFlowable();
    }
}

