/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.flightparam;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.flightcontroller.GoHomePathMode;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.EditorCell;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.SwitcherCell;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.flight.flightparam.DistanceLimitWidgetModel;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;

public class DistanceLimitWidget
extends ConstraintLayoutWidget<Object>
implements EditorCell.OnValueChangedListener {
    private DistanceLimitWidgetModel widgetModel = new DistanceLimitWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    private EditorCell mGoHomeEditCell;
    private EditorCell mMaxHeightEditCell;
    private EditorCell mMaxRadiusEditorCell;
    private SwitcherCell mMaxRadiusCell;
    private TextView mRTHTipTv;
    private int maxHeight = 500;
    private static final int ALARM_HEIGHT = 120;
    private static final int CONFIRM_ALARM_HEIGHT = 500;

    public DistanceLimitWidget(@NonNull Context context) {
        super(context);
    }

    public DistanceLimitWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public DistanceLimitWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        DistanceLimitWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_limit_distance_set_layout, (ViewGroup)this);
        this.mGoHomeEditCell = (EditorCell)this.findViewById(R.id.setting_menu_aircraft_goHomeAttitude);
        this.mGoHomeEditCell.setOnValueChangedListener(this);
        this.mMaxHeightEditCell = (EditorCell)this.findViewById(R.id.setting_menu_aircraft_maxHeight);
        this.mMaxHeightEditCell.setOnValueChangedListener(this);
        this.mMaxRadiusEditorCell = (EditorCell)this.findViewById(R.id.setting_menu_aircraft_maxRadius);
        this.mMaxRadiusEditorCell.setOnValueChangedListener(this);
        this.mMaxRadiusCell = (SwitcherCell)this.findViewById(R.id.setting_menu_aircraft_maxRadius_switch);
        this.mRTHTipTv = (TextView)this.findViewById(R.id.setting_menu_aircraft_go_home_mode_desc);
        this.mMaxRadiusCell.setOnCheckedChangedListener((cell, isChecked) -> {
            this.widgetModel.setDistanceLimitEnabled(isChecked).subscribe();
            if (isChecked) {
                this.mMaxRadiusEditorCell.setVisibility(0);
            } else {
                this.mMaxRadiusEditorCell.setVisibility(8);
            }
        });
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getGoHomeHeight().observeOn(SchedulerProvider.ui()).subscribe(this::updateGoHomeHeight));
        this.addReaction(this.widgetModel.getHomeLimitHeight().observeOn(SchedulerProvider.ui()).subscribe(this::updateHeightLimit));
        this.addReaction(this.widgetModel.getDistanceLimit().observeOn(SchedulerProvider.ui()).subscribe(this::updateDistanceLimit));
        this.addReaction(this.widgetModel.getDistanceLimitEnabled().observeOn(SchedulerProvider.ui()).subscribe(this::updateDistanceLimitEnable));
        this.addReaction(this.widgetModel.getGoHomePathMode().observeOn(SchedulerProvider.ui()).subscribe(this::updateGoHomeMode));
    }

    private void updateGoHomeMode(GoHomePathMode goHomePathMode) {
        if (goHomePathMode == GoHomePathMode.HEIGHT_FIXED || goHomePathMode == GoHomePathMode.UNKNOWN) {
            this.mRTHTipTv.setText(R.string.uxsdk_setting_menu_flyc_smart_rth_set_altitude);
        } else {
            this.mRTHTipTv.setText(R.string.uxsdk_setting_menu_flyc_smart_rth_smart_altitude);
        }
    }

    private void updateDistanceLimitEnable(Boolean isChecked) {
        this.mMaxRadiusCell.setChecked(isChecked);
        if (isChecked.booleanValue()) {
            this.mMaxRadiusEditorCell.setVisibility(0);
        } else {
            this.mMaxRadiusEditorCell.setVisibility(8);
        }
    }

    private void updateDistanceLimit(Integer integer2) {
        this.mMaxRadiusEditorCell.setValue(integer2);
    }

    private void updateHeightLimit(Integer integer2) {
        this.maxHeight = integer2;
        this.mMaxHeightEditCell.setValue(integer2);
    }

    private void updateGoHomeHeight(Integer integer2) {
        this.mGoHomeEditCell.setValue(integer2);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    @Override
    public void onValueChanged(EditorCell cell, int inputValue, int validValue) {
        if (inputValue > cell.getMaxValue() || inputValue < cell.getMinValue()) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_menu_setting_fail, 0);
            return;
        }
        if (cell.getId() == R.id.setting_menu_aircraft_goHomeAttitude) {
            if (inputValue > this.maxHeight) {
                ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_menu_flyc_gohome_altitude_limit, 0);
                return;
            }
            this.widgetModel.setGoHomeHeight(inputValue).observeOn(SchedulerProvider.ui()).subscribe(this.getFinishObserve());
        } else if (cell.getId() == R.id.setting_menu_aircraft_maxHeight) {
            this.checkMaxFlightHeight(inputValue);
            this.widgetModel.setHeightLimit(inputValue).observeOn(SchedulerProvider.ui()).subscribe(this.getFinishObserve());
        } else if (cell.getId() == R.id.setting_menu_aircraft_maxRadius) {
            this.widgetModel.setDistanceLimit(inputValue).observeOn(SchedulerProvider.ui()).subscribe(this.getFinishObserve());
        }
    }

    private void checkMaxFlightHeight(int inputValue) {
        if (inputValue <= 500 && inputValue > 120) {
            ViewUtil.showToast(this.getContext(), this.getContext().getString(R.string.uxsdk_setting_menu_flyc_limit_high_notice), 1);
        } else if (inputValue > 500) {
            ViewUtil.showToast(this.getContext(), this.getContext().getString(R.string.uxsdk_setting_menu_flyc_limit_high_notice_above_500), 1);
        }
    }

    private CompletableObserver getFinishObserve() {
        return new CompletableObserver(){

            public void onSubscribe(@io.reactivex.rxjava3.annotations.NonNull Disposable d) {
            }

            public void onComplete() {
                ViewUtil.showToast(DistanceLimitWidget.this.getContext(), R.string.uxsdk_setting_menu_setting_success, 0);
            }

            public void onError(@io.reactivex.rxjava3.annotations.NonNull Throwable e) {
            }
        };
    }
}

