/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.perception;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import dji.v5.manager.aircraft.perception.PerceptionManager;
import dji.v5.manager.aircraft.perception.data.PerceptionInfo;
import dji.v5.manager.interfaces.IPerceptionManager;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.widget.perception.PerceptionStateWidgetModel;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\b\u0010\u001b\u001a\u00020\u0019H\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0014J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J \u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0002H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldji/v5/ux/core/widget/perception/PerceptionStateWidget;", "Ldji/v5/ux/core/base/widget/FrameLayoutWidget;", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "perceptionIconImageView", "Landroid/widget/ImageView;", "widgetModel", "Ldji/v5/ux/core/widget/perception/PerceptionStateWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/core/widget/perception/PerceptionStateWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "perceptionSwitchState", "Ldji/v5/ux/core/widget/perception/PerceptionStateWidgetModel$PerceptionSwitchState;", "perceptionSwitchStateMap", "", "Landroid/graphics/drawable/Drawable;", "initView", "", "onAttachedToWindow", "onDetachedFromWindow", "getIdealDimensionRatioString", "", "reactToModelChanges", "handlePerceptionInfo", "perceptionInfo", "Ldji/v5/manager/aircraft/perception/data/PerceptionInfo;", "handleHorizontalPerceptionInfo", "handleUpwardPerceptionInfo", "handleDownwardPerceptionInfo", "handleAllPerceptionInfo", "isPerceptionEnabled", "horizontalDirection", "upwardDirection", "downwardDirection", "android-sdk-v5-uxsdk_debug"})
public final class PerceptionStateWidget
extends FrameLayoutWidget<Boolean> {
    @NotNull
    private final ImageView perceptionIconImageView;
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private PerceptionStateWidgetModel.PerceptionSwitchState perceptionSwitchState;
    @NotNull
    private final Map<PerceptionStateWidgetModel.PerceptionSwitchState, Drawable> perceptionSwitchStateMap;

    @JvmOverloads
    public PerceptionStateWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View view = this.findViewById(R.id.imageview_vision_icon);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.perceptionIconImageView = (ImageView)view;
        this.widgetModel$delegate = LazyKt.lazy(PerceptionStateWidget::widgetModel_delegate$lambda$0);
        this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ALL_DISABLED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)PerceptionStateWidgetModel.PerceptionSwitchState.ALL_ENABLED), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_avoid_normal_all)), TuplesKt.to((Object)((Object)PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_HORI_OFF), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_avoid_only_hori_off)), TuplesKt.to((Object)((Object)PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_UP_OFF), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_avoid_only_up_off)), TuplesKt.to((Object)((Object)PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_DOWN_OFF), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_avoid_only_down_off)), TuplesKt.to((Object)((Object)PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_HORI_ON), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_avoid_only_hori_on)), TuplesKt.to((Object)((Object)PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_UP_ON), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_avoid_only_up_on)), TuplesKt.to((Object)((Object)PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_DOWN_ON), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_avoid_only_down_on)), TuplesKt.to((Object)((Object)PerceptionStateWidgetModel.PerceptionSwitchState.ALL_DISABLED), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_avoid_disable_all))};
        this.perceptionSwitchStateMap = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    public /* synthetic */ PerceptionStateWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final PerceptionStateWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (PerceptionStateWidgetModel)lazy.getValue();
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        View.inflate((Context)context, (int)R.layout.uxsdk_widget_vision, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Nullable
    public Void getIdealDimensionRatioString() {
        return null;
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getPerceptionInfo().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ PerceptionStateWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(PerceptionInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PerceptionStateWidget.access$handlePerceptionInfo(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
    }

    private final void handlePerceptionInfo(PerceptionInfo perceptionInfo) {
        if (!perceptionInfo.isVisionPositioningEnabled()) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ALL_DISABLED;
            this.perceptionIconImageView.setImageDrawable(this.perceptionSwitchStateMap.get((Object)this.perceptionSwitchState));
            return;
        }
        this.handleHorizontalPerceptionInfo(perceptionInfo);
        this.handleUpwardPerceptionInfo(perceptionInfo);
        this.handleDownwardPerceptionInfo(perceptionInfo);
        this.handleAllPerceptionInfo(perceptionInfo);
        this.perceptionIconImageView.setImageDrawable(this.perceptionSwitchStateMap.get((Object)this.perceptionSwitchState));
    }

    private final void handleHorizontalPerceptionInfo(PerceptionInfo perceptionInfo) {
        if (this.isPerceptionEnabled(perceptionInfo.isHorizontalObstacleAvoidanceEnabled(), !perceptionInfo.isUpwardObstacleAvoidanceEnabled(), !perceptionInfo.isDownwardObstacleAvoidanceEnabled())) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_HORI_ON;
        } else if (!this.isPerceptionEnabled(perceptionInfo.isHorizontalObstacleAvoidanceEnabled(), perceptionInfo.isUpwardObstacleAvoidanceEnabled(), perceptionInfo.isDownwardObstacleAvoidanceEnabled())) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_HORI_OFF;
        }
    }

    private final void handleUpwardPerceptionInfo(PerceptionInfo perceptionInfo) {
        if (this.isPerceptionEnabled(!perceptionInfo.isHorizontalObstacleAvoidanceEnabled(), perceptionInfo.isUpwardObstacleAvoidanceEnabled(), !perceptionInfo.isDownwardObstacleAvoidanceEnabled())) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_UP_ON;
        } else if (this.isPerceptionEnabled(perceptionInfo.isHorizontalObstacleAvoidanceEnabled(), !perceptionInfo.isUpwardObstacleAvoidanceEnabled(), perceptionInfo.isDownwardObstacleAvoidanceEnabled())) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_UP_OFF;
        }
    }

    private final void handleDownwardPerceptionInfo(PerceptionInfo perceptionInfo) {
        if (this.isPerceptionEnabled(!perceptionInfo.isHorizontalObstacleAvoidanceEnabled(), !perceptionInfo.isUpwardObstacleAvoidanceEnabled(), perceptionInfo.isDownwardObstacleAvoidanceEnabled())) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_DOWN_ON;
        } else if (this.isPerceptionEnabled(perceptionInfo.isHorizontalObstacleAvoidanceEnabled(), perceptionInfo.isUpwardObstacleAvoidanceEnabled(), !perceptionInfo.isDownwardObstacleAvoidanceEnabled())) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ONLY_DOWN_OFF;
        }
    }

    private final void handleAllPerceptionInfo(PerceptionInfo perceptionInfo) {
        if (this.isPerceptionEnabled(perceptionInfo.isHorizontalObstacleAvoidanceEnabled(), perceptionInfo.isUpwardObstacleAvoidanceEnabled(), perceptionInfo.isDownwardObstacleAvoidanceEnabled())) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ALL_ENABLED;
        } else if (this.isPerceptionEnabled(!perceptionInfo.isHorizontalObstacleAvoidanceEnabled(), !perceptionInfo.isUpwardObstacleAvoidanceEnabled(), !perceptionInfo.isDownwardObstacleAvoidanceEnabled())) {
            this.perceptionSwitchState = PerceptionStateWidgetModel.PerceptionSwitchState.ALL_DISABLED;
        }
    }

    private final boolean isPerceptionEnabled(boolean horizontalDirection, boolean upwardDirection, boolean downwardDirection) {
        return horizontalDirection && upwardDirection && downwardDirection;
    }

    @JvmOverloads
    public PerceptionStateWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PerceptionStateWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final PerceptionStateWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        IPerceptionManager iPerceptionManager = PerceptionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)iPerceptionManager, (String)"getInstance(...)");
        return new PerceptionStateWidgetModel(dJISDKModel, observableInMemoryKeyedStore, iPerceptionManager);
    }

    public static final /* synthetic */ void access$handlePerceptionInfo(PerceptionStateWidget $this, PerceptionInfo perceptionInfo) {
        $this.handlePerceptionInfo(perceptionInfo);
    }
}

