/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd.frequency;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import dji.v5.ux.R;
import dji.v5.ux.core.base.BaseView;

public class ChartRightYAxisView
extends BaseView {
    private String[] mDistanceUnitStr = new String[]{"\u22481km", "\u22484km", "MHz"};
    private int mFirstLineNfValue = -91;
    private int mSecondLineNfValue = -103;
    private float mFirstLinePos = 0.0f;
    private float mSecondLinePos = 0.0f;
    private Paint mPaint;
    private float mSmallTxtSize = this.getResources().getDimension(R.dimen.uxsdk_12_dp);
    private float mNormalTxtSize = this.getResources().getDimension(R.dimen.uxsdk_14_dp);
    private float mChartHeight;
    private float mXOffset = 0.0f;
    private float mYOffset = 0.0f;

    public ChartRightYAxisView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint = new Paint();
        this.mPaint.setColor(this.getResources().getColor(17170443));
        this.mPaint.setTextSize(this.mSmallTxtSize);
        this.mChartHeight = this.getResources().getDimension(R.dimen.uxsdk_setting_ui_hd_sdr_chart_height);
        this.mYOffset = this.mSmallTxtSize / 4.0f;
        this.mXOffset = (int)this.getResources().getDimension(R.dimen.uxsdk_4_dp);
        this.mFirstLinePos = this.mChartHeight * (float)(50 - (this.mFirstLineNfValue - -110)) / 50.0f;
        this.mSecondLinePos = this.mChartHeight * (float)(50 - (this.mSecondLineNfValue - -110)) / 50.0f;
    }

    public void set1KmNfValue(int _val) {
        this.mFirstLineNfValue = _val;
        this.mSecondLineNfValue = this.mFirstLineNfValue - 12;
        this.mFirstLinePos = this.mChartHeight * (float)(50 - (this.mFirstLineNfValue - -110)) / 50.0f;
        this.mSecondLinePos = this.mChartHeight * (float)(50 - (this.mSecondLineNfValue - -110)) / 50.0f;
        this.postInvalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(this.getResources().getColor(17170443));
        this.mPaint.setTextSize(this.mSmallTxtSize);
        canvas.drawText(String.valueOf(this.mDistanceUnitStr[0]), this.mXOffset, this.mFirstLinePos + this.mYOffset, this.mPaint);
        canvas.drawText(String.valueOf(this.mDistanceUnitStr[1]), this.mXOffset, this.mSecondLinePos + this.mYOffset, this.mPaint);
        this.mPaint.setColor(this.getResources().getColor(0x1060000));
        this.mPaint.setTextSize(this.mNormalTxtSize);
        canvas.drawText(String.valueOf(this.mDistanceUnitStr[2]), this.mXOffset, this.mChartHeight + this.mYOffset, this.mPaint);
    }
}

