/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.common;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.utils.common.LogUtils;
import dji.v5.utils.common.StringUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.core.widget.common.CommonDeviceNameWidgetModel;

public class CommonDeviceNameWidget
extends FrameLayoutWidget<Object> {
    private static final String TAG = "DeviceRenameWidget";
    protected CommonDeviceNameWidgetModel widgetModel = new CommonDeviceNameWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    protected TextView saveTv;
    protected EditText renameCell;

    public CommonDeviceNameWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CommonDeviceNameWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CommonDeviceNameWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CommonDeviceNameWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_common_device_rename, (ViewGroup)this);
        this.saveTv = (TextView)this.findViewById(R.id.setting_menu_common_save_tv);
        this.renameCell = (EditText)this.findViewById(R.id.setting_menu_common_rename_cell);
        this.saveTv.setOnClickListener(v -> this.handleSaveAction());
    }

    @Override
    protected void reactToModelChanges() {
        this.addDisposable(this.widgetModel.getAircraftName().subscribe(name -> this.renameCell.setText((CharSequence)name)));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    private void handleSaveAction() {
        String deviceName = this.renameCell.getText().toString();
        if (deviceName.length() == 0) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_common_device_name_input_tip, 0);
            return;
        }
        if (StringUtils.containsEmoji((String)deviceName)) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_common_device_name_illegal, 0);
            return;
        }
        this.addDisposable(this.widgetModel.setAircraftName(deviceName).subscribe(() -> ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_common_device_name_save_success, 0), throwable -> {
            LogUtils.e((String)TAG, (Object[])new Object[]{"handleSaveAction fail: " + throwable});
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_common_device_name_save_fail, 0);
        }));
    }
}

