/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.component;

import android.graphics.Rect;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0019"}, d2={"Ldji/v5/ux/core/ui/component/PaletteItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "spanCount", "", "leftEdgeSpacing", "rightEdgeSpacing", "topEdgeSpacing", "hSpacing", "vSpacing", "<init>", "(IIIIII)V", "getSpanCount", "()I", "getLeftEdgeSpacing", "getRightEdgeSpacing", "getTopEdgeSpacing", "getHSpacing", "getVSpacing", "getItemOffsets", "", "outRect", "Landroid/graphics/Rect;", "itemPosition", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "android-sdk-v5-uxsdk_debug"})
public final class PaletteItemDecoration
extends RecyclerView.ItemDecoration {
    private final int spanCount;
    private final int leftEdgeSpacing;
    private final int rightEdgeSpacing;
    private final int topEdgeSpacing;
    private final int hSpacing;
    private final int vSpacing;

    public PaletteItemDecoration(int spanCount, int leftEdgeSpacing, int rightEdgeSpacing, int topEdgeSpacing, int hSpacing, int vSpacing) {
        this.spanCount = spanCount;
        this.leftEdgeSpacing = leftEdgeSpacing;
        this.rightEdgeSpacing = rightEdgeSpacing;
        this.topEdgeSpacing = topEdgeSpacing;
        this.hSpacing = hSpacing;
        this.vSpacing = vSpacing;
    }

    public final int getSpanCount() {
        return this.spanCount;
    }

    public final int getLeftEdgeSpacing() {
        return this.leftEdgeSpacing;
    }

    public final int getRightEdgeSpacing() {
        return this.rightEdgeSpacing;
    }

    public final int getTopEdgeSpacing() {
        return this.topEdgeSpacing;
    }

    public final int getHSpacing() {
        return this.hSpacing;
    }

    public final int getVSpacing() {
        return this.vSpacing;
    }

    public void getItemOffsets(@NotNull Rect outRect, int itemPosition, @NotNull RecyclerView parent) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int n = itemPosition % this.spanCount;
        if (n == 0) {
            outRect.left = this.leftEdgeSpacing;
            outRect.right = this.hSpacing / 2;
        } else if (n == this.spanCount - 1) {
            outRect.left = this.hSpacing / 2;
            outRect.right = this.rightEdgeSpacing;
        } else {
            outRect.left = this.hSpacing / 2;
            outRect.right = this.hSpacing / 2;
        }
        int row = itemPosition / this.spanCount;
        RecyclerView.Adapter adapter = parent.getAdapter();
        int maxRow = (adapter != null ? adapter.getItemCount() : 0) / this.spanCount;
        if (row == maxRow) {
            outRect.top = this.vSpacing / 2;
            outRect.bottom = this.vSpacing;
        } else {
            outRect.top = this.vSpacing / 2;
            outRect.bottom = this.vSpacing / 2;
        }
    }
}

