/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.component;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.RangeSeekBar;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u00013B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0018\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0014J\u0010\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010*\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010+\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u000e\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020%J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0014H\u0014J\u0010\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u000202H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00064"}, d2={"Ldji/v5/ux/core/ui/component/IsothermRangeSeekbar;", "Ldji/v5/ux/core/ui/RangeSeekBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "DEBUG_TOUCH_RECT", "", "paint", "Landroid/graphics/Paint;", "textPaint", "getTextPaint", "()Landroid/graphics/Paint;", "textBounds", "Landroid/graphics/Rect;", "getTextBounds", "()Landroid/graphics/Rect;", "thumbWidth", "", "getThumbWidth", "()I", "thumbHeight", "getThumbHeight", "textFormatCallback", "Ldji/v5/ux/core/ui/component/IsothermRangeSeekbar$TextFormatCallback;", "getTextFormatCallback", "()Ldji/v5/ux/core/ui/component/IsothermRangeSeekbar$TextFormatCallback;", "setTextFormatCallback", "(Ldji/v5/ux/core/ui/component/IsothermRangeSeekbar$TextFormatCallback;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "getTouchRect", "thumb", "Landroid/graphics/drawable/Drawable;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "drawLeftThumb", "drawRightThumb", "drawProgress", "setProgressDrawable", "drawable", "getThumbPosition", "value", "getValueByDelta", "delta", "", "TextFormatCallback", "android-sdk-v5-uxsdk_debug"})
public class IsothermRangeSeekbar
extends RangeSeekBar {
    private final boolean DEBUG_TOUCH_RECT;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Paint textPaint;
    @NotNull
    private final Rect textBounds;
    private final int thumbWidth;
    private final int thumbHeight;
    @Nullable
    private TextFormatCallback textFormatCallback;

    @JvmOverloads
    public IsothermRangeSeekbar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.paint = new Paint();
        this.textPaint = new Paint();
        this.textBounds = new Rect();
        this.thumbWidth = (int)AndUtil.getDimension((int)R.dimen.uxsdk_11_dp);
        this.thumbHeight = (int)AndUtil.getDimension((int)R.dimen.uxsdk_18_dp);
        this.paint.setColor(-65536);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(2.0f);
        Paint $this$_init__u24lambda_u240 = this.textPaint;
        boolean bl = false;
        $this$_init__u24lambda_u240.setDither(true);
        $this$_init__u24lambda_u240.setAntiAlias(true);
        $this$_init__u24lambda_u240.setColor(-1);
        $this$_init__u24lambda_u240.setTypeface(Typeface.DEFAULT_BOLD);
        $this$_init__u24lambda_u240.setTextSize(this.getResources().getDimension(R.dimen.uxsdk_10_dp));
    }

    public /* synthetic */ IsothermRangeSeekbar(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @NotNull
    public final Paint getTextPaint() {
        return this.textPaint;
    }

    @NotNull
    public final Rect getTextBounds() {
        return this.textBounds;
    }

    public final int getThumbWidth() {
        return this.thumbWidth;
    }

    public final int getThumbHeight() {
        return this.thumbHeight;
    }

    @Nullable
    public final TextFormatCallback getTextFormatCallback() {
        return this.textFormatCallback;
    }

    public final void setTextFormatCallback(@Nullable TextFormatCallback textFormatCallback) {
        this.textFormatCallback = textFormatCallback;
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.DEBUG_TOUCH_RECT) {
            canvas.drawRect(this.getTouchRect(this.mLeftThumb), this.paint);
            canvas.drawRect(this.getTouchRect(this.mRightThumb), this.paint);
        }
    }

    @Override
    @NotNull
    protected Rect getTouchRect(@Nullable Drawable thumb) {
        Rect rect;
        this.mTouchRect = super.getTouchRect(thumb);
        if (Intrinsics.areEqual((Object)thumb, (Object)this.mLeftThumb)) {
            rect = this.mTouchRect;
            rect.left -= this.thumbWidth;
        } else {
            rect = this.mTouchRect;
            rect.right += this.thumbWidth;
        }
        rect = this.mTouchRect;
        rect.top -= this.thumbHeight / 2;
        rect = this.mTouchRect;
        rect.bottom += this.thumbHeight / 2;
        Rect rect2 = this.mTouchRect;
        Intrinsics.checkNotNullExpressionValue((Object)rect2, (String)"mTouchRect");
        return rect2;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMeasureSpec2 = heightMeasureSpec;
        int heightNeeded = (int)this.getResources().getDimension(R.dimen.uxsdk_42_dp) + this.getPaddingTop() + this.getPaddingBottom();
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec2);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec2);
        heightMeasureSpec2 = switch (heightMode) {
            case 0x40000000 -> View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000);
            case Integer.MIN_VALUE -> View.MeasureSpec.makeMeasureSpec((int)(heightSize < heightNeeded ? heightSize : heightNeeded), (int)0x40000000);
            default -> View.MeasureSpec.makeMeasureSpec((int)heightNeeded, (int)0x40000000);
        };
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec2);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    @Override
    protected void drawLeftThumb(@NotNull Canvas canvas) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int leftTop = this.getHeight() / 2 - this.thumbHeight / 2;
        int leftX = this.getThumbPosition(this.mLeftValue) - this.thumbWidth;
        this.mLeftThumb.setBounds(leftX, leftTop, leftX + this.thumbWidth, leftTop + this.thumbHeight);
        if (this.isEnabled()) {
            this.mLeftThumb.draw(canvas);
        }
        if ((object = this.textFormatCallback) == null || (object = object.format(this.mLeftValue)) == null) {
            object = String.valueOf(this.mLeftValue);
        }
        Object text = object;
        this.textPaint.getTextBounds((String)text, 0, ((String)text).length(), this.textBounds);
        int textRight = leftX + this.textBounds.width();
        if (textRight > this.getWidth()) {
            this.textPaint.setTextAlign(Paint.Align.RIGHT);
        } else {
            this.textPaint.setTextAlign(Paint.Align.LEFT);
        }
        float textTop = (float)this.mLeftThumb.getBounds().bottom + this.getResources().getDimension(R.dimen.uxsdk_4_dp);
        float textLeft = this.mLeftThumb.getBounds().left;
        canvas.drawText((String)text, textLeft, textTop + (float)this.textBounds.height(), this.textPaint);
    }

    @Override
    protected void drawRightThumb(@NotNull Canvas canvas) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int rightX = this.getThumbPosition(this.mRightValue);
        int rightTop = this.getHeight() / 2 - this.thumbHeight / 2;
        this.mRightThumb.setBounds(rightX, rightTop, rightX + this.thumbWidth, rightTop + this.thumbHeight);
        if (this.isEnabled()) {
            this.mRightThumb.draw(canvas);
        }
        if ((object = this.textFormatCallback) == null || (object = object.format(this.mRightValue)) == null) {
            object = String.valueOf(this.mRightValue);
        }
        Object text = object;
        this.textPaint.getTextBounds((String)text, 0, ((String)text).length(), this.textBounds);
        int textRight = rightX - this.textBounds.width();
        if (textRight < 0) {
            this.textPaint.setTextAlign(Paint.Align.LEFT);
        } else {
            this.textPaint.setTextAlign(Paint.Align.RIGHT);
        }
        float textTop = (float)this.mRightThumb.getBounds().top + this.getResources().getDimension(R.dimen.uxsdk_4_dp);
        float textLeft = this.mRightThumb.getBounds().right;
        canvas.drawText((String)text, textLeft, textTop - (float)this.textBounds.height(), this.textPaint);
    }

    @Override
    protected void drawProgress(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int leftX = this.getThumbPosition(this.mLeftValue) - this.thumbWidth;
        int rightX = this.getThumbPosition(this.mRightValue) + this.thumbWidth;
        this.mProgressDrawable.setBounds(leftX, this.mBackgroundDrawable.getBounds().top, rightX, this.mBackgroundDrawable.getBounds().bottom);
        this.mProgressDrawable.draw(canvas);
    }

    public final void setProgressDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        this.mProgressDrawable = drawable2;
        this.postInvalidate();
    }

    @Override
    protected int getThumbPosition(int value) {
        float width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        float range = this.mDrawMax - this.mDrawMin;
        float v = (float)value - this.mDrawMin;
        return Math.round(v / range * width) + this.getPaddingLeft();
    }

    @Override
    protected int getValueByDelta(float delta) {
        float width = this.getWidth() - this.getPaddingRight() - this.thumbWidth / 2 - this.getPaddingLeft() - this.thumbWidth / 2;
        float range = this.mMax - this.mMin;
        return Math.round(delta / width * range);
    }

    @JvmOverloads
    public IsothermRangeSeekbar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Ldji/v5/ux/core/ui/component/IsothermRangeSeekbar$TextFormatCallback;", "", "format", "", "value", "", "android-sdk-v5-uxsdk_debug"})
    public static interface TextFormatCallback {
        @NotNull
        public String format(int var1);
    }
}

