/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 y2\u00020\u0001:\u0005yz{|}B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010G\u001a\u00020*2\b\u0010H\u001a\u0004\u0018\u00010IH\u0017J\u0010\u0010J\u001a\u00020K2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020NH\u0015J \u0010O\u001a\u00020*2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010P\u001a\u00020K2\u0006\u0010Q\u001a\u00020\u00102\u0006\u0010M\u001a\u00020NH\u0002J\u0018\u0010R\u001a\u00020K2\u0006\u0010Q\u001a\u00020\u00102\u0006\u0010M\u001a\u00020NH\u0002J\u0012\u0010S\u001a\u0004\u0018\u00010D2\u0006\u0010T\u001a\u00020\u0010H\u0002J\u0010\u0010U\u001a\u00020K2\u0006\u0010V\u001a\u00020IH\u0002J\u0010\u0010W\u001a\u00020*2\u0006\u0010T\u001a\u00020\u0010H\u0002J\u0010\u0010X\u001a\u00020*2\u0006\u0010T\u001a\u00020\u0010H\u0002J\u0010\u0010Y\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020>H\u0002J\u0010\u0010[\u001a\u00020K2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010\\\u001a\u00020K2\u0006\u0010\u000f\u001a\u00020>H\u0002J\u0010\u0010]\u001a\u00020K2\u0006\u0010\u000f\u001a\u00020>H\u0002J\u0010\u0010^\u001a\u00020>2\u0006\u0010_\u001a\u00020\u0010H\u0002J\u0010\u0010`\u001a\u00020>2\u0006\u0010\u000f\u001a\u00020>H\u0002J\u0010\u0010a\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010b\u001a\u00020cH\u0002J\b\u0010d\u001a\u00020cH\u0002J\u0010\u0010e\u001a\u00020c2\u0006\u0010\u000f\u001a\u00020>H\u0002J\b\u0010f\u001a\u00020KH\u0002J\u001e\u0010g\u001a\u00020K2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J&\u0010g\u001a\u00020K2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010J6\u0010g\u001a\u00020K2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010J\u0016\u0010h\u001a\u00020K2\u0006\u0010i\u001a\u00020\u00102\u0006\u0010j\u001a\u00020\u0010J\u0006\u0010k\u001a\u00020lJ\u0006\u0010m\u001a\u00020nJ\u0018\u0010o\u001a\u00020K2\u0006\u0010p\u001a\u00020\u00072\u0006\u0010q\u001a\u00020\u0007H\u0014J\b\u0010r\u001a\u00020sH\u0014J\u0010\u0010t\u001a\u00020K2\u0006\u0010u\u001a\u00020sH\u0014J\u0010\u0010v\u001a\u00020\u000b2\u0006\u0010w\u001a\u00020xH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR&\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR&\u0010!\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010+\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020*@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00105\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b6\u0010\u001bR\u000e\u00109\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Ldji/v5/ux/core/base/widget/BasicRangeSeekBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "leftThumbImg", "Landroid/graphics/Bitmap;", "rightThumbImg", "rightThumbOffset", "leftThumbOffset", "value", "", "minValue", "getMinValue", "()F", "maxValue", "stepValue", "gapValue", "lowerBoundaryValue", "largerBoundaryValue", "leftSideBarColor", "getLeftSideBarColor", "()I", "setLeftSideBarColor", "(I)V", "centerBarColor", "getCenterBarColor", "setCenterBarColor", "rightSideBarColor", "getRightSideBarColor", "setRightSideBarColor", "listener", "Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$OnRangeSeekBarListener;", "getListener", "()Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$OnRangeSeekBarListener;", "setListener", "(Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$OnRangeSeekBarListener;)V", "", "isShowLeftThumb", "()Z", "setShowLeftThumb", "(Z)V", "barHeight", "thumbLeftPointerPadding", "thumbRightPointerPadding", "thumbBackPadding", "isDragging", "stepsCount", "scaledTouchSlop", "getScaledTouchSlop", "scaledTouchSlop$delegate", "Lkotlin/Lazy;", "activePointerId", "downMotionX", "leftPadding", "rightPadding", "normalizedMinValue", "", "normalizedMaxValue", "normalizedGapValue", "normalizedLowerBoundaryValue", "normalizedLargerBoundaryValue", "pressedThumb", "Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$Thumb;", "paint", "Landroid/graphics/Paint;", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "onActionMove", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "stepValueValidation", "drawLeftThumb", "screenCoord", "drawRightThumb", "evalPressedThumb", "touchX", "onSecondaryPointerUp", "ev", "isInLeftThumbRange", "isInRightThumbRange", "normalizedToScreen", "normalizedPos", "trackTouchEvent", "setNormalizedMinValue", "setNormalizedMaxValue", "screenToNormalized", "screenPos", "valueToNormalize", "normalizeToValue", "getSelectedMinValue", "Ljava/math/BigDecimal;", "getSelectedMaxValue", "getValueAccordingToStep", "resetRange", "setRange", "setCurrentValues", "leftValue", "rightValue", "getRangeInfo", "Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$RangeInfo;", "getCurrentValues", "Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$Range;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSaveInstanceState", "Landroid/os/Parcelable;", "onRestoreInstanceState", "parcel", "toBitmap", "drawable", "Landroid/graphics/drawable/Drawable;", "Companion", "OnRangeSeekBarListener", "Range", "RangeInfo", "Thumb", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nBasicRangeSeekBarWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicRangeSeekBarWidget.kt\ndji/v5/ux/core/base/widget/BasicRangeSeekBar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,523:1\n1#2:524\n*E\n"})
public final class BasicRangeSeekBar
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bitmap leftThumbImg;
    @NotNull
    private final Bitmap rightThumbImg;
    private int rightThumbOffset;
    private int leftThumbOffset;
    private float minValue;
    private float maxValue;
    private float stepValue;
    private float gapValue;
    private float lowerBoundaryValue;
    private float largerBoundaryValue;
    @ColorInt
    private int leftSideBarColor;
    @ColorInt
    private int centerBarColor;
    @ColorInt
    private int rightSideBarColor;
    @Nullable
    private OnRangeSeekBarListener listener;
    private boolean isShowLeftThumb;
    private int barHeight;
    private int thumbLeftPointerPadding;
    private int thumbRightPointerPadding;
    private int thumbBackPadding;
    private boolean isDragging;
    private int stepsCount;
    @NotNull
    private final Lazy scaledTouchSlop$delegate;
    private int activePointerId;
    private float downMotionX;
    private float leftPadding;
    private float rightPadding;
    private double normalizedMinValue;
    private double normalizedMaxValue;
    private double normalizedGapValue;
    private double normalizedLowerBoundaryValue;
    private double normalizedLargerBoundaryValue;
    @Nullable
    private Thumb pressedThumb;
    @NotNull
    private final Paint paint;
    @NotNull
    private static final Rect srcThumbRect = new Rect();
    @NotNull
    private static final RectF dstThumbRectF = new RectF();
    @NotNull
    private static final Point center = new Point(0, 0);

    @JvmOverloads
    public BasicRangeSeekBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Resources resources;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.rightThumbOffset = 14;
        this.leftThumbOffset = 14;
        this.maxValue = 100.0f;
        this.stepValue = 1.0f;
        this.lowerBoundaryValue = 100.0f;
        this.leftSideBarColor = AndUtil.getResColor((int)R.color.uxsdk_checklist_seekbar_red_color);
        this.centerBarColor = AndUtil.getResColor((int)R.color.uxsdk_checklist_warning_bg_color);
        this.rightSideBarColor = AndUtil.getResColor((int)R.color.uxsdk_checklist_seekbar_gray_color);
        this.isShowLeftThumb = true;
        this.thumbRightPointerPadding = 24;
        this.scaledTouchSlop$delegate = LazyKt.lazy(() -> BasicRangeSeekBar.scaledTouchSlop_delegate$lambda$0(this));
        this.activePointerId = 255;
        this.normalizedMaxValue = 1.0;
        this.normalizedLowerBoundaryValue = 1.0;
        this.paint = new Paint(1);
        Resources $this$_init__u24lambda_u241 = resources = context.getResources();
        boolean bl = false;
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.uxsdk_ic_slider_block_red);
        Intrinsics.checkNotNull((Object)drawable2);
        this.leftThumbImg = this.toBitmap(drawable2);
        Drawable drawable3 = ContextCompat.getDrawable((Context)context, (int)R.drawable.uxsdk_ic_slider_block_orange);
        Intrinsics.checkNotNull((Object)drawable3);
        this.rightThumbImg = this.toBitmap(drawable3);
        this.thumbBackPadding = (int)AndUtil.getDimension((int)R.dimen.uxsdk_5_dp);
        this.thumbLeftPointerPadding = (int)AndUtil.getDimension((int)R.dimen.uxsdk_4_dp);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            TypedArray typedArray;
            AttributeSet it = attributeSet;
            boolean bl2 = false;
            TypedArray $this$lambda_u243_u24lambda_u242 = typedArray = context.obtainStyledAttributes(it, R.styleable.BasicRangeSeekBar);
            boolean bl3 = false;
            this.setCenterBarColor($this$lambda_u243_u24lambda_u242.getColor(R.styleable.BasicRangeSeekBar_uxsdk_bar_center_color, this.centerBarColor));
            this.setLeftSideBarColor($this$lambda_u243_u24lambda_u242.getColor(R.styleable.BasicRangeSeekBar_uxsdk_bar_left_side_color, this.leftSideBarColor));
            this.setRightSideBarColor($this$lambda_u243_u24lambda_u242.getColor(R.styleable.BasicRangeSeekBar_uxsdk_bar_right_side_color, this.rightSideBarColor));
            this.minValue = $this$lambda_u243_u24lambda_u242.getFloat(R.styleable.BasicRangeSeekBar_uxsdk_bar_min_value, this.minValue);
            this.maxValue = $this$lambda_u243_u24lambda_u242.getFloat(R.styleable.BasicRangeSeekBar_uxsdk_bar_max_value, this.maxValue);
            this.stepValue = $this$lambda_u243_u24lambda_u242.getFloat(R.styleable.BasicRangeSeekBar_uxsdk_bar_step_value, this.stepValue);
            if (this.maxValue < this.minValue) {
                throw new Exception("Min value can't be higher than max value");
            }
            if (!this.stepValueValidation(this.minValue, this.maxValue, this.stepValue)) {
                throw new Exception("Incorrect min/max/step, it must be: (maxValue - minValue) % stepValue == 0f");
            }
            this.stepsCount = (int)((this.maxValue - this.minValue) / this.stepValue);
            this.barHeight = $this$lambda_u243_u24lambda_u242.getDimensionPixelSize(R.styleable.BasicRangeSeekBar_uxsdk_bar_height, this.barHeight);
            $this$lambda_u243_u24lambda_u242.recycle();
        }
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
    }

    public /* synthetic */ BasicRangeSeekBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final float getMinValue() {
        return this.minValue;
    }

    public final int getLeftSideBarColor() {
        return this.leftSideBarColor;
    }

    public final void setLeftSideBarColor(int value) {
        this.leftSideBarColor = value;
        this.invalidate();
    }

    public final int getCenterBarColor() {
        return this.centerBarColor;
    }

    public final void setCenterBarColor(int value) {
        this.centerBarColor = value;
        this.invalidate();
    }

    public final int getRightSideBarColor() {
        return this.rightSideBarColor;
    }

    public final void setRightSideBarColor(int value) {
        this.rightSideBarColor = value;
        this.invalidate();
    }

    @Nullable
    public final OnRangeSeekBarListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable OnRangeSeekBarListener onRangeSeekBarListener) {
        this.listener = onRangeSeekBarListener;
    }

    public final boolean isShowLeftThumb() {
        return this.isShowLeftThumb;
    }

    public final void setShowLeftThumb(boolean value) {
        this.isShowLeftThumb = value;
        this.invalidate();
    }

    private final int getScaledTouchSlop() {
        Lazy lazy = this.scaledTouchSlop$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        MotionEvent motionEvent = event;
        if (motionEvent != null) {
            MotionEvent event2 = motionEvent;
            boolean bl = false;
            int pointerIndex = 0;
            switch (event2.getAction() & 0xFF) {
                case 0: {
                    this.activePointerId = event2.getPointerId(event2.getPointerCount() - 1);
                    pointerIndex = event2.findPointerIndex(this.activePointerId);
                    this.downMotionX = event2.getX(pointerIndex);
                    this.pressedThumb = this.evalPressedThumb(this.downMotionX);
                    if (this.pressedThumb == null) {
                        return super.onTouchEvent(event2);
                    }
                    this.setPressed(true);
                    this.invalidate();
                    this.isDragging = true;
                    this.trackTouchEvent(event2);
                    ViewParent viewParent = this.getParent();
                    if (viewParent != null) {
                        viewParent.requestDisallowInterceptTouchEvent(true);
                    }
                    System.out.println();
                    break;
                }
                case 2: {
                    this.onActionMove(event2);
                    break;
                }
                case 1: {
                    if (this.isDragging) {
                        this.trackTouchEvent(event2);
                        this.isDragging = false;
                        this.setPressed(false);
                    } else {
                        this.isDragging = true;
                        this.trackTouchEvent(event2);
                        this.isDragging = false;
                    }
                    OnRangeSeekBarListener onRangeSeekBarListener = this.listener;
                    if (onRangeSeekBarListener != null) {
                        onRangeSeekBarListener.onValuesChanged(this.getSelectedMinValue().floatValue(), this.getSelectedMaxValue().floatValue());
                    }
                    this.pressedThumb = null;
                    this.invalidate();
                    break;
                }
                case 5: {
                    int index = event2.getPointerCount() - 1;
                    this.downMotionX = event2.getX(index);
                    this.activePointerId = event2.getPointerId(index);
                    this.invalidate();
                    break;
                }
                case 6: {
                    this.onSecondaryPointerUp(event2);
                    this.invalidate();
                    break;
                }
                case 3: {
                    if (this.isDragging) {
                        this.isDragging = false;
                    }
                    this.setPressed(false);
                    this.invalidate();
                }
            }
        } else {
            BasicRangeSeekBar $this$onTouchEvent_u24lambda_u245 = this;
            boolean bl = false;
            return false;
        }
        return true;
    }

    private final void onActionMove(MotionEvent event) {
        Thumb thumb = this.pressedThumb;
        if (thumb != null) {
            Thumb it = thumb;
            boolean bl = false;
            int pointerIndex = 0;
            OnRangeSeekBarListener onRangeSeekBarListener = this.listener;
            if (onRangeSeekBarListener != null) {
                onRangeSeekBarListener.onValuesChanging(this.getSelectedMinValue().floatValue(), this.getSelectedMaxValue().floatValue());
            }
            if (this.isDragging) {
                this.trackTouchEvent(event);
            } else {
                pointerIndex = event.findPointerIndex(this.activePointerId);
                float x = event.getX(pointerIndex);
                if (Math.abs(x - this.downMotionX) > (float)this.getScaledTouchSlop()) {
                    this.setPressed(true);
                    this.invalidate();
                    this.isDragging = true;
                    this.trackTouchEvent(event);
                    ViewParent viewParent = this.getParent();
                    if (viewParent != null) {
                        viewParent.requestDisallowInterceptTouchEvent(true);
                    }
                    System.out.println();
                }
            }
        }
        System.out.println();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(@NotNull Canvas canvas) {
        Canvas canvas2;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.leftPadding = this.leftThumbImg.getWidth() + this.thumbLeftPointerPadding;
        this.rightPadding = this.getWidth() - this.rightThumbImg.getWidth() - this.thumbRightPointerPadding;
        center.set(this.getWidth() / 2, this.getHeight() / 2);
        float top = (float)BasicRangeSeekBar.center.y - (float)this.barHeight / 2.0f;
        float bottom = (float)BasicRangeSeekBar.center.y + (float)this.barHeight / 2.0f;
        float minScreenPos = this.normalizedToScreen(this.normalizedMinValue);
        float maxScreenPos = this.normalizedToScreen(this.normalizedMaxValue);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        Canvas $this$onDraw_u24lambda_u247 = canvas2 = canvas;
        boolean bl = false;
        RectF rectUnusedArea = new RectF();
        rectUnusedArea.top = top;
        rectUnusedArea.bottom = bottom;
        rectUnusedArea.left = this.leftPadding;
        rectUnusedArea.right = minScreenPos;
        this.paint.setColor(this.isShowLeftThumb ? this.leftSideBarColor : this.centerBarColor);
        RectF bufRect = new RectF(rectUnusedArea);
        bufRect.left += (float)10;
        $this$onDraw_u24lambda_u247.drawRect(bufRect, this.paint);
        $this$onDraw_u24lambda_u247.drawRoundRect(rectUnusedArea, 10.0f, 10.0f, this.paint);
        rectUnusedArea.right = this.rightPadding;
        rectUnusedArea.left = maxScreenPos;
        this.paint.setColor(this.rightSideBarColor);
        RectF bufRect1 = new RectF(rectUnusedArea);
        bufRect1.right -= (float)10;
        $this$onDraw_u24lambda_u247.drawRect(bufRect1, this.paint);
        $this$onDraw_u24lambda_u247.drawRoundRect(rectUnusedArea, 10.0f, 10.0f, this.paint);
        rectUnusedArea.left = minScreenPos;
        rectUnusedArea.right = maxScreenPos;
        this.paint.setColor(this.centerBarColor);
        $this$onDraw_u24lambda_u247.drawRect(rectUnusedArea, this.paint);
        if (this.isShowLeftThumb) {
            this.drawLeftThumb(minScreenPos, canvas);
        }
        this.drawRightThumb(maxScreenPos, canvas);
    }

    private final boolean stepValueValidation(float minValue, float maxValue, float stepValue) {
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(maxValue)).subtract(new BigDecimal(String.valueOf(minValue)));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.subtract(other)");
        BigDecimal bigDecimal2 = bigDecimal.remainder(new BigDecimal(String.valueOf(stepValue)));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.remainder(other)");
        return Intrinsics.areEqual((Object)bigDecimal2, (Object)new BigDecimal(String.valueOf(0.0f)));
    }

    private final void drawLeftThumb(float screenCoord, Canvas canvas) {
        srcThumbRect.set(0, 0, this.leftThumbImg.getWidth(), this.leftThumbImg.getHeight());
        dstThumbRectF.set(screenCoord - (float)this.leftThumbImg.getWidth() + (float)this.leftThumbOffset, (float)BasicRangeSeekBar.center.y - (float)this.leftThumbImg.getHeight() * 0.5f, screenCoord + (float)this.leftThumbOffset, (float)BasicRangeSeekBar.center.y + (float)this.leftThumbImg.getHeight() * 0.5f);
        canvas.drawBitmap(this.leftThumbImg, srcThumbRect, dstThumbRectF, this.paint);
    }

    private final void drawRightThumb(float screenCoord, Canvas canvas) {
        srcThumbRect.set(0, 0, this.rightThumbImg.getWidth(), this.rightThumbImg.getHeight());
        dstThumbRectF.set(screenCoord - (float)this.rightThumbOffset, (float)BasicRangeSeekBar.center.y - (float)this.rightThumbImg.getHeight() * 0.5f, screenCoord + (float)this.rightThumbImg.getWidth() - (float)this.rightThumbOffset, (float)BasicRangeSeekBar.center.y + (float)this.rightThumbImg.getHeight() * 0.5f);
        canvas.drawBitmap(this.rightThumbImg, srcThumbRect, dstThumbRectF, this.paint);
    }

    private final Thumb evalPressedThumb(float touchX) {
        boolean minThumbPressed = this.isInLeftThumbRange(touchX);
        boolean maxThumbPressed = this.isInRightThumbRange(touchX);
        return minThumbPressed && maxThumbPressed ? (this.isShowLeftThumb && touchX / (float)this.getWidth() > 0.5f ? Thumb.MIN : Thumb.MAX) : (this.isShowLeftThumb && minThumbPressed ? Thumb.MIN : (maxThumbPressed ? Thumb.MAX : null));
    }

    private final void onSecondaryPointerUp(MotionEvent ev) {
        int n;
        int $this$onSecondaryPointerUp_u24lambda_u248 = n = (ev.getAction() & 0xFF00) >> 8;
        boolean bl = false;
        if (ev.getPointerId($this$onSecondaryPointerUp_u24lambda_u248) == this.activePointerId) {
            int newPointerIndex = $this$onSecondaryPointerUp_u24lambda_u248 == 0 ? 1 : 0;
            this.downMotionX = ev.getX(newPointerIndex);
            this.activePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    private final boolean isInLeftThumbRange(float touchX) {
        float f = (float)this.leftThumbImg.getWidth() + 40.0f;
        float f2 = this.normalizedToScreen(this.normalizedMinValue) - touchX;
        return -4.0f <= f2 ? f2 <= f : false;
    }

    private final boolean isInRightThumbRange(float touchX) {
        float f = (float)this.rightThumbImg.getWidth() + 40.0f;
        float f2 = touchX - this.normalizedToScreen(this.normalizedMaxValue);
        return -4.0f <= f2 ? f2 <= f : false;
    }

    private final float normalizedToScreen(double normalizedPos) {
        return (float)((double)this.leftPadding + normalizedPos * (double)((float)this.getWidth() - this.leftPadding * (float)2));
    }

    private final void trackTouchEvent(MotionEvent event) {
        int pointerIndex = event.findPointerIndex(this.activePointerId);
        float x = event.getX(pointerIndex);
        if (Thumb.MIN == this.pressedThumb) {
            this.setNormalizedMinValue(this.screenToNormalized(x));
        } else if (Thumb.MAX == this.pressedThumb) {
            this.setNormalizedMaxValue(this.screenToNormalized(x));
        }
    }

    private final void setNormalizedMinValue(double value) {
        this.normalizedMinValue = Math.max(0.0, Math.min(1.0, Math.min(value, Math.min(this.normalizedMaxValue + this.normalizedGapValue, this.normalizedLowerBoundaryValue))));
        this.invalidate();
    }

    private final void setNormalizedMaxValue(double value) {
        this.normalizedMaxValue = Math.max(0.0, Math.min(1.0, Math.max(value, Math.max(this.normalizedMinValue - this.normalizedGapValue, this.normalizedLargerBoundaryValue))));
        this.invalidate();
    }

    private final double screenToNormalized(float screenPos) {
        double d;
        int width = this.getWidth();
        if ((float)width <= this.leftPadding * (float)2) {
            d = 0.0;
        } else {
            double result = (screenPos - this.leftPadding) / ((float)width - this.leftPadding * (float)2);
            d = Math.min(1.0, Math.max(0.0, result));
        }
        return d;
    }

    private final double valueToNormalize(double value) {
        return (double)(this.maxValue - this.minValue) * (value * (double)100) / (double)100 + (double)this.minValue;
    }

    private final float normalizeToValue(float value) {
        return (value - this.minValue) * (float)100 / (this.maxValue - this.minValue) / (float)100;
    }

    private final BigDecimal getSelectedMinValue() {
        return this.getValueAccordingToStep(this.valueToNormalize(this.normalizedMinValue));
    }

    private final BigDecimal getSelectedMaxValue() {
        return this.getValueAccordingToStep(this.valueToNormalize(this.normalizedMaxValue));
    }

    private final BigDecimal getValueAccordingToStep(double value) {
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(value)).divide(new BigDecimal(String.valueOf(this.stepValue)), RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.divide(other, RoundingMode.HALF_EVEN)");
        BigDecimal bigDecimal2 = BigDecimal.valueOf(MathKt.roundToInt((double)bigDecimal.doubleValue()));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(this.toLong())");
        BigDecimal bigDecimal3 = bigDecimal2.multiply(new BigDecimal(String.valueOf(this.stepValue)));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.multiply(other)");
        return bigDecimal3;
    }

    private final void resetRange() {
        if (this.maxValue < this.minValue) {
            throw new Exception("Min value can't be higher than max value");
        }
        if (!this.stepValueValidation(this.minValue, this.maxValue, this.stepValue)) {
            throw new Exception("Incorrect min/max/step, it must be: (maxValue - minValue) % stepValue == 0f");
        }
        this.normalizedMinValue = 0.0;
        this.normalizedMaxValue = 1.0;
        this.normalizedGapValue = this.normalizeToValue(this.gapValue);
        this.normalizedLowerBoundaryValue = this.normalizeToValue(this.lowerBoundaryValue);
        this.normalizedLargerBoundaryValue = this.normalizeToValue(this.largerBoundaryValue);
        this.invalidate();
    }

    public final void setRange(float minValue, float maxValue, float stepValue) {
        this.setRange(minValue, maxValue, stepValue, 0.0f, 100.0f, 0.0f);
    }

    public final void setRange(float minValue, float maxValue, float stepValue, float gapValue) {
        this.setRange(minValue, maxValue, stepValue, gapValue, 100.0f, 0.0f);
    }

    public final void setRange(float minValue, float maxValue, float stepValue, float gapValue, float lowerBoundaryValue, float largerBoundaryValue) {
        boolean notChange;
        boolean bl = notChange = Float.compare(this.minValue, minValue) == 0 && Float.compare(this.maxValue, maxValue) == 0 && Float.compare(this.stepValue, stepValue) == 0 && Float.compare(this.gapValue, gapValue) == 0 && Float.compare(this.lowerBoundaryValue, lowerBoundaryValue) == 0 && Float.compare(this.largerBoundaryValue, largerBoundaryValue) == 0;
        if (notChange) {
            return;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepValue = stepValue;
        this.gapValue = gapValue;
        this.lowerBoundaryValue = lowerBoundaryValue;
        this.largerBoundaryValue = largerBoundaryValue;
        this.resetRange();
    }

    public final void setCurrentValues(float leftValue, float rightValue) {
        boolean valueNotChanged;
        if (leftValue > rightValue) {
            throw new Exception("LeftValue " + leftValue + " can't be higher than rightValue " + rightValue);
        }
        if (leftValue < this.minValue || rightValue > this.maxValue) {
            throw new Exception(leftValue + " or " + rightValue + " Out of range[" + this.minValue + ", " + this.maxValue + "]");
        }
        if (!this.stepValueValidation(leftValue, this.maxValue, this.stepValue) || !this.stepValueValidation(this.minValue, rightValue, this.stepValue)) {
            throw new Exception("You can't set these values according to your step");
        }
        double newNormalizedMinValue = this.normalizeToValue(leftValue);
        double newNormalizedMaxValue = this.normalizeToValue(rightValue);
        boolean bl = valueNotChanged = Double.compare(this.normalizedMinValue, newNormalizedMinValue) == 0 && Double.compare(this.normalizedMaxValue, newNormalizedMaxValue) == 0;
        if (valueNotChanged) {
            return;
        }
        this.normalizedMinValue = newNormalizedMinValue;
        this.normalizedMaxValue = newNormalizedMaxValue;
        this.invalidate();
    }

    @NotNull
    public final RangeInfo getRangeInfo() {
        return new RangeInfo(this.minValue, this.maxValue, this.stepValue, this.gapValue);
    }

    @NotNull
    public final Range getCurrentValues() {
        return new Range(this.getSelectedMinValue().floatValue(), this.getSelectedMaxValue().floatValue());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = 200;
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        int height = this.leftThumbImg.getHeight();
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) != 0) {
            height = Math.max(height, View.MeasureSpec.getSize((int)heightMeasureSpec));
        }
        this.setMeasuredDimension(width, height);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("SUPER", super.onSaveInstanceState());
        bundle.putDouble("LEFT_VALUE", this.normalizedMinValue);
        bundle.putDouble("RIGHT_VALUE", this.normalizedMaxValue);
        bundle.putFloat("MIN_VALUE", this.minValue);
        bundle.putFloat("MAX_VALUE", this.maxValue);
        bundle.putFloat("STEP_VALUE", this.stepValue);
        bundle.putInt("SIDE_BAR_COLOR", this.leftSideBarColor);
        bundle.putInt("CENTER_BAR_COLOR", this.centerBarColor);
        bundle.putInt("TRANSITION_BAR_COLOR", this.rightSideBarColor);
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        Bundle bundle = (Bundle)parcel;
        super.onRestoreInstanceState(bundle.getParcelable("SUPER"));
        this.normalizedMinValue = bundle.getDouble("LEFT_VALUE");
        this.normalizedMaxValue = bundle.getDouble("RIGHT_VALUE");
        this.minValue = bundle.getFloat("MIN_VALUE");
        this.maxValue = bundle.getFloat("MAX_VALUE");
        this.stepValue = bundle.getFloat("STEP_VALUE");
        this.setLeftSideBarColor(bundle.getInt("SIDE_BAR_COLOR"));
        this.setCenterBarColor(bundle.getInt("CENTER_BAR_COLOR"));
        this.setRightSideBarColor(bundle.getInt("TRANSITION_BAR_COLOR"));
        this.invalidate();
    }

    private final Bitmap toBitmap(Drawable drawable2) {
        Canvas canvas;
        if (drawable2 instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"getBitmap(...)");
            return bitmap;
        }
        Drawable $this$toBitmap_u24lambda_u2410 = drawable2;
        boolean bl = false;
        int width = !$this$toBitmap_u24lambda_u2410.getBounds().isEmpty() ? $this$toBitmap_u24lambda_u2410.getBounds().width() : $this$toBitmap_u24lambda_u2410.getIntrinsicWidth();
        int height = !$this$toBitmap_u24lambda_u2410.getBounds().isEmpty() ? $this$toBitmap_u24lambda_u2410.getBounds().height() : $this$toBitmap_u24lambda_u2410.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)(width <= 0 ? 1 : width), (int)(height <= 0 ? 1 : height), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap bitmap2 = bitmap;
        Canvas $this$toBitmap_u24lambda_u2410_u24lambda_u249 = canvas = new Canvas(bitmap2);
        boolean bl2 = false;
        $this$toBitmap_u24lambda_u2410.setBounds(0, 0, width, height);
        $this$toBitmap_u24lambda_u2410.draw($this$toBitmap_u24lambda_u2410_u24lambda_u249);
        return bitmap2;
    }

    @JvmOverloads
    public BasicRangeSeekBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BasicRangeSeekBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final int scaledTouchSlop_delegate$lambda$0(BasicRangeSeekBar this$0) {
        return ViewConfiguration.get((Context)this$0.getContext()).getScaledTouchSlop();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$Companion;", "", "<init>", "()V", "srcThumbRect", "Landroid/graphics/Rect;", "dstThumbRectF", "Landroid/graphics/RectF;", "center", "Landroid/graphics/Point;", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$OnRangeSeekBarListener;", "", "onValuesChanging", "", "minValue", "", "maxValue", "onValuesChanged", "android-sdk-v5-uxsdk_debug"})
    public static interface OnRangeSeekBarListener {
        public void onValuesChanging(float var1, float var2);

        public void onValuesChanged(float var1, float var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$Range;", "", "leftValue", "", "rightValue", "<init>", "(FF)V", "getLeftValue", "()F", "getRightValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
    public static final class Range {
        private final float leftValue;
        private final float rightValue;

        public Range(float leftValue, float rightValue) {
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        public final float getLeftValue() {
            return this.leftValue;
        }

        public final float getRightValue() {
            return this.rightValue;
        }

        public final float component1() {
            return this.leftValue;
        }

        public final float component2() {
            return this.rightValue;
        }

        @NotNull
        public final Range copy(float leftValue, float rightValue) {
            return new Range(leftValue, rightValue);
        }

        public static /* synthetic */ Range copy$default(Range range, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = range.leftValue;
            }
            if ((n & 2) != 0) {
                f2 = range.rightValue;
            }
            return range.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "Range(leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.leftValue);
            result = result * 31 + Float.hashCode(this.rightValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (Float.compare(this.leftValue, range.leftValue) != 0) {
                return false;
            }
            return Float.compare(this.rightValue, range.rightValue) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$RangeInfo;", "", "minValue", "", "maxValue", "stepValue", "gapValue", "<init>", "(FFFF)V", "getMinValue", "()F", "getMaxValue", "getStepValue", "getGapValue", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
    public static final class RangeInfo {
        private final float minValue;
        private final float maxValue;
        private final float stepValue;
        private final float gapValue;

        public RangeInfo(float minValue, float maxValue, float stepValue, float gapValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.stepValue = stepValue;
            this.gapValue = gapValue;
        }

        public final float getMinValue() {
            return this.minValue;
        }

        public final float getMaxValue() {
            return this.maxValue;
        }

        public final float getStepValue() {
            return this.stepValue;
        }

        public final float getGapValue() {
            return this.gapValue;
        }

        public final float component1() {
            return this.minValue;
        }

        public final float component2() {
            return this.maxValue;
        }

        public final float component3() {
            return this.stepValue;
        }

        public final float component4() {
            return this.gapValue;
        }

        @NotNull
        public final RangeInfo copy(float minValue, float maxValue, float stepValue, float gapValue) {
            return new RangeInfo(minValue, maxValue, stepValue, gapValue);
        }

        public static /* synthetic */ RangeInfo copy$default(RangeInfo rangeInfo, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 1) != 0) {
                f = rangeInfo.minValue;
            }
            if ((n & 2) != 0) {
                f2 = rangeInfo.maxValue;
            }
            if ((n & 4) != 0) {
                f3 = rangeInfo.stepValue;
            }
            if ((n & 8) != 0) {
                f4 = rangeInfo.gapValue;
            }
            return rangeInfo.copy(f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            return "RangeInfo(minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", stepValue=" + this.stepValue + ", gapValue=" + this.gapValue + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.minValue);
            result = result * 31 + Float.hashCode(this.maxValue);
            result = result * 31 + Float.hashCode(this.stepValue);
            result = result * 31 + Float.hashCode(this.gapValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RangeInfo)) {
                return false;
            }
            RangeInfo rangeInfo = (RangeInfo)other;
            if (Float.compare(this.minValue, rangeInfo.minValue) != 0) {
                return false;
            }
            if (Float.compare(this.maxValue, rangeInfo.maxValue) != 0) {
                return false;
            }
            if (Float.compare(this.stepValue, rangeInfo.stepValue) != 0) {
                return false;
            }
            return Float.compare(this.gapValue, rangeInfo.gapValue) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/core/base/widget/BasicRangeSeekBar$Thumb;", "", "<init>", "(Ljava/lang/String;I)V", "MIN", "MAX", "android-sdk-v5-uxsdk_debug"})
    private static final class Thumb
    extends Enum<Thumb> {
        public static final /* enum */ Thumb MIN = new Thumb();
        public static final /* enum */ Thumb MAX = new Thumb();
        private static final /* synthetic */ Thumb[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Thumb[] values() {
            return (Thumb[])$VALUES.clone();
        }

        public static Thumb valueOf(String value) {
            return Enum.valueOf(Thumb.class, value);
        }

        @NotNull
        public static EnumEntries<Thumb> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = thumbArray = new Thumb[]{Thumb.MIN, Thumb.MAX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

