/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.panel;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import dji.v5.ux.R;
import dji.v5.ux.core.base.panel.PanelItem;
import dji.v5.ux.core.base.panel.PanelWidget;
import dji.v5.ux.core.base.panel.PanelWidgetConfiguration;
import dji.v5.ux.core.base.panel.PanelWidgetType;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.util.ViewIDGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\"\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003_`aB/\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\"\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J,\u0010&\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010'\u001a\u0004\u0018\u00010\fH\u0014J\u0012\u0010(\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020\nH\u0016J\u001b\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-H\u0016\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\nH\u0016J\u0018\u00100\u001a\u00020+2\u0006\u0010)\u001a\u00020\n2\u0006\u00101\u001a\u00020\u0004H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020\nH\u0016J\b\u00103\u001a\u00020+H\u0014J\b\u00104\u001a\u00020%H\u0016J/\u00105\u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0-\u00a2\u0006\u0002\u0010;JH\u0010<\u001a\u00020%2\u0006\u00106\u001a\u00020\n2\u0006\u0010=\u001a\u00020>2\b\b\u0002\u0010?\u001a\u00020@2\b\b\u0002\u0010A\u001a\u00020\n2\b\b\u0002\u0010B\u001a\u00020\n2\b\b\u0002\u0010C\u001a\u00020\n2\b\b\u0002\u0010D\u001a\u00020\nJ\u000e\u0010E\u001a\u00020%2\u0006\u00106\u001a\u00020\nJ\u000e\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020>J\u0010\u0010H\u001a\u0004\u0018\u00010>2\u0006\u00106\u001a\u00020\nJ\u0014\u0010I\u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u00106\u001a\u00020\nJ\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u00106\u001a\u00020\nJ\u000e\u0010K\u001a\u00020\n2\u0006\u00106\u001a\u00020\nJ,\u0010L\u001a\u00020%2\u0006\u0010M\u001a\u00020\u00142\b\b\u0002\u0010N\u001a\u00020\u00142\b\b\u0003\u0010O\u001a\u00020\n2\b\b\u0003\u0010P\u001a\u00020\nJ\u000e\u0010Q\u001a\u00020%2\u0006\u00106\u001a\u00020\nJ\u000e\u0010R\u001a\u00020%2\u0006\u00106\u001a\u00020\nJ\u0010\u0010S\u001a\u0004\u0018\u00010@2\u0006\u00106\u001a\u00020\nJ>\u0010T\u001a\u00020%2\u0006\u00106\u001a\u00020\n2\u0006\u0010?\u001a\u00020@2\b\b\u0002\u0010A\u001a\u00020\n2\b\b\u0002\u0010B\u001a\u00020\n2\b\b\u0002\u0010C\u001a\u00020\n2\b\b\u0002\u0010D\u001a\u00020\nJ\u0018\u0010U\u001a\u00020%2\u0006\u00106\u001a\u00020\n2\b\b\u0001\u0010V\u001a\u00020\nJ\u0016\u0010W\u001a\u00020%2\u0006\u00106\u001a\u00020\n2\u0006\u0010X\u001a\u00020\u0014J@\u0010Y\u001a\u00020%2\u0006\u00106\u001a\u00020\n2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\nH\u0002J\u0010\u0010Z\u001a\u00020%2\u0006\u00106\u001a\u00020\nH\u0002J\u001c\u0010[\u001a\u00020%2\b\b\u0002\u0010\\\u001a\u00020\u00142\b\b\u0002\u0010]\u001a\u00020\u0014H\u0002J\b\u0010^\u001a\u00020%H\u0002R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u0010j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u0011\u0010\u001e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006b"}, d2={"Ldji/v5/ux/core/base/panel/FreeFormPanelWidget;", "T", "", "Ldji/v5/ux/core/base/panel/PanelWidget;", "Ldji/v5/ux/core/base/panel/PanelItem;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "configuration", "Ldji/v5/ux/core/base/panel/PanelWidgetConfiguration;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;ILdji/v5/ux/core/base/panel/PanelWidgetConfiguration;)V", "paneMap", "Ljava/util/HashMap;", "Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$Pane;", "Lkotlin/collections/HashMap;", "isLabelAssistEnabled", "", "isBackgroundAssistEnabled", "debugTextColor", "getDebugTextColor", "()I", "setDebugTextColor", "(I)V", "debugTextBackgroundColor", "getDebugTextBackgroundColor", "setDebugTextBackgroundColor", "rootID", "getRootID", "listOfViewIds", "", "getListOfViewIds", "()Ljava/util/List;", "initView", "", "initPanelWidget", "widgetConfiguration", "getWidget", "index", "addWidgets", "", "items", "", "([Ldji/v5/ux/core/base/panel/PanelItem;)Ljava/lang/Void;", "size", "addWidget", "item", "removeWidget", "updateUI", "removeAllWidgets", "splitPane", "paneId", "splitType", "Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$SplitType;", "proportions", "", "(ILdji/v5/ux/core/base/panel/FreeFormPanelWidget$SplitType;[Ljava/lang/Float;)Ljava/util/List;", "addView", "widgetView", "Landroid/view/View;", "position", "Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$ViewAlignment;", "leftMargin", "topMargin", "rightMargin", "bottomMargin", "removeView", "findViewPane", "view", "viewInPane", "getSiblingList", "getChildrenList", "getParentId", "enablePaneDebug", "enableLabelAssist", "enableBackgroundAssist", "textColor", "textBackgroundColor", "mergeChildren", "mergeSiblings", "getPanePositioning", "setPanePosition", "setPaneBackgroundColor", "color", "setPaneVisibility", "isVisible", "setViewAlignment", "mergePaneChildren", "addDebugViews", "isLabelAssist", "isBackgroundAssist", "removeDebugViews", "ViewAlignment", "Pane", "SplitType", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nFreeFormPanelWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreeFormPanelWidget.kt\ndji/v5/ux/core/base/panel/FreeFormPanelWidget\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ViewGroup.kt\nandroidx/core/view/ViewGroupKt\n*L\n1#1,727:1\n515#2:728\n500#2,6:729\n515#2:741\n500#2,6:742\n515#2:748\n500#2,6:749\n515#2:755\n500#2,6:756\n13644#3,3:735\n13600#3,2:738\n36#4:740\n36#4:762\n*S KotlinDebug\n*F\n+ 1 FreeFormPanelWidget.kt\ndji/v5/ux/core/base/panel/FreeFormPanelWidget\n*L\n96#1:728\n96#1:729,6\n318#1:741\n318#1:742,6\n586#1:748\n586#1:749,6\n619#1:755\n619#1:756,6\n208#1:735,3\n260#1:738,2\n307#1:740\n634#1:762\n*E\n"})
public abstract class FreeFormPanelWidget<T>
extends PanelWidget<PanelItem, T> {
    @NotNull
    private final HashMap<Integer, Pane> paneMap;
    private boolean isLabelAssistEnabled;
    private boolean isBackgroundAssistEnabled;
    private int debugTextColor;
    private int debugTextBackgroundColor;
    private final int rootID;

    @JvmOverloads
    public FreeFormPanelWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull PanelWidgetConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(context, attrs, defStyleAttr, configuration);
        this.paneMap = new HashMap();
        this.debugTextColor = ViewExtensions.getColor((View)this, R.color.uxsdk_white);
        this.debugTextBackgroundColor = ViewExtensions.getColor((View)this, R.color.uxsdk_black);
        this.rootID = ViewIDGenerator.INSTANCE.generateViewId();
        if (!(this.getPanelWidgetConfiguration().getPanelWidgetType() == PanelWidgetType.FREE_FORM)) {
            boolean $i$a$-check-FreeFormPanelWidget$22 = false;
            String $i$a$-check-FreeFormPanelWidget$22 = "PanelWidgetConfiguration.panelWidgetType should be PanelWidgetType.FREE_FORM";
            throw new IllegalStateException($i$a$-check-FreeFormPanelWidget$22.toString());
        }
        View defaultView = new View(context);
        this.addView(defaultView, this.getChildCount());
        defaultView.setId(this.rootID);
        defaultView.setBackgroundColor(ViewExtensions.getColor((View)this, R.color.uxsdk_yellow));
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)this);
        constraintSet.constrainHeight(this.rootID, 0);
        constraintSet.constrainWidth(this.rootID, 0);
        PanelWidget.constraintToParentStart$default(this, constraintSet, defaultView, 0, 2, null);
        PanelWidget.constraintToParentEnd$default(this, constraintSet, defaultView, 0, 2, null);
        PanelWidget.constraintToParentBottom$default(this, constraintSet, defaultView, 0, 2, null);
        PanelWidget.constraintToParentTop$default(this, constraintSet, defaultView, 0, 2, null);
        constraintSet.applyTo((ConstraintLayout)this);
        ((Map)this.paneMap).put(this.rootID, new Pane(this.rootID, -1, defaultView, 0, false, null, null, null, null, null, 1016, null));
    }

    public /* synthetic */ FreeFormPanelWidget(Context context, AttributeSet attributeSet, int n, PanelWidgetConfiguration panelWidgetConfiguration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n, panelWidgetConfiguration);
    }

    public final int getDebugTextColor() {
        return this.debugTextColor;
    }

    public final void setDebugTextColor(int n) {
        this.debugTextColor = n;
    }

    public final int getDebugTextBackgroundColor() {
        return this.debugTextBackgroundColor;
    }

    public final void setDebugTextBackgroundColor(int n) {
        this.debugTextBackgroundColor = n;
    }

    public final int getRootID() {
        return this.rootID;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getListOfViewIds() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.paneMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!((Pane)it.getValue()).isSplit())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @Override
    protected void initPanelWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable PanelWidgetConfiguration widgetConfiguration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @Override
    @Nullable
    public PanelItem getWidget(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Try findViewPane instead");
    }

    @NotNull
    public Void addWidgets(@NotNull PanelItem[] items) throws UnsupportedOperationException {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        throw new UnsupportedOperationException("This call is not supported.");
    }

    @Override
    public int size() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This call is not supported.");
    }

    @NotNull
    public Void addWidget(int index, @NotNull PanelItem item) throws UnsupportedOperationException {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        throw new UnsupportedOperationException("Try addView instead");
    }

    @Override
    @Nullable
    public PanelItem removeWidget(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Try remove view instead");
    }

    @NotNull
    protected Void updateUI() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This call is not supported.");
    }

    @Override
    public void removeAllWidgets() {
        Iterator iterator = ((Map)this.paneMap).entrySet().iterator();
        while (iterator.hasNext()) {
            Pane pane = (Pane)iterator.next().getValue();
            this.removeView(pane.getView());
            pane.setView(null);
        }
    }

    @NotNull
    public final List<Integer> splitPane(int paneId, @NotNull SplitType splitType, @NotNull Float[] proportions) {
        Intrinsics.checkNotNullParameter((Object)((Object)splitType), (String)"splitType");
        Intrinsics.checkNotNullParameter((Object)proportions, (String)"proportions");
        Pane parentPane = this.paneMap.get(paneId);
        if (parentPane == null || parentPane.isSplit()) {
            return CollectionsKt.emptyList();
        }
        if (proportions.length < 2) {
            return CollectionsKt.emptyList();
        }
        float sum = ArraysKt.sumOfFloat((Float[])proportions);
        if (sum > 1.0f) {
            return CollectionsKt.emptyList();
        }
        this.removeDebugViews();
        if (parentPane.getView() != null) {
            this.removeView(paneId);
        }
        ConstraintSet set = new ConstraintSet();
        set.clone((ConstraintLayout)this);
        ArrayList<View> childrenViewList = new ArrayList<View>();
        int[] childrenIdList = new int[proportions.length];
        float[] weights = ArraysKt.toFloatArray((Float[])proportions);
        Float[] $this$forEachIndexed$iv = proportions;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Float item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            ((Number)item$iv).floatValue();
            int index = n;
            boolean bl = false;
            View childView = new View(this.getContext());
            childView.setId(ViewIDGenerator.INSTANCE.generateViewId());
            childrenIdList[index] = childView.getId();
            childrenViewList.add(childView);
            this.addView(childView, this.getChildCount());
            Pane childPane = new Pane(childView.getId(), parentPane.getId(), childView, 0, false, null, null, null, null, null, 1016, null);
            ((Map)this.paneMap).put(childView.getId(), childPane);
            if (splitType == SplitType.HORIZONTAL) {
                set.constrainPercentHeight(((View)childrenViewList.get(index)).getId(), 1.0f);
                set.connect(childView.getId(), 3, paneId, 3);
                set.connect(childView.getId(), 4, paneId, 4);
                continue;
            }
            set.constrainPercentWidth(((View)childrenViewList.get(index)).getId(), 1.0f);
            set.connect(childView.getId(), 1, paneId, 1);
            set.connect(childView.getId(), 2, paneId, 2);
        }
        proportions[ArraysKt.getLastIndex((Object[])proportions)] = Float.valueOf(1.0f - sum + proportions[ArraysKt.getLastIndex((Object[])proportions)].floatValue());
        if (splitType == SplitType.HORIZONTAL) {
            set.createHorizontalChain(paneId, 1, paneId, 2, childrenIdList, weights, 0);
        } else {
            set.createVerticalChain(paneId, 3, paneId, 4, childrenIdList, weights, 0);
        }
        set.applyTo((ConstraintLayout)this);
        parentPane.setChildrenIdList(ArraysKt.toList((int[])childrenIdList));
        parentPane.setSplit(true);
        int[] $this$forEach$iv = childrenIdList;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int childId = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Pane pane = this.paneMap.get(childId);
            if (pane == null) continue;
            pane.setSiblingIdList(ArraysKt.toList((int[])childrenIdList));
        }
        this.addDebugViews(this.isLabelAssistEnabled, this.isBackgroundAssistEnabled);
        return ArraysKt.toList((int[])childrenIdList);
    }

    public final void addView(int paneId, @NotNull View widgetView, @NotNull ViewAlignment position, int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        Intrinsics.checkNotNullParameter((Object)widgetView, (String)"widgetView");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Pane pane = this.paneMap.get(paneId);
        if (pane == null) {
            return;
        }
        Pane pane2 = pane;
        this.removeView(paneId);
        if (widgetView.getId() == -1) {
            widgetView.setId(ViewIDGenerator.INSTANCE.generateViewId());
        }
        this.addView(widgetView, this.getChildCount());
        this.setViewAlignment(paneId, widgetView, position, leftMargin, topMargin, rightMargin, bottomMargin);
        pane2.setView(widgetView);
        pane2.setPosition(position);
    }

    public static /* synthetic */ void addView$default(FreeFormPanelWidget freeFormPanelWidget, int n, View view, ViewAlignment viewAlignment, int n2, int n3, int n4, int n5, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addView");
        }
        if ((n6 & 4) != 0) {
            viewAlignment = ViewAlignment.CENTER;
        }
        if ((n6 & 8) != 0) {
            n2 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x40) != 0) {
            n5 = 0;
        }
        freeFormPanelWidget.addView(n, view, viewAlignment, n2, n3, n4, n5);
    }

    public final void removeView(int paneId) {
        Pane pane = this.paneMap.get(paneId);
        if (pane == null) {
            return;
        }
        Pane pane2 = pane;
        View view = pane2.getView();
        if (view == null) {
            return;
        }
        View viewToRemove = view;
        ConstraintSet set = new ConstraintSet();
        set.clone((ConstraintLayout)this);
        set.clear(viewToRemove.getId());
        set.applyTo((ConstraintLayout)this);
        ViewGroup $this$contains$iv = (ViewGroup)this;
        boolean $i$f$contains = false;
        if ($this$contains$iv.indexOfChild(viewToRemove) != -1) {
            this.removeView(viewToRemove);
        }
        pane2.setView(null);
    }

    /*
     * WARNING - void declaration
     */
    public final int findViewPane(@NotNull View view) {
        Integer key;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Map $this$filter$iv = this.paneMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Pane)it.getValue()).getView(), (Object)view)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Integer n = key = (Integer)CollectionsKt.firstOrNull((Iterable)destination$iv$iv.keySet());
        return n != null ? n : -1;
    }

    @Nullable
    public final View viewInPane(int paneId) {
        Pane pane = this.paneMap.get(paneId);
        return pane != null ? pane.getView() : null;
    }

    @NotNull
    public final List<Integer> getSiblingList(int paneId) {
        Pane pane = this.paneMap.get(paneId);
        List list = pane != null ? pane.getSiblingIdList() : null;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final List<Integer> getChildrenList(int paneId) {
        Pane pane = this.paneMap.get(paneId);
        List list = pane != null ? pane.getChildrenIdList() : null;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final int getParentId(int paneId) {
        Integer parentId;
        Pane pane = this.paneMap.get(paneId);
        Integer n = parentId = pane != null ? Integer.valueOf(pane.getParentId()) : null;
        return n != null ? n : -1;
    }

    public final void enablePaneDebug(boolean enableLabelAssist, boolean enableBackgroundAssist, @ColorInt int textColor, @ColorInt int textBackgroundColor) {
        if (textColor != 0) {
            this.debugTextColor = textColor;
        }
        if (textBackgroundColor != 0) {
            this.debugTextBackgroundColor = textBackgroundColor;
        }
        this.isLabelAssistEnabled = enableLabelAssist;
        this.isBackgroundAssistEnabled = enableBackgroundAssist;
        this.removeDebugViews();
        this.addDebugViews(this.isLabelAssistEnabled, this.isBackgroundAssistEnabled);
    }

    public static /* synthetic */ void enablePaneDebug$default(FreeFormPanelWidget freeFormPanelWidget, boolean bl, boolean bl2, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enablePaneDebug");
        }
        if ((n3 & 2) != 0) {
            bl2 = false;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        freeFormPanelWidget.enablePaneDebug(bl, bl2, n, n2);
    }

    public final void mergeChildren(int paneId) {
        this.removeDebugViews();
        this.mergePaneChildren(paneId);
        this.addDebugViews(this.isLabelAssistEnabled, this.isBackgroundAssistEnabled);
    }

    public final void mergeSiblings(int paneId) {
        Pane pane = this.paneMap.get(paneId);
        if (pane == null) {
            return;
        }
        Pane pane2 = pane;
        this.mergeChildren(pane2.getParentId());
    }

    @Nullable
    public final ViewAlignment getPanePositioning(int paneId) {
        Pane pane = this.paneMap.get(paneId);
        return pane != null ? pane.getPosition() : null;
    }

    public final void setPanePosition(int paneId, @NotNull ViewAlignment position, int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Pane pane = this.paneMap.get(paneId);
        if (pane == null) {
            return;
        }
        Pane pane2 = pane;
        View view = pane2.getView();
        if (view == null) {
            return;
        }
        View widgetView = view;
        pane2.setPosition(position);
        this.setViewAlignment(paneId, widgetView, position, leftMargin, topMargin, rightMargin, bottomMargin);
    }

    public static /* synthetic */ void setPanePosition$default(FreeFormPanelWidget freeFormPanelWidget, int n, ViewAlignment viewAlignment, int n2, int n3, int n4, int n5, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setPanePosition");
        }
        if ((n6 & 4) != 0) {
            n2 = 0;
        }
        if ((n6 & 8) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n5 = 0;
        }
        freeFormPanelWidget.setPanePosition(n, viewAlignment, n2, n3, n4, n5);
    }

    public final void setPaneBackgroundColor(int paneId, @ColorInt int color2) {
        Pane pane = this.paneMap.get(paneId);
        if (pane == null) {
            return;
        }
        Pane pane2 = pane;
        pane2.setBackgroundColor(color2);
        pane2.getBackground().setBackgroundColor(color2);
    }

    public final void setPaneVisibility(int paneId, boolean isVisible) {
        Pane pane = this.paneMap.get(paneId);
        if (pane == null) {
            return;
        }
        Pane pane2 = pane;
        if (isVisible) {
            ViewExtensions.show(pane2.getBackground());
        } else {
            ViewExtensions.hide(pane2.getBackground());
        }
        View view = pane2.getView();
        if (view == null) {
            return;
        }
        View view2 = view;
        if (isVisible) {
            ViewExtensions.show(view2);
        } else {
            ViewExtensions.hide(view2);
        }
    }

    private final void setViewAlignment(int paneId, View widgetView, ViewAlignment position, int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        ConstraintSet set = new ConstraintSet();
        set.clone((ConstraintLayout)this);
        set.clear(widgetView.getId());
        set.setMargin(widgetView.getId(), 1, leftMargin);
        set.setMargin(widgetView.getId(), 3, topMargin);
        set.setMargin(widgetView.getId(), 2, rightMargin);
        set.setMargin(widgetView.getId(), 4, bottomMargin);
        switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1: {
                set.connect(widgetView.getId(), 1, paneId, 1);
                set.connect(widgetView.getId(), 2, paneId, 2);
                set.connect(widgetView.getId(), 3, paneId, 3);
                set.connect(widgetView.getId(), 4, paneId, 4);
                break;
            }
            case 2: {
                set.constrainHeight(widgetView.getId(), -2);
                set.constrainWidth(widgetView.getId(), 0);
                set.connect(widgetView.getId(), 1, paneId, 1);
                set.connect(widgetView.getId(), 2, paneId, 2);
                set.connect(widgetView.getId(), 3, paneId, 3);
                break;
            }
            case 3: {
                set.constrainHeight(widgetView.getId(), -2);
                set.constrainWidth(widgetView.getId(), 0);
                set.connect(widgetView.getId(), 1, paneId, 1);
                set.connect(widgetView.getId(), 2, paneId, 2);
                set.connect(widgetView.getId(), 4, paneId, 4);
                break;
            }
            case 4: {
                set.constrainHeight(widgetView.getId(), 0);
                set.constrainWidth(widgetView.getId(), -2);
                set.connect(widgetView.getId(), 1, paneId, 1);
                set.connect(widgetView.getId(), 3, paneId, 3);
                set.connect(widgetView.getId(), 4, paneId, 4);
                break;
            }
            case 5: {
                set.constrainHeight(widgetView.getId(), 0);
                set.constrainWidth(widgetView.getId(), -2);
                set.connect(widgetView.getId(), 2, paneId, 2);
                set.connect(widgetView.getId(), 3, paneId, 3);
                set.connect(widgetView.getId(), 4, paneId, 4);
                break;
            }
            case 6: {
                set.constrainHeight(widgetView.getId(), -2);
                set.constrainWidth(widgetView.getId(), -2);
                set.connect(widgetView.getId(), 1, paneId, 1);
                set.connect(widgetView.getId(), 3, paneId, 3);
                break;
            }
            case 7: {
                set.constrainHeight(widgetView.getId(), -2);
                set.constrainWidth(widgetView.getId(), -2);
                set.connect(widgetView.getId(), 1, paneId, 1);
                set.connect(widgetView.getId(), 4, paneId, 4);
                break;
            }
            case 8: {
                set.constrainHeight(widgetView.getId(), -2);
                set.constrainWidth(widgetView.getId(), -2);
                set.connect(widgetView.getId(), 2, paneId, 2);
                set.connect(widgetView.getId(), 3, paneId, 3);
                break;
            }
            case 9: {
                set.constrainHeight(widgetView.getId(), -2);
                set.constrainWidth(widgetView.getId(), -2);
                set.connect(widgetView.getId(), 2, paneId, 2);
                set.connect(widgetView.getId(), 4, paneId, 4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        set.applyTo((ConstraintLayout)this);
    }

    private final void mergePaneChildren(int paneId) {
        Pane pane = this.paneMap.get(paneId);
        if (pane == null) {
            return;
        }
        Pane pane2 = pane;
        if (!pane2.isSplit()) {
            return;
        }
        Iterator<Integer> iterator = pane2.getChildrenIdList().iterator();
        while (iterator.hasNext()) {
            TextView debugTextView;
            Pane childPane;
            int childId = ((Number)iterator.next()).intValue();
            this.mergePaneChildren(childId);
            if (this.paneMap.get(childId) == null) continue;
            ConstraintSet set = new ConstraintSet();
            set.clone((ConstraintLayout)this);
            View widgetView = childPane.getView();
            if (widgetView != null) {
                set.clear(widgetView.getId());
                this.removeView(widgetView);
            }
            if ((debugTextView = childPane.getDebugTextView()) != null) {
                set.clear(debugTextView.getId());
                this.removeView((View)debugTextView);
                childPane.setDebugTextView(null);
            }
            set.clear(childPane.getId());
            this.removeView(childPane.getBackground());
            childPane.setSiblingIdList(CollectionsKt.emptyList());
            this.paneMap.remove(childPane.getId());
            set.applyTo((ConstraintLayout)this);
        }
        pane2.setChildrenIdList(CollectionsKt.emptyList());
        pane2.setSplit(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void addDebugViews(boolean isLabelAssist, boolean isBackgroundAssist) {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.paneMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!((Pane)it.getValue()).isSplit())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map visiblePaneMap = destination$iv$iv;
        Iterator iterator2 = visiblePaneMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pane pane = (Pane)iterator2.next().getValue();
            if (isBackgroundAssist) {
                int color2 = Color.argb((int)255, (int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256));
                pane.getBackground().setBackgroundColor(color2);
            }
            if (!isLabelAssist || pane.getDebugTextView() != null) continue;
            TextView debugTextView = new TextView(this.getContext());
            debugTextView.setId(ViewIDGenerator.INSTANCE.generateViewId());
            debugTextView.setText((CharSequence)String.valueOf(pane.getId()));
            debugTextView.setTextColor(this.debugTextColor);
            debugTextView.setBackgroundColor(this.debugTextBackgroundColor);
            this.addView((View)debugTextView, this.getChildCount());
            ConstraintSet set = new ConstraintSet();
            set.clone((ConstraintLayout)this);
            set.connect(debugTextView.getId(), 1, pane.getBackground().getId(), 1);
            set.connect(debugTextView.getId(), 3, pane.getBackground().getId(), 3);
            set.applyTo((ConstraintLayout)this);
            pane.setDebugTextView(debugTextView);
        }
    }

    static /* synthetic */ void addDebugViews$default(FreeFormPanelWidget freeFormPanelWidget, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addDebugViews");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        freeFormPanelWidget.addDebugViews(bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeDebugViews() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.paneMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!((Pane)it.getValue()).isSplit())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map visiblePaneMap = destination$iv$iv;
        Iterator iterator2 = visiblePaneMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            TextView debugTextView;
            Pane pane = (Pane)iterator2.next().getValue();
            if (pane.getBackgroundColor() == 0) {
                pane.getBackground().setBackground(null);
            } else {
                pane.getBackground().setBackgroundColor(pane.getBackgroundColor());
            }
            if ((debugTextView = pane.getDebugTextView()) == null) continue;
            ConstraintSet set = new ConstraintSet();
            set.clone((ConstraintLayout)this);
            set.clear(debugTextView.getId());
            set.applyTo((ConstraintLayout)this);
            ViewGroup $this$contains$iv = (ViewGroup)this;
            boolean $i$f$contains = false;
            if ($this$contains$iv.indexOfChild((View)debugTextView) != -1) {
                this.removeView((View)debugTextView);
            }
            pane.setDebugTextView(null);
        }
    }

    @JvmOverloads
    public FreeFormPanelWidget(@NotNull Context context, @Nullable AttributeSet attrs, @NotNull PanelWidgetConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this(context, attrs, 0, configuration, 4, null);
    }

    @JvmOverloads
    public FreeFormPanelWidget(@NotNull Context context, @NotNull PanelWidgetConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this(context, null, 0, configuration, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0006H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\tH\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u00c6\u0003J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u007f\u0010:\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00c6\u0001J\u0013\u0010;\u001a\u00020\t2\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010=\u001a\u00020\u0003H\u00d6\u0001J\t\u0010>\u001a\u00020?H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010!R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010'\"\u0004\b+\u0010)R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006@"}, d2={"Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$Pane;", "", "id", "", "parentId", "background", "Landroid/view/View;", "backgroundColor", "isSplit", "", "view", "position", "Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$ViewAlignment;", "childrenIdList", "", "siblingIdList", "debugTextView", "Landroid/widget/TextView;", "<init>", "(IILandroid/view/View;IZLandroid/view/View;Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$ViewAlignment;Ljava/util/List;Ljava/util/List;Landroid/widget/TextView;)V", "getId", "()I", "getParentId", "getBackground", "()Landroid/view/View;", "getBackgroundColor", "setBackgroundColor", "(I)V", "()Z", "setSplit", "(Z)V", "getView", "setView", "(Landroid/view/View;)V", "getPosition", "()Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$ViewAlignment;", "setPosition", "(Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$ViewAlignment;)V", "getChildrenIdList", "()Ljava/util/List;", "setChildrenIdList", "(Ljava/util/List;)V", "getSiblingIdList", "setSiblingIdList", "getDebugTextView", "()Landroid/widget/TextView;", "setDebugTextView", "(Landroid/widget/TextView;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "other", "hashCode", "toString", "", "android-sdk-v5-uxsdk_debug"})
    private static final class Pane {
        private final int id;
        private final int parentId;
        @NotNull
        private final View background;
        private int backgroundColor;
        private boolean isSplit;
        @Nullable
        private View view;
        @Nullable
        private ViewAlignment position;
        @NotNull
        private List<Integer> childrenIdList;
        @NotNull
        private List<Integer> siblingIdList;
        @Nullable
        private TextView debugTextView;

        public Pane(int id2, int parentId, @NotNull View background, int backgroundColor, boolean isSplit, @Nullable View view, @Nullable ViewAlignment position, @NotNull List<Integer> childrenIdList, @NotNull List<Integer> siblingIdList, @Nullable TextView debugTextView) {
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            Intrinsics.checkNotNullParameter(childrenIdList, (String)"childrenIdList");
            Intrinsics.checkNotNullParameter(siblingIdList, (String)"siblingIdList");
            this.id = id2;
            this.parentId = parentId;
            this.background = background;
            this.backgroundColor = backgroundColor;
            this.isSplit = isSplit;
            this.view = view;
            this.position = position;
            this.childrenIdList = childrenIdList;
            this.siblingIdList = siblingIdList;
            this.debugTextView = debugTextView;
        }

        public /* synthetic */ Pane(int n, int n2, View view, int n3, boolean bl, View view2, ViewAlignment viewAlignment, List list, List list2, TextView textView, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x10) != 0) {
                bl = false;
            }
            if ((n4 & 0x20) != 0) {
                view2 = null;
            }
            if ((n4 & 0x40) != 0) {
                viewAlignment = null;
            }
            if ((n4 & 0x80) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n4 & 0x100) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n4 & 0x200) != 0) {
                textView = null;
            }
            this(n, n2, view, n3, bl, view2, viewAlignment, list, list2, textView);
        }

        public final int getId() {
            return this.id;
        }

        public final int getParentId() {
            return this.parentId;
        }

        @NotNull
        public final View getBackground() {
            return this.background;
        }

        public final int getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(int n) {
            this.backgroundColor = n;
        }

        public final boolean isSplit() {
            return this.isSplit;
        }

        public final void setSplit(boolean bl) {
            this.isSplit = bl;
        }

        @Nullable
        public final View getView() {
            return this.view;
        }

        public final void setView(@Nullable View view) {
            this.view = view;
        }

        @Nullable
        public final ViewAlignment getPosition() {
            return this.position;
        }

        public final void setPosition(@Nullable ViewAlignment viewAlignment) {
            this.position = viewAlignment;
        }

        @NotNull
        public final List<Integer> getChildrenIdList() {
            return this.childrenIdList;
        }

        public final void setChildrenIdList(@NotNull List<Integer> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.childrenIdList = list;
        }

        @NotNull
        public final List<Integer> getSiblingIdList() {
            return this.siblingIdList;
        }

        public final void setSiblingIdList(@NotNull List<Integer> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.siblingIdList = list;
        }

        @Nullable
        public final TextView getDebugTextView() {
            return this.debugTextView;
        }

        public final void setDebugTextView(@Nullable TextView textView) {
            this.debugTextView = textView;
        }

        public final int component1() {
            return this.id;
        }

        public final int component2() {
            return this.parentId;
        }

        @NotNull
        public final View component3() {
            return this.background;
        }

        public final int component4() {
            return this.backgroundColor;
        }

        public final boolean component5() {
            return this.isSplit;
        }

        @Nullable
        public final View component6() {
            return this.view;
        }

        @Nullable
        public final ViewAlignment component7() {
            return this.position;
        }

        @NotNull
        public final List<Integer> component8() {
            return this.childrenIdList;
        }

        @NotNull
        public final List<Integer> component9() {
            return this.siblingIdList;
        }

        @Nullable
        public final TextView component10() {
            return this.debugTextView;
        }

        @NotNull
        public final Pane copy(int id2, int parentId, @NotNull View background, int backgroundColor, boolean isSplit, @Nullable View view, @Nullable ViewAlignment position, @NotNull List<Integer> childrenIdList, @NotNull List<Integer> siblingIdList, @Nullable TextView debugTextView) {
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            Intrinsics.checkNotNullParameter(childrenIdList, (String)"childrenIdList");
            Intrinsics.checkNotNullParameter(siblingIdList, (String)"siblingIdList");
            return new Pane(id2, parentId, background, backgroundColor, isSplit, view, position, childrenIdList, siblingIdList, debugTextView);
        }

        public static /* synthetic */ Pane copy$default(Pane pane, int n, int n2, View view, int n3, boolean bl, View view2, ViewAlignment viewAlignment, List list, List list2, TextView textView, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = pane.id;
            }
            if ((n4 & 2) != 0) {
                n2 = pane.parentId;
            }
            if ((n4 & 4) != 0) {
                view = pane.background;
            }
            if ((n4 & 8) != 0) {
                n3 = pane.backgroundColor;
            }
            if ((n4 & 0x10) != 0) {
                bl = pane.isSplit;
            }
            if ((n4 & 0x20) != 0) {
                view2 = pane.view;
            }
            if ((n4 & 0x40) != 0) {
                viewAlignment = pane.position;
            }
            if ((n4 & 0x80) != 0) {
                list = pane.childrenIdList;
            }
            if ((n4 & 0x100) != 0) {
                list2 = pane.siblingIdList;
            }
            if ((n4 & 0x200) != 0) {
                textView = pane.debugTextView;
            }
            return pane.copy(n, n2, view, n3, bl, view2, viewAlignment, list, list2, textView);
        }

        @NotNull
        public String toString() {
            return "Pane(id=" + this.id + ", parentId=" + this.parentId + ", background=" + this.background + ", backgroundColor=" + this.backgroundColor + ", isSplit=" + this.isSplit + ", view=" + this.view + ", position=" + this.position + ", childrenIdList=" + this.childrenIdList + ", siblingIdList=" + this.siblingIdList + ", debugTextView=" + this.debugTextView + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.id);
            result = result * 31 + Integer.hashCode(this.parentId);
            result = result * 31 + this.background.hashCode();
            result = result * 31 + Integer.hashCode(this.backgroundColor);
            result = result * 31 + Boolean.hashCode(this.isSplit);
            result = result * 31 + (this.view == null ? 0 : this.view.hashCode());
            result = result * 31 + (this.position == null ? 0 : this.position.hashCode());
            result = result * 31 + ((Object)this.childrenIdList).hashCode();
            result = result * 31 + ((Object)this.siblingIdList).hashCode();
            result = result * 31 + (this.debugTextView == null ? 0 : this.debugTextView.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Pane)) {
                return false;
            }
            Pane pane = (Pane)other;
            if (this.id != pane.id) {
                return false;
            }
            if (this.parentId != pane.parentId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.background, (Object)pane.background)) {
                return false;
            }
            if (this.backgroundColor != pane.backgroundColor) {
                return false;
            }
            if (this.isSplit != pane.isSplit) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.view, (Object)pane.view)) {
                return false;
            }
            if (this.position != pane.position) {
                return false;
            }
            if (!Intrinsics.areEqual(this.childrenIdList, pane.childrenIdList)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.siblingIdList, pane.siblingIdList)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.debugTextView, (Object)pane.debugTextView);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$SplitType;", "", "<init>", "(Ljava/lang/String;I)V", "HORIZONTAL", "VERTICAL", "android-sdk-v5-uxsdk_debug"})
    public static final class SplitType
    extends Enum<SplitType> {
        public static final /* enum */ SplitType HORIZONTAL = new SplitType();
        public static final /* enum */ SplitType VERTICAL = new SplitType();
        private static final /* synthetic */ SplitType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SplitType[] values() {
            return (SplitType[])$VALUES.clone();
        }

        public static SplitType valueOf(String value) {
            return Enum.valueOf(SplitType.class, value);
        }

        @NotNull
        public static EnumEntries<SplitType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = splitTypeArray = new SplitType[]{SplitType.HORIZONTAL, SplitType.VERTICAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Ldji/v5/ux/core/base/panel/FreeFormPanelWidget$ViewAlignment;", "", "<init>", "(Ljava/lang/String;I)V", "CENTER", "TOP", "BOTTOM", "LEFT", "RIGHT", "LEFT_TOP", "LEFT_BOTTOM", "RIGHT_TOP", "RIGHT_BOTTOM", "android-sdk-v5-uxsdk_debug"})
    public static final class ViewAlignment
    extends Enum<ViewAlignment> {
        public static final /* enum */ ViewAlignment CENTER = new ViewAlignment();
        public static final /* enum */ ViewAlignment TOP = new ViewAlignment();
        public static final /* enum */ ViewAlignment BOTTOM = new ViewAlignment();
        public static final /* enum */ ViewAlignment LEFT = new ViewAlignment();
        public static final /* enum */ ViewAlignment RIGHT = new ViewAlignment();
        public static final /* enum */ ViewAlignment LEFT_TOP = new ViewAlignment();
        public static final /* enum */ ViewAlignment LEFT_BOTTOM = new ViewAlignment();
        public static final /* enum */ ViewAlignment RIGHT_TOP = new ViewAlignment();
        public static final /* enum */ ViewAlignment RIGHT_BOTTOM = new ViewAlignment();
        private static final /* synthetic */ ViewAlignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ViewAlignment[] values() {
            return (ViewAlignment[])$VALUES.clone();
        }

        public static ViewAlignment valueOf(String value) {
            return Enum.valueOf(ViewAlignment.class, value);
        }

        @NotNull
        public static EnumEntries<ViewAlignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = viewAlignmentArray = new ViewAlignment[]{ViewAlignment.CENTER, ViewAlignment.TOP, ViewAlignment.BOTTOM, ViewAlignment.LEFT, ViewAlignment.RIGHT, ViewAlignment.LEFT_TOP, ViewAlignment.LEFT_BOTTOM, ViewAlignment.RIGHT_TOP, ViewAlignment.RIGHT_BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ViewAlignment.values().length];
            try {
                nArray[ViewAlignment.CENTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewAlignment.TOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewAlignment.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewAlignment.LEFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewAlignment.RIGHT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewAlignment.LEFT_TOP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewAlignment.LEFT_BOTTOM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewAlignment.RIGHT_TOP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewAlignment.RIGHT_BOTTOM.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

