/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.model;

import dji.v5.ux.core.base.charts.formatter.BubbleChartValueFormatter;
import dji.v5.ux.core.base.charts.formatter.SimpleBubbleChartValueFormatter;
import dji.v5.ux.core.base.charts.model.AbstractChartData;
import dji.v5.ux.core.base.charts.model.BubbleValue;
import java.util.ArrayList;
import java.util.List;

public class BubbleChartData
extends AbstractChartData {
    private BubbleChartValueFormatter formatter = new SimpleBubbleChartValueFormatter();
    private boolean hasLabels = false;
    private boolean hasLabelsOnlyForSelected = false;
    private int minBubbleRadius = 6;
    private float bubbleScale = 1.0f;
    private List<BubbleValue> values = new ArrayList<BubbleValue>();

    public BubbleChartData() {
    }

    public BubbleChartData(List<BubbleValue> values) {
        this.setValues(values);
    }

    public BubbleChartData(BubbleChartData data) {
        super(data);
        this.formatter = data.formatter;
        this.hasLabels = data.hasLabels;
        this.hasLabelsOnlyForSelected = data.hasLabelsOnlyForSelected;
        this.minBubbleRadius = data.minBubbleRadius;
        this.bubbleScale = data.bubbleScale;
        for (BubbleValue bubbleValue : data.getValues()) {
            this.values.add(new BubbleValue(bubbleValue));
        }
    }

    public static BubbleChartData generateDummyData() {
        BubbleChartData data = new BubbleChartData();
        ArrayList<BubbleValue> values = new ArrayList<BubbleValue>(4);
        values.add(new BubbleValue(0.0f, 20.0f, 15000.0f));
        values.add(new BubbleValue(3.0f, 22.0f, 20000.0f));
        values.add(new BubbleValue(5.0f, 25.0f, 5000.0f));
        values.add(new BubbleValue(7.0f, 30.0f, 30000.0f));
        values.add(new BubbleValue(11.0f, 22.0f, 10.0f));
        data.setValues(values);
        return data;
    }

    @Override
    public void update(float scale) {
        for (BubbleValue value : this.values) {
            value.update(scale);
        }
    }

    @Override
    public void finish() {
        for (BubbleValue value : this.values) {
            value.finish();
        }
    }

    public List<BubbleValue> getValues() {
        return this.values;
    }

    public BubbleChartData setValues(List<BubbleValue> values) {
        this.values = null == values ? new ArrayList<BubbleValue>() : values;
        return this;
    }

    public boolean hasLabels() {
        return this.hasLabels;
    }

    public BubbleChartData setHasLabels(boolean hasLabels) {
        this.hasLabels = hasLabels;
        if (hasLabels) {
            this.hasLabelsOnlyForSelected = false;
        }
        return this;
    }

    public boolean hasLabelsOnlyForSelected() {
        return this.hasLabelsOnlyForSelected;
    }

    public BubbleChartData setHasLabelsOnlyForSelected(boolean hasLabelsOnlyForSelected) {
        this.hasLabelsOnlyForSelected = hasLabelsOnlyForSelected;
        if (hasLabelsOnlyForSelected) {
            this.hasLabels = false;
        }
        return this;
    }

    public int getMinBubbleRadius() {
        return this.minBubbleRadius;
    }

    public void setMinBubbleRadius(int minBubbleRadius) {
        this.minBubbleRadius = minBubbleRadius;
    }

    public float getBubbleScale() {
        return this.bubbleScale;
    }

    public void setBubbleScale(float bubbleScale) {
        this.bubbleScale = bubbleScale;
    }

    public BubbleChartValueFormatter getFormatter() {
        return this.formatter;
    }

    public BubbleChartData setFormatter(BubbleChartValueFormatter formatter) {
        if (null != formatter) {
            this.formatter = formatter;
        }
        return this;
    }
}

