/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.TextView;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.ContextUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DividerConstraintLayout;
import dji.v5.ux.core.base.TabModeWidget;
import java.util.ArrayList;
import java.util.List;

public class TabSelectCell
extends DividerConstraintLayout {
    TabModeWidget mTabWidget;
    TextView mSummary;
    TextView mTitle;
    TextView mDesc;
    private OnTabChangeListener mChangeListener;

    public TabSelectCell(Context context) {
        this(context, null);
    }

    public TabSelectCell(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TabSelectCell(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        CharSequence[] entries;
        LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_cell_tab_select_layout, (ViewGroup)this, true);
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TabSelectCell, defStyleAttr, 0);
        this.mTabWidget = (TabModeWidget)this.findViewById(R.id.tab_switcher);
        this.mSummary = (TextView)this.findViewById(R.id.summary);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mDesc = (TextView)this.findViewById(R.id.desc);
        if (ta.hasValue(R.styleable.TabSelectCell_uxsdk_title)) {
            this.mTitle.setText((CharSequence)ta.getString(R.styleable.TabSelectCell_uxsdk_title));
        } else {
            this.mTitle.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.TabSelectCell_uxsdk_summary)) {
            this.mSummary.setText((CharSequence)ta.getString(R.styleable.TabSelectCell_uxsdk_summary));
        } else {
            this.mSummary.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.TabSelectCell_uxsdk_desc)) {
            this.mDesc.setText((CharSequence)ta.getString(R.styleable.TabSelectCell_uxsdk_desc));
        } else {
            this.mDesc.setVisibility(8);
        }
        int selectIndex = ta.getInt(R.styleable.TabSelectCell_uxsdk_select, 0);
        ArrayList<String> tabs = new ArrayList<String>();
        if (ta.hasValue(R.styleable.TabSelectCell_uxsdk_tabs) && (entries = ta.getTextArray(R.styleable.TabSelectCell_uxsdk_tabs)) != null && entries.length > 0) {
            for (CharSequence s : entries) {
                tabs.add(s.toString());
            }
            this.mTabWidget.setTabs(selectIndex, tabs);
        }
        ta.recycle();
        this.mTabWidget.setCurrentTab(selectIndex);
        this.mTabWidget.setOnTabChangeListener((int oldIndex, int newIndex) -> {
            if (this.mChangeListener != null) {
                this.mChangeListener.onTabChanged(this, oldIndex, newIndex);
            }
        });
        this.setMinHeight((int)AndUtil.getItemHeight((Context)ContextUtil.getContext()));
        this.setClickable(true);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mTabWidget.setEnabled(enabled);
    }

    public void addTabs(int select, List<String> tabs) {
        this.mTabWidget.setTabs(select, tabs);
    }

    public void setCurrentTab(int tab) {
        this.mTabWidget.setCurrentTab(tab);
    }

    public void setCurrentDes(int resId) {
        this.mDesc.setText(resId);
    }

    public int getTabSize() {
        return this.mTabWidget.getTabSize();
    }

    public int getCurrentTab() {
        return this.mTabWidget.getCurrentTab();
    }

    public void setOnTabChangeListener(OnTabChangeListener listener2) {
        this.mChangeListener = listener2;
    }

    public static interface OnTabChangeListener {
        public void onTabChanged(TabSelectCell var1, int var2, int var3);
    }
}

