/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.accessory.data;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.recyclerview.widget.RecyclerView;
import dji.sdk.keyvalue.value.rtkbasestation.RTKStationConnetState;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.accessory.data.DJIRTKBaseStationConnectInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002,-B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010!J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0007J\n\u0010&\u001a\u00020\u001a*\u00020'J\n\u0010(\u001a\u00020\u001a*\u00020'J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldji/v5/ux/accessory/data/RtkStationScanAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Ldji/v5/ux/accessory/data/RtkStationScanAdapter$RtkViewHolder;", "context", "Landroid/content/Context;", "list", "", "Ldji/v5/ux/accessory/data/DJIRTKBaseStationConnectInfo;", "<init>", "(Landroid/content/Context;Ljava/util/List;)V", "getContext", "()Landroid/content/Context;", "TAG", "", "LEVEL_0", "", "LEVEL_1", "LEVEL_2", "LEVEL_3", "LEVEL_4", "baseStationInfoList", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onBindViewHolder", "", "holder", "position", "getItemId", "", "getItemCount", "mOnItemClickListener", "Ldji/v5/ux/accessory/data/RtkStationScanAdapter$OnItemClickListener;", "setOnItemClickListener", "onItemClickListener", "getSignalLevelDrawable", "signalLevel", "visible", "Landroid/view/View;", "gone", "checkConnecting", "", "checkConnected", "OnItemClickListener", "RtkViewHolder", "android-sdk-v5-uxsdk_debug"})
public final class RtkStationScanAdapter
extends RecyclerView.Adapter<RtkViewHolder> {
    @NotNull
    private final Context context;
    @NotNull
    private final String TAG;
    private final int LEVEL_0;
    private final int LEVEL_1;
    private final int LEVEL_2;
    private final int LEVEL_3;
    private final int LEVEL_4;
    @Nullable
    private List<DJIRTKBaseStationConnectInfo> baseStationInfoList;
    @Nullable
    private OnItemClickListener mOnItemClickListener;

    public RtkStationScanAdapter(@NotNull Context context, @Nullable List<DJIRTKBaseStationConnectInfo> list) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.TAG = "RtkStationScanAdapter";
        this.LEVEL_1 = 1;
        this.LEVEL_2 = 2;
        this.LEVEL_3 = 3;
        this.LEVEL_4 = 4;
        this.baseStationInfoList = list;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public RtkViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.uxsdk_widget_rtk_connect_status_item, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"inflate(...)");
        View view2 = view;
        return new RtkViewHolder(view2);
    }

    public void onBindViewHolder(@NotNull RtkViewHolder holder, int position) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
            Object object = this.baseStationInfoList;
            if (object == null || (object = object.get(position)) == null) break block4;
            Object info = object;
            boolean bl = false;
            holder.getMRtkStationNameTv().setText((CharSequence)((DJIRTKBaseStationConnectInfo)((Object)info)).getRtkStationName());
            holder.getMConnectSignalIv().setBackgroundResource(this.getSignalLevelDrawable(((DJIRTKBaseStationConnectInfo)((Object)info)).getSignalLevel()));
            holder.itemView.setOnClickListener(arg_0 -> RtkStationScanAdapter.onBindViewHolder$lambda$1$lambda$0(holder, this, arg_0));
            switch (WhenMappings.$EnumSwitchMapping$0[((DJIRTKBaseStationConnectInfo)((Object)info)).getConnectStatus().ordinal()]) {
                case 1: {
                    this.visible((View)holder.getMConnectStatusIv());
                    holder.getMConnectStatusIv().setImageResource(R.drawable.uxsdk_rotate_progress_circle);
                    break;
                }
                case 2: {
                    this.visible((View)holder.getMConnectStatusIv());
                    holder.getMConnectStatusIv().setImageResource(R.drawable.uxsdk_ic_confirm);
                    break;
                }
                default: {
                    this.gone((View)holder.getMConnectStatusIv());
                }
            }
        }
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        int n;
        if (this.baseStationInfoList == null) {
            n = 0;
        } else {
            List<DJIRTKBaseStationConnectInfo> list = this.baseStationInfoList;
            Intrinsics.checkNotNull(list);
            n = list.size();
        }
        return n;
    }

    public final void setOnItemClickListener(@Nullable OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    @DrawableRes
    public final int getSignalLevelDrawable(int signalLevel) {
        Object[] objectArray = new Object[]{"getSignalLevelDrawable,signalLevel=" + signalLevel};
        LogUtils.i((String)this.TAG, (Object[])objectArray);
        int n = signalLevel;
        return n == this.LEVEL_0 ? R.drawable.uxsdk_ic_topbar_signal_level_0 : (n == this.LEVEL_1 ? R.drawable.uxsdk_ic_topbar_signal_level_1 : (n == this.LEVEL_2 ? R.drawable.uxsdk_ic_topbar_signal_level_2 : (n == this.LEVEL_3 ? R.drawable.uxsdk_ic_topbar_signal_level_3 : (n == this.LEVEL_4 ? R.drawable.uxsdk_ic_topbar_signal_level_4 : R.drawable.uxsdk_ic_topbar_signal_level_5))));
    }

    public final void visible(@NotNull View $this$visible) {
        Intrinsics.checkNotNullParameter((Object)$this$visible, (String)"<this>");
        $this$visible.setVisibility(0);
    }

    public final void gone(@NotNull View $this$gone) {
        Intrinsics.checkNotNullParameter((Object)$this$gone, (String)"<this>");
        $this$gone.setVisibility(8);
    }

    private final boolean checkConnecting() {
        List<DJIRTKBaseStationConnectInfo> list = this.baseStationInfoList;
        if (list != null) {
            List<DJIRTKBaseStationConnectInfo> it = list;
            boolean bl = false;
            for (DJIRTKBaseStationConnectInfo station : it) {
                if (station.getConnectStatus() != RTKStationConnetState.CONNECTING) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private final boolean checkConnected(int position) {
        List<DJIRTKBaseStationConnectInfo> list = this.baseStationInfoList;
        if (list != null) {
            List<DJIRTKBaseStationConnectInfo> $this$checkConnected_u24lambda_u243 = list;
            boolean bl = false;
            DJIRTKBaseStationConnectInfo stationInfo = $this$checkConnected_u24lambda_u243.get(position);
            return stationInfo.getConnectStatus() == RTKStationConnetState.CONNECTED;
        }
        return false;
    }

    private static final void onBindViewHolder$lambda$1$lambda$0(RtkViewHolder $holder, RtkStationScanAdapter this$0, View it) {
        int pos = $holder.getLayoutPosition();
        boolean isConnecting = this$0.checkConnecting();
        boolean hasConnected = this$0.checkConnected(pos);
        if (!isConnecting && !hasConnected) {
            OnItemClickListener onItemClickListener = this$0.mOnItemClickListener;
            if (onItemClickListener != null) {
                onItemClickListener.onItemClick($holder.itemView, pos);
            }
        } else if (this$0.checkConnecting()) {
            Object[] objectArray = new Object[]{"The station is currently connecting, please try to connect later\uff01"};
            LogUtils.e((String)this$0.TAG, (Object[])objectArray);
        } else {
            Object[] objectArray = new Object[]{"The station has connected!"};
            LogUtils.e((String)this$0.TAG, (Object[])objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Ldji/v5/ux/accessory/data/RtkStationScanAdapter$OnItemClickListener;", "", "onItemClick", "", "view", "Landroid/view/View;", "position", "", "android-sdk-v5-uxsdk_debug"})
    public static interface OnItemClickListener {
        public void onItemClick(@Nullable View var1, int var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ldji/v5/ux/accessory/data/RtkStationScanAdapter$RtkViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "<init>", "(Landroid/view/View;)V", "mConnectStatusIv", "Landroid/widget/ImageView;", "getMConnectStatusIv", "()Landroid/widget/ImageView;", "setMConnectStatusIv", "(Landroid/widget/ImageView;)V", "mRtkStationNameTv", "Landroid/widget/TextView;", "getMRtkStationNameTv", "()Landroid/widget/TextView;", "setMRtkStationNameTv", "(Landroid/widget/TextView;)V", "mConnectSignalIv", "getMConnectSignalIv", "setMConnectSignalIv", "android-sdk-v5-uxsdk_debug"})
    public static final class RtkViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private ImageView mConnectStatusIv;
        @NotNull
        private TextView mRtkStationNameTv;
        @NotNull
        private ImageView mConnectSignalIv;

        public RtkViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.mConnectStatusIv = (ImageView)itemView.findViewById(R.id.connect_status_iv);
            this.mRtkStationNameTv = (TextView)itemView.findViewById(R.id.station_name_tv);
            this.mConnectSignalIv = (ImageView)itemView.findViewById(R.id.connect_signal_iv);
            this.mConnectStatusIv.setVisibility(8);
        }

        @NotNull
        public final ImageView getMConnectStatusIv() {
            return this.mConnectStatusIv;
        }

        public final void setMConnectStatusIv(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.mConnectStatusIv = imageView;
        }

        @NotNull
        public final TextView getMRtkStationNameTv() {
            return this.mRtkStationNameTv;
        }

        public final void setMRtkStationNameTv(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.mRtkStationNameTv = textView;
        }

        @NotNull
        public final ImageView getMConnectSignalIv() {
            return this.mConnectSignalIv;
        }

        public final void setMConnectSignalIv(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.mConnectSignalIv = imageView;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RTKStationConnetState.values().length];
            try {
                nArray[RTKStationConnetState.CONNECTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKStationConnetState.CONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

