/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.wb;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.CameraWhiteBalanceInfo;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.visualcamera.wb.CameraConfigWBWidgetModel;

public class CameraConfigWBWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private static final String EMPTY_STRING = "";
    private static final int COLOR_TEMP_MULTIPLIER = 100;
    private CameraConfigWBWidgetModel widgetModel;
    private TextView wbTitleTextView;
    private TextView wbValueTextView;
    private String[] wbNameArray;

    public CameraConfigWBWidget(@NonNull Context context) {
        super(context);
    }

    public CameraConfigWBWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraConfigWBWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        CameraConfigWBWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_base_camera_info, (ViewGroup)this);
        this.wbTitleTextView = (TextView)this.findViewById(R.id.textview_title);
        this.wbValueTextView = (TextView)this.findViewById(R.id.textview_value);
        if (!this.isInEditMode()) {
            this.widgetModel = new CameraConfigWBWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.wbTitleTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_white_balance_title, new Object[]{EMPTY_STRING}));
            this.wbNameArray = this.getResources().getStringArray(R.array.uxsdk_camera_white_balance_name_array);
        }
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getWhiteBalance().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI));
    }

    private void updateUI(@NonNull CameraWhiteBalanceInfo whiteBalance) {
        int wbPresetValue = whiteBalance.getWhiteBalanceMode().value();
        if (wbPresetValue < this.wbNameArray.length) {
            this.wbTitleTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_white_balance_title, new Object[]{this.wbNameArray[wbPresetValue]}));
            this.wbValueTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_white_balance_temp, new Object[]{whiteBalance.getColorTemperature() * 100}));
        } else {
            this.wbTitleTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_white_balance_title, new Object[]{EMPTY_STRING}));
            this.wbValueTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_string_default_value));
        }
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_base_camera_info_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void setWBTitleTextAppearance(@StyleRes int textAppearance) {
        this.wbTitleTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getWBTitleTextColors() {
        return this.wbTitleTextView.getTextColors();
    }

    @ColorInt
    public int getWBTitleTextColor() {
        return this.wbTitleTextView.getCurrentTextColor();
    }

    public void setWBTitleTextColor(@NonNull ColorStateList colorStateList) {
        this.wbTitleTextView.setTextColor(colorStateList);
    }

    public void setWBTitleTextColor(@ColorInt int color2) {
        this.wbTitleTextView.setTextColor(color2);
    }

    @Dimension
    public float getWBTitleTextSize() {
        return this.wbTitleTextView.getTextSize();
    }

    public void setWBTitleTextSize(@Dimension float textSize) {
        this.wbTitleTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getWBTitleTextBackground() {
        return this.wbTitleTextView.getBackground();
    }

    public void setWBTitleTextBackground(@DrawableRes int resourceId) {
        this.wbTitleTextView.setBackgroundResource(resourceId);
    }

    public void setWBTitleTextBackground(@Nullable Drawable drawable2) {
        this.wbTitleTextView.setBackground(drawable2);
    }

    public void setWBValueTextAppearance(@StyleRes int textAppearance) {
        this.wbValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public ColorStateList getWBValueTextColors() {
        return this.wbValueTextView.getTextColors();
    }

    @ColorInt
    public int getWBValueTextColor() {
        return this.wbValueTextView.getCurrentTextColor();
    }

    public void setWBValueTextColor(@NonNull ColorStateList colorStateList) {
        this.wbValueTextView.setTextColor(colorStateList);
    }

    public void setWBValueTextColor(@ColorInt int color2) {
        this.wbValueTextView.setTextColor(color2);
    }

    @Dimension
    public float getWBValueTextSize() {
        return this.wbValueTextView.getTextSize();
    }

    public void setWBValueTextSize(@Dimension float textSize) {
        this.wbValueTextView.setTextSize(textSize);
    }

    @Nullable
    public Drawable getWBValueTextBackground() {
        return this.wbValueTextView.getBackground();
    }

    public void setWBValueTextBackground(@DrawableRes int resourceId) {
        this.wbValueTextView.setBackgroundResource(resourceId);
    }

    public void setWBValueTextBackground(@Nullable Drawable drawable2) {
        this.wbValueTextView.setBackground(drawable2);
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        Drawable wbValueTextBackgroundDrawable;
        int wbValueTextColor;
        float wbValueTextSize;
        int wbValueTextAppearanceId;
        Drawable wbTitleTextBackgroundDrawable;
        int wbTitleTextColor;
        float wbTitleTextSize;
        int wbTitleTextAppearanceId;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraConfigWBWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.CameraConfigWBWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.CameraConfigWBWidget_uxsdk_lensType, 0)));
        }
        if ((wbTitleTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigWBWidget_uxsdk_wbTitleTextAppearance, -1)) != -1) {
            this.setWBTitleTextAppearance(wbTitleTextAppearanceId);
        }
        if ((wbTitleTextSize = typedArray.getDimension(R.styleable.CameraConfigWBWidget_uxsdk_wbTitleTextSize, -1.0f)) != -1.0f) {
            this.setWBTitleTextSize(DisplayUtil.pxToSp((Context)context, (float)wbTitleTextSize));
        }
        if ((wbTitleTextColor = typedArray.getColor(R.styleable.CameraConfigWBWidget_uxsdk_wbTitleTextColor, 0)) != 0) {
            this.setWBTitleTextColor(wbTitleTextColor);
        }
        if ((wbTitleTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigWBWidget_uxsdk_wbTitleBackgroundDrawable)) != null) {
            this.setWBTitleTextBackground(wbTitleTextBackgroundDrawable);
        }
        if ((wbValueTextAppearanceId = typedArray.getResourceId(R.styleable.CameraConfigWBWidget_uxsdk_wbValueTextAppearance, -1)) != -1) {
            this.setWBValueTextAppearance(wbValueTextAppearanceId);
        }
        if ((wbValueTextSize = typedArray.getDimension(R.styleable.CameraConfigWBWidget_uxsdk_wbValueTextSize, -1.0f)) != -1.0f) {
            this.setWBValueTextSize(DisplayUtil.pxToSp((Context)context, (float)wbValueTextSize));
        }
        if ((wbValueTextColor = typedArray.getColor(R.styleable.CameraConfigWBWidget_uxsdk_wbValueTextColor, 0)) != 0) {
            this.setWBValueTextColor(wbValueTextColor);
        }
        if ((wbValueTextBackgroundDrawable = typedArray.getDrawable(R.styleable.CameraConfigWBWidget_uxsdk_wbValueBackgroundDrawable)) != null) {
            this.setWBValueTextBackground(wbValueTextBackgroundDrawable);
        }
        typedArray.recycle();
    }
}

