/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.models.annotations;

import androidx.annotation.ColorInt;
import dji.v5.ux.mapkit.core.models.BasePointCollection;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import java.util.List;

public class DJIPolylineOptions
extends BasePointCollection {
    private static final float DASH_LENGTH = 3.0f;
    private float mWidth;
    private float mZIndex;
    @ColorInt
    private int mColor = -16777216;
    private boolean mGeodesic;
    private boolean mVisible = true;
    private DJIBitmapDescriptor mBitmapDescriptor;
    private boolean mEnableTexture;
    private float mDashLength = 3.0f;
    private boolean mDashed;

    public DJIPolylineOptions width(float width) {
        this.mWidth = width;
        return this;
    }

    public DJIPolylineOptions zIndex(float zIndex) {
        this.mZIndex = zIndex;
        return this;
    }

    public DJIPolylineOptions color(@ColorInt int color2) {
        this.mColor = color2;
        return this;
    }

    public DJIPolylineOptions geodesic(boolean geodesic) {
        this.mGeodesic = geodesic;
        return this;
    }

    public DJIPolylineOptions visible(boolean visible) {
        this.mVisible = visible;
        return this;
    }

    public DJIPolylineOptions setUseTexture(boolean enableTexture) {
        this.mEnableTexture = enableTexture;
        return this;
    }

    public DJIPolylineOptions setCustomTexture(DJIBitmapDescriptor bitmapDescriptor) {
        this.mBitmapDescriptor = bitmapDescriptor;
        return this;
    }

    public DJIPolylineOptions setDashed(boolean dashed) {
        this.mDashed = dashed;
        return this;
    }

    public DJIPolylineOptions setDashLength(float length) {
        this.mDashLength = length;
        return this;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getZIndex() {
        return this.mZIndex;
    }

    @ColorInt
    public int getColor() {
        return this.mColor;
    }

    public boolean isGeodesic() {
        return this.mGeodesic;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public boolean isEnableTexture() {
        return this.mEnableTexture;
    }

    public boolean isDashed() {
        return this.mDashed;
    }

    public float getDashLength() {
        return this.mDashLength;
    }

    public DJIBitmapDescriptor getBitmapDescriptor() {
        return this.mBitmapDescriptor;
    }

    public DJIPolylineOptions add(DJILatLng point) {
        this.addPoint(point);
        return this;
    }

    public DJIPolylineOptions add(DJILatLng ... points) {
        for (DJILatLng point : points) {
            this.addPoint(point);
        }
        return this;
    }

    public DJIPolylineOptions addAll(List<DJILatLng> points) {
        this.setPoints(points);
        return this;
    }
}

