/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.amap.map;

import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.Circle;
import com.amap.api.maps.model.CircleOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.Polygon;
import com.amap.api.maps.model.Polyline;
import dji.v5.ux.mapkit.amap.annotations.ACircle;
import dji.v5.ux.mapkit.amap.annotations.AGroupCircle;
import dji.v5.ux.mapkit.amap.annotations.AMarker;
import dji.v5.ux.mapkit.amap.annotations.APolygon;
import dji.v5.ux.mapkit.amap.annotations.APolyline;
import dji.v5.ux.mapkit.amap.map.AProjection;
import dji.v5.ux.mapkit.amap.map.AUiSettings;
import dji.v5.ux.mapkit.amap.utils.AMapUtils;
import dji.v5.ux.mapkit.core.callback.MapScreenShotListener;
import dji.v5.ux.mapkit.core.callback.OnMapTypeLoadedListener;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.maps.DJIBaseMap;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.maps.DJIProjection;
import dji.v5.ux.mapkit.core.maps.DJIUiSettings;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircle;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygon;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AMapDelegate
extends DJIBaseMap
implements AMap.OnMarkerClickListener,
AMap.OnMapClickListener,
AMap.OnInfoWindowClickListener,
AMap.OnMarkerDragListener,
AMap.OnMapLongClickListener,
AMap.OnCameraChangeListener {
    private AMap mMap;
    private Map<Marker, AMarker> markerMap;

    public AMapDelegate(AMap map) {
        this.mMap = map;
        this.mMap.setOnMarkerClickListener((AMap.OnMarkerClickListener)this);
        this.mMap.setOnMapClickListener((AMap.OnMapClickListener)this);
        this.mMap.setOnInfoWindowClickListener((AMap.OnInfoWindowClickListener)this);
        this.mMap.setOnCameraChangeListener((AMap.OnCameraChangeListener)this);
        this.mMap.setOnMarkerDragListener((AMap.OnMarkerDragListener)this);
        this.markerMap = new HashMap<Marker, AMarker>();
    }

    @Override
    @NonNull
    public DJIMarker addMarker(DJIMarkerOptions markerOptions) {
        DJILatLng latLng = markerOptions.getPosition();
        if (latLng == null) {
            throw new IllegalArgumentException("DJIMarkerOptions parameter must have position set");
        }
        MarkerOptions options = new MarkerOptions();
        DJILatLng position = markerOptions.getPosition();
        DJIBitmapDescriptor icon = markerOptions.getIcon();
        options.draggable(markerOptions.getDraggable()).position(AMapUtils.fromDJILatLng(position)).anchor(markerOptions.getAnchorU(), markerOptions.getAnchorV()).rotateAngle(-markerOptions.getRotation()).zIndex((float)markerOptions.getZIndex()).visible(markerOptions.getVisible()).title(markerOptions.getTitle()).infoWindowEnable(markerOptions.isInfoWindowEnable()).setFlat(markerOptions.isFlat());
        if (icon != null) {
            options.icon(AMapUtils.fromDJIBitmapDescriptor(icon));
        }
        Marker marker = this.mMap.addMarker(options);
        AMarker aMarker = new AMarker(marker, this);
        aMarker.setPositionCache(markerOptions.getPosition());
        this.markerMap.put(marker, aMarker);
        return aMarker;
    }

    @Override
    public Object getMap() {
        return this.mMap;
    }

    @Override
    public DJICameraPosition getCameraPosition() {
        CameraPosition p = this.mMap.getCameraPosition();
        return AMapUtils.fromCameraPosition(p);
    }

    @Override
    public void animateCamera(DJICameraUpdate cameraUpdate) {
        CameraUpdate update = AMapUtils.fromDJICameraUpdate(cameraUpdate);
        this.mMap.animateCamera(update);
    }

    @Override
    public void moveCamera(DJICameraUpdate cameraUpdate) {
        CameraUpdate update = AMapUtils.fromDJICameraUpdate(cameraUpdate);
        this.mMap.moveCamera(update);
    }

    @Override
    public void setInfoWindowAdapter(final DJIMap.InfoWindowAdapter adapter) {
        this.mMap.setInfoWindowAdapter(new AMap.InfoWindowAdapter(){

            public View getInfoWindow(Marker marker) {
                return adapter.getInfoWindow(new AMarker(marker, AMapDelegate.this));
            }

            public View getInfoContents(Marker marker) {
                return adapter.getInfoContents(new AMarker(marker, AMapDelegate.this));
            }
        });
    }

    @Override
    @NonNull
    public DJIPolyline addPolyline(DJIPolylineOptions options) {
        Polyline polyline = this.mMap.addPolyline(AMapUtils.fromDJIPolylineOptions(options));
        return new APolyline(polyline, options);
    }

    @Override
    @NonNull
    public DJIPolygon addPolygon(DJIPolygonOptions options) {
        Polygon polygon = this.mMap.addPolygon(AMapUtils.fromDJIPolygonOptions(options));
        return new APolygon(polygon);
    }

    @Override
    @Nullable
    public DJICircle addSingleCircle(DJICircleOptions options) {
        if (options.getRadius() <= 0.0) {
            return null;
        }
        CircleOptions circleOptions = new CircleOptions();
        DJILatLng center = options.getCenter();
        circleOptions.center(AMapUtils.fromDJILatLng(center)).radius(options.getRadius()).strokeWidth(options.getStrokeWidth()).strokeColor(options.getStrokeColor()).fillColor(options.getFillColor());
        Circle circle = this.mMap.addCircle(circleOptions);
        return new ACircle(circle);
    }

    @Override
    @Nullable
    public DJICircle addMarkerCircle(DJICircleOptions options) {
        return null;
    }

    @Override
    @Nullable
    public DJIGroupCircle addGroupCircle(DJIGroupCircleOptions options) {
        if (options.getRadius().size() != options.getCenters().size() || options.getRadius().size() == 0) {
            return null;
        }
        int size = options.getCenters().size();
        ArrayList<Circle> circles = new ArrayList<Circle>(size);
        for (int i = 0; i < size; ++i) {
            CircleOptions circleOptions = new CircleOptions();
            DJILatLng center = options.getCenters().get(i);
            Double radius = options.getRadius().get(i);
            circleOptions.center(AMapUtils.fromDJILatLng(center)).radius(radius.doubleValue()).strokeWidth(options.getStrokeWidth()).strokeColor(options.getStrokeColor()).fillColor(options.getFillColor());
            Circle circle = this.mMap.addCircle(circleOptions);
            circles.add(circle);
        }
        return new AGroupCircle(circles);
    }

    @Override
    public void setMapType(int type) {
        switch (type) {
            case 1: {
                this.mMap.setMapType(1);
                break;
            }
            case 2: {
                this.mMap.setMapType(3);
                break;
            }
            case 4: {
                this.mMap.setMapType(2);
                break;
            }
            default: {
                this.mMap.setMapType(1);
            }
        }
    }

    @Override
    public void setMapType(DJIMap.MapType type, OnMapTypeLoadedListener listener2) {
        this.setMapType(type);
        listener2.onMapTypeLoaded();
    }

    @Override
    public void setMapType(DJIMap.MapType type) {
        switch (type) {
            case NORMAL: {
                this.mMap.setMapType(1);
                break;
            }
            case SATELLITE: {
                this.mMap.setMapType(3);
                break;
            }
            case HYBRID: {
                this.mMap.setMapType(2);
                break;
            }
            default: {
                this.mMap.setMapType(1);
            }
        }
    }

    @Override
    public DJIUiSettings getUiSettings() {
        return new AUiSettings(this.mMap.getUiSettings());
    }

    public boolean onMarkerClick(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            this.onMarkerClick(this.markerMap.get(marker));
        }
        return true;
    }

    public void onMapClick(LatLng latLng) {
        DJILatLng djiLatLng = AMapUtils.fromLatLng(latLng);
        this.onMapClick(djiLatLng);
    }

    public void onInfoWindowClick(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            this.onInfoWindowClick(this.markerMap.get(marker));
        }
    }

    public void onMarkerDragStart(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            this.onMarkerDragStart(this.markerMap.get(marker));
        }
    }

    public void onMarkerDrag(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            DJIMarker djiMarker = this.markerMap.get(marker);
            LatLng latLng = marker.getPosition();
            DJILatLng djiLatLng = AMapUtils.fromLatLng(latLng);
            djiMarker.setPosition(djiLatLng);
            this.onMarkerDrag(djiMarker);
        }
    }

    public void onMarkerDragEnd(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            DJIMarker djiMarker = this.markerMap.get(marker);
            LatLng latLng = marker.getPosition();
            DJILatLng djiLatLng = AMapUtils.fromLatLng(latLng);
            djiMarker.setPosition(djiLatLng);
            this.onMarkerDragEnd(djiMarker);
        }
    }

    @Override
    public void snapshot(final MapScreenShotListener callback) {
        this.mMap.getMapScreenShot(new AMap.OnMapScreenShotListener(){

            public void onMapScreenShot(Bitmap bitmap) {
                callback.onMapScreenShot(bitmap);
            }

            public void onMapScreenShot(Bitmap bitmap, int i) {
            }
        });
    }

    @Override
    public DJIProjection getProjection() {
        return new AProjection(this.mMap.getProjection());
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    public void onMarkerRemove(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            this.markerMap.remove(marker);
        }
    }

    public void onMapLongClick(LatLng latLng) {
        DJILatLng djiLatLng = AMapUtils.fromLatLng(latLng);
        this.onMapLongClick(djiLatLng);
    }

    public void onCameraChange(CameraPosition cameraPosition) {
        DJICameraPosition p = AMapUtils.fromCameraPosition(cameraPosition);
        this.onCameraChange(p);
    }

    public void onCameraChangeFinish(CameraPosition cameraPosition) {
        DJICameraPosition p = AMapUtils.fromCameraPosition(cameraPosition);
        this.onCameraChangeFinish(p);
    }
}

