/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.setting;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.viewpager.widget.PagerAdapter;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.sdk.keyvalue.value.remotecontroller.RCMode;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.accessory.RTKStartServiceHelper;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.ui.setting.SettingFragmentPagerAdapter;
import dji.v5.ux.core.ui.setting.data.MenuBean;
import dji.v5.ux.core.ui.setting.taplayout.TabViewPager;
import dji.v5.ux.core.ui.setting.taplayout.VerticalTabLayout;
import dji.v5.ux.core.ui.setting.ui.MenuFragment;
import dji.v5.ux.core.ui.setting.ui.SettingMenuFragment;
import dji.v5.ux.core.widget.setting.SettingPanelWidgetModel;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SettingPanelWidget
extends ConstraintLayoutWidget<Boolean> {
    private final String tag = LogUtils.getTag((Object)((Object)this));
    private ProductType mProductType = ProductType.UNKNOWN;
    private ProductType mPrevProductType = ProductType.UNKNOWN;
    private boolean mProductConnected;
    private RCMode mCurrentRcMode = RCMode.CHANNEL_A;
    private FragmentManager fm;
    private TabViewPager viewPager;
    private SettingFragmentPagerAdapter mAdapter;
    private List<MenuBean> menus = new ArrayList<MenuBean>();
    private List<Fragment> mFragments = new ArrayList<Fragment>();
    private VerticalTabLayout mTabLayout;
    private Disposable mRestartDispose;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    private SettingPanelWidgetModel widgetModel = new SettingPanelWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());

    public SettingPanelWidget(Context context) {
        this(context, null);
    }

    public SettingPanelWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SettingPanelWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeView();
        this.showWidgets();
        this.prepareData();
    }

    protected void initializeView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.uxsdk_panel_layout_setting, (ViewGroup)this, true);
        this.setDescendantFocusability(262144);
        this.mTabLayout = (VerticalTabLayout)this.findViewById(R.id.setting_vertical_tabLayout);
        this.viewPager = (TabViewPager)this.findViewById(R.id.setting_viewpager);
        this.viewPager.setPagingEnabled(false);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    protected void prepareData() {
        this.mCompositeDisposable.add(this.widgetModel.getRcModeProcessor().toFlowableOnUI().distinctUntilChanged().subscribe(rcMode -> {
            if (rcMode != RCMode.UNKNOWN && rcMode != this.mCurrentRcMode) {
                this.mCurrentRcMode = rcMode;
                this.updateData((RCMode)rcMode);
            }
        }));
        this.mPrevProductType = this.widgetModel.getProduceType();
        this.mCompositeDisposable.add(this.widgetModel.getProductTypeProcessor().toFlowableOnUI().distinctUntilChanged().subscribe(productType -> {
            this.mProductType = productType;
        }));
        this.mProductConnected = this.widgetModel.getFlightControllerConnectStatus();
        this.mCompositeDisposable.add(this.widgetModel.getFlightControllerConnectProcessor().toFlowableOnUI().distinctUntilChanged().subscribe(connection -> {
            if (connection != this.mProductConnected) {
                this.mProductConnected = connection;
                if (this.mProductConnected && this.mProductType != ProductType.UNKNOWN && this.mPrevProductType != this.mProductType) {
                    this.delayRestartPanel();
                    this.mPrevProductType = this.mProductType;
                }
            }
        }));
        this.mCompositeDisposable.add(RTKStartServiceHelper.INSTANCE.getRtkModuleAvailable().distinctUntilChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (this.isSupportAdvRtk((Boolean)aBoolean)) {
                this.mAdapter.addRTKPanel();
            } else {
                this.mAdapter.removeRTKPanel();
            }
        }));
        this.mCompositeDisposable.add(this.widgetModel.getPayloadConnectedStatusMapProcessor().toFlowableOnUI().subscribe(payloadIndexTypeBooleanHashMap -> {
            if (payloadIndexTypeBooleanHashMap.isEmpty()) {
                this.mAdapter.removePayloadPanel();
            } else {
                this.mAdapter.addPayloadPanel();
            }
        }));
    }

    protected void showWidgets() {
        this.fm = ((FragmentActivity)this.getContext()).getSupportFragmentManager();
        if (this.isSlaverRcMode(this.mCurrentRcMode)) {
            this.createSlaverFragments();
        } else {
            this.createMasterFragments();
        }
        this.mAdapter = new SettingFragmentPagerAdapter(this.fm, this.menus, this.mFragments);
        this.viewPager.setAdapter((PagerAdapter)this.mAdapter);
        this.mTabLayout.setupWithViewPager(this.viewPager);
        if (this.isSlaverRcMode(this.mCurrentRcMode)) {
            this.setCurrentItem("RCMenuFragment");
        } else if (!TextUtils.isEmpty((CharSequence)this.getCurrentItemFlag())) {
            this.setCurrentItem(this.getCurrentItemFlag());
        } else {
            this.setCurrentItem("FlycMenuFragment");
        }
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.destroy();
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    private void destroy() {
        LogUtils.e((String)this.tag, (Object[])new Object[]{"destroy mFragments.clear()"});
        this.mFragments.clear();
        if (this.mCompositeDisposable != null && !this.mCompositeDisposable.isDisposed()) {
            this.mCompositeDisposable.dispose();
            this.mCompositeDisposable = null;
        }
        if (this.mRestartDispose != null && !this.mRestartDispose.isDisposed()) {
            this.mRestartDispose.dispose();
        }
        if (this.viewPager != null) {
            this.viewPager.clearOnPageChangeListeners();
        }
        if (this.mTabLayout != null) {
            this.mTabLayout.setupWithViewPager(null);
            this.mTabLayout = null;
        }
        if (this.mAdapter != null) {
            this.mAdapter.destroy();
            this.mAdapter = null;
        }
        this.fm = null;
        this.mAdapter = null;
    }

    private void setMasterFragmentData() {
        this.createMasterFragments();
        if (!TextUtils.isEmpty((CharSequence)this.getCurrentItemFlag())) {
            this.setCurrentItem(this.getCurrentItemFlag());
        } else {
            this.setCurrentItem("FlycMenuFragment");
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void createMasterFragments() {
        this.menus.clear();
        this.mFragments.clear();
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_drone_active, R.drawable.uxsdk_ic_setting_drone));
        this.mFragments.add(SettingMenuFragment.newInstance("FlycMenuFragment"));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_obstacl_avoidance_active, R.drawable.uxsdk_ic_setting_obstacl_avoidance));
        this.mFragments.add(SettingMenuFragment.newInstance("PerceptionMenuFragment"));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_rc_active, R.drawable.uxsdk_ic_setting_rc));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_hd_active, R.drawable.uxsdk_ic_setting_hd));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_plane_electricity_active, R.drawable.uxsdk_ic_setting_plane_electricity));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_camera_active, R.drawable.uxsdk_ic_setting_camera));
        this.mFragments.add(SettingMenuFragment.newInstance("RCMenuFragment"));
        this.mFragments.add(SettingMenuFragment.newInstance("HDMenuFragment"));
        this.mFragments.add(SettingMenuFragment.newInstance("BatteryMenuFragment"));
        this.mFragments.add(SettingMenuFragment.newInstance("GimbalMenuFragment"));
        if (this.isSupportAdvRtk(false)) {
            this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_rtk_active, R.drawable.uxsdk_ic_setting_rtk));
            this.mFragments.add(SettingMenuFragment.newInstance("RtkMenuFragment"));
        }
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_more_active, R.drawable.uxsdk_ic_setting_more));
        this.mFragments.add(SettingMenuFragment.newInstance("CommonMenuFragment"));
    }

    private void setSlaverFragmentData() {
        this.createSlaverFragments();
        this.setCurrentItem("RCMenuFragment");
        this.mAdapter.notifyDataSetChanged();
    }

    private void createSlaverFragments() {
        this.menus.clear();
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_rc_active, R.drawable.uxsdk_ic_setting_rc));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_hd_active, R.drawable.uxsdk_ic_setting_hd));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_plane_electricity_active, R.drawable.uxsdk_ic_setting_plane_electricity));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_camera_active, R.drawable.uxsdk_ic_setting_camera));
        this.menus.add(new MenuBean(R.drawable.uxsdk_ic_setting_more_active, R.drawable.uxsdk_ic_setting_more));
        this.mFragments.clear();
        this.mFragments.add(SettingMenuFragment.newInstance("RCMenuFragment"));
        this.mFragments.add(SettingMenuFragment.newInstance("HDMenuFragment"));
        this.mFragments.add(SettingMenuFragment.newInstance("BatteryMenuFragment"));
        this.mFragments.add(SettingMenuFragment.newInstance("GimbalMenuFragment"));
        this.mFragments.add(SettingMenuFragment.newInstance("CommonMenuFragment"));
    }

    public void setCurrentItem(String flag) {
        if (this.mAdapter == null) {
            LogUtils.e((String)this.tag, (Object[])new Object[]{"SettingPanel is not ready!"});
            return;
        }
        int result = this.mAdapter.getSelectIndex(flag);
        if (result >= 0) {
            this.viewPager.setCurrentItem(result, true);
        }
    }

    public String getCurrentItemFlag() {
        int result = this.viewPager.getCurrentItem();
        return this.mAdapter.getSelectFlag(result);
    }

    private void delayRestartPanel() {
        if (this.mRestartDispose != null && !this.mRestartDispose.isDisposed()) {
            this.mRestartDispose.dispose();
        }
        this.mRestartDispose = Observable.just((Object)true).delay(1L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (this.isSlaverRcMode(this.mCurrentRcMode)) {
                this.setSlaverFragmentData();
            } else {
                this.setMasterFragmentData();
            }
        });
    }

    private void updateData(RCMode rcMode) {
        if (this.isSlaverRcMode(rcMode)) {
            this.setSlaverFragmentData();
        } else {
            this.setMasterFragmentData();
        }
    }

    private boolean isSlaverRcMode(RCMode mode) {
        if (mode != null) {
            return mode == RCMode.SLAVE || mode == RCMode.SLAVE_SUB;
        }
        return false;
    }

    private boolean isSupportAdvRtk(Boolean isRTKModuleAvailable) {
        return !this.isSlaverRcMode(this.mCurrentRcMode) && isRTKModuleAvailable != false || ProductUtil.isM300Product() || ProductUtil.isM30Product() || ProductUtil.isM350Product() || ProductUtil.isM400Product();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
    }

    public boolean onBackPressed() {
        boolean handled;
        block1: {
            Fragment fragment;
            handled = false;
            if (this.mFragments == null) break block1;
            Iterator<Fragment> iterator = this.mFragments.iterator();
            while (!(!iterator.hasNext() || (fragment = iterator.next()) instanceof MenuFragment && (handled = ((MenuFragment)fragment).onBackPressed()))) {
            }
        }
        return handled;
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    }

    @Override
    protected void reactToModelChanges() {
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }
}

