/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.exposure;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.VerticalSeekBar;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0014J\u0012\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldji/v5/ux/core/ui/exposure/ExposeVSeekBar;", "Ldji/v5/ux/core/ui/VerticalSeekBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "isShowSeekBar", "", "()Z", "setShowSeekBar", "(Z)V", "sunSize", "", "rectWidth", "sunMargin", "rectStrokeWidth", "halfSunSize", "rect", "Landroid/graphics/Rect;", "paint", "Landroid/graphics/Paint;", "rectSolidColor", "rectStrokeColor", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "drawRect", "onDrawRect", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nExposeVSeekBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposeVSeekBar.kt\ndji/v5/ux/core/ui/exposure/ExposeVSeekBar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class ExposeVSeekBar
extends VerticalSeekBar {
    private boolean isShowSeekBar;
    private final int sunSize;
    private final int rectWidth;
    private final int sunMargin;
    private final int rectStrokeWidth;
    private final int halfSunSize;
    @NotNull
    private final Rect rect;
    @NotNull
    private final Paint paint;
    private final int rectSolidColor;
    private final int rectStrokeColor;

    @JvmOverloads
    public ExposeVSeekBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.sunSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.uxsdk_14_dp);
        this.rectWidth = this.getContext().getResources().getDimensionPixelSize(R.dimen.uxsdk_1_dp);
        this.sunMargin = this.getContext().getResources().getDimensionPixelSize(R.dimen.uxsdk_2_dp);
        this.rectStrokeWidth = AndUtil.dip2px((Context)context, (float)0.5f);
        this.halfSunSize = this.sunSize >> 1;
        this.rect = new Rect();
        this.paint = new Paint();
        this.rectSolidColor = ContextCompat.getColor((Context)context, (int)R.color.uxsdk_yellow_500);
        this.rectStrokeColor = ContextCompat.getColor((Context)context, (int)R.color.uxsdk_black_30_percent);
    }

    public /* synthetic */ ExposeVSeekBar(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public final boolean isShowSeekBar() {
        return this.isShowSeekBar;
    }

    public final void setShowSeekBar(boolean bl) {
        this.isShowSeekBar = bl;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int thumbWidth = this.mThumb == null ? 0 : this.mThumb.getIntrinsicWidth();
        int dw = this.mProgressWidth;
        int dh = View.MeasureSpec.getSize((int)heightMeasureSpec);
        dw = Math.max(thumbWidth << 1, dw);
        this.setMeasuredDimension(dw += this.getPaddingLeft() + this.getPaddingRight(), dh += this.getPaddingTop() + this.getPaddingBottom());
    }

    @Override
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        if (event != null && event.getAction() == 0 && this.mThumb != null && (event.getY() < (float)(this.mThumb.getBounds().top - this.mThumb.getIntrinsicWidth()) || event.getY() > (float)(this.mThumb.getBounds().bottom + this.mThumb.getIntrinsicWidth()))) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Canvas canvas2;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Canvas it = canvas2 = canvas;
        boolean bl = false;
        Object object = this.isShowSeekBar ? canvas2 : null;
        if (object != null) {
            it = object;
            boolean bl2 = false;
            this.drawRect(it);
        }
        super.onDraw(canvas);
    }

    private final void drawRect(Canvas canvas) {
        int bottomStartOffY;
        int bottomEndOffY;
        Rect rect = this.mThumb.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
        Rect thumbRect = rect;
        int startOffX = thumbRect.left + thumbRect.right - this.rectWidth >> 1;
        int topEndOffY = thumbRect.top - this.sunMargin;
        if ((float)topEndOffY > (float)this.halfSunSize) {
            this.rect.set(startOffX, this.halfSunSize, startOffX + this.rectWidth, topEndOffY);
            this.onDrawRect(canvas);
        }
        if ((bottomEndOffY = this.getLayoutParams().height - this.halfSunSize) > (bottomStartOffY = thumbRect.bottom + this.sunMargin)) {
            this.rect.set(startOffX, bottomStartOffY, startOffX + this.rectWidth, bottomEndOffY);
            this.onDrawRect(canvas);
        }
    }

    private final void onDrawRect(Canvas canvas) {
        this.paint.setColor(this.rectSolidColor);
        this.paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(this.rect, this.paint);
        this.paint.setColor(this.rectStrokeColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth((float)this.rectStrokeWidth);
        Rect $this$onDrawRect_u24lambda_u242 = this.rect;
        boolean bl = false;
        $this$onDrawRect_u24lambda_u242.right += this.rectStrokeWidth;
        $this$onDrawRect_u24lambda_u242.bottom += this.rectStrokeWidth;
        canvas.drawRect(this.rect, this.paint);
    }

    @JvmOverloads
    public ExposeVSeekBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }
}

