/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import dji.v5.ux.BuildConfig;
import dji.v5.ux.core.base.charts.listener.ColumnChartOnValueSelectListener;
import dji.v5.ux.core.base.charts.listener.DummyColumnChartOnValueSelectListener;
import dji.v5.ux.core.base.charts.model.ColumnChartData;
import dji.v5.ux.core.base.charts.model.SelectedValue;
import dji.v5.ux.core.base.charts.model.SubcolumnValue;
import dji.v5.ux.core.base.charts.provider.ColumnChartDataProvider;
import dji.v5.ux.core.base.charts.renderer.ColumnChartRenderer;
import dji.v5.ux.core.base.charts.view.AbstractChartView;

public class ColumnChartView
extends AbstractChartView
implements ColumnChartDataProvider {
    private ColumnChartData data;
    private ColumnChartOnValueSelectListener onValueTouchListener = new DummyColumnChartOnValueSelectListener();

    public ColumnChartView(Context context) {
        this(context, null, 0);
    }

    public ColumnChartView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColumnChartView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setChartRenderer(new ColumnChartRenderer(context, this, this));
        this.setColumnChartData(ColumnChartData.generateDummyData());
    }

    @Override
    public ColumnChartData getColumnChartData() {
        return this.data;
    }

    @Override
    public void setColumnChartData(ColumnChartData data) {
        if (BuildConfig.DEBUG) {
            Log.d((String)"ColumnChartView", (String)"Setting data for ColumnChartView");
        }
        this.data = null == data ? ColumnChartData.generateDummyData() : data;
        super.onChartDataChange();
    }

    @Override
    public ColumnChartData getChartData() {
        return this.data;
    }

    @Override
    public void callTouchListener() {
        SelectedValue selectedValue = this.chartRenderer.getSelectedValue();
        if (selectedValue.isSet()) {
            SubcolumnValue value = this.data.getColumns().get(selectedValue.getFirstIndex()).getValues().get(selectedValue.getSecondIndex());
            this.onValueTouchListener.onValueSelected(selectedValue.getFirstIndex(), selectedValue.getSecondIndex(), value);
        } else {
            this.onValueTouchListener.onValueDeselected();
        }
    }

    public ColumnChartOnValueSelectListener getOnValueTouchListener() {
        return this.onValueTouchListener;
    }

    public void setOnValueTouchListener(ColumnChartOnValueSelectListener touchListener) {
        if (null != touchListener) {
            this.onValueTouchListener = touchListener;
        }
    }
}

