/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.fpvinteraction;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraExposureCompensation;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import java.util.ArrayList;
import java.util.List;

public class ExposureMeteringWidgetModel
extends WidgetModel
implements ICameraIndex {
    public final DataProcessor<List<CameraExposureCompensation>> compensationRangeProcessor = DataProcessor.create(new ArrayList());
    public final DataProcessor<CameraExposureCompensation> exposureCompensationProcessor = DataProcessor.create(CameraExposureCompensation.NEG_0EV);
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public ExposureMeteringWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    public Completable setEV(int value) {
        if (this.compensationRangeProcessor.getValue().size() <= value) {
            return Completable.complete();
        }
        return this.djiSdkModel.setValue(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureCompensation, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.compensationRangeProcessor.getValue().get(value));
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureCompensationRange, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.compensationRangeProcessor);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureCompensation, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.exposureCompensationProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }
}

