/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracontrols.exposuresettings;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import dji.sdk.keyvalue.value.camera.CameraExposureMode;
import dji.sdk.keyvalue.value.camera.CameraExposureSettings;
import dji.sdk.keyvalue.value.camera.CameraFlatMode;
import dji.sdk.keyvalue.value.camera.CameraISO;
import dji.sdk.keyvalue.value.camera.CameraWorkMode;
import dji.sdk.keyvalue.value.camera.EIType;
import dji.sdk.keyvalue.value.camera.ExposureSensitivityMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.cameracontrols.exposuresettings.ISOAndEISettingModel;
import dji.v5.ux.cameracore.widget.cameracontrols.exposuresettings.ISOAndEISettingWidget;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.ui.HorizontalSeekBar;
import dji.v5.ux.core.util.AudioUtil;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.databinding.UxsdkWidgetIsoEiSettingBinding;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u0001XB'\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010%\u001a\u00020&2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010'\u001a\u00020&H\u0014J\b\u0010(\u001a\u00020&H\u0014J\b\u0010)\u001a\u00020&H\u0014J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020-H\u0016J\n\u00101\u001a\u0004\u0018\u00010\u000fH\u0016J \u00102\u001a\u00020&2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u0011H\u0016J\u0018\u00107\u001a\u00020&2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000bH\u0016J\u0018\u00108\u001a\u00020&2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000bH\u0016J\u0010\u00109\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010:\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0016J\u0012\u0010;\u001a\u00020&2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\b\u0010>\u001a\u00020&H\u0002J\u0010\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020\u0019H\u0002J\u0010\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020CH\u0002J\u001d\u0010D\u001a\u00020&2\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u00020&H\u0002J\b\u0010H\u001a\u00020&H\u0002J\u001d\u0010I\u001a\u00020\u00112\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010JJ%\u0010K\u001a\u00020&2\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010L\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010MJ\b\u0010N\u001a\u00020&H\u0002J%\u0010O\u001a\u00020\u000b2\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010P\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010QJ\u0010\u0010R\u001a\u00020&2\u0006\u0010S\u001a\u00020\u0011H\u0002J\u0010\u0010T\u001a\u00020&2\u0006\u0010@\u001a\u00020\u0019H\u0002J\u0010\u0010U\u001a\u00020&2\u0006\u0010V\u001a\u00020\u000bH\u0002J\b\u0010W\u001a\u00020&H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"\u00a8\u0006Y"}, d2={"Ldji/v5/ux/cameracore/widget/cameracontrols/exposuresettings/ISOAndEISettingWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "Ldji/v5/ux/cameracore/widget/cameracontrols/exposuresettings/ISOAndEISettingWidget$ModelState;", "Landroid/view/View$OnClickListener;", "Ldji/v5/ux/core/ui/HorizontalSeekBar$OnSeekBarChangeListener;", "Ldji/v5/ux/core/base/ICameraIndex;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "LOCKED_ISO_VALUE", "", "isISOAutoSelected", "", "isISOAutoSupported", "isISOSeekBarEnabled", "isISOLocked", "isSeekBarTracking", "uiCameraISO", "uiIsoValueArray", "", "Ldji/sdk/keyvalue/value/camera/CameraISO;", "[Ldji/sdk/keyvalue/value/camera/CameraISO;", "eiValueArray", "", "binding", "Ldji/v5/ux/databinding/UxsdkWidgetIsoEiSettingBinding;", "widgetModel", "Ldji/v5/ux/cameracore/widget/cameracontrols/exposuresettings/ISOAndEISettingModel;", "getWidgetModel", "()Ldji/v5/ux/cameracore/widget/cameracontrols/exposuresettings/ISOAndEISettingModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "initView", "", "reactToModelChanges", "onAttachedToWindow", "onDetachedFromWindow", "getCameraIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "getLensType", "Ldji/sdk/keyvalue/value/common/CameraLensType;", "updateCameraSource", "cameraIndex", "lensType", "getIdealDimensionRatioString", "onProgressChanged", "view", "Ldji/v5/ux/core/ui/HorizontalSeekBar;", "progress", "isFromUI", "onStartTrackingTouch", "onStopTrackingTouch", "onPlusClicked", "onMinusClicked", "onClick", "v", "Landroid/view/View;", "updateWidgetUI", "onISOUpdated", "iso", "onExposureModeUpdated", "exposureMode", "Ldji/sdk/keyvalue/value/camera/CameraExposureMode;", "updateISORangeValue", "array", "([Ldji/sdk/keyvalue/value/camera/CameraISO;)V", "updateISORangeUI", "updateISOEnableStatus", "checkAutoISO", "([Ldji/sdk/keyvalue/value/camera/CameraISO;)Z", "updateISOValue", "value", "([Ldji/sdk/keyvalue/value/camera/CameraISO;I)V", "updateAutoISOButton", "getISOIndex", "isoValue", "([Ldji/sdk/keyvalue/value/camera/CameraISO;I)I", "setAutoISO", "isAuto", "updateISOToCamera", "updateEIToCamera", "ei", "updateISOLocked", "ModelState", "android-sdk-v5-uxsdk_debug"})
public class ISOAndEISettingWidget
extends ConstraintLayoutWidget<ModelState>
implements View.OnClickListener,
HorizontalSeekBar.OnSeekBarChangeListener,
ICameraIndex {
    @NotNull
    private final String LOCKED_ISO_VALUE;
    private boolean isISOAutoSelected;
    private boolean isISOAutoSupported;
    private boolean isISOSeekBarEnabled;
    private final boolean isISOLocked;
    private boolean isSeekBarTracking;
    private int uiCameraISO;
    @NotNull
    private CameraISO[] uiIsoValueArray;
    @NotNull
    private int[] eiValueArray;
    private UxsdkWidgetIsoEiSettingBinding binding;
    @NotNull
    private final Lazy widgetModel$delegate;

    @JvmOverloads
    public ISOAndEISettingWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.LOCKED_ISO_VALUE = "500";
        this.uiIsoValueArray = new CameraISO[0];
        this.eiValueArray = new int[0];
        this.widgetModel$delegate = LazyKt.lazy(ISOAndEISettingWidget::widgetModel_delegate$lambda$0);
    }

    public /* synthetic */ ISOAndEISettingWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final ISOAndEISettingModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (ISOAndEISettingModel)lazy.getValue();
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.binding = UxsdkWidgetIsoEiSettingBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getExposureModeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ ISOAndEISettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(CameraExposureMode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ISOAndEISettingWidget.access$onExposureModeUpdated(this.this$0, it);
                ISOAndEISettingWidget.access$updateISOEnableStatus(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().getISOProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ ISOAndEISettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(CameraISO it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ISOAndEISettingWidget.access$onISOUpdated(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.getWidgetModel().getISORangeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ ISOAndEISettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(List<? extends CameraISO> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Collection $this$toTypedArray$iv = it;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ISOAndEISettingWidget.access$updateISORangeValue(this.this$0, thisCollection$iv.toArray(new CameraISO[0]));
                ISOAndEISettingWidget.access$updateISOEnableStatus(this.this$0);
                ISOAndEISettingWidget.access$updateISORangeUI(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
        Disposable disposable4 = this.getWidgetModel().getExposureSettingsProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ ISOAndEISettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(CameraExposureSettings it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CameraExposureSettings exposureParameters = it;
                ISOAndEISettingWidget.access$setUiCameraISO$p(this.this$0, exposureParameters.getIso());
                ISOAndEISettingWidget.access$updateISORangeUI(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable4, (String)"subscribe(...)");
        this.addReaction(disposable4);
        Disposable disposable5 = this.getWidgetModel().getEiValueProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe((Consumer)reactToModelChanges.5.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)disposable5, (String)"subscribe(...)");
        this.addReaction(disposable5);
        Disposable disposable6 = this.getWidgetModel().getEiValueRangeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe((Consumer)reactToModelChanges.6.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)disposable6, (String)"subscribe(...)");
        this.addReaction(disposable6);
        Disposable disposable7 = this.getWidgetModel().getEiRecommendedValueProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe((Consumer)reactToModelChanges.7.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)disposable7, (String)"subscribe(...)");
        this.addReaction(disposable7);
        Disposable disposable8 = this.getWidgetModel().getExposureSensitivityModeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ ISOAndEISettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(ExposureSensitivityMode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ISOAndEISettingWidget.access$updateWidgetUI(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable8, (String)"subscribe(...)");
        this.addReaction(disposable8);
        Disposable disposable9 = this.getWidgetModel().getCameraModeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ ISOAndEISettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(CameraWorkMode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ISOAndEISettingWidget.access$updateWidgetUI(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable9, (String)"subscribe(...)");
        this.addReaction(disposable9);
        Disposable disposable10 = this.getWidgetModel().getFlatCameraModeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ ISOAndEISettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(CameraFlatMode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ISOAndEISettingWidget.access$updateWidgetUI(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable10, (String)"subscribe(...)");
        this.addReaction(disposable10);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Resources res = this.getContext().getResources();
        int[] nArray = res.getIntArray(R.array.uxsdk_iso_values);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getIntArray(...)");
        int[] valueArray = nArray;
        this.uiIsoValueArray = new CameraISO[valueArray.length];
        if (!this.isInEditMode()) {
            int n = valueArray.length;
            for (int i = 0; i < n; ++i) {
                this.uiIsoValueArray[i] = CameraISO.find((int)valueArray[i]);
            }
            this.updateISORangeValue(this.uiIsoValueArray);
        }
        this.isISOSeekBarEnabled = false;
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        uxsdkWidgetIsoEiSettingBinding.seekbarIso.setProgress(0);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding2 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding2 = null;
        }
        uxsdkWidgetIsoEiSettingBinding2.seekbarIso.enable(false);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding3 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding3 = null;
        }
        uxsdkWidgetIsoEiSettingBinding3.seekbarIso.addOnSeekBarChangeListener(this);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding4 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding4 = null;
        }
        uxsdkWidgetIsoEiSettingBinding4.seekbarIso.setBaselineVisibility(false);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding5 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding5 = null;
        }
        uxsdkWidgetIsoEiSettingBinding5.seekbarIso.setMinValueVisibility(true);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding6 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding6 = null;
        }
        uxsdkWidgetIsoEiSettingBinding6.seekbarIso.setMaxValueVisibility(true);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding7 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding7 = null;
        }
        uxsdkWidgetIsoEiSettingBinding7.seekbarIso.setMinusVisibility(false);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding8 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding8 = null;
        }
        uxsdkWidgetIsoEiSettingBinding8.seekbarIso.setPlusVisibility(false);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding9 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding9 = null;
        }
        uxsdkWidgetIsoEiSettingBinding9.buttonIsoAuto.setOnClickListener((View.OnClickListener)this);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding10 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding10 = null;
        }
        uxsdkWidgetIsoEiSettingBinding10.seekbarEi.addOnSeekBarChangeListener(this);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding11 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding11 = null;
        }
        uxsdkWidgetIsoEiSettingBinding11.seekbarEi.setVisibility(8);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding12 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding12 = null;
        }
        uxsdkWidgetIsoEiSettingBinding12.seekbarEi.setMinValueVisibility(true);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding13 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding13 = null;
        }
        uxsdkWidgetIsoEiSettingBinding13.seekbarEi.setMaxValueVisibility(true);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding14 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding14 = null;
        }
        uxsdkWidgetIsoEiSettingBinding14.seekbarEi.setMinusVisibility(false);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding15 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding15 = null;
        }
        uxsdkWidgetIsoEiSettingBinding15.seekbarEi.setPlusVisibility(false);
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    @NotNull
    public ComponentIndexType getCameraIndex() {
        return this.getWidgetModel().getCameraIndex();
    }

    @Override
    @NotNull
    public CameraLensType getLensType() {
        return this.getWidgetModel().getLensType();
    }

    @Override
    public void updateCameraSource(@NotNull ComponentIndexType cameraIndex, @NotNull CameraLensType lensType) {
        Intrinsics.checkNotNullParameter((Object)cameraIndex, (String)"cameraIndex");
        Intrinsics.checkNotNullParameter((Object)lensType, (String)"lensType");
        this.getWidgetModel().updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    @Override
    public void onProgressChanged(@NotNull HorizontalSeekBar view, int progress, boolean isFromUI) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        if (Intrinsics.areEqual((Object)((Object)view), (Object)((Object)uxsdkWidgetIsoEiSettingBinding.seekbarIso))) {
            if (this.isISOLocked) {
                UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding2 = this.binding;
                if (uxsdkWidgetIsoEiSettingBinding2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    uxsdkWidgetIsoEiSettingBinding2 = null;
                }
                uxsdkWidgetIsoEiSettingBinding2.seekbarIso.setText(this.LOCKED_ISO_VALUE);
            } else if (!(this.uiIsoValueArray.length == 0)) {
                this.uiCameraISO = CameraUtil.convertISOToInt(this.uiIsoValueArray[progress]);
                UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding3 = this.binding;
                if (uxsdkWidgetIsoEiSettingBinding3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    uxsdkWidgetIsoEiSettingBinding3 = null;
                }
                uxsdkWidgetIsoEiSettingBinding3.seekbarIso.setText(String.valueOf(this.uiCameraISO));
            }
        } else if (progress < this.eiValueArray.length) {
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding4 = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding4 = null;
            }
            uxsdkWidgetIsoEiSettingBinding4.seekbarEi.setText(String.valueOf(this.eiValueArray[progress]));
        }
    }

    @Override
    public void onStartTrackingTouch(@NotNull HorizontalSeekBar view, int progress) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        this.isSeekBarTracking = true;
    }

    @Override
    public void onStopTrackingTouch(@NotNull HorizontalSeekBar view, int progress) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        this.isSeekBarTracking = false;
        AudioUtil.playSoundInBackground(this.getContext(), R.raw.uxsdk_camera_ev_center);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        if (Intrinsics.areEqual((Object)((Object)view), (Object)((Object)uxsdkWidgetIsoEiSettingBinding.seekbarIso))) {
            if (!(this.uiIsoValueArray.length == 0)) {
                CameraISO newISO;
                CameraISO cameraISO = newISO = this.uiIsoValueArray[progress];
                if (cameraISO != null) {
                    CameraISO it = cameraISO;
                    boolean bl = false;
                    this.updateISOToCamera(it);
                }
            }
        } else if (progress < this.eiValueArray.length) {
            this.updateEIToCamera(this.eiValueArray[progress]);
        }
    }

    @Override
    public void onPlusClicked(@NotNull HorizontalSeekBar view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
    }

    @Override
    public void onMinusClicked(@NotNull HorizontalSeekBar view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
    }

    public void onClick(@Nullable View v) {
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        if (Intrinsics.areEqual((Object)v, (Object)uxsdkWidgetIsoEiSettingBinding.buttonIsoAuto)) {
            this.isISOAutoSelected = !this.isISOAutoSelected;
            this.setAutoISO(this.isISOAutoSelected);
        }
    }

    private final void updateWidgetUI() {
        if (this.getWidgetModel().isRecordVideoEIMode()) {
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding = null;
            }
            uxsdkWidgetIsoEiSettingBinding.textviewIsoTitle.setText(R.string.uxsdk_camera_ei);
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding2 = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding2 = null;
            }
            uxsdkWidgetIsoEiSettingBinding2.seekbarIsoLayout.setVisibility(8);
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding3 = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding3 = null;
            }
            uxsdkWidgetIsoEiSettingBinding3.seekbarEi.setVisibility(0);
        } else {
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding = null;
            }
            uxsdkWidgetIsoEiSettingBinding.textviewIsoTitle.setText(R.string.uxsdk_camera_exposure_iso_title);
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding4 = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding4 = null;
            }
            uxsdkWidgetIsoEiSettingBinding4.seekbarIsoLayout.setVisibility(0);
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding5 = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding5 = null;
            }
            uxsdkWidgetIsoEiSettingBinding5.seekbarEi.setVisibility(8);
        }
    }

    private final void onISOUpdated(CameraISO iso) {
        if (iso == CameraISO.ISO_FIXED) {
            this.updateISOLocked();
        }
    }

    private final void onExposureModeUpdated(CameraExposureMode exposureMode) {
        if (exposureMode != CameraExposureMode.MANUAL) {
            this.isISOAutoSelected = true;
            this.setAutoISO(this.isISOAutoSelected);
        } else {
            this.isISOAutoSelected = false;
        }
    }

    private final void updateISORangeValue(CameraISO[] array2) {
        this.isISOAutoSupported = this.checkAutoISO(array2);
        CameraISO[] newISOValues = this.isISOAutoSupported ? new CameraISO[array2.length - 1] : new CameraISO[array2.length];
        int j = 0;
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] == CameraISO.ISO_AUTO) continue;
            newISOValues[j] = array2[i];
            ++j;
        }
        this.uiIsoValueArray = newISOValues;
    }

    private final void updateISORangeUI() {
        if (!(this.uiIsoValueArray.length == 0)) {
            int minCameraISO = CameraUtil.convertISOToInt(this.uiIsoValueArray[0]);
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding = null;
            }
            uxsdkWidgetIsoEiSettingBinding.seekbarIso.setMinValueText(String.valueOf(minCameraISO));
            int maxCameraISO = CameraUtil.convertISOToInt(this.uiIsoValueArray[this.uiIsoValueArray.length - 1]);
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding2 = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding2 = null;
            }
            uxsdkWidgetIsoEiSettingBinding2.seekbarIso.setMaxValueText(String.valueOf(maxCameraISO));
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding3 = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding3 = null;
            }
            uxsdkWidgetIsoEiSettingBinding3.seekbarIso.setMax(this.uiIsoValueArray.length - 1);
            this.isISOSeekBarEnabled = true;
            this.updateISOValue(this.uiIsoValueArray, this.uiCameraISO);
            this.updateAutoISOButton();
        } else {
            this.isISOSeekBarEnabled = false;
        }
    }

    private final void updateISOEnableStatus() {
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        uxsdkWidgetIsoEiSettingBinding.seekbarIso.enable(!this.isISOAutoSelected && this.isISOSeekBarEnabled);
    }

    private final boolean checkAutoISO(CameraISO[] array2) {
        for (CameraISO iso : array2) {
            if (iso != CameraISO.ISO_AUTO) continue;
            return true;
        }
        return false;
    }

    private final void updateISOValue(CameraISO[] array2, int value) {
        int progress = this.getISOIndex(array2, value);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        uxsdkWidgetIsoEiSettingBinding.seekbarIso.setProgress(progress);
    }

    private final void updateAutoISOButton() {
        if (this.isISOAutoSupported && this.isISOSeekBarEnabled && !this.getWidgetModel().isRecordVideoEIMode() && CameraUtil.isAutoISOSupportedByProduct()) {
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding = null;
            }
            uxsdkWidgetIsoEiSettingBinding.buttonIsoAuto.setVisibility(0);
        } else {
            UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
            if (uxsdkWidgetIsoEiSettingBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                uxsdkWidgetIsoEiSettingBinding = null;
            }
            uxsdkWidgetIsoEiSettingBinding.buttonIsoAuto.setVisibility(8);
        }
    }

    private final int getISOIndex(CameraISO[] array2, int isoValue) {
        int index = -1;
        CameraISO cameraISO = CameraUtil.convertIntToISO(isoValue);
        Intrinsics.checkNotNullExpressionValue((Object)cameraISO, (String)"convertIntToISO(...)");
        CameraISO iso = cameraISO;
        int n = array2.length;
        for (int i = 0; i < n; ++i) {
            if (iso != array2[i]) continue;
            index = i;
            break;
        }
        return index;
    }

    private final void setAutoISO(boolean isAuto) {
        block5: {
            CameraISO newISO = null;
            if (isAuto) {
                newISO = CameraISO.ISO_AUTO;
            } else {
                UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
                if (uxsdkWidgetIsoEiSettingBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    uxsdkWidgetIsoEiSettingBinding = null;
                }
                if (uxsdkWidgetIsoEiSettingBinding.seekbarIso.getProgress() < this.uiIsoValueArray.length) {
                    UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding2 = this.binding;
                    if (uxsdkWidgetIsoEiSettingBinding2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                        uxsdkWidgetIsoEiSettingBinding2 = null;
                    }
                    newISO = this.uiIsoValueArray[uxsdkWidgetIsoEiSettingBinding2.seekbarIso.getProgress()];
                }
            }
            CameraISO cameraISO = newISO;
            if (cameraISO == null) break block5;
            CameraISO it = cameraISO;
            boolean bl = false;
            this.updateISOToCamera(it);
        }
    }

    private final void updateISOToCamera(CameraISO iso) {
        Disposable disposable = this.getWidgetModel().setISO(iso).observeOn(SchedulerProvider.ui()).subscribe(ISOAndEISettingWidget::updateISOToCamera$lambda$3, UxErrorHandle.errorConsumer(() -> ISOAndEISettingWidget.updateISOToCamera$lambda$4(this), this.toString(), "updateISOToCamera: "));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
    }

    private final void updateEIToCamera(int ei) {
        ISOAndEISettingModel iSOAndEISettingModel = this.getWidgetModel();
        EIType eIType = EIType.find((int)ei);
        Intrinsics.checkNotNullExpressionValue((Object)eIType, (String)"find(...)");
        Disposable disposable = iSOAndEISettingModel.setEI(eIType).observeOn(SchedulerProvider.ui()).subscribe(ISOAndEISettingWidget::updateEIToCamera$lambda$5, UxErrorHandle.errorConsumer(() -> ISOAndEISettingWidget.updateEIToCamera$lambda$6(this), this.toString(), "updateEIToCamera: "));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
    }

    private final void updateISOLocked() {
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        uxsdkWidgetIsoEiSettingBinding.buttonIsoAuto.setVisibility(8);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding2 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding2 = null;
        }
        uxsdkWidgetIsoEiSettingBinding2.seekbarIso.enable(false);
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding3 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding3 = null;
        }
        HorizontalSeekBar horizontalSeekBar = uxsdkWidgetIsoEiSettingBinding3.seekbarIso;
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding4 = this.binding;
        if (uxsdkWidgetIsoEiSettingBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding4 = null;
        }
        horizontalSeekBar.setProgress(uxsdkWidgetIsoEiSettingBinding4.seekbarIso.getMax() / 2 - 1);
    }

    @JvmOverloads
    public ISOAndEISettingWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ISOAndEISettingWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final ISOAndEISettingModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new ISOAndEISettingModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final void updateISOToCamera$lambda$3() {
    }

    private static final void updateISOToCamera$lambda$4(ISOAndEISettingWidget this$0) {
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this$0.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        uxsdkWidgetIsoEiSettingBinding.seekbarIso.restorePreviousProgress();
    }

    private static final void updateEIToCamera$lambda$5() {
    }

    private static final void updateEIToCamera$lambda$6(ISOAndEISettingWidget this$0) {
        UxsdkWidgetIsoEiSettingBinding uxsdkWidgetIsoEiSettingBinding = this$0.binding;
        if (uxsdkWidgetIsoEiSettingBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            uxsdkWidgetIsoEiSettingBinding = null;
        }
        uxsdkWidgetIsoEiSettingBinding.seekbarIso.restorePreviousProgress();
    }

    public static final /* synthetic */ void access$onExposureModeUpdated(ISOAndEISettingWidget $this, CameraExposureMode exposureMode) {
        $this.onExposureModeUpdated(exposureMode);
    }

    public static final /* synthetic */ void access$updateISOEnableStatus(ISOAndEISettingWidget $this) {
        $this.updateISOEnableStatus();
    }

    public static final /* synthetic */ void access$onISOUpdated(ISOAndEISettingWidget $this, CameraISO iso) {
        $this.onISOUpdated(iso);
    }

    public static final /* synthetic */ void access$updateISORangeValue(ISOAndEISettingWidget $this, CameraISO[] array2) {
        $this.updateISORangeValue(array2);
    }

    public static final /* synthetic */ void access$updateISORangeUI(ISOAndEISettingWidget $this) {
        $this.updateISORangeUI();
    }

    public static final /* synthetic */ void access$setUiCameraISO$p(ISOAndEISettingWidget $this, int n) {
        $this.uiCameraISO = n;
    }

    public static final /* synthetic */ void access$updateWidgetUI(ISOAndEISettingWidget $this) {
        $this.updateWidgetUI();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/cameracore/widget/cameracontrols/exposuresettings/ISOAndEISettingWidget$ModelState;", "", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

