/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.gmap.utils;

import android.graphics.Bitmap;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Dash;
import com.google.android.gms.maps.model.Gap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdateFactory;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.DJILatLngBounds;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.core.utils.DJIGpsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoogleUtils {
    private GoogleUtils() {
    }

    public static final LatLng fromDJILatLng(DJILatLng latLng) {
        DJILatLng gcjLatLng = DJIGpsUtils.wgs2gcjJustInMainlandChina(latLng);
        return new LatLng(gcjLatLng.getLatitude(), gcjLatLng.getLongitude());
    }

    public static final DJILatLng fromLatLng(LatLng latLng) {
        DJILatLng ll = new DJILatLng(latLng.latitude, latLng.longitude);
        DJILatLng transformed = DJIGpsUtils.gcj2wgsJustInMainlandChina(ll);
        return transformed;
    }

    public static final CameraUpdate fromDJICameraUpdate(DJICameraUpdate cameraUpdate) {
        CameraUpdate u = CameraUpdateFactory.newLatLng((LatLng)new LatLng(0.0, 0.0));
        if (cameraUpdate instanceof DJICameraUpdateFactory.CameraBoundsUpdate) {
            DJICameraUpdateFactory.CameraBoundsUpdate boundsUpdate = (DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate;
            int width = boundsUpdate.getWidth();
            int height = boundsUpdate.getHeight();
            int padding = boundsUpdate.getPadding();
            LatLngBounds.Builder builder = new LatLngBounds.Builder();
            DJILatLngBounds bounds = boundsUpdate.getBounds();
            DJILatLng northeast = bounds.getNortheast();
            DJILatLng southwest = bounds.getSouthwest();
            builder.include(GoogleUtils.fromDJILatLng(northeast)).include(GoogleUtils.fromDJILatLng(southwest));
            u = width == 0 || height == 0 ? CameraUpdateFactory.newLatLngBounds((LatLngBounds)builder.build(), (int)boundsUpdate.getPadding()) : CameraUpdateFactory.newLatLngBounds((LatLngBounds)builder.build(), (int)width, (int)height, (int)padding);
        } else if (cameraUpdate instanceof DJICameraUpdateFactory.CameraPositionUpdate) {
            DJICameraUpdateFactory.CameraPositionUpdate positionUpdate = (DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate;
            LatLng target = GoogleUtils.fromDJILatLng(positionUpdate.getTarget());
            CameraPosition p = new CameraPosition.Builder().target(target).zoom(positionUpdate.getZoom()).tilt(positionUpdate.getTilt()).bearing(positionUpdate.getBearing()).build();
            u = CameraUpdateFactory.newCameraPosition((CameraPosition)p);
        }
        return u;
    }

    public static final DJICameraPosition fromCameraPosition(CameraPosition cameraPosition) {
        DJICameraPosition.Builder builder = new DJICameraPosition.Builder();
        LatLng target = cameraPosition.target;
        builder.target(GoogleUtils.fromLatLng(target)).zoom(cameraPosition.zoom).tilt(cameraPosition.tilt).bearing(cameraPosition.bearing);
        return builder.build();
    }

    public static final BitmapDescriptor fromDJIBitmapDescriptor(DJIBitmapDescriptor descriptor) {
        String path = descriptor.getPath();
        return switch (descriptor.getType()) {
            case DJIBitmapDescriptor.Type.BITMAP -> BitmapDescriptorFactory.fromBitmap((Bitmap)descriptor.getBitmap());
            case DJIBitmapDescriptor.Type.PATH_ABSOLUTE -> BitmapDescriptorFactory.fromPath((String)path);
            case DJIBitmapDescriptor.Type.PATH_ASSET -> BitmapDescriptorFactory.fromAsset((String)path);
            case DJIBitmapDescriptor.Type.PATH_FILEINPUT -> BitmapDescriptorFactory.fromFile((String)path);
            case DJIBitmapDescriptor.Type.RESOURCE_ID -> BitmapDescriptorFactory.fromResource((int)descriptor.getResourceId());
            default -> throw new AssertionError();
        };
    }

    public static final PolygonOptions fromDJIPolygonOptions(DJIPolygonOptions options) {
        PolygonOptions result = new PolygonOptions();
        ArrayList<LatLng> points = new ArrayList<LatLng>();
        for (DJILatLng point : options.getPoints()) {
            points.add(GoogleUtils.fromDJILatLng(point));
        }
        result.strokeWidth(options.getStrokeWidth()).zIndex(options.getZIndex()).strokeColor(options.getStrokeColor()).fillColor(options.getFillColor()).visible(options.isVisible()).addAll(points);
        return result;
    }

    public static final PolylineOptions fromDJIPolylineOptions(DJIPolylineOptions options) {
        PolylineOptions result = new PolylineOptions();
        ArrayList<LatLng> points = new ArrayList<LatLng>();
        for (DJILatLng point : options.getPoints()) {
            points.add(GoogleUtils.fromDJILatLng(point));
        }
        result.width(options.getWidth()).zIndex(options.getZIndex()).color(options.getColor()).visible(options.isVisible()).geodesic(options.isGeodesic()).addAll(points);
        if (options.isDashed()) {
            Dash dash = new Dash(options.getDashLength());
            Gap gap = new Gap(options.getDashLength());
            List<PatternItem> patternItems = Arrays.asList(dash, gap);
            result.pattern(patternItems);
        }
        return result;
    }
}

