/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.gmap.map;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.Polyline;
import dji.v5.ux.mapkit.core.callback.MapScreenShotListener;
import dji.v5.ux.mapkit.core.callback.OnCameraChangeListener;
import dji.v5.ux.mapkit.core.callback.OnMapTypeLoadedListener;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.maps.DJIBaseMap;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.maps.DJIProjection;
import dji.v5.ux.mapkit.core.maps.DJIUiSettings;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircle;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygon;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.gmap.annotations.GCircle;
import dji.v5.ux.mapkit.gmap.annotations.GMarker;
import dji.v5.ux.mapkit.gmap.annotations.GPolygon;
import dji.v5.ux.mapkit.gmap.annotations.GPolyline;
import dji.v5.ux.mapkit.gmap.map.GProjection;
import dji.v5.ux.mapkit.gmap.map.GUiSettings;
import dji.v5.ux.mapkit.gmap.utils.GoogleUtils;
import java.util.HashMap;

public class GMapDelegate
extends DJIBaseMap
implements DJIMap,
GoogleMap.OnMarkerClickListener,
GoogleMap.OnMapClickListener,
GoogleMap.OnMarkerDragListener,
GoogleMap.OnInfoWindowClickListener {
    private GoogleMap mMap;
    private HashMap<Marker, GMarker> markerMap;

    public GMapDelegate(GoogleMap map) {
        this.mMap = map;
        this.mMap.setOnMarkerClickListener((GoogleMap.OnMarkerClickListener)this);
        this.mMap.setOnMapClickListener((GoogleMap.OnMapClickListener)this);
        this.mMap.setOnMarkerDragListener((GoogleMap.OnMarkerDragListener)this);
        this.mMap.setOnInfoWindowClickListener((GoogleMap.OnInfoWindowClickListener)this);
        this.markerMap = new HashMap();
        this.mMap.setOnCameraMoveListener(() -> {
            CameraPosition p = this.mMap.getCameraPosition();
            DJICameraPosition cameraPosition = GoogleUtils.fromCameraPosition(p);
            this.onCameraChange(cameraPosition);
        });
    }

    @Override
    @NonNull
    public DJIMarker addMarker(DJIMarkerOptions markerOptions) {
        DJILatLng latLng = markerOptions.getPosition();
        if (latLng == null) {
            throw new IllegalArgumentException("DJIMarkerOptions parameter must have position set");
        }
        MarkerOptions options = new MarkerOptions();
        DJILatLng position = markerOptions.getPosition();
        DJIBitmapDescriptor icon = markerOptions.getIcon();
        options.draggable(markerOptions.getDraggable()).position(GoogleUtils.fromDJILatLng(position)).anchor(markerOptions.getAnchorU(), markerOptions.getAnchorV()).rotation(markerOptions.getRotation()).zIndex((float)markerOptions.getZIndex()).visible(markerOptions.getVisible()).title(markerOptions.getTitle()).flat(markerOptions.isFlat());
        if (icon != null) {
            options.icon(GoogleUtils.fromDJIBitmapDescriptor(icon));
        }
        Marker marker = this.mMap.addMarker(options);
        GMarker gMarker = new GMarker(marker, this);
        gMarker.setPositionCache(markerOptions.getPosition());
        this.markerMap.put(marker, gMarker);
        return gMarker;
    }

    @Override
    public Object getMap() {
        return this.mMap;
    }

    @Override
    public DJICameraPosition getCameraPosition() {
        CameraPosition p = this.mMap.getCameraPosition();
        return GoogleUtils.fromCameraPosition(p);
    }

    @Override
    public void animateCamera(DJICameraUpdate cameraUpdate) {
        CameraUpdate update = GoogleUtils.fromDJICameraUpdate(cameraUpdate);
        this.mMap.animateCamera(update);
    }

    @Override
    public void moveCamera(@NonNull DJICameraUpdate cameraUpdate) {
        CameraUpdate update = GoogleUtils.fromDJICameraUpdate(cameraUpdate);
        this.mMap.moveCamera(update);
    }

    @Override
    public void setOnCameraChangeListener(OnCameraChangeListener listener2) {
        if (this.onCameraChangeListeners.contains(listener2)) {
            return;
        }
        this.onCameraChangeListeners.add(listener2);
        this.mMap.setOnCameraMoveListener(() -> {
            CameraPosition p = this.mMap.getCameraPosition();
            DJICameraPosition cameraPosition = GoogleUtils.fromCameraPosition(p);
            for (OnCameraChangeListener listener1 : this.onCameraChangeListeners) {
                listener1.onCameraChange(cameraPosition);
            }
        });
    }

    @Override
    public void removeAllOnCameraChangeListeners() {
        this.mMap.setOnCameraMoveListener(null);
        this.onCameraChangeListeners.clear();
    }

    @Override
    public void setInfoWindowAdapter(final DJIMap.InfoWindowAdapter adapter) {
        this.mMap.setInfoWindowAdapter(new GoogleMap.InfoWindowAdapter(){

            public View getInfoWindow(Marker marker) {
                return adapter.getInfoWindow(GMapDelegate.this.markerMap.get(marker));
            }

            public View getInfoContents(Marker marker) {
                return adapter.getInfoContents(GMapDelegate.this.markerMap.get(marker));
            }
        });
    }

    @Override
    @NonNull
    public DJIPolyline addPolyline(DJIPolylineOptions options) {
        Polyline polyline = this.mMap.addPolyline(GoogleUtils.fromDJIPolylineOptions(options));
        return new GPolyline(polyline);
    }

    @Override
    @NonNull
    public DJIPolygon addPolygon(DJIPolygonOptions options) {
        Polygon polygon = this.mMap.addPolygon(GoogleUtils.fromDJIPolygonOptions(options));
        return new GPolygon(polygon);
    }

    @Override
    public DJICircle addMarkerCircle(DJICircleOptions options) {
        return null;
    }

    @Override
    public DJIGroupCircle addGroupCircle(DJIGroupCircleOptions options) {
        return null;
    }

    @Override
    @Nullable
    public DJICircle addSingleCircle(DJICircleOptions options) {
        if (options.getRadius() <= 0.0) {
            return null;
        }
        CircleOptions circleOptions = new CircleOptions();
        DJILatLng center = options.getCenter();
        circleOptions.center(GoogleUtils.fromDJILatLng(center)).radius(options.getRadius()).strokeWidth(options.getStrokeWidth()).strokeColor(options.getStrokeColor()).fillColor(options.getFillColor());
        Circle circle = this.mMap.addCircle(circleOptions);
        return new GCircle(circle);
    }

    @Override
    public void setMapType(DJIMap.MapType type, OnMapTypeLoadedListener listener2) {
        this.setMapType(type);
        listener2.onMapTypeLoaded();
    }

    @Override
    public void setMapType(int type) {
        switch (type) {
            case 1: {
                this.mMap.setMapType(1);
                break;
            }
            case 2: {
                this.mMap.setMapType(2);
                break;
            }
            case 4: {
                this.mMap.setMapType(4);
                break;
            }
            default: {
                this.mMap.setMapType(1);
            }
        }
    }

    @Override
    public void setMapType(DJIMap.MapType type) {
        switch (type) {
            case NORMAL: {
                this.mMap.setMapType(1);
                break;
            }
            case SATELLITE: {
                this.mMap.setMapType(2);
                break;
            }
            case HYBRID: {
                this.mMap.setMapType(4);
                break;
            }
            default: {
                this.mMap.setMapType(1);
            }
        }
    }

    @Override
    public DJIUiSettings getUiSettings() {
        return new GUiSettings(this.mMap.getUiSettings());
    }

    public boolean onMarkerClick(Marker marker) {
        boolean result = true;
        if (this.markerMap.containsKey(marker)) {
            this.onMarkerClick(this.markerMap.get(marker));
        }
        return result;
    }

    public void onMapClick(LatLng latLng) {
        DJILatLng djiLatLng = GoogleUtils.fromLatLng(latLng);
        this.onMapClick(djiLatLng);
    }

    public void onInfoWindowClick(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            this.onInfoWindowClick(this.markerMap.get(marker));
        }
    }

    public void onMarkerDragStart(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            this.onMarkerDragStart(this.markerMap.get(marker));
        }
    }

    public void onMarkerDrag(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            DJIMarker djiMarker = this.markerMap.get(marker);
            LatLng latLng = marker.getPosition();
            DJILatLng djiLatLng = GoogleUtils.fromLatLng(latLng);
            djiMarker.setPosition(djiLatLng);
            this.onMarkerDrag(djiMarker);
        }
    }

    public void onMarkerDragEnd(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            DJIMarker djiMarker = this.markerMap.get(marker);
            LatLng latLng = marker.getPosition();
            DJILatLng djiLatLng = GoogleUtils.fromLatLng(latLng);
            djiMarker.setPosition(djiLatLng);
            this.onMarkerDragEnd(djiMarker);
        }
    }

    @Override
    public void snapshot(MapScreenShotListener callback) {
        this.mMap.snapshot(bitmap -> callback.onMapScreenShot(bitmap));
    }

    @Override
    public DJIProjection getProjection() {
        return new GProjection(this.mMap.getProjection());
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    public void onMarkerRemove(Marker marker) {
        if (this.markerMap.containsKey(marker)) {
            this.markerMap.remove(marker);
        }
    }
}

