/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.flightparam;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.flightcontroller.FailsafeAction;
import dji.v5.ux.R;
import dji.v5.ux.accessory.DescSpinnerCell;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.flight.flightparam.LostActionWidgetModel;

public class LostActionWidget
extends ConstraintLayoutWidget<Object> {
    LostActionWidgetModel widgetModel = new LostActionWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    DescSpinnerCell spinnerCell;

    public LostActionWidget(@NonNull Context context) {
        super(context);
    }

    public LostActionWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public LostActionWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        LostActionWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_flight_lost_action, (ViewGroup)this);
        this.spinnerCell = (DescSpinnerCell)this.findViewById(R.id.setting_menu_aircraft_failSafe);
        this.spinnerCell.addOnItemSelectedListener(position -> {
            FailsafeAction value = FailsafeAction.find((int)position);
            this.widgetModel.setLostAction(value).subscribe();
        });
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getLostActionFlowable().observeOn(SchedulerProvider.ui()).subscribe(this::updateSelection));
    }

    private void updateSelection(FailsafeAction failsafeAction) {
        this.spinnerCell.select(failsafeAction.value());
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }
}

