/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd.frequency;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import dji.v5.ux.R;
import dji.v5.ux.core.base.BaseView;

public class RectCenterTextView
extends BaseView {
    private String mAverageVal = "-70dBm";
    private float mPosX = 0.0f;
    private Paint mPaint;
    private float mTxtSize = this.getResources().getDimension(R.dimen.uxsdk_text_size_small);
    private float mMarginLeft = 0.0f;

    public RectCenterTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint = new Paint();
        this.mPaint.setColor(this.getResources().getColor(17170443));
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize(this.mTxtSize);
        this.mMarginLeft = this.getResources().getDimension(R.dimen.uxsdk_setting_ui_hd_sdr_chart_left_axis_width);
    }

    public void setCenterAverageText(String val) {
        this.mAverageVal = val;
        this.postInvalidate();
    }

    public void setCenterPos(float pos, boolean isRectDragging) {
        this.mPosX = pos;
        if (isRectDragging && this.getVisibility() != 4) {
            this.setVisibility(4);
        } else if (!isRectDragging && this.getVisibility() != 0) {
            this.setVisibility(0);
        }
        this.postInvalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float offset = this.mTxtSize / 4.0f * (float)this.mAverageVal.length();
        canvas.drawText(this.mAverageVal, this.mMarginLeft + this.mPosX - offset, this.mTxtSize, this.mPaint);
    }
}

