/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.TabSelectCell;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.hd.FrequencyTabSelectWidgetModel;
import java.util.ArrayList;
import java.util.List;

public class FrequencyTabSelectWidget
extends ConstraintLayoutWidget<Object>
implements TabSelectCell.OnTabChangeListener {
    private static final String TAG = "FrequencyTabSelectWidget";
    private TabSelectCell frequencySelectTab;
    private FrequencyBand mOcuSyncFrequencyBand = FrequencyBand.BAND_MULTI;
    private List<FrequencyBand> mSupportOcuSyncFrequencyBands;
    private ChannelSelectionMode mChannelSelectionMode;
    private FrequencyTabSelectWidgetModel widgetModel = new FrequencyTabSelectWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    private String[] mAllFrequencyNames;

    public FrequencyTabSelectWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public FrequencyTabSelectWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FrequencyTabSelectWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    public void onTabChanged(TabSelectCell cell, int oldIndex, int newIndex) {
        FrequencyBand newBand;
        if (oldIndex == newIndex) {
            return;
        }
        if (this.mSupportOcuSyncFrequencyBands != null && newIndex < this.mSupportOcuSyncFrequencyBands.size() && (newBand = this.mSupportOcuSyncFrequencyBands.get(newIndex)) != this.mOcuSyncFrequencyBand) {
            this.addDisposable(this.widgetModel.setFrequencyBand(newBand).subscribe(() -> {}, throwable -> {
                LogUtils.e((String)TAG, (Object[])new Object[]{"setFrequencyBand fail: " + throwable});
                this.frequencySelectTab.setCurrentTab(oldIndex);
            }));
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        FrequencyTabSelectWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_frequency_tab_select_layout, (ViewGroup)this);
        this.frequencySelectTab = (TabSelectCell)this.findViewById(R.id.tsc_setting_menu_hd_frequency_tab_cell);
        this.frequencySelectTab.setOnTabChangeListener(this);
        this.mAllFrequencyNames = this.getResources().getStringArray(R.array.uxsdk_sdr_frequency_names);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getFrequencyBand().subscribe(value -> {
            this.mOcuSyncFrequencyBand = value;
            this.updateSelection();
        }));
        this.addReaction(this.widgetModel.getFrequencyBandRange().subscribe(value -> {
            this.mSupportOcuSyncFrequencyBands = value;
            ArrayList<String> names = new ArrayList<String>();
            boolean is1dot4Support = this.find1dot4Band(this.mSupportOcuSyncFrequencyBands);
            if (this.mSupportOcuSyncFrequencyBands != null && this.mAllFrequencyNames != null) {
                for (FrequencyBand band : this.mSupportOcuSyncFrequencyBands) {
                    if (band.value() >= this.mAllFrequencyNames.length || band == FrequencyBand.BAND_MULTI && this.mChannelSelectionMode != ChannelSelectionMode.AUTO) continue;
                    names.add(this.mAllFrequencyNames[this.convertOcuSyncBandValue(band, is1dot4Support)]);
                }
            }
            this.frequencySelectTab.addTabs(0, names);
            this.updateSelection();
        }));
        this.addReaction(this.widgetModel.getChannelSelectionMode().subscribe(value -> {
            this.mChannelSelectionMode = value;
            this.updateSelection();
        }));
        this.addReaction(this.widgetModel.getConnection().subscribe(isConnected -> {
            this.frequencySelectTab.setEnabled((boolean)isConnected);
            if (Boolean.TRUE.equals(isConnected)) {
                return;
            }
            this.frequencySelectTab.setCurrentTab(0);
        }));
    }

    private void updateSelection() {
        if (this.mSupportOcuSyncFrequencyBands != null) {
            for (int i = 0; i < this.mSupportOcuSyncFrequencyBands.size(); ++i) {
                FrequencyBand band = this.mSupportOcuSyncFrequencyBands.get(i);
                if (band.value() != this.mOcuSyncFrequencyBand.value()) continue;
                this.frequencySelectTab.setCurrentTab(i);
                break;
            }
        }
    }

    private boolean find1dot4Band(List<FrequencyBand> bands) {
        if (bands != null) {
            for (FrequencyBand band : bands) {
                if (band != FrequencyBand.BAND_1_DOT_4G) continue;
                return true;
            }
        }
        return false;
    }

    public int convertOcuSyncBandValue(FrequencyBand band, boolean is1Dot4Support) {
        if (band == null) {
            return 0;
        }
        switch (band) {
            case BAND_MULTI: {
                if (is1Dot4Support) {
                    return 5;
                }
                return 0;
            }
            case BAND_2_DOT_4G: {
                return 1;
            }
            case BAND_5_DOT_8G: {
                return 2;
            }
            case BAND_1_DOT_4G: {
                return 3;
            }
            case BAND_5_DOT_7G: {
                return 4;
            }
        }
        return 0;
    }
}

