/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.airlink.Bandwidth;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.TabSelectCell;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.hd.BandWidthSelectWidgetModel;
import java.util.ArrayList;
import java.util.List;

public class BandWidthSelectWidget
extends ConstraintLayoutWidget<Object>
implements TabSelectCell.OnTabChangeListener {
    private static final String TAG = "BandWidthSelectWidget";
    private Bandwidth mBandwidth = Bandwidth.UNKNOWN;
    private List<DJIBandwidth> mBandWidthItems = new ArrayList<DJIBandwidth>();
    private ChannelSelectionMode mChannelMode = ChannelSelectionMode.UNKNOWN;
    private FrequencyBand mFrequencyBand = FrequencyBand.UNKNOWN;
    private TabSelectCell sdrBandWidthSelectTab;
    BandWidthSelectWidgetModel widgetModel = new BandWidthSelectWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());

    public BandWidthSelectWidget(Context context) {
        this(context, null);
    }

    public BandWidthSelectWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BandWidthSelectWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
        this.initBandwidthItems();
        this.initBandwidthItemsUI();
        this.setVisibility(8);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    private void updateBandwidthSelect() {
        int position;
        if (this.mBandwidth != Bandwidth.UNKNOWN && (position = this.findBandwidthPosition(this.mBandwidth)) >= 0) {
            this.sdrBandWidthSelectTab.setOnTabChangeListener(null);
            this.sdrBandWidthSelectTab.setCurrentTab(position);
            this.sdrBandWidthSelectTab.setOnTabChangeListener(this);
        }
    }

    private int findBandwidthPosition(Bandwidth bandwidth) {
        if (this.mBandWidthItems.isEmpty()) {
            return -1;
        }
        DJIBandwidth bandwidthMode = DJIBandwidth.find(bandwidth);
        return this.mBandWidthItems.indexOf((Object)bandwidthMode);
    }

    private void initBandwidthItemsUI() {
        if (!this.mBandWidthItems.isEmpty()) {
            ArrayList<String> items = new ArrayList<String>();
            for (DJIBandwidth bandwidth : this.mBandWidthItems) {
                items.add(bandwidth.getName());
            }
            int position = this.findBandwidthPosition(this.mBandwidth);
            position = Math.max(position, 0);
            this.sdrBandWidthSelectTab.setOnTabChangeListener(null);
            this.sdrBandWidthSelectTab.addTabs(position, items);
            this.sdrBandWidthSelectTab.setOnTabChangeListener(this);
        }
    }

    private void initBandwidthItems() {
        this.mBandWidthItems.clear();
        this.mBandWidthItems.add(DJIBandwidth.BW_40);
        this.mBandWidthItems.add(DJIBandwidth.BW_20);
        this.mBandWidthItems.add(DJIBandwidth.BW_10);
    }

    private void updateVisible() {
        if (this.mChannelMode == ChannelSelectionMode.AUTO || this.mFrequencyBand == FrequencyBand.BAND_1_DOT_4G) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
    }

    @Override
    public void onTabChanged(TabSelectCell cell, int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        if (newIndex < this.mBandWidthItems.size()) {
            Bandwidth bandwidth = this.mBandWidthItems.get(newIndex).getValue();
            this.addDisposable(this.widgetModel.setBandwidth(bandwidth).subscribe(() -> {}, throwable -> {
                LogUtils.e((String)TAG, (Object[])new Object[]{"setFrequencyBand fail: " + throwable});
                this.updateBandwidthSelect();
            }));
        }
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        BandWidthSelectWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_sdr_band_width_select_layout, (ViewGroup)this);
        this.sdrBandWidthSelectTab = (TabSelectCell)this.findViewById(R.id.tsc_setting_menu_sdr_band_width_select);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getBandwidth().subscribe(value -> {
            this.mBandwidth = value;
            int position = this.findBandwidthPosition(this.mBandwidth);
            if (position >= 0) {
                this.sdrBandWidthSelectTab.setOnTabChangeListener(null);
                this.sdrBandWidthSelectTab.setCurrentTab(position);
                this.sdrBandWidthSelectTab.setOnTabChangeListener(this);
            }
            this.updateBandwidthSelect();
        }));
        this.addReaction(this.widgetModel.getChannelSelectionMode().subscribe(value -> {
            this.mChannelMode = value;
            this.updateVisible();
        }));
        this.addReaction(this.widgetModel.getFrequencyBand().subscribe(value -> {
            this.mFrequencyBand = value;
            this.updateVisible();
        }));
    }

    public static enum DJIBandwidth {
        BW_40("40MHz", Bandwidth.BANDWIDTH_40MHZ),
        BW_20("20MHz", Bandwidth.BANDWIDTH_20MHZ),
        BW_10("10MHz", Bandwidth.BANDWIDTH_10MHZ),
        UNKNOWN("", Bandwidth.UNKNOWN);

        private String mName;
        private Bandwidth mValue;

        private DJIBandwidth(String name, Bandwidth value) {
            this.mName = name;
            this.mValue = value;
        }

        public String getName() {
            return this.mName;
        }

        public Bandwidth getValue() {
            return this.mValue;
        }

        public static DJIBandwidth find(Bandwidth value) {
            DJIBandwidth target = UNKNOWN;
            for (DJIBandwidth bandwidth : DJIBandwidth.values()) {
                if (bandwidth.mValue != value) continue;
                target = bandwidth;
                break;
            }
            return target;
        }
    }
}

