/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

public final class MathUtil {
    private static final int ROTATION_VECTOR_LENGTH_MAX = 4;
    private static final int ROTATION_MATRIX_SMALL = 9;
    private static final int ROTATION_MATRIX_BIG = 16;

    private MathUtil() {
    }

    public static void getRotationMatrixFromVector(float[] rotationMatrix, float[] rotationVector) {
        float q0;
        float q1 = rotationVector[0];
        float q2 = rotationVector[1];
        float q3 = rotationVector[2];
        q0 = rotationVector.length == 4 ? rotationVector[3] : ((q0 = 1.0f - q1 * q1 - q2 * q2 - q3 * q3) > 0.0f ? (float)Math.sqrt(q0) : 0.0f);
        float sqQ1 = 2.0f * q1 * q1;
        float sqQ2 = 2.0f * q2 * q2;
        float sqQ3 = 2.0f * q3 * q3;
        float q1Q2 = 2.0f * q1 * q2;
        float q3Q0 = 2.0f * q3 * q0;
        float q1Q3 = 2.0f * q1 * q3;
        float q2Q0 = 2.0f * q2 * q0;
        float q2Q3 = 2.0f * q2 * q3;
        float q1Q0 = 2.0f * q1 * q0;
        if (rotationMatrix.length == 9) {
            rotationMatrix[0] = 1.0f - sqQ2 - sqQ3;
            rotationMatrix[1] = q1Q2 - q3Q0;
            rotationMatrix[2] = q1Q3 + q2Q0;
            rotationMatrix[3] = q1Q2 + q3Q0;
            rotationMatrix[4] = 1.0f - sqQ1 - sqQ3;
            rotationMatrix[5] = q2Q3 - q1Q0;
            rotationMatrix[6] = q1Q3 - q2Q0;
            rotationMatrix[7] = q2Q3 + q1Q0;
            rotationMatrix[8] = 1.0f - sqQ1 - sqQ2;
        } else if (rotationMatrix.length == 16) {
            rotationMatrix[0] = 1.0f - sqQ2 - sqQ3;
            rotationMatrix[1] = q1Q2 - q3Q0;
            rotationMatrix[2] = q1Q3 + q2Q0;
            rotationMatrix[3] = 0.0f;
            rotationMatrix[4] = q1Q2 + q3Q0;
            rotationMatrix[5] = 1.0f - sqQ1 - sqQ3;
            rotationMatrix[6] = q2Q3 - q1Q0;
            rotationMatrix[7] = 0.0f;
            rotationMatrix[8] = q1Q3 - q2Q0;
            rotationMatrix[9] = q2Q3 + q1Q0;
            rotationMatrix[10] = 1.0f - sqQ1 - sqQ2;
            rotationMatrix[11] = 0.0f;
            rotationMatrix[14] = 0.0f;
            rotationMatrix[13] = 0.0f;
            rotationMatrix[12] = 0.0f;
            rotationMatrix[15] = 1.0f;
        }
    }

    public static int normalize(int oldValue, int oldMin, int oldMax, int newMin, int newMax) {
        int oldRange = oldMax - oldMin;
        int newRange = newMax - newMin;
        if (oldRange == 0) {
            oldRange = 1;
        }
        return (oldValue - oldMin) * newRange / oldRange + newMin;
    }

    public static boolean isInteger(String number) {
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

