/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.RoundedLinearLayout;
import java.util.ArrayList;
import java.util.List;

public class TabModeWidget
extends RoundedLinearLayout
implements View.OnClickListener {
    private int mSelectIndex;
    private int mTextSize;
    private int mTextColor;
    private boolean mFixedSize;
    private List<String> mTabs;
    private OnTabChangeListener mOnTabChangeListener;

    public TabModeWidget(Context context) {
        this(context, null);
    }

    public TabModeWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TabModeWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        CharSequence[] entries;
        this.setBackgroundResource(R.drawable.uxsdk_selector_white_round_rect);
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TabModeWidget, defStyleAttr, 0);
        this.mSelectIndex = ta.getInt(R.styleable.TabModeWidget_uxsdk_select, 0);
        this.mTextSize = ta.getDimensionPixelSize(R.styleable.TabModeWidget_uxsdk_textSize, AndUtil.dip2px((Context)this.getContext(), (float)9.0f));
        this.mTextColor = ta.getColor(R.styleable.TabModeWidget_uxsdk_textColor, -1);
        this.mFixedSize = ta.getBoolean(R.styleable.TabModeWidget_uxsdk_fixedSize, false);
        this.mTabs = new ArrayList<String>();
        if (ta.hasValue(R.styleable.TabModeWidget_uxsdk_tabs) && (entries = ta.getTextArray(R.styleable.TabModeWidget_uxsdk_tabs)) != null && entries.length > 0) {
            for (CharSequence s : entries) {
                this.mTabs.add(s.toString());
            }
            this.setTabs();
        }
        ta.recycle();
    }

    private void setTabs() {
        for (int i = 0; i < this.mTabs.size(); ++i) {
            LinearLayout.LayoutParams params;
            TextView tab = i == this.mSelectIndex ? new TabBuilder().setTabName(this.mTabs.get(i)).setTextSize(this.mTextSize).setTextColor(-16777216).setBackground(-1).build() : new TabBuilder().setTabName(this.mTabs.get(i)).setTextSize(this.mTextSize).setTextColor(this.mTextColor).setBackground(0).build();
            tab.setOnClickListener((View.OnClickListener)this);
            this.addView((View)tab);
            if (!this.mFixedSize || (params = (LinearLayout.LayoutParams)tab.getLayoutParams()) == null) continue;
            params.weight = 1.0f;
            params.width = 0;
            tab.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.invalidate();
    }

    public void setTabs(int select, List<String> tabs) {
        this.removeAllViews();
        this.mTabs.clear();
        this.mTabs.addAll(tabs);
        this.mSelectIndex = select;
        this.setTabs();
    }

    public int getTabSize() {
        return this.mTabs.size();
    }

    public void setCurrentTab(int tab) {
        View child = this.getChildAt(tab);
        if (child != null) {
            this.updateSelectedView(child);
        }
    }

    public int getCurrentTab() {
        return this.mSelectIndex;
    }

    public void setOnTabChangeListener(OnTabChangeListener listener2) {
        this.mOnTabChangeListener = listener2;
    }

    private void updateSelectedView(View view) {
        if (view == null) {
            return;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TextView child = (TextView)this.getChildAt(i);
            if (child == null) continue;
            if (child == view) {
                child.setBackgroundColor(-1);
                child.setTextColor(-16777216);
                this.mSelectIndex = i;
                continue;
            }
            child.setTextColor(this.mTextColor);
            child.setBackgroundColor(0);
        }
        this.invalidate();
    }

    public void onClick(View view) {
        if (!this.isEnabled()) {
            return;
        }
        int oldIndex = this.mSelectIndex;
        this.updateSelectedView(view);
        if (this.mOnTabChangeListener != null) {
            this.mOnTabChangeListener.onTabChanged(oldIndex, this.mSelectIndex);
        }
    }

    protected class TabBuilder {
        String tabName;
        int textSize;
        int textColor;
        int background;

        protected TabBuilder() {
        }

        public TabBuilder setTabName(String tabName) {
            this.tabName = tabName;
            return this;
        }

        public TabBuilder setTextSize(int textSize) {
            this.textSize = textSize;
            return this;
        }

        public TabBuilder setTextColor(int textColor) {
            this.textColor = textColor;
            return this;
        }

        public TabBuilder setBackground(int background) {
            this.background = background;
            return this;
        }

        public TextView build() {
            TextView tab = (TextView)LayoutInflater.from((Context)TabModeWidget.this.getContext()).inflate(R.layout.uxsdk_widget_tab_item, null);
            tab.setText((CharSequence)this.tabName);
            tab.setTextColor(this.textColor);
            tab.setBackgroundColor(this.background);
            return tab;
        }
    }

    public static interface OnTabChangeListener {
        public void onTabChanged(int var1, int var2);
    }
}

