/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.accessory;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import dji.sdk.keyvalue.value.rtkbasestation.RTKStationConnetState;
import dji.sdk.keyvalue.value.rtkbasestation.RTKStationInfo;
import dji.v5.manager.aircraft.rtk.RTKCenter;
import dji.v5.manager.aircraft.rtk.station.ConnectedRTKStationInfo;
import dji.v5.manager.interfaces.IRTKCenter;
import dji.v5.utils.common.LogUtils;
import dji.v5.utils.common.StringUtils;
import dji.v5.ux.R;
import dji.v5.ux.accessory.RTKStationConnectWidgetModel;
import dji.v5.ux.accessory.data.DJIRTKBaseStationConnectInfo;
import dji.v5.ux.accessory.data.RtkStationScanAdapter;
import dji.v5.ux.accessory.item.RtkGuidanceView;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B'\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010.\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u00100\u001a\u00020/H\u0014J\b\u00101\u001a\u00020/H\u0002J\b\u00102\u001a\u00020/H\u0014J\u0012\u00103\u001a\u00020/2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\b\u00106\u001a\u00020/H\u0014J\n\u00107\u001a\u0004\u0018\u000108H\u0016J\u0010\u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020\u0002H\u0002J\u0018\u0010;\u001a\u00020/2\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010=H\u0002J\u0012\u0010>\u001a\u00020/2\b\u0010?\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010@\u001a\u00020\u00022\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010=H\u0002J\u001a\u0010C\u001a\u00020/2\b\u0010D\u001a\u0004\u0018\u0001052\u0006\u0010E\u001a\u00020\nH\u0016J\u0016\u0010F\u001a\u00020/*\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010G\u001a\u00020/2\u0006\u0010B\u001a\u00020\u0011H\u0002J\b\u0010H\u001a\u00020/H\u0002J\b\u0010I\u001a\u00020/H\u0002J\b\u0010J\u001a\u00020\u0002H\u0002J\u0012\u0010K\u001a\u00020/2\b\u0010L\u001a\u0004\u0018\u00010#H\u0002J\u0012\u0010M\u001a\u00020/2\b\u0010N\u001a\u0004\u0018\u00010OH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b*\u0010+R\u000e\u0010B\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Ldji/v5/ux/accessory/RTKStationConnectWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "", "Ldji/v5/ux/accessory/data/RtkStationScanAdapter$OnItemClickListener;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "rtkStationScanAdapter", "Ldji/v5/ux/accessory/data/RtkStationScanAdapter;", "stationList", "Ljava/util/ArrayList;", "Ldji/v5/ux/accessory/data/DJIRTKBaseStationConnectInfo;", "Lkotlin/collections/ArrayList;", "searchBt", "Landroid/widget/Button;", "checkReasonTv", "Landroid/widget/TextView;", "searchIv", "Landroid/widget/ImageView;", "stationListView", "Landroidx/recyclerview/widget/RecyclerView;", "stationScanningView", "Landroidx/constraintlayout/widget/ConstraintLayout;", "stationHasNotFoundView", "connectState", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKStationConnetState;", "scanHandler", "Landroid/os/Handler;", "scanTimeOutDisposable", "Lio/reactivex/rxjava3/disposables/Disposable;", "isMotorOn", "firstEnter", "SCAN_TIME_OUT", "", "widgetModel", "Ldji/v5/ux/accessory/RTKStationConnectWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/accessory/RTKStationConnectWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "initView", "", "onAttachedToWindow", "initCheckReasonContent", "onDetachedFromWindow", "onClick", "v", "Landroid/view/View;", "reactToModelChanges", "getIdealDimensionRatioString", "", "updateRefreshUI", "boolean", "handleStationRTKList", "list", "", "updateConnectStatus", "rtkBaseStationConnectState", "checkNeedUpdateUI", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKStationInfo;", "selectedRTKStationConnectInfo", "onItemClick", "view", "position", "refresh", "startConnectStation", "startScanning", "scanTimeOut", "isHasFoundRTK", "disposeTimeout", "timeOutDisposable", "handleReconnectedStationInfo", "infoConnected", "Ldji/v5/manager/aircraft/rtk/station/ConnectedRTKStationInfo;", "android-sdk-v5-uxsdk_release"})
public final class RTKStationConnectWidget
extends ConstraintLayoutWidget<Boolean>
implements RtkStationScanAdapter.OnItemClickListener,
View.OnClickListener {
    @NotNull
    private RtkStationScanAdapter rtkStationScanAdapter;
    @NotNull
    private final ArrayList<DJIRTKBaseStationConnectInfo> stationList;
    @NotNull
    private final Button searchBt;
    @NotNull
    private final TextView checkReasonTv;
    @NotNull
    private final ImageView searchIv;
    @NotNull
    private final RecyclerView stationListView;
    @NotNull
    private final ConstraintLayout stationScanningView;
    @NotNull
    private final ConstraintLayout stationHasNotFoundView;
    @NotNull
    private RTKStationConnetState connectState;
    @NotNull
    private final Handler scanHandler;
    @Nullable
    private Disposable scanTimeOutDisposable;
    private boolean isMotorOn;
    private boolean firstEnter;
    private final double SCAN_TIME_OUT;
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private DJIRTKBaseStationConnectInfo selectedRTKStationConnectInfo;

    @JvmOverloads
    public RTKStationConnectWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.stationList = new ArrayList();
        View view = this.findViewById(R.id.bt_rtk_signal_search_again);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.searchBt = (Button)view;
        View view2 = this.findViewById(R.id.tv_rtk_signal_problem_checked_reason);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.checkReasonTv = (TextView)view2;
        View view3 = this.findViewById(R.id.iv_rtk_signal_search_iv);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.searchIv = (ImageView)view3;
        View view4 = this.findViewById(R.id.rl_rtk_signal_searching_list);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        this.stationListView = (RecyclerView)view4;
        View view5 = this.findViewById(R.id.cl_rtk_has_found);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
        this.stationScanningView = (ConstraintLayout)view5;
        View view6 = this.findViewById(R.id.cl_rtk_not_found);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
        this.stationHasNotFoundView = (ConstraintLayout)view6;
        this.connectState = RTKStationConnetState.UNKNOWN;
        this.scanHandler = new Handler(Looper.getMainLooper());
        this.SCAN_TIME_OUT = 5.0;
        this.widgetModel$delegate = LazyKt.lazy(RTKStationConnectWidget::widgetModel_delegate$lambda$0);
        LinearLayoutManager layoutManager3 = new LinearLayoutManager(this.getContext(), 1, false);
        this.stationListView.setLayoutManager((RecyclerView.LayoutManager)layoutManager3);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        this.rtkStationScanAdapter = new RtkStationScanAdapter(context2, (List<DJIRTKBaseStationConnectInfo>)this.stationList);
        this.stationListView.setAdapter((RecyclerView.Adapter)this.rtkStationScanAdapter);
        this.searchBt.setOnClickListener((View.OnClickListener)this);
        this.searchIv.setOnClickListener((View.OnClickListener)this);
        this.rtkStationScanAdapter.setOnItemClickListener(this);
        this.initCheckReasonContent();
        this.selectedRTKStationConnectInfo = new DJIRTKBaseStationConnectInfo();
    }

    public /* synthetic */ RTKStationConnectWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final RTKStationConnectWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (RTKStationConnectWidgetModel)lazy.getValue();
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConstraintLayout.inflate((Context)context, (int)R.layout.uxsdk_widget_rtk_connect_status_layout, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
        this.firstEnter = true;
    }

    private final void initCheckReasonContent() {
        String string2 = StringUtils.getResStr((int)R.string.uxsdk_rtk_base_station_not_found_reason, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getResStr(...)");
        String reason = string2;
        String string3 = StringUtils.getResStr((int)R.string.uxsdk_rtk_connect_description, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getResStr(...)");
        String description = string3;
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        spannableStringBuilder.append((CharSequence)reason).append((CharSequence)" ").append((CharSequence)description);
        ClickableSpan clickableSpan2 = new ClickableSpan(this){
            final /* synthetic */ RTKStationConnectWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClick(View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                RtkGuidanceView guidanceView = new RtkGuidanceView(this.this$0.getContext());
                guidanceView.showPopupWindow(view);
            }

            public void updateDrawState(TextPaint ds) {
                Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                ds.setUnderlineText(false);
            }
        };
        spannableStringBuilder.setSpan((Object)clickableSpan2, reason.length(), spannableStringBuilder.length(), 33);
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(this.getResources().getColor(R.color.uxsdk_blue_highlight));
        spannableStringBuilder.setSpan((Object)foregroundColorSpan, reason.length() + 1, spannableStringBuilder.length(), 33);
        this.checkReasonTv.setMovementMethod(LinkMovementMethod.getInstance());
        this.checkReasonTv.setText((CharSequence)spannableStringBuilder);
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    public void onClick(@Nullable View v) {
        block3: {
            block2: {
                Integer n;
                View view = v;
                Integer n2 = n = view != null ? Integer.valueOf(view.getId()) : null;
                int n3 = R.id.iv_rtk_signal_search_iv;
                if (n2 != null && n2 == n3) break block2;
                Integer n4 = n;
                n3 = R.id.bt_rtk_signal_search_again;
                if (n4 == null || n4 != n3) break block3;
            }
            this.startScanning();
        }
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getConnectedRTKStationInfo().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ RTKStationConnectWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(ConnectedRTKStationInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RTKStationConnectWidget.access$handleReconnectedStationInfo(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().isMotorOn().subscribe(new Consumer(this){
            final /* synthetic */ RTKStationConnectWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RTKStationConnectWidget.access$setMotorOn$p(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.getWidgetModel().getStationConnectStatus().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ RTKStationConnectWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(RTKStationConnetState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RTKStationConnectWidget.access$updateConnectStatus(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
        Disposable disposable4 = this.getWidgetModel().getStationList().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ RTKStationConnectWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(ArrayList<DJIRTKBaseStationConnectInfo> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                RTKStationConnectWidget.access$handleStationRTKList(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable4, (String)"subscribe(...)");
        this.addReaction(disposable4);
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return ViewExtensions.getString((View)this, R.string.uxsdk_widget_rtk_keep_status_ratio, new Object[0]);
    }

    private final void updateRefreshUI(boolean bl) {
        this.searchBt.setClickable(bl);
        this.searchBt.setBackgroundResource(bl ? R.drawable.uxsdk_bg_white_radius : R.drawable.uxsdk_bg_gray_radius);
        this.searchIv.setVisibility(bl ? this.getVisibility() : 8);
    }

    private final void handleStationRTKList(List<DJIRTKBaseStationConnectInfo> list) {
        if (this.checkNeedUpdateUI(list)) {
            this.stationList.clear();
            Object[] objectArray = new Object[]{"has found rtk\uff0cclear stationList"};
            LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray);
            List<DJIRTKBaseStationConnectInfo> list2 = list;
            if (list2 != null) {
                List<DJIRTKBaseStationConnectInfo> it = list2;
                boolean bl = false;
                for (DJIRTKBaseStationConnectInfo i : it) {
                    Object[] objectArray2 = new Object[]{"stationName=" + i.getRtkStationName() + ",signalLevel=" + i.getSignalLevel()};
                    LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray2);
                    this.stationList.add(i);
                }
            }
            this.searchIv.setImageResource(R.drawable.uxsdk_ic_refresh);
            this.rtkStationScanAdapter.notifyDataSetChanged();
        }
    }

    private final void updateConnectStatus(RTKStationConnetState rtkBaseStationConnectState) {
        if (rtkBaseStationConnectState == null) {
            return;
        }
        Object[] objectArray = new Object[]{"Current station status is " + (RTKStationConnetState)rtkBaseStationConnectState};
        LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray);
        objectArray = rtkBaseStationConnectState;
        switch (WhenMappings.$EnumSwitchMapping$0[objectArray.ordinal()]) {
            case 1: 
            case 2: {
                if (this.firstEnter) {
                    Object[] objectArray2 = new Object[]{"first enter\uff0cstartScanning auto"};
                    LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray2);
                    this.firstEnter = false;
                    this.updateConnectStatus(RTKStationConnetState.SCANNING);
                    this.scanHandler.postDelayed(() -> RTKStationConnectWidget.updateConnectStatus$lambda$2(this), 2000L);
                    break;
                }
                this.searchIv.setImageResource(R.drawable.uxsdk_ic_refresh);
                break;
            }
            case 3: {
                ViewExtensions.hide((View)this.stationHasNotFoundView);
                ViewExtensions.show((View)this.stationScanningView);
                this.searchIv.setImageResource(R.drawable.uxsdk_ic_refresh);
                Toast.makeText((Context)this.getContext(), (CharSequence)"Station has disconnected", (int)0).show();
                break;
            }
            case 4: {
                ViewExtensions.hide((View)this.stationHasNotFoundView);
                ViewExtensions.show((View)this.stationScanningView);
                this.searchIv.setImageResource(R.drawable.uxsdk_rotate_progress_circle);
                Object[] objectArray3 = new Object[]{"scan rtk ing..."};
                LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray3);
                break;
            }
            case 5: {
                Object[] objectArray4 = new Object[]{"rtk has connected"};
                LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray4);
                ViewExtensions.hide((View)this.stationHasNotFoundView);
                ViewExtensions.show((View)this.stationScanningView);
                this.searchIv.setImageResource(R.drawable.uxsdk_ic_refresh);
                if (this.stationList.remove((Object)this.selectedRTKStationConnectInfo)) {
                    this.stationList.add(0, this.selectedRTKStationConnectInfo);
                }
                this.rtkStationScanAdapter.notifyDataSetChanged();
                break;
            }
            default: {
                ViewExtensions.hide((View)this.stationHasNotFoundView);
                ViewExtensions.show((View)this.stationScanningView);
                this.searchIv.setImageResource(R.drawable.uxsdk_ic_refresh);
            }
        }
        this.connectState = rtkBaseStationConnectState;
        this.refresh(this.selectedRTKStationConnectInfo, (RTKStationConnetState)rtkBaseStationConnectState);
        this.updateRefreshUI(!this.isMotorOn);
    }

    private final boolean checkNeedUpdateUI(List<? extends RTKStationInfo> list) {
        List<? extends RTKStationInfo> list2 = list;
        if (!(list2 != null ? list2.size() == this.stationList.size() : false)) {
            return true;
        }
        return !((Collection)this.stationList).containsAll((Collection)list) || !list.containsAll((Collection)this.stationList);
    }

    @Override
    public void onItemClick(@Nullable View view, int position) {
        this.selectedRTKStationConnectInfo = this.stationList.get(position);
        Object object = new Object[]{"click and connecting rtk:" + this.selectedRTKStationConnectInfo};
        LogUtils.i((String)"RTKStationConnectWidget", (Object[])object);
        Iterator<DJIRTKBaseStationConnectInfo> iterator = this.stationList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            DJIRTKBaseStationConnectInfo stationInfo = (DJIRTKBaseStationConnectInfo)((Object)e);
            stationInfo.setConnectStatus(RTKStationConnetState.IDLE);
        }
        this.refresh(this.selectedRTKStationConnectInfo, RTKStationConnetState.CONNECTING);
        this.startConnectStation(this.selectedRTKStationConnectInfo);
    }

    private final void refresh(DJIRTKBaseStationConnectInfo $this$refresh, RTKStationConnetState connectState) {
        RTKStationConnetState rTKStationConnetState = connectState;
        if (rTKStationConnetState != null) {
            RTKStationConnetState it = rTKStationConnetState;
            boolean bl = false;
            Object[] objectArray = new Object[]{"connectState=" + connectState};
            LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray);
            $this$refresh.setConnectStatus(it);
        }
        this.rtkStationScanAdapter.notifyDataSetChanged();
    }

    private final void startConnectStation(DJIRTKBaseStationConnectInfo selectedRTKStationConnectInfo) {
        DJIRTKBaseStationConnectInfo $this$startConnectStation_u24lambda_u244 = selectedRTKStationConnectInfo;
        boolean bl = false;
        Disposable disposable = this.getWidgetModel().startConnectToRTKStation($this$startConnectStation_u24lambda_u244.getBaseStationId()).observeOn(SchedulerProvider.ui()).subscribe(new Consumer($this$startConnectStation_u24lambda_u244){
            final /* synthetic */ DJIRTKBaseStationConnectInfo $this_run;
            {
                this.$this_run = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = new Object[]{this.$this_run.getRtkStationName() + " connect success"};
                LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray);
            }
        }, new Consumer(this, selectedRTKStationConnectInfo){
            final /* synthetic */ RTKStationConnectWidget this$0;
            final /* synthetic */ DJIRTKBaseStationConnectInfo $selectedRTKStationConnectInfo;
            {
                this.this$0 = $receiver;
                this.$selectedRTKStationConnectInfo = $selectedRTKStationConnectInfo;
            }

            public final void accept(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RTKStationConnectWidget.access$refresh(this.this$0, this.$selectedRTKStationConnectInfo, RTKStationConnetState.IDLE);
                Toast.makeText((Context)this.this$0.getContext(), (CharSequence)StringUtils.getResStr((int)R.string.uxsdk_rtk_base_station_connect_fail, (Object[])new Object[0]), (int)0).show();
                Object[] objectArray = new Object[]{this.$selectedRTKStationConnectInfo.getRtkStationName() + "connect fail\uff01\uff01\uff01"};
                LogUtils.e((String)"RTKStationConnectWidget", (Object[])objectArray);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
    }

    private final void startScanning() {
        Object[] objectArray = new Object[]{"startScanning now"};
        LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray);
        this.scanTimeOut();
        this.stationList.clear();
        this.rtkStationScanAdapter.notifyDataSetChanged();
        Disposable disposable = this.getWidgetModel().startSearchStationRTK().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ RTKStationConnectWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ViewExtensions.hide((View)RTKStationConnectWidget.access$getStationHasNotFoundView$p(this.this$0));
                ViewExtensions.show((View)RTKStationConnectWidget.access$getStationScanningView$p(this.this$0));
            }
        }, new Consumer(this){
            final /* synthetic */ RTKStationConnectWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ViewExtensions.show((View)RTKStationConnectWidget.access$getStationHasNotFoundView$p(this.this$0));
                ViewExtensions.hide((View)RTKStationConnectWidget.access$getStationScanningView$p(this.this$0));
                Toast.makeText((Context)this.this$0.getContext(), (CharSequence)StringUtils.getResStr((int)R.string.uxsdk_rtk_base_station_search_false_and_try_again, (Object[])new Object[0]), (int)0).show();
                Object[] objectArray = new Object[]{"startSearchStationRTK fail:" + it.getLocalizedMessage()};
                LogUtils.e((String)"RTKStationConnectWidget", (Object[])objectArray);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
        this.updateConnectStatus(RTKStationConnetState.SCANNING);
    }

    private final void scanTimeOut() {
        block1: {
            this.disposeTimeout(this.scanTimeOutDisposable);
            Disposable disposable = this.scanTimeOutDisposable = Observable.timer((long)((long)this.SCAN_TIME_OUT), (TimeUnit)TimeUnit.SECONDS).observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
                final /* synthetic */ RTKStationConnectWidget this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(Long it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (!RTKStationConnectWidget.access$isHasFoundRTK(this.this$0)) {
                        Object[] objectArray = new Object[]{"scanTimeOut ,stop search station RTK"};
                        LogUtils.e((String)"RTKStationConnectWidget", (Object[])objectArray);
                        ViewExtensions.show((View)RTKStationConnectWidget.access$getStationHasNotFoundView$p(this.this$0));
                        ViewExtensions.hide((View)RTKStationConnectWidget.access$getStationScanningView$p(this.this$0));
                        RTKStationConnectWidget.access$getWidgetModel(this.this$0).stopSearchStationRTK();
                        RTKStationConnectWidget.access$updateConnectStatus(this.this$0, RTKStationConnetState.IDLE);
                    } else {
                        Object[] objectArray = new Object[]{"scan finish\uff0chas found rtk"};
                        LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray);
                        ViewExtensions.hide((View)RTKStationConnectWidget.access$getStationHasNotFoundView$p(this.this$0));
                        ViewExtensions.show((View)RTKStationConnectWidget.access$getStationScanningView$p(this.this$0));
                        RTKStationConnectWidget.access$getWidgetModel(this.this$0).stopSearchStationRTK();
                        RTKStationConnectWidget.access$getSearchIv$p(this.this$0).setImageResource(R.drawable.uxsdk_ic_refresh);
                    }
                }
            }, new Consumer(this){
                final /* synthetic */ RTKStationConnectWidget this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object[] objectArray = new Object[]{it.getLocalizedMessage()};
                    LogUtils.e((String)"RTKStationConnectWidget", (Object[])objectArray);
                    RTKStationConnectWidget.access$disposeTimeout(this.this$0, RTKStationConnectWidget.access$getScanTimeOutDisposable$p(this.this$0));
                }
            });
            if (disposable == null) break block1;
            Disposable it = disposable;
            boolean bl = false;
            if (!it.isDisposed()) {
                this.addDisposable(it);
            }
        }
    }

    private final boolean isHasFoundRTK() {
        return this.connectState == RTKStationConnetState.CONNECTED || this.connectState == RTKStationConnetState.CONNECTING || !((Collection)this.stationList).isEmpty();
    }

    private final void disposeTimeout(Disposable timeOutDisposable) {
        block1: {
            Disposable disposable = timeOutDisposable;
            if (disposable == null) break block1;
            Disposable it = disposable;
            boolean bl = false;
            if (!it.isDisposed()) {
                it.dispose();
            }
        }
    }

    private final void handleReconnectedStationInfo(ConnectedRTKStationInfo infoConnected) {
        block1: {
            ConnectedRTKStationInfo connectedRTKStationInfo = infoConnected;
            if (connectedRTKStationInfo == null) break block1;
            ConnectedRTKStationInfo $this$handleReconnectedStationInfo_u24lambda_u247 = connectedRTKStationInfo;
            boolean bl = false;
            if (this.selectedRTKStationConnectInfo.getBaseStationId() == 0) {
                Object[] objectArray = new Object[]{"RTK Station has reconnected and remove scanHandler message"};
                LogUtils.i((String)"RTKStationConnectWidget", (Object[])objectArray);
                Integer n = $this$handleReconnectedStationInfo_u24lambda_u247.getStationId();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getStationId(...)");
                int n2 = ((Number)n).intValue();
                Integer n3 = $this$handleReconnectedStationInfo_u24lambda_u247.getSignalLevel();
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getSignalLevel(...)");
                int n4 = ((Number)n3).intValue();
                String string2 = $this$handleReconnectedStationInfo_u24lambda_u247.getStationName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStationName(...)");
                this.selectedRTKStationConnectInfo = new DJIRTKBaseStationConnectInfo(n2, n4, string2, RTKStationConnetState.CONNECTED);
                this.scanHandler.removeCallbacksAndMessages(null);
                this.updateConnectStatus(RTKStationConnetState.CONNECTED);
                objectArray = new DJIRTKBaseStationConnectInfo[]{this.selectedRTKStationConnectInfo};
                this.handleStationRTKList(CollectionsKt.arrayListOf((Object[])objectArray));
            }
        }
    }

    @JvmOverloads
    public RTKStationConnectWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RTKStationConnectWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final RTKStationConnectWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        IRTKCenter iRTKCenter = RTKCenter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)iRTKCenter, (String)"getInstance(...)");
        return new RTKStationConnectWidgetModel(dJISDKModel, observableInMemoryKeyedStore, iRTKCenter);
    }

    private static final void updateConnectStatus$lambda$2(RTKStationConnectWidget this$0) {
        this$0.startScanning();
    }

    public static final /* synthetic */ void access$handleReconnectedStationInfo(RTKStationConnectWidget $this, ConnectedRTKStationInfo infoConnected) {
        $this.handleReconnectedStationInfo(infoConnected);
    }

    public static final /* synthetic */ void access$setMotorOn$p(RTKStationConnectWidget $this, boolean bl) {
        $this.isMotorOn = bl;
    }

    public static final /* synthetic */ void access$updateConnectStatus(RTKStationConnectWidget $this, RTKStationConnetState rtkBaseStationConnectState) {
        $this.updateConnectStatus(rtkBaseStationConnectState);
    }

    public static final /* synthetic */ void access$handleStationRTKList(RTKStationConnectWidget $this, List list) {
        $this.handleStationRTKList(list);
    }

    public static final /* synthetic */ ConstraintLayout access$getStationHasNotFoundView$p(RTKStationConnectWidget $this) {
        return $this.stationHasNotFoundView;
    }

    public static final /* synthetic */ ConstraintLayout access$getStationScanningView$p(RTKStationConnectWidget $this) {
        return $this.stationScanningView;
    }

    public static final /* synthetic */ boolean access$isHasFoundRTK(RTKStationConnectWidget $this) {
        return $this.isHasFoundRTK();
    }

    public static final /* synthetic */ RTKStationConnectWidgetModel access$getWidgetModel(RTKStationConnectWidget $this) {
        return $this.getWidgetModel();
    }

    public static final /* synthetic */ ImageView access$getSearchIv$p(RTKStationConnectWidget $this) {
        return $this.searchIv;
    }

    public static final /* synthetic */ void access$disposeTimeout(RTKStationConnectWidget $this, Disposable timeOutDisposable) {
        $this.disposeTimeout(timeOutDisposable);
    }

    public static final /* synthetic */ Disposable access$getScanTimeOutDisposable$p(RTKStationConnectWidget $this) {
        return $this.scanTimeOutDisposable;
    }

    public static final /* synthetic */ void access$refresh(RTKStationConnectWidget $this, DJIRTKBaseStationConnectInfo $receiver, RTKStationConnetState connectState) {
        $this.refresh($receiver, connectState);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RTKStationConnetState.values().length];
            try {
                nArray[RTKStationConnetState.IDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKStationConnetState.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKStationConnetState.DISCONNECTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKStationConnetState.SCANNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKStationConnetState.CONNECTED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

