/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd.frequency;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.airlink.Bandwidth;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.sdk.keyvalue.value.airlink.FrequencyInterferenceInfo;
import dji.sdk.keyvalue.value.airlink.SDRHdOffsetParams;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.hd.frequency.FreqRangeRectViewModel;
import java.util.List;
import java.util.Locale;

public class FreqRangeRectView
extends ConstraintLayoutWidget<Object>
implements View.OnTouchListener {
    private static final String TAG = FreqRangeRectView.class.getSimpleName();
    private ImageView mCenterDown;
    private ImageView mCenterUp;
    private ProgressBar mAveragePgb;
    private boolean mIsDragging = false;
    private float mRangeRectTouchX = 0.0f;
    private int mNumNfValues = Integer.MAX_VALUE;
    private float mNfStartIndex = 2400.5f;
    private int mRangeSize = 5;
    private float mWidthInterval = Float.MAX_VALUE;
    private Integer mCurNfIndex = Integer.MAX_VALUE;
    private float mLeftNfIndex = Float.MAX_VALUE;
    private int mLastNfIndex2dot4G = Integer.MIN_VALUE;
    private float mCurCenterX = Float.MAX_VALUE;
    private int mParentWidth = Integer.MAX_VALUE;
    private FrequencyBand mCurBandChannelMode = FrequencyBand.UNKNOWN;
    private ChannelSelectionMode mCurChannelMode = ChannelSelectionMode.AUTO;
    private List<FrequencyInterferenceInfo> mRssis;
    private OnRangeChangedListener mListener;
    private Drawable mNormalBg;
    private Drawable mHoverBg;
    private float mRectX = -1.0f;
    private float mUnusedRectX = -1.0f;
    private float mAlpha = 1.0f;
    private float mLeftX;
    private float mRightX;
    private Handler mSkipPointHandler;
    FreqRangeRectViewModel widgetModel = new FreqRangeRectViewModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    private Bandwidth mBandwidth;
    private Integer[] mValidRanges;
    private SDRHdOffsetParams mOffsetParams;

    public FreqRangeRectView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSkipPointHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getFrequencyPointIndex().subscribe(value -> {
            this.mCurNfIndex = value;
            this.updatePosition();
        }));
        this.addReaction(this.widgetModel.getChannelSelectionMode().subscribe(value -> {
            this.mCurChannelMode = value;
            this.updateAllView();
        }));
        this.addReaction(this.widgetModel.getBandwidth().subscribe(value -> {
            this.mBandwidth = value;
            this.updateAllView();
        }));
        this.addReaction(this.widgetModel.getFrequencyPointRSSIInfo().subscribe(value -> {
            this.mRssis = value;
            this.updateAverageValue();
        }));
        this.addReaction(this.widgetModel.getFrequencyPointIndexRange().subscribe(value -> {
            this.mValidRanges = new Integer[2];
            this.mValidRanges[0] = value.getMin();
            this.mValidRanges[1] = value.getMax();
            this.onValidRangeChanged();
        }));
        this.addReaction(this.widgetModel.getSDRHdOffsetParams().subscribe(value -> {
            this.mOffsetParams = value;
        }));
        this.addReaction(this.widgetModel.getFrequencyBand().subscribe(value -> {
            this.mCurBandChannelMode = value;
            this.onDualBandModeChange();
            this.updateAllView();
        }));
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.isInEditMode()) {
            return;
        }
        this.mCenterDown = (ImageView)this.findViewById(R.id.sdr_snr_freq_range_center_down);
        this.mCenterUp = (ImageView)this.findViewById(R.id.sdr_snr_freq_range_center_up);
        this.mAveragePgb = (ProgressBar)this.findViewById(R.id.sdr_snr_freq_rect_pgb);
        this.mNormalBg = this.getResources().getDrawable(R.drawable.uxsdk_freq_range_rect);
        this.mHoverBg = this.getResources().getDrawable(R.drawable.uxsdk_freq_range_rect_hover);
        this.setOnTouchListener(this);
        this.mAlpha = this.getAlpha();
        super.setAlpha(0.0f);
        this.updateAllView();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    public FreqRangeRectView setParentWidth(int _width) {
        this.mParentWidth = _width;
        return this;
    }

    public FreqRangeRectView setNumValues(int _num) {
        this.mNumNfValues = _num;
        return this;
    }

    public FreqRangeRectView setWidthInterval(float _interval) {
        this.mWidthInterval = _interval;
        return this;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mCurChannelMode != ChannelSelectionMode.MANUAL) {
            return false;
        }
        if (event.getAction() == 0) {
            this.setParentInterceptTouchEvent(true);
            this.mRangeRectTouchX = event.getRawX();
            this.mIsDragging = true;
            this.updateRectBg(this.mIsDragging);
        } else if (event.getAction() == 2) {
            float curX = event.getRawX();
            float setX = v.getX() + curX - this.mRangeRectTouchX;
            if (setX < 0.0f) {
                setX = 0.0f;
            } else if (setX + (float)v.getWidth() > (float)this.mParentWidth) {
                setX = (float)this.mParentWidth - (float)v.getWidth();
            }
            v.setX(setX);
            this.mRangeRectTouchX = curX;
            this.mLeftNfIndex = this.convertX2Index(setX);
            this.onRangeChanged(this.mLeftNfIndex, this.mLeftNfIndex + (float)(this.mRangeSize * 2), setX, setX + (float)v.getWidth(), this.mIsDragging);
        } else if (event.getAction() == 1 || event.getAction() == 3) {
            this.mIsDragging = false;
            float curX = v.getX();
            if (curX % this.mWidthInterval != 0.0f) {
                float multiple = curX / this.mWidthInterval;
                float preMulX = multiple * this.mWidthInterval;
                float aftMulX = (multiple + 1.0f) * this.mWidthInterval;
                curX = curX - preMulX < aftMulX - curX || multiple + 1.0f >= (float)(this.mNumNfValues - 1) ? preMulX : aftMulX;
                v.setX(curX);
            }
            this.mLeftNfIndex = this.convertX2Index(curX);
            this.onRangeChanged(this.mLeftNfIndex, this.mLeftNfIndex + (float)(this.mRangeSize * 2), curX, curX + (float)v.getWidth(), this.mIsDragging);
            this.updateAverageValue();
            this.updateRectBg(this.mIsDragging);
            this.sendNfIndex2Sdr(curX);
            this.setParentInterceptTouchEvent(false);
        }
        return true;
    }

    public void setParentInterceptTouchEvent(boolean disallow) {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(disallow);
        }
    }

    private void sendNfIndex2Sdr(float leftX) {
        float centerX = leftX + (float)this.mRangeSize * this.mWidthInterval;
        float caculNf = this.convertX2Index(centerX);
        int sendNf = (int)caculNf;
        this.addDisposable(this.widgetModel.setFrequencyPointIndex(sendNf).subscribe(() -> {}, throwable -> LogUtils.e((String)TAG, (Object[])new Object[]{"setFrequencyPointIndex fail: " + throwable})));
    }

    public void setOnRangeChangedListener(OnRangeChangedListener l) {
        this.mListener = l;
    }

    public void onValidRangeChanged() {
        if (this.mBandwidth == null || this.mCurChannelMode == null || this.mParentWidth == Integer.MAX_VALUE || this.mValidRanges == null) {
            return;
        }
        float selectRange = 5.0f;
        if (this.mBandwidth == Bandwidth.BANDWIDTH_20MHZ) {
            selectRange = 10.0f;
        } else if (this.mBandwidth == Bandwidth.BANDWIDTH_40MHZ) {
            selectRange = 20.0f;
        }
        float left = this.mValidRanges[0].intValue();
        float right = this.mValidRanges[1].intValue();
        if (left != 2400.0f && left != 5470.0f) {
            left -= selectRange;
            right += selectRange;
        }
        this.mNumNfValues = (int)(right - left);
        this.mWidthInterval = (float)this.mParentWidth * 1.0f / (float)this.mNumNfValues;
        this.mNfStartIndex = left;
        if (null == this.mCurNfIndex || this.mCurNfIndex == Integer.MAX_VALUE) {
            return;
        }
        this.checkCurNfInRange(this.mCurNfIndex.intValue());
        this.updateAllView();
    }

    private void checkCurNfInRange(float curNfIndex) {
        if (this.mValidRanges == null) {
            return;
        }
        if (curNfIndex < (float)this.mValidRanges[0].intValue()) {
            this.addDisposable(this.widgetModel.setFrequencyPointIndex(this.mValidRanges[0]).subscribe(() -> {}, throwable -> LogUtils.e((String)TAG, (Object[])new Object[]{"setFrequencyPointIndex fail: " + throwable})));
        } else if (curNfIndex > (float)this.mValidRanges[1].intValue()) {
            this.addDisposable(this.widgetModel.setFrequencyPointIndex(this.mValidRanges[1]).subscribe(() -> {}, throwable -> LogUtils.e((String)TAG, (Object[])new Object[]{"setFrequencyPointIndex fail: " + throwable})));
        }
    }

    private void onDualBandModeChange() {
        if (this.mCurBandChannelMode == FrequencyBand.BAND_5_DOT_8G) {
            this.mLastNfIndex2dot4G = this.mCurNfIndex;
        } else if (this.mCurBandChannelMode == FrequencyBand.BAND_2_DOT_4G) {
            this.addDisposable(this.widgetModel.setFrequencyPointIndex(this.mLastNfIndex2dot4G).subscribe(() -> {}, throwable -> LogUtils.e((String)TAG, (Object[])new Object[]{"setFrequencyPointIndex fail: " + throwable})));
        }
        this.updateAllView();
    }

    private void updateAverageValue() {
        if (this.mRssis == null || (float)this.mCurNfIndex.intValue() == Float.MAX_VALUE) {
            return;
        }
        int rssiStartIndex = (int)((this.mLeftNfIndex - this.mNfStartIndex) / 2.0f);
        if (rssiStartIndex < 0) {
            rssiStartIndex = 0;
        }
        float averageVal = 0.0f;
        for (int i = rssiStartIndex; i < rssiStartIndex + this.mRangeSize && i < this.mRssis.size(); ++i) {
            averageVal += (float)this.mRssis.get(i).getRssi().intValue();
        }
        averageVal /= (float)this.mRangeSize;
        if (this.mOffsetParams != null) {
            averageVal += (float)((this.mOffsetParams.getRcLinkOffset().byteValue() > 0 ? this.mOffsetParams.getRcLinkOffset() : 0) + this.mOffsetParams.getPathLossOffset().byteValue() + this.mOffsetParams.getTxPowerOffset().byteValue());
        }
        this.mAveragePgb.setProgress((int)((averageVal - -110.0f) * 2.0f));
        if (this.mListener != null) {
            this.mListener.onAverageValChanged(String.format(Locale.US, "%.1f", Float.valueOf(averageVal)) + "dBm");
        }
    }

    private void updateAllView() {
        this.resizeRect();
        this.updatePosition();
        this.onChannelModeChanged();
    }

    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        this.mAlpha = alpha;
    }

    private void updatePosition() {
        if (this.mCurNfIndex == null || this.mCurNfIndex == Integer.MAX_VALUE) {
            return;
        }
        if (this.mWidthInterval == Float.MAX_VALUE) {
            return;
        }
        if (this.mIsDragging) {
            return;
        }
        Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("convertIndex: " + this.mCurNfIndex));
        this.mCurCenterX = ((float)this.mCurNfIndex.intValue() - this.mNfStartIndex) * this.mWidthInterval;
        if (this.getAlpha() != this.mAlpha) {
            super.setAlpha(this.mAlpha);
        }
        this.setRectBorder();
    }

    private void resizeRect() {
        if (this.mBandwidth == null) {
            return;
        }
        if (this.mBandwidth == Bandwidth.BANDWIDTH_10MHZ) {
            this.mRangeSize = 5;
        } else if (this.mBandwidth == Bandwidth.BANDWIDTH_20MHZ) {
            this.mRangeSize = 10;
        } else if (this.mBandwidth == Bandwidth.BANDWIDTH_40MHZ) {
            this.mRangeSize = 20;
        }
        this.setRectBorder();
    }

    private void setRectBorder() {
        if (this.mCurCenterX == Float.MAX_VALUE) {
            return;
        }
        this.mLeftNfIndex = (float)this.mCurNfIndex.intValue() - (float)this.mRangeSize;
        float leftX = Math.max(this.mCurCenterX - (float)this.mRangeSize * this.mWidthInterval, 0.0f);
        float rightX = this.mCurCenterX + (float)this.mRangeSize * this.mWidthInterval;
        this.onRangeChanged((float)this.mCurNfIndex.intValue() - (float)this.mRangeSize, (float)this.mCurNfIndex.intValue() + (float)this.mRangeSize, leftX, rightX, this.mIsDragging);
    }

    private void reDrawRectBorder(float leftX, float rightX) {
        if (this.mLeftX == leftX && this.mRightX == rightX) {
            return;
        }
        this.mLeftX = leftX;
        this.mRightX = rightX;
        this.setX(leftX);
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        lp.width = (int)(rightX - leftX);
        this.setLayoutParams(lp);
        this.updateAverageValue();
    }

    private void onRangeChanged(float leftVal, float rightVal, float leftPos, float rightPos, boolean isRectDragging) {
        this.mSkipPointHandler.removeCallbacksAndMessages(null);
        if (this.mRectX == -1.0f || Math.abs(leftVal - this.mRectX) <= 5.0f || this.mUnusedRectX != -1.0f && Math.abs(leftVal - this.mUnusedRectX) <= 5.0f) {
            this.mRectX = leftVal;
            if (this.mListener != null) {
                this.mListener.onRangeChanged(leftVal, rightVal, leftPos, rightPos, isRectDragging);
            }
            if (!this.mIsDragging) {
                this.reDrawRectBorder(leftPos, rightPos);
            }
        } else {
            this.mUnusedRectX = leftVal;
            this.mSkipPointHandler.postDelayed(() -> this.onRangeChanged(leftVal, rightVal, leftPos, rightPos, isRectDragging), 1000L);
        }
    }

    private float convertX2Index(float coordX) {
        float caculNf = coordX / this.mWidthInterval + this.mNfStartIndex;
        return (float)(Math.floor(caculNf) + 0.5);
    }

    private void onChannelModeChanged() {
        if (this.mCurChannelMode == null) {
            return;
        }
        if (this.mCurChannelMode == ChannelSelectionMode.AUTO) {
            this.mCenterDown.setVisibility(4);
            this.mCenterUp.setVisibility(4);
            this.mIsDragging = false;
            this.setBackground(this.mNormalBg);
        } else {
            this.mCenterDown.setVisibility(0);
            this.mCenterUp.setVisibility(0);
            this.setBackground(this.mHoverBg);
            this.postDelayed(() -> this.setBackground(this.mNormalBg), 200L);
        }
    }

    private void updateRectBg(boolean _isdragging) {
        if (_isdragging) {
            this.mAveragePgb.setVisibility(4);
            this.setBackground(this.mHoverBg);
        } else {
            this.mAveragePgb.setVisibility(0);
            this.setBackground(this.mNormalBg);
        }
    }

    public static interface OnRangeChangedListener {
        public void onRangeChanged(float var1, float var2, float var3, float var4, boolean var5);

        public void onAverageValChanged(String var1);
    }
}

