/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.remotecontroller.calibration;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.BaseView;

public class DJICalProgressBar
extends BaseView {
    private int mLineWidth = 2;
    private int mDividerWidth = 2;
    private int mFontSize = 12;
    private int orientation = 0;
    private int mBgColor = Color.parseColor((String)"#727272");
    private int mColor = Color.parseColor((String)"#00d8ff");
    private Paint mPaint;
    private int mLeft = 20;
    private int mRight = 70;
    private Paint mFontPaint;

    public DJICalProgressBar(Context context) {
        this(context, null);
    }

    public DJICalProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DJICalProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributeSet(context, attrs);
        this.init();
    }

    private void initAttributeSet(Context context, @Nullable AttributeSet attrs) {
        if (attrs == null) {
            this.orientation = 0;
            return;
        }
        TypedArray ar = context.obtainStyledAttributes(attrs, R.styleable.DJICalProgressBar);
        this.orientation = ar.getInt(R.styleable.DJICalProgressBar_uxsdk_orientation_sb, 0);
        ar.recycle();
    }

    @RequiresApi(api=21)
    public DJICalProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttributeSet(context, attrs);
        this.init();
    }

    private void init() {
        this.mFontSize = (int)this.getResources().getDimension(R.dimen.uxsdk_rc_cal_progress_font);
        this.mLineWidth = (int)this.getResources().getDimension(R.dimen.uxsdk_rc_cal_progress_line_width);
        this.mDividerWidth = (int)this.getResources().getDimension(R.dimen.uxsdk_rc_cal_progress_line_width);
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStrokeWidth(0.0f);
        this.mFontPaint = new Paint(1);
        this.mFontPaint.setStrokeWidth(0.0f);
        this.mFontPaint.setTextSize((float)this.mFontSize);
        this.mFontPaint.setColor(-1);
        this.mFontPaint.setTextAlign(Paint.Align.CENTER);
    }

    public void setValue(int left, int right) {
        this.mLeft = left;
        this.mRight = right;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int w = this.getWidth();
        int h = this.getHeight();
        this.mPaint.setColor(this.mBgColor);
        if (this.orientation == 1) {
            canvas.drawRect(new Rect((w - this.mLineWidth) / 2, 0, (w - this.mLineWidth) / 2 + this.mLineWidth, h), this.mPaint);
        } else {
            canvas.drawRect(new Rect(0, (h - this.mLineWidth) / 2, w, (h - this.mLineWidth) / 2 + this.mLineWidth), this.mPaint);
        }
        this.mPaint.setColor(this.mColor);
        if (this.orientation == 1) {
            canvas.drawRect(new Rect((w - this.mLineWidth) / 2, h / 2, (w - this.mLineWidth) / 2 + this.mLineWidth, h / 2 + h / 2 * this.mLeft / 100), this.mPaint);
            canvas.drawRect(new Rect((w - this.mLineWidth) / 2, h / 2 * (100 - this.mRight) / 100, (w - this.mLineWidth) / 2 + this.mLineWidth, h / 2), this.mPaint);
        } else {
            canvas.drawRect(new Rect(w / 2 * (100 - this.mLeft) / 100, (h - this.mLineWidth) / 2, w / 2, (h - this.mLineWidth) / 2 + this.mLineWidth), this.mPaint);
            canvas.drawRect(new Rect(w / 2, (h - this.mLineWidth) / 2, w / 2 + w / 2 * this.mRight / 100, (h - this.mLineWidth) / 2 + this.mLineWidth), this.mPaint);
        }
        this.mPaint.setColor(-1);
        if (this.orientation == 1) {
            canvas.drawRect(new Rect((w - this.mLineWidth) / 2, (h - this.mDividerWidth) / 2, (w - this.mLineWidth) / 2 + this.mLineWidth, (h - this.mDividerWidth) / 2 + this.mDividerWidth), this.mPaint);
        } else {
            canvas.drawRect(new Rect((w - this.mDividerWidth) / 2, (h - this.mLineWidth) / 2, (w - this.mDividerWidth) / 2 + this.mDividerWidth, (h - this.mLineWidth) / 2 + this.mLineWidth), this.mPaint);
        }
    }
}

