/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdateFactory;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.DJILatLngBounds;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import java.util.ArrayList;
import java.util.Locale;

public class MaplibreUtils {
    private static final float ZOOM_OFFSET = 2.0f;

    private MaplibreUtils() {
    }

    public static final LatLng fromDJILatLng(DJILatLng latLng) {
        return new LatLng(latLng.getLatitude(), latLng.getLongitude(), latLng.getAltitude());
    }

    public static final DJILatLng fromLatLng(LatLng latLng) {
        DJILatLng ll = new DJILatLng(latLng.getLatitude(), latLng.getLongitude(), latLng.getAltitude());
        return ll;
    }

    public static final CameraUpdate fromDJICameraUpdate(DJICameraUpdate cameraUpdate) {
        CameraUpdate u = CameraUpdateFactory.newLatLng((LatLng)new LatLng(0.0, 0.0));
        if (cameraUpdate instanceof DJICameraUpdateFactory.CameraBoundsUpdate) {
            DJILatLng southwest;
            DJICameraUpdateFactory.CameraBoundsUpdate boundsUpdate = (DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate;
            int padding = boundsUpdate.getPadding();
            int paddingLeft = boundsUpdate.getPaddingLeft();
            int paddingRight = boundsUpdate.getPaddingRight();
            int paddingBottom = boundsUpdate.getPaddingBottom();
            int paddingTop = boundsUpdate.getPaddingTop();
            LatLngBounds.Builder builder = new LatLngBounds.Builder();
            DJILatLngBounds bounds = boundsUpdate.getBounds();
            DJILatLng northeast = bounds.getNortheast();
            if (northeast.equals(southwest = bounds.getSouthwest())) {
                u = CameraUpdateFactory.newLatLng((LatLng)MaplibreUtils.fromDJILatLng(northeast));
            } else {
                builder.include(MaplibreUtils.fromDJILatLng(northeast)).include(MaplibreUtils.fromDJILatLng(southwest));
                u = CameraUpdateFactory.newLatLngBounds((LatLngBounds)builder.build(), (int)(paddingLeft + padding), (int)(paddingTop + padding), (int)(paddingRight + padding), (int)(paddingBottom + padding));
            }
        } else if (cameraUpdate instanceof DJICameraUpdateFactory.CameraPositionUpdate) {
            DJICameraUpdateFactory.CameraPositionUpdate positionUpdate = (DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate;
            LatLng target = MaplibreUtils.fromDJILatLng(positionUpdate.getTarget());
            CameraPosition p = new CameraPosition.Builder().target(target).zoom((double)(positionUpdate.getZoom() - 2.0f)).tilt((double)positionUpdate.getTilt()).bearing((double)positionUpdate.getBearing()).build();
            u = CameraUpdateFactory.newCameraPosition((CameraPosition)p);
        }
        return u;
    }

    public static final DJICameraPosition fromCameraPosition(CameraPosition cameraPosition) {
        DJICameraPosition.Builder builder = new DJICameraPosition.Builder();
        builder.target(MaplibreUtils.fromLatLng(cameraPosition.target)).zoom((float)cameraPosition.zoom + 2.0f).tilt((float)cameraPosition.tilt).bearing((float)cameraPosition.bearing);
        return builder.build();
    }

    public static final Icon fromDJIBitmapDescriptor(Context context, DJIBitmapDescriptor descriptor) {
        String path = descriptor.getPath();
        Icon icon = switch (descriptor.getType()) {
            case DJIBitmapDescriptor.Type.BITMAP -> IconFactory.getInstance((Context)context).fromBitmap(descriptor.getBitmap());
            case DJIBitmapDescriptor.Type.PATH_ABSOLUTE -> IconFactory.getInstance((Context)context).fromPath(path);
            case DJIBitmapDescriptor.Type.PATH_ASSET -> IconFactory.getInstance((Context)context).fromAsset(path);
            case DJIBitmapDescriptor.Type.PATH_FILEINPUT -> IconFactory.getInstance((Context)context).fromFile(path);
            case DJIBitmapDescriptor.Type.RESOURCE_ID -> IconFactory.getInstance((Context)context).fromResource(descriptor.getResourceId());
            default -> throw new AssertionError();
        };
        descriptor.updateBitmap(icon.getBitmap());
        return icon;
    }

    public static final PolygonOptions fromDJIPolygonOptions(DJIPolygonOptions options) {
        PolygonOptions result = new PolygonOptions();
        ArrayList<LatLng> points = new ArrayList<LatLng>();
        for (DJILatLng point : options.getPoints()) {
            points.add(MaplibreUtils.fromDJILatLng(point));
        }
        int fillColor = options.getFillColor();
        int rgbColor = Color.rgb((int)Color.red((int)fillColor), (int)Color.green((int)fillColor), (int)Color.blue((int)fillColor));
        float alpha = (float)Color.alpha((int)fillColor) * 1.0f / 255.0f;
        options.setAlpha(alpha);
        result.strokeColor(options.getStrokeColor()).alpha(alpha).fillColor(rgbColor).addAll(points);
        return result;
    }

    public static String getLanguageString(Context context) {
        String result;
        Configuration configuration = context.getResources().getConfiguration();
        Locale locale = Build.VERSION.SDK_INT >= 24 && !configuration.getLocales().isEmpty() ? configuration.getLocales().get(0) : configuration.locale;
        if (Build.VERSION.SDK_INT >= 21) {
            result = TextUtils.isEmpty((CharSequence)locale.getScript()) ? locale.getLanguage() : locale.getLanguage() + "-" + locale.getScript();
        } else {
            result = locale.getLanguage();
            if (Locale.CHINESE.getLanguage().equals(result)) {
                result = result + (Locale.SIMPLIFIED_CHINESE.getCountry().equals(locale.getCountry()) ? "-Hans" : "-Hant");
            }
        }
        return result;
    }

    public static Polygon getCircle(Point center, double radius) {
        double radiusInKilometers = radius / 1000.0;
        ArrayList<Point> positions = new ArrayList<Point>();
        double distanceX = radiusInKilometers / (111.319 * Math.cos(center.latitude() * Math.PI / 180.0));
        double distanceY = radiusInKilometers / 110.574;
        double slice = 0.09817477042468103;
        for (int i = 0; i < 64; ++i) {
            double theta = (double)i * slice;
            double x = distanceX * Math.cos(theta);
            double y = distanceY * Math.sin(theta);
            Point position = Point.fromLngLat((double)(center.longitude() + x), (double)(center.latitude() + y));
            positions.add(position);
        }
        ArrayList<ArrayList<Point>> circleList = new ArrayList<ArrayList<Point>>(1);
        circleList.add(positions);
        return Polygon.fromLngLats(circleList);
    }
}

