/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.autoexposurelock;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.autoexposurelock.AutoExposureLockWidgetModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.core.util.ViewUtil;

public class AutoExposureLockWidget
extends ConstraintLayoutWidget<Object>
implements View.OnClickListener,
ICameraIndex {
    private static final String TAG = "AutoExposureLockWidget";
    private ImageView foregroundImageView;
    private TextView titleTextView;
    private AutoExposureLockWidgetModel widgetModel;
    private Drawable autoExposureLockDrawable;
    private Drawable autoExposureUnlockDrawable;
    private ColorStateList lockDrawableTint;
    private ColorStateList unlockDrawableTint;

    public AutoExposureLockWidget(@NonNull Context context) {
        super(context);
    }

    public AutoExposureLockWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public AutoExposureLockWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        AutoExposureLockWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_auto_exposure_lock, (ViewGroup)this);
        if (this.getBackground() == null) {
            this.setBackgroundResource(R.drawable.uxsdk_background_black_rectangle);
        }
        this.foregroundImageView = (ImageView)this.findViewById(R.id.auto_exposure_lock_widget_foreground_image_view);
        this.titleTextView = (TextView)this.findViewById(R.id.auto_exposure_lock_widget_title_text_view);
        if (!this.isInEditMode()) {
            this.widgetModel = new AutoExposureLockWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        this.initDefaults();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
        this.setOnClickListener(this);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.isAutoExposureLockOn().observeOn(SchedulerProvider.ui()).subscribe(this::onAELockChange));
    }

    public void onClick(View v) {
        if (v == this) {
            this.setAutoExposureLock();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @MainThread
    private void onAELockChange(boolean isLocked) {
        if (isLocked) {
            this.foregroundImageView.setImageDrawable(this.autoExposureLockDrawable);
            if (this.lockDrawableTint != null) {
                ViewUtil.tintImage(this.foregroundImageView, this.lockDrawableTint);
            }
        } else {
            this.foregroundImageView.setImageDrawable(this.autoExposureUnlockDrawable);
            if (this.unlockDrawableTint != null) {
                ViewUtil.tintImage(this.foregroundImageView, this.unlockDrawableTint);
            }
        }
    }

    private void setAutoExposureLock() {
        this.addDisposable(this.widgetModel.toggleAutoExposureLock().observeOn(SchedulerProvider.ui()).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(TAG, "set auto exposure lock: ")));
    }

    private void checkAndUpdateAELock() {
        if (!this.isInEditMode()) {
            this.addDisposable(this.widgetModel.isAutoExposureLockOn().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(this::onAELockChange, UxErrorHandle.logErrorConsumer(TAG, "Update AE Lock ")));
        }
    }

    private void initDefaults() {
        this.autoExposureLockDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_auto_exposure_lock);
        this.autoExposureUnlockDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_auto_exposure_unlock);
        this.setTitleTextColor(this.getResources().getColorStateList(R.color.uxsdk_color_selector_auto_exposure_lock));
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        int textAppearance;
        int colorResource;
        ColorStateList colorStateList;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AutoExposureLockWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.AutoExposureLockWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.AutoExposureLockWidget_uxsdk_lensType, 0)));
        }
        if ((colorStateList = typedArray.getColorStateList(R.styleable.AutoExposureLockWidget_uxsdk_widgetTitleTextColor)) != null) {
            this.setTitleTextColor(colorStateList);
        }
        if ((colorResource = typedArray.getColor(R.styleable.AutoExposureLockWidget_uxsdk_widgetTitleTextColor, 0)) != 0) {
            this.setTitleTextColor(colorResource);
        }
        if ((colorStateList = typedArray.getColorStateList(R.styleable.AutoExposureLockWidget_uxsdk_autoExposureUnlockDrawableTint)) != null) {
            this.setAutoExposureUnlockIconTint(colorStateList);
        }
        if ((colorResource = typedArray.getColor(R.styleable.AutoExposureLockWidget_uxsdk_autoExposureUnlockDrawableTint, 0)) != 0) {
            this.setAutoExposureUnlockIconTint(colorResource);
        }
        if ((colorStateList = typedArray.getColorStateList(R.styleable.AutoExposureLockWidget_uxsdk_autoExposureLockDrawableTint)) != null) {
            this.setAutoExposureLockIconTint(colorStateList);
        }
        if ((colorResource = typedArray.getColor(R.styleable.AutoExposureLockWidget_uxsdk_autoExposureLockDrawableTint, 0)) != 0) {
            this.setAutoExposureLockIconTint(colorResource);
        }
        if ((textAppearance = typedArray.getResourceId(R.styleable.AutoExposureLockWidget_uxsdk_widgetTitleTextAppearance, -1)) != -1) {
            this.setTitleTextAppearance(textAppearance);
        }
        if (typedArray.getDrawable(R.styleable.AutoExposureLockWidget_uxsdk_autoExposureLockDrawable) != null) {
            this.autoExposureLockDrawable = typedArray.getDrawable(R.styleable.AutoExposureLockWidget_uxsdk_autoExposureLockDrawable);
        }
        if (typedArray.getDrawable(R.styleable.AutoExposureLockWidget_uxsdk_autoExposureUnlockDrawable) != null) {
            this.autoExposureUnlockDrawable = typedArray.getDrawable(R.styleable.AutoExposureLockWidget_uxsdk_autoExposureUnlockDrawable);
        }
        typedArray.recycle();
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_auto_exposure_lock_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    public void setAutoExposureLockIcon(@DrawableRes int resourceId) {
        this.setAutoExposureLockIcon(this.getResources().getDrawable(resourceId));
    }

    public void setAutoExposureLockIcon(@Nullable Drawable drawable2) {
        this.autoExposureLockDrawable = drawable2;
        this.checkAndUpdateAELock();
    }

    @Nullable
    public Drawable getAutoExposureLockDrawable() {
        return this.autoExposureLockDrawable;
    }

    public void setAutoExposureUnlockIcon(@DrawableRes int resourceId) {
        this.setAutoExposureUnlockIcon(this.getResources().getDrawable(resourceId));
    }

    public void setAutoExposureUnlockIcon(@Nullable Drawable drawable2) {
        this.autoExposureUnlockDrawable = drawable2;
        this.checkAndUpdateAELock();
    }

    @Nullable
    public Drawable getAutoExposureUnlockDrawable() {
        return this.autoExposureUnlockDrawable;
    }

    @Nullable
    public ColorStateList getTitleTextColors() {
        return this.titleTextView.getTextColors();
    }

    @ColorInt
    public int getTitleTextColor() {
        return this.titleTextView.getCurrentTextColor();
    }

    public void setTitleTextColor(@Nullable ColorStateList colorStateList) {
        this.titleTextView.setTextColor(colorStateList);
    }

    public void setTitleTextColor(@ColorInt int color2) {
        this.titleTextView.setTextColor(color2);
    }

    public void setTitleTextAppearance(@StyleRes int textAppearance) {
        this.titleTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @NonNull
    public Drawable getIconBackground() {
        return this.foregroundImageView.getBackground();
    }

    public void setIconBackground(@DrawableRes int resourceId) {
        this.setIconBackground(this.getResources().getDrawable(resourceId));
    }

    public void setIconBackground(@Nullable Drawable drawable2) {
        this.foregroundImageView.setBackground(drawable2);
    }

    @Nullable
    public Drawable getTitleBackground() {
        return this.titleTextView.getBackground();
    }

    public void setTitleBackground(@DrawableRes int resourceId) {
        this.setTitleBackground(this.getResources().getDrawable(resourceId));
    }

    public void setTitleBackground(@Nullable Drawable drawable2) {
        this.titleTextView.setBackground(drawable2);
    }

    public void setEnabled(boolean enabled) {
        this.titleTextView.setEnabled(enabled);
        this.foregroundImageView.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Nullable
    public ColorStateList getAutoExposureUnlockIconTint() {
        return this.unlockDrawableTint;
    }

    public void setAutoExposureUnlockIconTint(@ColorInt int color2) {
        this.setAutoExposureUnlockIconTint(ColorStateList.valueOf((int)color2));
    }

    public void setAutoExposureUnlockIconTint(@Nullable ColorStateList colorStateList) {
        this.unlockDrawableTint = colorStateList;
        this.checkAndUpdateAELock();
    }

    @Nullable
    public ColorStateList getAutoExposureLockIconTint() {
        return this.lockDrawableTint;
    }

    public void setAutoExposureLockIconTint(@ColorInt int color2) {
        this.setAutoExposureLockIconTint(ColorStateList.valueOf((int)color2));
    }

    public void setAutoExposureLockIconTint(@Nullable ColorStateList colorStateList) {
        this.lockDrawableTint = colorStateList;
        this.checkAndUpdateAELock();
    }
}

