/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.returnhome;

import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.flightcontroller.FCAutoRTHReason;
import dji.sdk.keyvalue.value.flightcontroller.FCFlightMode;
import dji.sdk.keyvalue.value.remotecontroller.RCMode;
import dji.v5.utils.common.LocationUtil;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u000245B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0014J\b\u0010+\u001a\u00020)H\u0014J\b\u0010,\u001a\u00020\fH\u0002J(\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u0002002\u0006\u00103\u001a\u000200H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00066"}, d2={"Ldji/v5/ux/flight/returnhome/ReturnHomeWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "preferencesManager", "Ldji/v5/ux/core/communication/GlobalPreferencesInterface;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/communication/GlobalPreferencesInterface;)V", "isGoingHomeDataProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "isFlyingDataProcessor", "isAutoLandingDataProcessor", "areMotorsOnDataProcessor", "returnHomeDataProcessor", "Ldji/v5/ux/flight/returnhome/ReturnHomeWidgetModel$ReturnHomeState;", "isCancelReturnToHomeDisabledProcessor", "rcModeDataProcessor", "Ldji/sdk/keyvalue/value/remotecontroller/RCMode;", "flightModeProcessor", "Ldji/sdk/keyvalue/value/flightcontroller/FCFlightMode;", "autoRTHReasonProcessor", "Ldji/sdk/keyvalue/value/flightcontroller/FCAutoRTHReason;", "unitTypeProcessor", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "returnHomeState", "Lio/reactivex/rxjava3/core/Flowable;", "getReturnHomeState", "()Lio/reactivex/rxjava3/core/Flowable;", "distanceToHome", "Ldji/v5/ux/flight/returnhome/ReturnHomeWidgetModel$ReturnHomeDistance;", "getDistanceToHome", "()Ldji/v5/ux/flight/returnhome/ReturnHomeWidgetModel$ReturnHomeDistance;", "isRTHAtCurrentAltitudeEnabled", "()Z", "performReturnHomeAction", "Lio/reactivex/rxjava3/core/Completable;", "performCancelReturnHomeAction", "inSetup", "", "inCleanup", "updateStates", "isCancelReturnHomeDisabled", "distanceBetween", "", "latitude1", "", "longitude1", "latitude2", "longitude2", "ReturnHomeState", "ReturnHomeDistance", "android-sdk-v5-uxsdk_release"})
public final class ReturnHomeWidgetModel
extends WidgetModel {
    @Nullable
    private final GlobalPreferencesInterface preferencesManager;
    @NotNull
    private final DataProcessor<Boolean> isGoingHomeDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> isFlyingDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> isAutoLandingDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> areMotorsOnDataProcessor;
    @NotNull
    private final DataProcessor<ReturnHomeState> returnHomeDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> isCancelReturnToHomeDisabledProcessor;
    @NotNull
    private final DataProcessor<RCMode> rcModeDataProcessor;
    @NotNull
    private final DataProcessor<FCFlightMode> flightModeProcessor;
    @NotNull
    private final DataProcessor<FCAutoRTHReason> autoRTHReasonProcessor;
    @NotNull
    private final DataProcessor<UnitConversionUtil.UnitType> unitTypeProcessor;

    public ReturnHomeWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.preferencesManager = preferencesManager;
        DataProcessor<Boolean> dataProcessor = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.isGoingHomeDataProcessor = dataProcessor;
        DataProcessor<Boolean> dataProcessor2 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.isFlyingDataProcessor = dataProcessor2;
        DataProcessor<Boolean> dataProcessor3 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.isAutoLandingDataProcessor = dataProcessor3;
        DataProcessor<Boolean> dataProcessor4 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.areMotorsOnDataProcessor = dataProcessor4;
        DataProcessor<ReturnHomeState> dataProcessor5 = DataProcessor.create(ReturnHomeState.DISCONNECTED);
        Intrinsics.checkNotNullExpressionValue(dataProcessor5, (String)"create(...)");
        this.returnHomeDataProcessor = dataProcessor5;
        DataProcessor<Boolean> dataProcessor6 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor6, (String)"create(...)");
        this.isCancelReturnToHomeDisabledProcessor = dataProcessor6;
        DataProcessor<RCMode> dataProcessor7 = DataProcessor.create(RCMode.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor7, (String)"create(...)");
        this.rcModeDataProcessor = dataProcessor7;
        DataProcessor<FCFlightMode> dataProcessor8 = DataProcessor.create(FCFlightMode.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor8, (String)"create(...)");
        this.flightModeProcessor = dataProcessor8;
        DataProcessor<FCAutoRTHReason> dataProcessor9 = DataProcessor.create(FCAutoRTHReason.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor9, (String)"create(...)");
        this.autoRTHReasonProcessor = dataProcessor9;
        DataProcessor<UnitConversionUtil.UnitType> dataProcessor10 = DataProcessor.create(UnitConversionUtil.UnitType.METRIC);
        Intrinsics.checkNotNullExpressionValue(dataProcessor10, (String)"create(...)");
        this.unitTypeProcessor = dataProcessor10;
        if (this.preferencesManager != null) {
            this.unitTypeProcessor.onNext(this.preferencesManager.getUnitType());
        }
    }

    @NotNull
    public final Flowable<ReturnHomeState> getReturnHomeState() {
        Flowable flowable = this.returnHomeDataProcessor.toFlowable().distinctUntilChanged();
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"distinctUntilChanged(...)");
        return flowable;
    }

    @NotNull
    public final ReturnHomeDistance getDistanceToHome() {
        DJIKey dJIKey = KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyGoHomeHeight);
        Intrinsics.checkNotNullExpressionValue((Object)dJIKey, (String)"createKey(...)");
        DJIKey goHomeHeightKey = dJIKey;
        DJIKey dJIKey2 = KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHomeLocation);
        Intrinsics.checkNotNullExpressionValue((Object)dJIKey2, (String)"createKey(...)");
        DJIKey homeLocationKey = dJIKey2;
        DJIKey dJIKey3 = KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAltitude);
        Intrinsics.checkNotNullExpressionValue((Object)dJIKey3, (String)"createKey(...)");
        DJIKey currentHeightKey = dJIKey3;
        DJIKey dJIKey4 = KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftLocation);
        Intrinsics.checkNotNullExpressionValue((Object)dJIKey4, (String)"createKey(...)");
        DJIKey aircraftLocationKey = dJIKey4;
        float currentHeight = 0.0f;
        float goHomeHeight = 0.0f;
        double homeLatitude = 0.0;
        homeLatitude = Double.NaN;
        double homeLongitude = 0.0;
        homeLongitude = Double.NaN;
        double aircraftLocationLat = 0.0;
        double aircraftLocationLong = 0.0;
        UnitConversionUtil.UnitType unitType = this.unitTypeProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
        UnitConversionUtil.UnitType unitType2 = unitType;
        Double d = (Double)this.djiSdkModel.getCacheValue(currentHeightKey);
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            currentHeight = (float)it;
        }
        Integer n = (Integer)this.djiSdkModel.getCacheValue(goHomeHeightKey);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            goHomeHeight = it;
        }
        LocationCoordinate2D locationCoordinate2D = (LocationCoordinate2D)this.djiSdkModel.getCacheValue(homeLocationKey);
        if (locationCoordinate2D != null) {
            LocationCoordinate2D it = locationCoordinate2D;
            boolean bl = false;
            homeLatitude = it.getLatitude();
            homeLongitude = it.getLongitude();
        }
        LocationCoordinate2D locationCoordinate2D2 = (LocationCoordinate2D)this.djiSdkModel.getCacheValue(aircraftLocationKey);
        if (locationCoordinate2D2 != null) {
            LocationCoordinate2D it = locationCoordinate2D2;
            boolean bl = false;
            aircraftLocationLat = it.getLatitude();
            aircraftLocationLong = it.getLongitude();
        }
        float distanceToHome = 0.0f;
        if (!Double.isNaN(homeLatitude) && !Double.isNaN(homeLongitude)) {
            distanceToHome = this.distanceBetween(homeLatitude, homeLongitude, aircraftLocationLat, aircraftLocationLong);
        }
        return new ReturnHomeDistance(distanceToHome, currentHeight, goHomeHeight, unitType2);
    }

    public final boolean isRTHAtCurrentAltitudeEnabled() {
        return true;
    }

    @NotNull
    public final Completable performReturnHomeAction() {
        Completable completable = this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStartGoHome));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"performActionWithOutResult(...)");
        return completable;
    }

    @NotNull
    public final Completable performCancelReturnHomeAction() {
        Completable completable = this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStopGoHome));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"performActionWithOutResult(...)");
        return completable;
    }

    @Override
    protected void inSetup() {
        block0: {
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIsFlying), this.isFlyingDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIsInLandingMode), this.isAutoLandingDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAreMotorsOn), this.areMotorsOnDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyFCFlightMode), this.flightModeProcessor, arg_0 -> ReturnHomeWidgetModel.inSetup$lambda$4(this, arg_0));
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAutoRTHReason), this.autoRTHReasonProcessor, arg_0 -> ReturnHomeWidgetModel.inSetup$lambda$5(this, arg_0));
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcMachineMode), this.rcModeDataProcessor);
            UXKey unitKey = UXKeys.create("UnitType");
            this.bindDataProcessor(unitKey, this.unitTypeProcessor);
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface == null) break block0;
            globalPreferencesInterface.setUpListener();
        }
    }

    @Override
    protected void inCleanup() {
        block0: {
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface == null) break block0;
            globalPreferencesInterface.cleanup();
        }
    }

    @Override
    protected void updateStates() {
        if (!((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            this.returnHomeDataProcessor.onNext(ReturnHomeState.DISCONNECTED);
        } else if (!this.isFlyingDataProcessor.getValue().booleanValue() || !this.areMotorsOnDataProcessor.getValue().booleanValue()) {
            this.returnHomeDataProcessor.onNext(ReturnHomeState.RETURN_HOME_DISABLED);
        } else if (this.isAutoLandingDataProcessor.getValue().booleanValue()) {
            this.returnHomeDataProcessor.onNext(ReturnHomeState.AUTO_LANDING);
        } else if (this.isGoingHomeDataProcessor.getValue().booleanValue() && !this.isAutoLandingDataProcessor.getValue().booleanValue()) {
            if (this.isCancelReturnHomeDisabled()) {
                this.returnHomeDataProcessor.onNext(ReturnHomeState.FORCED_RETURNING_TO_HOME);
            } else {
                this.returnHomeDataProcessor.onNext(ReturnHomeState.RETURNING_TO_HOME);
            }
        } else {
            this.returnHomeDataProcessor.onNext(ReturnHomeState.READY_TO_RETURN_HOME);
        }
    }

    private final boolean isCancelReturnHomeDisabled() {
        return this.isCancelReturnToHomeDisabledProcessor.getValue() != false || this.rcModeDataProcessor.getValue() == RCMode.SLAVE;
    }

    private final float distanceBetween(double latitude1, double longitude1, double latitude2, double longitude2) {
        return LocationUtil.distanceBetween((double)latitude1, (double)longitude1, (double)latitude2, (double)longitude2);
    }

    private static final void inSetup$lambda$4(ReturnHomeWidgetModel this$0, FCFlightMode it) {
        this$0.isGoingHomeDataProcessor.onNext(it == FCFlightMode.GO_HOME || it == FCFlightMode.AUTO_LANDING);
    }

    private static final void inSetup$lambda$5(ReturnHomeWidgetModel this$0, FCAutoRTHReason it) {
        this$0.isCancelReturnToHomeDisabledProcessor.onNext(it == FCAutoRTHReason.MC_PROTECT_GOHOME);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Ldji/v5/ux/flight/returnhome/ReturnHomeWidgetModel$ReturnHomeDistance;", "", "distanceToHome", "", "currentHeight", "goToHomeHeight", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(FFFLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getDistanceToHome", "()F", "getCurrentHeight", "getGoToHomeHeight", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
    public static final class ReturnHomeDistance {
        private final float distanceToHome;
        private final float currentHeight;
        private final float goToHomeHeight;
        @NotNull
        private final UnitConversionUtil.UnitType unitType;

        public ReturnHomeDistance(float distanceToHome, float currentHeight, float goToHomeHeight, @NotNull UnitConversionUtil.UnitType unitType) {
            Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
            this.distanceToHome = distanceToHome;
            this.currentHeight = currentHeight;
            this.goToHomeHeight = goToHomeHeight;
            this.unitType = unitType;
        }

        public final float getDistanceToHome() {
            return this.distanceToHome;
        }

        public final float getCurrentHeight() {
            return this.currentHeight;
        }

        public final float getGoToHomeHeight() {
            return this.goToHomeHeight;
        }

        @NotNull
        public final UnitConversionUtil.UnitType getUnitType() {
            return this.unitType;
        }

        public final float component1() {
            return this.distanceToHome;
        }

        public final float component2() {
            return this.currentHeight;
        }

        public final float component3() {
            return this.goToHomeHeight;
        }

        @NotNull
        public final UnitConversionUtil.UnitType component4() {
            return this.unitType;
        }

        @NotNull
        public final ReturnHomeDistance copy(float distanceToHome, float currentHeight, float goToHomeHeight, @NotNull UnitConversionUtil.UnitType unitType) {
            Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
            return new ReturnHomeDistance(distanceToHome, currentHeight, goToHomeHeight, unitType);
        }

        public static /* synthetic */ ReturnHomeDistance copy$default(ReturnHomeDistance returnHomeDistance, float f, float f2, float f3, UnitConversionUtil.UnitType unitType, int n, Object object) {
            if ((n & 1) != 0) {
                f = returnHomeDistance.distanceToHome;
            }
            if ((n & 2) != 0) {
                f2 = returnHomeDistance.currentHeight;
            }
            if ((n & 4) != 0) {
                f3 = returnHomeDistance.goToHomeHeight;
            }
            if ((n & 8) != 0) {
                unitType = returnHomeDistance.unitType;
            }
            return returnHomeDistance.copy(f, f2, f3, unitType);
        }

        @NotNull
        public String toString() {
            return "ReturnHomeDistance(distanceToHome=" + this.distanceToHome + ", currentHeight=" + this.currentHeight + ", goToHomeHeight=" + this.goToHomeHeight + ", unitType=" + this.unitType + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.distanceToHome);
            result = result * 31 + Float.hashCode(this.currentHeight);
            result = result * 31 + Float.hashCode(this.goToHomeHeight);
            result = result * 31 + this.unitType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReturnHomeDistance)) {
                return false;
            }
            ReturnHomeDistance returnHomeDistance = (ReturnHomeDistance)other;
            if (Float.compare(this.distanceToHome, returnHomeDistance.distanceToHome) != 0) {
                return false;
            }
            if (Float.compare(this.currentHeight, returnHomeDistance.currentHeight) != 0) {
                return false;
            }
            if (Float.compare(this.goToHomeHeight, returnHomeDistance.goToHomeHeight) != 0) {
                return false;
            }
            return this.unitType == returnHomeDistance.unitType;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Ldji/v5/ux/flight/returnhome/ReturnHomeWidgetModel$ReturnHomeState;", "", "<init>", "(Ljava/lang/String;I)V", "READY_TO_RETURN_HOME", "RETURN_HOME_DISABLED", "RETURNING_TO_HOME", "FORCED_RETURNING_TO_HOME", "AUTO_LANDING", "DISCONNECTED", "android-sdk-v5-uxsdk_release"})
    public static final class ReturnHomeState
    extends Enum<ReturnHomeState> {
        public static final /* enum */ ReturnHomeState READY_TO_RETURN_HOME = new ReturnHomeState();
        public static final /* enum */ ReturnHomeState RETURN_HOME_DISABLED = new ReturnHomeState();
        public static final /* enum */ ReturnHomeState RETURNING_TO_HOME = new ReturnHomeState();
        public static final /* enum */ ReturnHomeState FORCED_RETURNING_TO_HOME = new ReturnHomeState();
        public static final /* enum */ ReturnHomeState AUTO_LANDING = new ReturnHomeState();
        public static final /* enum */ ReturnHomeState DISCONNECTED = new ReturnHomeState();
        private static final /* synthetic */ ReturnHomeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReturnHomeState[] values() {
            return (ReturnHomeState[])$VALUES.clone();
        }

        public static ReturnHomeState valueOf(String value) {
            return Enum.valueOf(ReturnHomeState.class, value);
        }

        @NotNull
        public static EnumEntries<ReturnHomeState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = returnHomeStateArray = new ReturnHomeState[]{ReturnHomeState.READY_TO_RETURN_HOME, ReturnHomeState.RETURN_HOME_DISABLED, ReturnHomeState.RETURNING_TO_HOME, ReturnHomeState.FORCED_RETURNING_TO_HOME, ReturnHomeState.AUTO_LANDING, ReturnHomeState.DISCONNECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

