/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.compass;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.Px;
import dji.v5.ux.R;
import dji.v5.ux.core.extension.ViewExtensions;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0018\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00128\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR(\u0010\u001d\u001a\u00020\u00072\b\b\u0001\u0010\u001d\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R(\u0010\"\u001a\u00020\u00072\b\b\u0001\u0010\"\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R(\u0010%\u001a\u00020\u00072\b\b\u0001\u0010%\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!\u00a8\u0006/"}, d2={"Ldji/v5/ux/core/widget/compass/GimbalYawView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "rect", "Landroid/graphics/RectF;", "paint", "Landroid/graphics/Paint;", "curBlinkColor", "beforeShow", "", "yaw", "", "absYaw", "yawStartAngle", "yawSweepAngle", "invalidStartAngle", "invalidSweepAngle", "strokeWidth", "getStrokeWidth", "()F", "setStrokeWidth", "(F)V", "yawColor", "getYawColor", "()I", "setYawColor", "(I)V", "invalidColor", "getInvalidColor", "setInvalidColor", "blinkColor", "getBlinkColor", "setBlinkColor", "init", "", "setYaw", "onDraw", "canvas", "Landroid/graphics/Canvas;", "Companion", "android-sdk-v5-uxsdk_debug"})
public final class GimbalYawView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RectF rect;
    @NotNull
    private final Paint paint;
    private int curBlinkColor;
    private boolean beforeShow;
    private float yaw;
    private float absYaw;
    private float yawStartAngle;
    private float yawSweepAngle;
    private float invalidStartAngle;
    private float invalidSweepAngle;
    @Px
    @FloatRange(from=1.0, to=4.0)
    private float strokeWidth;
    @ColorInt
    private int yawColor;
    @ColorInt
    private int invalidColor;
    @ColorInt
    private int blinkColor;
    public static final int MAX_LINE_WIDTH = 4;

    @JvmOverloads
    public GimbalYawView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.rect = new RectF();
        this.paint = new Paint();
        this.strokeWidth = ViewExtensions.getDimension(this, R.dimen.uxsdk_gimbal_line_width);
        this.yawColor = ViewExtensions.getColor(this, R.color.uxsdk_blue_material_A400);
        this.invalidColor = ViewExtensions.getColor(this, R.color.uxsdk_red);
        this.blinkColor = ViewExtensions.getColor(this, R.color.uxsdk_red_material_900_30_percent);
        this.init();
    }

    public /* synthetic */ GimbalYawView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(@FloatRange(from=1.0, to=4.0) float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.postInvalidate();
    }

    public final int getYawColor() {
        return this.yawColor;
    }

    public final void setYawColor(@ColorInt int yawColor) {
        this.yawColor = yawColor;
        this.postInvalidate();
    }

    public final int getInvalidColor() {
        return this.invalidColor;
    }

    public final void setInvalidColor(@ColorInt int invalidColor) {
        this.invalidColor = invalidColor;
        this.postInvalidate();
    }

    public final int getBlinkColor() {
        return this.blinkColor;
    }

    public final void setBlinkColor(@ColorInt int blinkColor) {
        this.blinkColor = blinkColor;
        this.postInvalidate();
    }

    private final void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.paint.setStrokeWidth(this.strokeWidth);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setAntiAlias(true);
    }

    public final void setYaw(float yaw) {
        if (!(this.yaw == yaw)) {
            this.yaw = yaw;
            float f = this.absYaw = yaw >= 0.0f ? yaw : 0.0f - yaw;
            if (this.absYaw >= 190.0f) {
                this.beforeShow = true;
            } else if (this.absYaw < 90.0f) {
                this.beforeShow = false;
            }
            this.yawStartAngle = 0.0f;
            this.yawSweepAngle = 0.0f;
            this.invalidStartAngle = 0.0f;
            this.invalidSweepAngle = 30.0f;
            if (this.yaw < 0.0f) {
                this.yawStartAngle = this.yaw;
                this.yawSweepAngle = 0.0f - this.yaw;
            } else {
                this.invalidStartAngle = -30.0f;
                this.yawSweepAngle = this.yaw;
            }
            this.postInvalidate();
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.isInEditMode()) {
            return;
        }
        float width = this.getWidth() < this.getHeight() ? (float)this.getWidth() : (float)this.getHeight();
        float halfStroke = this.strokeWidth / 2.0f;
        float radius = width / (float)2;
        this.rect.set(halfStroke, halfStroke, width - halfStroke, width - halfStroke);
        canvas.save();
        canvas.translate(radius, radius);
        canvas.rotate(-90.0f);
        canvas.translate(-radius, -radius);
        if (this.absYaw >= 270.0f) {
            this.curBlinkColor = this.curBlinkColor == this.invalidColor ? this.blinkColor : this.invalidColor;
            this.paint.setColor(this.curBlinkColor);
            canvas.drawArc(this.rect, this.invalidStartAngle, this.invalidSweepAngle, false, this.paint);
            this.postInvalidateDelayed(200L);
        } else if (this.beforeShow) {
            this.curBlinkColor = this.invalidColor;
            this.paint.setColor(this.invalidColor);
            canvas.drawArc(this.rect, this.invalidStartAngle, this.invalidSweepAngle, false, this.paint);
        }
        this.paint.setColor(this.yawColor);
        canvas.drawArc(this.rect, this.yawStartAngle, this.yawSweepAngle, false, this.paint);
        canvas.restore();
    }

    @JvmOverloads
    public GimbalYawView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GimbalYawView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/core/widget/compass/GimbalYawView$Companion;", "", "<init>", "()V", "MAX_LINE_WIDTH", "", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

