/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracapture.recordvideo;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraSDCardState;
import dji.sdk.keyvalue.value.camera.CameraStorageInfo;
import dji.sdk.keyvalue.value.camera.CameraStorageInfos;
import dji.sdk.keyvalue.value.camera.CameraStorageLocation;
import dji.sdk.keyvalue.value.camera.CameraType;
import dji.sdk.keyvalue.value.camera.SSDOperationState;
import dji.sdk.keyvalue.value.camera.VideoFrameRate;
import dji.sdk.keyvalue.value.camera.VideoResolution;
import dji.sdk.keyvalue.value.camera.VideoResolutionFrameRate;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.cameracore.widget.cameracapture.recordvideo.CameraSDVideoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.recordvideo.CameraVideoStorageState;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.module.FlatCameraModule;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;

public class RecordVideoWidgetModel
extends WidgetModel
implements ICameraIndex {
    private static final int INVALID_AVAILABLE_RECORDING_TIME = -1;
    private static final int MAX_VIDEO_TIME_THRESHOLD_MINUTES = 29;
    private static final int SECONDS_PER_MIN = 60;
    private final DataProcessor<CameraVideoStorageState> cameraVideoStorageState;
    private final DataProcessor<Boolean> isRecording;
    private final DataProcessor<String> cameraDisplayName;
    private final DataProcessor<CameraType> cameraType;
    private final DataProcessor<Integer> recordingTimeInSeconds;
    private final DataProcessor<VideoResolutionFrameRate> recordedVideoParameters;
    private final DataProcessor<VideoResolutionFrameRate> nonSSDRecordedVideoParameters;
    private final DataProcessor<VideoResolutionFrameRate> ssdRecordedVideoParameters;
    private final DataProcessor<CameraStorageLocation> storageLocation;
    private final DataProcessor<CameraSDCardState> sdCardState;
    private final DataProcessor<CameraSDCardState> storageState;
    private final DataProcessor<CameraSDCardState> innerStorageState;
    private final DataProcessor<SSDOperationState> ssdState;
    private final DataProcessor<CameraStorageInfos> cameraStorageInfos;
    private final DataProcessor<RecordingState> recordingStateProcessor;
    private final FlatCameraModule flatCameraModule;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;
    private boolean lastIsRecording = false;

    public RecordVideoWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
        CameraSDVideoStorageState cameraSDVideoStorageState = new CameraSDVideoStorageState(CameraStorageLocation.SDCARD, 0, CameraSDCardState.NOT_INSERTED);
        this.cameraVideoStorageState = DataProcessor.create(cameraSDVideoStorageState);
        this.isRecording = DataProcessor.create(false);
        this.cameraDisplayName = DataProcessor.create("");
        this.cameraType = DataProcessor.create(CameraType.NOT_SUPPORTED);
        this.recordingTimeInSeconds = DataProcessor.create(0);
        VideoResolutionFrameRate resolutionAndFrameRate = new VideoResolutionFrameRate(VideoResolution.UNKNOWN, VideoFrameRate.UNKNOWN);
        this.recordedVideoParameters = DataProcessor.create(resolutionAndFrameRate);
        this.nonSSDRecordedVideoParameters = DataProcessor.create(resolutionAndFrameRate);
        this.ssdRecordedVideoParameters = DataProcessor.create(resolutionAndFrameRate);
        this.storageLocation = DataProcessor.create(CameraStorageLocation.SDCARD);
        this.sdCardState = DataProcessor.create(CameraSDCardState.UNKNOWN_ERROR);
        this.storageState = DataProcessor.create(CameraSDCardState.NORMAL);
        this.innerStorageState = DataProcessor.create(CameraSDCardState.UNKNOWN_ERROR);
        this.ssdState = DataProcessor.create(SSDOperationState.UNKNOWN);
        this.cameraStorageInfos = DataProcessor.create(new CameraStorageInfos(CameraStorageLocation.UNKNOWN, new ArrayList()));
        this.recordingStateProcessor = DataProcessor.create(RecordingState.UNKNOWN);
        this.flatCameraModule = new FlatCameraModule();
        this.addModule(this.flatCameraModule);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsRecording, (ComponentIndexType)this.cameraIndex), this.isRecording, newValue -> {
            if (newValue == null) {
                this.recordingStateProcessor.onNext(RecordingState.UNKNOWN);
                return;
            }
            if (this.lastIsRecording && !newValue.booleanValue()) {
                this.recordingStateProcessor.onNext(RecordingState.RECORDING_STOPPED);
            } else if (newValue.booleanValue()) {
                this.recordingStateProcessor.onNext(RecordingState.RECORDING_IN_PROGRESS);
            } else {
                this.recordingStateProcessor.onNext(RecordingState.RECORDING_NOT_STARED);
            }
            this.lastIsRecording = newValue;
        });
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyRecordingTime, (ComponentIndexType)this.cameraIndex), this.recordingTimeInSeconds);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraType, (ComponentIndexType)this.cameraIndex), this.cameraType, type -> this.cameraDisplayName.onNext(type.name()));
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraStorageLocation, (ComponentIndexType)this.cameraIndex), this.storageLocation);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraSDCardState, (ComponentIndexType)this.cameraIndex), this.sdCardState);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyInternalStorageState, (ComponentIndexType)this.cameraIndex), this.innerStorageState);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySSDOperationState, (ComponentIndexType)this.cameraIndex), this.ssdState);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraStorageInfos, (ComponentIndexType)this.cameraIndex), this.cameraStorageInfos);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyVideoResolutionFrameRate, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.nonSSDRecordedVideoParameters);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeySSDVideoResolutionFrameRate, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.ssdRecordedVideoParameters);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
        this.updateVideoStorageState();
        if (this.isRecording.getValue().booleanValue()) {
            this.checkIsOverRecordTime(this.recordingTimeInSeconds.getValue());
        }
    }

    @Override
    protected void onProductConnectionChanged(boolean isConnected) {
        super.onProductConnectionChanged(isConnected);
        if (!isConnected) {
            this.recordingStateProcessor.onNext(RecordingState.UNKNOWN);
        }
    }

    public boolean isVideoMode() {
        return this.flatCameraModule.getCameraModeDataProcessor().getValue().isVideoMode();
    }

    public Flowable<CameraVideoStorageState> getCameraVideoStorageState() {
        return this.cameraVideoStorageState.toFlowable();
    }

    public Flowable<RecordingState> getRecordingState() {
        return this.recordingStateProcessor.toFlowable();
    }

    public Flowable<String> getCameraDisplayName() {
        return this.cameraDisplayName.toFlowable();
    }

    public Flowable<Integer> getRecordingTimeInSeconds() {
        return this.recordingTimeInSeconds.toFlowable();
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.flatCameraModule.updateCameraSource(cameraIndex, lensType);
        this.restart();
    }

    public Completable startRecordVideo() {
        if (this.isRecording.getValue().booleanValue()) {
            return Completable.complete();
        }
        return this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)CameraKey.KeyStartRecord, (ComponentIndexType)this.cameraIndex));
    }

    public Completable stopRecordVideo() {
        if (!this.isRecording.getValue().booleanValue()) {
            return Completable.complete();
        }
        return this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)CameraKey.KeyStopRecord, (ComponentIndexType)this.cameraIndex));
    }

    private void updateVideoStorageState() {
        CameraStorageLocation currentStorageLocation = this.storageLocation.getValue();
        if (CameraStorageLocation.UNKNOWN.equals((Object)currentStorageLocation)) {
            return;
        }
        int availableRecordingTime = this.getAvailableRecordingTime();
        CameraSDVideoStorageState newCameraVideoStorageState = null;
        if (CameraStorageLocation.SDCARD.equals((Object)currentStorageLocation)) {
            if (!CameraSDCardState.UNKNOWN_ERROR.equals((Object)this.sdCardState.getValue())) {
                newCameraVideoStorageState = new CameraSDVideoStorageState(currentStorageLocation, availableRecordingTime, this.sdCardState.getValue());
            } else if (!CameraSDCardState.UNKNOWN_ERROR.equals((Object)this.storageState.getValue())) {
                newCameraVideoStorageState = new CameraSDVideoStorageState(currentStorageLocation, availableRecordingTime, this.storageState.getValue());
            }
            this.recordedVideoParameters.onNext(this.nonSSDRecordedVideoParameters.getValue());
        } else if (CameraStorageLocation.INTERNAL.equals((Object)currentStorageLocation)) {
            newCameraVideoStorageState = new CameraSDVideoStorageState(currentStorageLocation, availableRecordingTime, this.innerStorageState.getValue());
        }
        if (newCameraVideoStorageState != null) {
            this.cameraVideoStorageState.onNext(newCameraVideoStorageState);
        }
    }

    private int getAvailableRecordingTime() {
        CameraStorageInfo info = this.cameraStorageInfos.getValue().getCurrentCameraStorageInfo();
        if (info == null) {
            return -1;
        }
        Integer availableVideoDuration = info.getAvailableVideoDuration();
        return availableVideoDuration == null ? -1 : availableVideoDuration;
    }

    private void checkIsOverRecordTime(int recordTime) {
        if (recordTime > 1740) {
            this.stopRecordVideo();
        }
    }

    public static enum RecordingState {
        UNKNOWN,
        RECORDING_NOT_STARED,
        RECORDING_IN_PROGRESS,
        RECORDING_STOPPED;

    }
}

