/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.gimbal;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.gimbal.GimbalCalibrationState;
import dji.sdk.keyvalue.value.gimbal.GimbalCalibrationStatusInfo;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.IGimbalIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.ui.setting.dialog.CommonLoadingDialog;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.gimbal.GimbalSettingWidgetModel;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001\u001fB'\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001cH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldji/v5/ux/gimbal/GimbalSettingWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "", "Landroid/view/View$OnClickListener;", "Ldji/v5/ux/core/base/IGimbalIndex;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "loadingDialog", "Ldji/v5/ux/core/ui/setting/dialog/CommonLoadingDialog;", "areMotors", "", "widgetModel", "Ldji/v5/ux/gimbal/GimbalSettingWidgetModel;", "initView", "", "reactToModelChanges", "onAttachedToWindow", "onDetachedFromWindow", "onClick", "v", "Landroid/view/View;", "getGimbalIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "updateGimbalIndex", "gimbalIndex", "Companion", "android-sdk-v5-uxsdk_release"})
public class GimbalSettingWidget
extends ConstraintLayoutWidget<Object>
implements View.OnClickListener,
IGimbalIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonLoadingDialog loadingDialog;
    private boolean areMotors;
    @NotNull
    private final GimbalSettingWidgetModel widgetModel;
    @NotNull
    private static final String TAG = "GimbalSettingWidget";

    @JvmOverloads
    public GimbalSettingWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.loadingDialog = new CommonLoadingDialog(context);
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        this.widgetModel = new GimbalSettingWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    public /* synthetic */ GimbalSettingWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConstraintLayout.inflate((Context)context, (int)R.layout.uxsdk_gimbal_setting, (ViewGroup)((ViewGroup)this));
        Button btnReset = (Button)this.findViewById(R.id.setting_menu_gimbal_reset_param);
        Button btnCalibration = (Button)this.findViewById(R.id.setting_menu_gimbal_calibration);
        Button setting_menu_gimbal_adjust = (Button)this.findViewById(R.id.setting_menu_gimbal_adjust);
        btnReset.setOnClickListener((View.OnClickListener)this);
        btnCalibration.setOnClickListener((View.OnClickListener)this);
        setting_menu_gimbal_adjust.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.widgetModel.calibrationStatus().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GimbalSettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(GimbalCalibrationStatusInfo status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                if (status.getStatus() != GimbalCalibrationState.IN_PROGRESS) {
                    if (GimbalSettingWidget.access$getLoadingDialog$p(this.this$0).isShowing()) {
                        if (status.getStatus() == GimbalCalibrationState.IDLE) {
                            ViewUtil.showToast(this.this$0.getContext(), R.string.uxsdk_gimbal_cali_success, 0);
                        } else {
                            ViewUtil.showToast(this.this$0.getContext(), R.string.uxsdk_gimbal_cali_fail, 0);
                        }
                    }
                    GimbalSettingWidget.access$getLoadingDialog$p(this.this$0).dismiss();
                    return;
                }
                if (!GimbalSettingWidget.access$getLoadingDialog$p(this.this$0).isShowing()) {
                    GimbalSettingWidget.access$getLoadingDialog$p(this.this$0).show();
                }
                Object[] objectArray = new Object[]{status.getProgress()};
                GimbalSettingWidget.access$getLoadingDialog$p(this.this$0).setLoadingText(this.this$0.getResources().getString(R.string.uxsdk_gimbal_caling, objectArray));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.widgetModel.areMotorsOn().subscribe(new Consumer(this){
            final /* synthetic */ GimbalSettingWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean areMotors) {
                Intrinsics.checkNotNullParameter((Object)areMotors, (String)"areMotors");
                GimbalSettingWidget.access$setAreMotors$p(this.this$0, areMotors);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    public void onClick(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (v.getId() == R.id.setting_menu_gimbal_reset_param) {
            this.widgetModel.resetGimbal().doOnComplete(() -> GimbalSettingWidget.onClick$lambda$0(this)).doOnError(new Consumer(this){
                final /* synthetic */ GimbalSettingWidget this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    Object[] objectArray = new Object[]{"resetGimbal fail " + throwable};
                    LogUtils.e((String)"GimbalSettingWidget", (Object[])objectArray);
                    ViewUtil.showToast(this.this$0.getContext(), R.string.uxsdk_gimbal_gimbal_reset_params_fail, 0);
                }
            }).subscribe();
        } else if (v.getId() == R.id.setting_menu_gimbal_calibration) {
            if (this.areMotors) {
                ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_ui_gimbal_calibration_tip, 0);
                return;
            }
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_ui_gimbal_auto_calibration_tip, 0);
            this.widgetModel.calibrateGimbal().subscribe();
        } else if (v.getId() == R.id.setting_menu_gimbal_adjust) {
            this.widgetModel.setGimbalClicked();
        }
    }

    @Override
    @NotNull
    public ComponentIndexType getGimbalIndex() {
        return this.widgetModel.getGimbalIndex();
    }

    @Override
    public void updateGimbalIndex(@NotNull ComponentIndexType gimbalIndex) {
        Intrinsics.checkNotNullParameter((Object)gimbalIndex, (String)"gimbalIndex");
        this.widgetModel.updateGimbalIndex(gimbalIndex);
    }

    @JvmOverloads
    public GimbalSettingWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GimbalSettingWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void onClick$lambda$0(GimbalSettingWidget this$0) {
        ViewUtil.showToast(this$0.getContext(), R.string.uxsdk_gimbal_gimbal_reset_params_success, 0);
    }

    public static final /* synthetic */ CommonLoadingDialog access$getLoadingDialog$p(GimbalSettingWidget $this) {
        return $this.loadingDialog;
    }

    public static final /* synthetic */ void access$setAreMotors$p(GimbalSettingWidget $this, boolean bl) {
        $this.areMotors = bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/gimbal/GimbalSettingWidget$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

