/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.module;

import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraMode;
import dji.sdk.keyvalue.value.camera.CameraShootPhotoMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.BaseModule;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.extension.CameraExtensions;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJ\b\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\rH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\""}, d2={"Ldji/v5/ux/core/module/FlatCameraModule;", "Ldji/v5/ux/core/base/BaseModule;", "Ldji/v5/ux/core/base/ICameraIndex;", "<init>", "()V", "isFlatCameraModeSupportedDataProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "cameraIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "lensType", "Ldji/sdk/keyvalue/value/common/CameraLensType;", "cameraModeDataProcessor", "Ldji/sdk/keyvalue/value/camera/CameraMode;", "getCameraModeDataProcessor", "()Ldji/v5/ux/core/util/DataProcessor;", "shootPhotoModeProcessor", "Ldji/sdk/keyvalue/value/camera/CameraShootPhotoMode;", "getShootPhotoModeProcessor", "setup", "", "widgetModel", "Ldji/v5/ux/core/base/WidgetModel;", "cleanup", "setCameraMode", "Lio/reactivex/rxjava3/core/Completable;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "cameraMode", "getCameraIndex", "getLensType", "updateCameraSource", "updateModes", "flatCameraMode", "android-sdk-v5-uxsdk_release"})
public final class FlatCameraModule
extends BaseModule
implements ICameraIndex {
    @NotNull
    private final DataProcessor<Boolean> isFlatCameraModeSupportedDataProcessor;
    @NotNull
    private ComponentIndexType cameraIndex;
    @NotNull
    private CameraLensType lensType;
    @NotNull
    private final DataProcessor<CameraMode> cameraModeDataProcessor;
    @NotNull
    private final DataProcessor<CameraShootPhotoMode> shootPhotoModeProcessor;

    public FlatCameraModule() {
        DataProcessor<Boolean> dataProcessor = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.isFlatCameraModeSupportedDataProcessor = dataProcessor;
        this.cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
        this.lensType = CameraLensType.CAMERA_LENS_ZOOM;
        DataProcessor<CameraMode> dataProcessor2 = DataProcessor.create(CameraMode.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.cameraModeDataProcessor = dataProcessor2;
        DataProcessor<CameraShootPhotoMode> dataProcessor3 = DataProcessor.create(CameraShootPhotoMode.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.shootPhotoModeProcessor = dataProcessor3;
    }

    @NotNull
    public final DataProcessor<CameraMode> getCameraModeDataProcessor() {
        return this.cameraModeDataProcessor;
    }

    @NotNull
    public final DataProcessor<CameraShootPhotoMode> getShootPhotoModeProcessor() {
        return this.shootPhotoModeProcessor;
    }

    @Override
    protected void setup(@NotNull WidgetModel widgetModel) {
        Intrinsics.checkNotNullParameter((Object)widgetModel, (String)"widgetModel");
        BaseModule baseModule = this;
        DJIKey dJIKey = KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraMode, (ComponentIndexType)this.cameraIndex);
        Intrinsics.checkNotNullExpressionValue((Object)dJIKey, (String)"createKey(...)");
        BaseModule.bindDataProcessor$default(baseModule, widgetModel, dJIKey, this.cameraModeDataProcessor, null, 8, null);
        BaseModule baseModule2 = this;
        DJIKey dJIKey2 = KeyTools.createKey((DJIKeyInfo)CameraKey.KeyShootPhotoMode, (ComponentIndexType)this.cameraIndex);
        Intrinsics.checkNotNullExpressionValue((Object)dJIKey2, (String)"createKey(...)");
        BaseModule.bindDataProcessor$default(baseModule2, widgetModel, dJIKey2, this.shootPhotoModeProcessor, null, 8, null);
        DJIKey dJIKey3 = KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraFlatModeSupported, (ComponentIndexType)this.cameraIndex);
        Intrinsics.checkNotNullExpressionValue((Object)dJIKey3, (String)"createKey(...)");
        DJIKey isFlatCameraModeSupportedKey = dJIKey3;
        BaseModule.bindDataProcessor$default(this, widgetModel, isFlatCameraModeSupportedKey, this.isFlatCameraModeSupportedDataProcessor, null, 8, null);
    }

    @Override
    protected void cleanup() {
    }

    @NotNull
    public final Completable setCameraMode(@NotNull DJISDKModel djiSdkModel, @NotNull CameraMode cameraMode) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)cameraMode, (String)"cameraMode");
        Completable completable = djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraMode, (ComponentIndexType)this.cameraIndex), cameraMode);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"setValue(...)");
        return completable;
    }

    @Override
    @NotNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NotNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NotNull ComponentIndexType cameraIndex, @NotNull CameraLensType lensType) {
        Intrinsics.checkNotNullParameter((Object)cameraIndex, (String)"cameraIndex");
        Intrinsics.checkNotNullParameter((Object)lensType, (String)"lensType");
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
    }

    private final void updateModes(CameraMode flatCameraMode) {
        this.cameraModeDataProcessor.onNext(CameraExtensions.isPictureMode(flatCameraMode) ? CameraMode.PHOTO_NORMAL : CameraMode.VIDEO_NORMAL);
        this.shootPhotoModeProcessor.onNext(CameraExtensions.toShootPhotoMode(flatCameraMode));
    }
}

