/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.VerticalSeekBar;

public class OffsetVerticalSeekBar
extends VerticalSeekBar {
    private Rect mRect;
    private Paint mPaint;
    private int mSeekBarHeight;
    private int mRectColor;
    private boolean mIsOnlyDragSupported = false;
    private boolean mIsDragging = false;

    public OffsetVerticalSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViews(context);
    }

    private void initViews(Context context) {
        this.mRect = new Rect();
        this.mPaint = new Paint();
        this.mSeekBarHeight = DisplayUtil.dip2px((Context)this.getContext(), (float)4.0f);
        this.mRectColor = context.getResources().getColor(R.color.uxsdk_white_0_percent);
    }

    @Override
    public void setProgressDrawable(Drawable d) {
        super.setProgressDrawable(d);
        this.updateProgressDrawableBounds();
    }

    @Override
    public void setThumb(Drawable thumb) {
        super.setThumb(thumb);
        this.updateProgressDrawableBounds();
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        this.mRect.set(0, this.getHeight() / 2 - this.mSeekBarHeight / 2, this.getWidth(), this.getHeight() / 2 + this.mSeekBarHeight / 2);
        this.mPaint.setColor(0);
        canvas.drawRect(this.mRect, this.mPaint);
        if (this.getProgress() < this.getMax() / 2) {
            this.mRect.set(this.getWidth() / 2 - this.mSeekBarHeight / 2, this.getHeight() / 2, this.getWidth() / 2 + this.mSeekBarHeight / 2, this.getThumb().getBounds().top);
            this.mPaint.setColor(this.mRectColor);
            canvas.drawRect(this.mRect, this.mPaint);
        }
        if (this.getProgress() > this.getMax() / 2) {
            this.mRect.set(this.getWidth() / 2 - this.mSeekBarHeight / 2, this.getThumb().getBounds().bottom, this.getWidth() / 2 + this.mSeekBarHeight / 2, this.getHeight() / 2);
            this.mPaint.setColor(this.mRectColor);
            canvas.drawRect(this.mRect, this.mPaint);
        }
        super.onDraw(canvas);
    }

    @Override
    protected void updateDrawableBounds(int w, int h) {
        float scale;
        this.updateProgressDrawableBounds();
        Drawable thumb = this.mThumb;
        int max = this.mMax;
        float f = scale = max > 0 ? (float)this.mProgress / (float)max : 0.0f;
        if (thumb != null) {
            this.setDrawableBounds(w, h, thumb, scale);
        }
    }

    public void updateProgressDrawableBounds() {
        Drawable d = this.mProgressDrawable;
        Drawable thumb = this.mThumb;
        int trackWidth = this.mProgressWidth;
        int thumbWidth = thumb == null ? 0 : thumb.getIntrinsicWidth();
        int thumbHeight = thumb == null ? 0 : thumb.getIntrinsicHeight();
        int gapForCenteringTrack = (thumbWidth - trackWidth) / 2;
        int top = thumbHeight / 2 + this.getPaddingTop();
        int bottom = this.getHeight() - this.getPaddingBottom() - thumbHeight / 2;
        if (d != null) {
            d.setBounds(gapForCenteringTrack, top, gapForCenteringTrack + trackWidth, bottom);
        }
    }

    public void setIsOnlyDrag(boolean isOnlyDragSupported) {
        this.mIsOnlyDragSupported = isOnlyDragSupported;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0 && this.mIsOnlyDragSupported && (event.getY() < (float)this.mThumb.getBounds().top || event.getY() > (float)this.mThumb.getBounds().bottom)) {
            this.mIsDragging = true;
            return true;
        }
        if (this.mIsOnlyDragSupported && this.mIsDragging && (event.getAction() == 1 || event.getAction() == 3)) {
            this.mIsDragging = false;
            return true;
        }
        return super.onTouchEvent(event);
    }
}

