/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdateFactory;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010K\u001a\u00020\u00012\u0006\u0010L\u001a\u00020\u0001\u001a\u000e\u0010M\u001a\u00020\u00012\u0006\u0010N\u001a\u00020\u0001\u001a\u001a\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010T\u001a\u000e\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X\u001a\u0010\u0010Y\u001a\u00020X2\b\u0010W\u001a\u0004\u0018\u00010V\u001a\u000e\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]\u001a\u0016\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\u0006\u0010\\\u001a\u00020]\u001a\u000e\u0010b\u001a\u00020\u00012\u0006\u0010c\u001a\u00020d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0010\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0016\u0010\u0014\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\"\u0016\u0010\u0016\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0016\u0010\u0018\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\"\u0016\u0010\u001a\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0016\u0010\u001c\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0016\u0010\u001e\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0016\u0010 \u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013\"\u0016\u0010\"\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0016\u0010$\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013\"\u0016\u0010&\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0013\"\u0016\u0010(\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0013\"\u0016\u0010*\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0013\"\u0016\u0010,\u001a\u00020\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0013\"\u0011\u0010.\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0011\u00101\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b2\u00100\"\u0011\u00103\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b4\u00100\"\u0011\u00105\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b6\u00100\"\u0011\u00107\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b8\u00100\"\u0011\u00109\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b:\u00100\"\u0011\u0010;\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b<\u00100\"\u0011\u0010=\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b>\u00100\"\u0011\u0010?\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b@\u00100\"\u0011\u0010A\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bB\u00100\"\u0011\u0010C\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bD\u00100\"\u0011\u0010E\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bF\u00100\"\u0011\u0010G\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bH\u00100\"\u0011\u0010I\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bJ\u00100\u00a8\u0006e"}, d2={"FEATURE_ID_PREFIX", "", "MARKER_ICON_ID_PREFIX", "MARKER_LAYER_ID_PREFIX", "MARKER_SOURCE_ID_PREFIX", "CIRCLE_SOURCE_ID_PREFIX", "CIRCLE_LAYER_ID_PREFIX", "CIRCLE_BORDER_LAYER_ID_PREFIX", "CIRCLE_BORDER_SOURCE_ID_PREFIX", "POLYGON_LAYER_ID_PREFIX", "POLYGON_SOURCE_ID_PREFIX", "POLYGON_BORDER_LAYER_ID_PREFIX", "POLYGON_BORDER_SOURCE_ID_PREFIX", "POLYLINE_LAYER_ID_PREFIX", "POLYLINE_SOURCE_ID_PREFIX", "INFO_WINDOW_ID_POSTFIX", "markerIconIndex", "", "getMarkerIconIndex", "()I", "markerLayerIndex", "getMarkerLayerIndex", "markerSourceIndex", "getMarkerSourceIndex", "circleSourceIndex", "getCircleSourceIndex", "circleLayerIndex", "getCircleLayerIndex", "circleBorderLayerIndex", "getCircleBorderLayerIndex", "circleBorderSourceIndex", "getCircleBorderSourceIndex", "polygonLayerIndex", "getPolygonLayerIndex", "polygonSourceIndex", "getPolygonSourceIndex", "polygonBorderLayerIndex", "getPolygonBorderLayerIndex", "polygonBorderSourceIndex", "getPolygonBorderSourceIndex", "polylineLayerIndex", "getPolylineLayerIndex", "polylineSourceIndex", "getPolylineSourceIndex", "featureIdIndex", "getFeatureIdIndex", "markerIconIdAndIncrement", "getMarkerIconIdAndIncrement", "()Ljava/lang/String;", "markerLayerIdAndIncrement", "getMarkerLayerIdAndIncrement", "markerSourceIdAndIncrement", "getMarkerSourceIdAndIncrement", "circleLayerIdAndIncrement", "getCircleLayerIdAndIncrement", "circleSourceIdAndIncrement", "getCircleSourceIdAndIncrement", "circleBorderLayerIdAndIncrement", "getCircleBorderLayerIdAndIncrement", "circleBorderSourceIdAndIncrement", "getCircleBorderSourceIdAndIncrement", "polygonLayerIdAndIncrement", "getPolygonLayerIdAndIncrement", "polygonSourceIdAndIncrement", "getPolygonSourceIdAndIncrement", "polygonBorderLayerIdAndIncrement", "getPolygonBorderLayerIdAndIncrement", "polygonBorderSourceIdAndIncrement", "getPolygonBorderSourceIdAndIncrement", "polylineLayerIdAndIncrement", "getPolylineLayerIdAndIncrement", "polylineSourceIdAndIncrement", "getPolylineSourceIdAndIncrement", "sourceFeatureIdAndIncrement", "getSourceFeatureIdAndIncrement", "getInfoWindowIconId", "markerIconId", "getInfoWindowLayerId", "markerLayerId", "fromDJIBitmapDescriptor", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "descriptor", "Ldji/v5/ux/mapkit/core/models/DJIBitmapDescriptor;", "fromDJILatLng", "Lcom/mapbox/mapboxsdk/geometry/LatLng;", "latLng", "Ldji/v5/ux/mapkit/core/models/DJILatLng;", "fromLatLng", "fromCameraPosition", "Ldji/v5/ux/mapkit/core/models/DJICameraPosition;", "cameraPosition", "Lcom/mapbox/mapboxsdk/camera/CameraPosition;", "fromDJICameraUpdate", "Lcom/mapbox/mapboxsdk/camera/CameraUpdate;", "cameraUpdate", "Ldji/v5/ux/mapkit/core/camera/DJICameraUpdate;", "fromMapType", "mapType", "Ldji/v5/ux/mapkit/core/maps/DJIMap$MapType;", "android-sdk-v5-uxsdk_release"})
@JvmName(name="MapboxUtil")
public final class MapboxUtil {
    @NotNull
    private static final String FEATURE_ID_PREFIX = "FEATURE_ID_PREFIX";
    @NotNull
    private static final String MARKER_ICON_ID_PREFIX = "MARKER_ICON_ID_PREFIX";
    @NotNull
    private static final String MARKER_LAYER_ID_PREFIX = "MARKER_LAYER_ID_PREFIX";
    @NotNull
    private static final String MARKER_SOURCE_ID_PREFIX = "MARKER_SOURCE_ID_PREFIX";
    @NotNull
    private static final String CIRCLE_SOURCE_ID_PREFIX = "CIRCLE_SOURCE_ID_PREFIX";
    @NotNull
    private static final String CIRCLE_LAYER_ID_PREFIX = "CIRCLE_LAYER_ID_PREFIX";
    @NotNull
    private static final String CIRCLE_BORDER_LAYER_ID_PREFIX = "CIRCLE_BORDER_LAYER_ID_PREFIX";
    @NotNull
    private static final String CIRCLE_BORDER_SOURCE_ID_PREFIX = "CIRCLE_BORDER_SOURCE_ID_PREFIX";
    @NotNull
    private static final String POLYGON_LAYER_ID_PREFIX = "POLYGON_LAYER_ID_PREFIX";
    @NotNull
    private static final String POLYGON_SOURCE_ID_PREFIX = "POLYGON_SOURCE_ID_PREFIX";
    @NotNull
    private static final String POLYGON_BORDER_LAYER_ID_PREFIX = "POLYGON_BORDER_LAYER_ID_PREFIX";
    @NotNull
    private static final String POLYGON_BORDER_SOURCE_ID_PREFIX = "POLYGON_BORDER_SOURCE_ID_PREFIX";
    @NotNull
    private static final String POLYLINE_LAYER_ID_PREFIX = "POLYLINE_LAYER_ID_PREFIX";
    @NotNull
    private static final String POLYLINE_SOURCE_ID_PREFIX = "POLYLINE_SOURCE_ID_PREFIX";
    @NotNull
    private static final String INFO_WINDOW_ID_POSTFIX = "_INFO_WINDOW";
    private static int markerIconIndex;
    private static int markerLayerIndex;
    private static int markerSourceIndex;
    private static int circleSourceIndex;
    private static int circleLayerIndex;
    private static int circleBorderLayerIndex;
    private static int circleBorderSourceIndex;
    private static int polygonLayerIndex;
    private static int polygonSourceIndex;
    private static int polygonBorderLayerIndex;
    private static int polygonBorderSourceIndex;
    private static int polylineLayerIndex;
    private static int polylineSourceIndex;
    private static int featureIdIndex;

    private static final int getMarkerIconIndex() {
        return ++markerIconIndex;
    }

    private static final int getMarkerLayerIndex() {
        return ++markerLayerIndex;
    }

    private static final int getMarkerSourceIndex() {
        return ++markerSourceIndex;
    }

    private static final int getCircleSourceIndex() {
        return ++circleSourceIndex;
    }

    private static final int getCircleLayerIndex() {
        return ++circleLayerIndex;
    }

    private static final int getCircleBorderLayerIndex() {
        return ++circleBorderLayerIndex;
    }

    private static final int getCircleBorderSourceIndex() {
        return ++circleBorderSourceIndex;
    }

    private static final int getPolygonLayerIndex() {
        return ++polygonLayerIndex;
    }

    private static final int getPolygonSourceIndex() {
        return ++polygonSourceIndex;
    }

    private static final int getPolygonBorderLayerIndex() {
        return ++polygonBorderLayerIndex;
    }

    private static final int getPolygonBorderSourceIndex() {
        return ++polygonBorderSourceIndex;
    }

    private static final int getPolylineLayerIndex() {
        return ++polylineLayerIndex;
    }

    private static final int getPolylineSourceIndex() {
        return ++polylineSourceIndex;
    }

    private static final int getFeatureIdIndex() {
        return ++featureIdIndex;
    }

    @NotNull
    public static final String getMarkerIconIdAndIncrement() {
        return "MARKER_ICON_ID_PREFIX-" + MapboxUtil.getMarkerIconIndex();
    }

    @NotNull
    public static final String getMarkerLayerIdAndIncrement() {
        return "MARKER_LAYER_ID_PREFIX-" + MapboxUtil.getMarkerLayerIndex();
    }

    @NotNull
    public static final String getMarkerSourceIdAndIncrement() {
        return "MARKER_SOURCE_ID_PREFIX-" + MapboxUtil.getMarkerSourceIndex();
    }

    @NotNull
    public static final String getCircleLayerIdAndIncrement() {
        return "CIRCLE_LAYER_ID_PREFIX-" + MapboxUtil.getCircleLayerIndex();
    }

    @NotNull
    public static final String getCircleSourceIdAndIncrement() {
        return "CIRCLE_SOURCE_ID_PREFIX-" + MapboxUtil.getCircleSourceIndex();
    }

    @NotNull
    public static final String getCircleBorderLayerIdAndIncrement() {
        return "CIRCLE_BORDER_LAYER_ID_PREFIX-" + MapboxUtil.getCircleBorderLayerIndex();
    }

    @NotNull
    public static final String getCircleBorderSourceIdAndIncrement() {
        return "CIRCLE_BORDER_SOURCE_ID_PREFIX-" + MapboxUtil.getCircleBorderSourceIndex();
    }

    @NotNull
    public static final String getPolygonLayerIdAndIncrement() {
        return "POLYGON_LAYER_ID_PREFIX-" + MapboxUtil.getPolygonLayerIndex();
    }

    @NotNull
    public static final String getPolygonSourceIdAndIncrement() {
        return "POLYGON_SOURCE_ID_PREFIX-" + MapboxUtil.getPolygonSourceIndex();
    }

    @NotNull
    public static final String getPolygonBorderLayerIdAndIncrement() {
        return "POLYGON_BORDER_LAYER_ID_PREFIX-" + MapboxUtil.getPolygonBorderLayerIndex();
    }

    @NotNull
    public static final String getPolygonBorderSourceIdAndIncrement() {
        return "POLYGON_BORDER_SOURCE_ID_PREFIX-" + MapboxUtil.getPolygonBorderSourceIndex();
    }

    @NotNull
    public static final String getPolylineLayerIdAndIncrement() {
        return "POLYLINE_LAYER_ID_PREFIX-" + MapboxUtil.getPolylineLayerIndex();
    }

    @NotNull
    public static final String getPolylineSourceIdAndIncrement() {
        return "POLYLINE_SOURCE_ID_PREFIX-" + MapboxUtil.getPolylineSourceIndex();
    }

    @NotNull
    public static final String getSourceFeatureIdAndIncrement() {
        return "FEATURE_ID_PREFIX-" + MapboxUtil.getFeatureIdIndex();
    }

    @NotNull
    public static final String getInfoWindowIconId(@NotNull String markerIconId) {
        Intrinsics.checkNotNullParameter((Object)markerIconId, (String)"markerIconId");
        return markerIconId + INFO_WINDOW_ID_POSTFIX;
    }

    @NotNull
    public static final String getInfoWindowLayerId(@NotNull String markerLayerId) {
        Intrinsics.checkNotNullParameter((Object)markerLayerId, (String)"markerLayerId");
        return markerLayerId + INFO_WINDOW_ID_POSTFIX;
    }

    @Nullable
    public static final Bitmap fromDJIBitmapDescriptor(@NotNull Context context, @Nullable DJIBitmapDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DJIBitmapDescriptor dJIBitmapDescriptor = descriptor;
        DJIBitmapDescriptor.Type type = dJIBitmapDescriptor != null ? dJIBitmapDescriptor.getType() : null;
        return switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> descriptor.getBitmap();
            case 2 -> BitmapUtils.getBitmapFromDrawable((Drawable)context.getResources().getDrawable(descriptor.getResourceId()));
            default -> null;
        };
    }

    @NotNull
    public static final LatLng fromDJILatLng(@NotNull DJILatLng latLng) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        return new LatLng(latLng.latitude, latLng.longitude, latLng.altitude);
    }

    @NotNull
    public static final DJILatLng fromLatLng(@Nullable LatLng latLng) {
        LatLng latLng2 = latLng;
        if (latLng2 != null) {
            LatLng it = latLng2;
            boolean bl = false;
            return new DJILatLng(it.getLatitude(), it.getLongitude(), it.getAltitude());
        }
        return new DJILatLng(Double.NaN, Double.NaN, Double.NaN);
    }

    @NotNull
    public static final DJICameraPosition fromCameraPosition(@NotNull CameraPosition cameraPosition) {
        Intrinsics.checkNotNullParameter((Object)cameraPosition, (String)"cameraPosition");
        DJICameraPosition dJICameraPosition = new DJICameraPosition.Builder().target(MapboxUtil.fromLatLng(cameraPosition.target)).zoom((float)cameraPosition.zoom).tilt((float)cameraPosition.tilt).bearing((float)cameraPosition.bearing).build();
        Intrinsics.checkNotNullExpressionValue((Object)dJICameraPosition, (String)"build(...)");
        return dJICameraPosition;
    }

    @NotNull
    public static final CameraUpdate fromDJICameraUpdate(@NotNull DJICameraUpdate cameraUpdate, @NotNull CameraPosition cameraPosition) {
        Intrinsics.checkNotNullParameter((Object)cameraUpdate, (String)"cameraUpdate");
        Intrinsics.checkNotNullParameter((Object)cameraPosition, (String)"cameraPosition");
        DJICameraUpdate dJICameraUpdate = cameraUpdate;
        if (dJICameraUpdate instanceof DJICameraUpdateFactory.CameraBoundsUpdate) {
            CameraUpdate cameraUpdate2;
            DJILatLng southwest;
            DJILatLng northeast = ((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getBounds().getNortheast();
            if (Intrinsics.areEqual((Object)northeast, (Object)(southwest = ((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getBounds().getSouthwest()))) {
                Intrinsics.checkNotNull((Object)northeast);
                cameraUpdate2 = CameraUpdateFactory.newLatLng((LatLng)MapboxUtil.fromDJILatLng(northeast));
            } else {
                LatLngBounds.Builder builder = new LatLngBounds.Builder();
                Object[] objectArray = new LatLng[2];
                Intrinsics.checkNotNull((Object)northeast);
                objectArray[0] = MapboxUtil.fromDJILatLng(northeast);
                Intrinsics.checkNotNull((Object)southwest);
                objectArray[1] = MapboxUtil.fromDJILatLng(southwest);
                cameraUpdate2 = CameraUpdateFactory.newLatLngBounds((LatLngBounds)builder.includes(CollectionsKt.listOf((Object[])objectArray)).build(), (int)(((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getPaddingLeft() + ((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getPadding()), (int)(((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getPaddingTop() + ((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getPadding()), (int)(((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getPaddingRight() + ((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getPadding()), (int)(((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getPaddingBottom() + ((DJICameraUpdateFactory.CameraBoundsUpdate)cameraUpdate).getPadding()));
            }
            return cameraUpdate2;
        }
        if (dJICameraUpdate instanceof DJICameraUpdateFactory.CameraPositionUpdate) {
            LatLng latLng;
            if (((DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate).getTarget().isAvailable()) {
                DJILatLng dJILatLng = ((DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate).getTarget();
                Intrinsics.checkNotNullExpressionValue((Object)dJILatLng, (String)"getTarget(...)");
                latLng = MapboxUtil.fromDJILatLng(dJILatLng);
            } else {
                latLng = cameraPosition.target;
            }
            LatLng target = latLng;
            double bearing = Float.isNaN(((DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate).getBearing()) ? cameraPosition.bearing : (double)((DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate).getBearing();
            double tilt = Float.isNaN(((DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate).getTilt()) ? cameraPosition.tilt : (double)((DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate).getTilt();
            double zoom = Float.isNaN(((DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate).getZoom()) ? cameraPosition.zoom : (double)((DJICameraUpdateFactory.CameraPositionUpdate)cameraUpdate).getZoom();
            return CameraUpdateFactory.newCameraPosition((CameraPosition)new CameraPosition.Builder().target(target).bearing(bearing).tilt(tilt).zoom(zoom).build());
        }
        return CameraUpdateFactory.newLatLng((LatLng)new LatLng(0.0, 0.0));
    }

    @NotNull
    public static final String fromMapType(@NotNull DJIMap.MapType mapType) {
        Intrinsics.checkNotNullParameter((Object)((Object)mapType), (String)"mapType");
        return switch (WhenMappings.$EnumSwitchMapping$1[mapType.ordinal()]) {
            case 1 -> "mapbox://styles/mapbox/streets-v11";
            case 2 -> "mapbox://styles/mapbox/satellite-streets-v11";
            case 3 -> "mapbox://styles/mapbox/satellite-v9";
            default -> throw new IllegalArgumentException(mapType + " is not implemented");
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DJIBitmapDescriptor.Type.values().length];
            try {
                nArray[DJIBitmapDescriptor.Type.BITMAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DJIBitmapDescriptor.Type.RESOURCE_ID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DJIMap.MapType.values().length];
            try {
                nArray[DJIMap.MapType.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DJIMap.MapType.HYBRID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DJIMap.MapType.SATELLITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

