/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import dji.sdk.keyvalue.value.flightcontroller.FCFlightMode;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.manager.aircraft.perception.data.ObstacleAvoidanceType;
import dji.v5.manager.aircraft.perception.data.PerceptionInfo;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.hsi.HSIContract;
import dji.v5.ux.core.ui.hsi.HSIView;
import dji.v5.ux.core.ui.hsi.HSIWidgetModel;
import dji.v5.ux.core.ui.hsi.RecyclerPool;
import dji.v5.ux.core.ui.hsi.config.IOmniAbility;
import dji.v5.ux.core.ui.hsi.dashboard.FpvStrokeConfig;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HSIPerceptionLayer
implements HSIContract.HSILayer {
    private static final String TAG = HSIPerceptionLayer.class.getSimpleName();
    private static final String PERCEPTION_DISABLED = "NA";
    private static final String PERCEPTION_TOF_ONLY = "TOF";
    private static final String PERCEPTION_USER_DISABLE = "OFF";
    private static final int RADAR_PATH_OP_TIMEOUT = 500;
    private static final int DEFAULT_PERCEPTION_BLIND_AREA_COUNT = 4;
    private static final int DEFAULT_PERCEPTION_AREA_COUNT = 4;
    private static final int DEFAULT_RADAR_START_ANGLE_OFFSET = -15;
    public static final int WARN_COLOR_ALPHA_CENTER = 20;
    public static final int WARN_COLOR_ALPHA_OUTER = 64;
    private static final int PERCEPTION_GROUP_SIZE = 5;
    @NonNull
    private final Path mPath = new Path();
    @NonNull
    private final RectF mRect = new RectF();
    private final int[] mPerceptionLevelColor = new int[3];
    private final int[] mRadarLevelColor = new int[3];
    private final FpvStrokeConfig mStrokeConfig;
    private List<Integer> mRadarHorizontalDistances = new ArrayList<Integer>();
    @NonNull
    private final GradientDrawable mPerceptionAreaDrawable;
    @NonNull
    private final GradientDrawable mTofDrawable;
    private final GradientDrawable mNaDrawable;
    private final int mPerceptionDisabledTextSize;
    private final int mMaxPerceptionStrokeWidth;
    private final int mRadarMaxPerceptionStrokeWidth;
    private HSIContract.HSIContainer mHSIContainer;
    private float mHorizontalBarrierAvoidanceDistance;
    private float mHorizontalPerceptionDistance;
    private int mCompassSize;
    private boolean mShowVisualPerceptionInfo;
    private boolean mShowRadarPerceptionInfo;
    private boolean mPerceptionNotWorkMode = false;
    private boolean isHidePerceptionBg = false;
    private FCFlightMode mFlightMode = FCFlightMode.UNKNOWN;
    private boolean mIsMultiModeOpen = false;
    @NonNull
    private final List<Shape> mShapeList = new ArrayList<Shape>();
    @NonNull
    private final List<Shape> mRadarShapeList = new ArrayList<Shape>();
    @Nullable
    private CompositeDisposable mDisposable;
    IOmniAbility mOmniAbility;
    @NonNull
    private final boolean[] mVisionPerceptionEnableState = new boolean[4];
    @NonNull
    private final boolean[] mToFPerceptionEnableState = new boolean[]{true, true, true, true};
    private boolean mSupportTof = true;
    private static final PathPool mPathPool = new PathPool(128);
    private static final PathPool mRadarPathPool = new PathPool(128);
    private Shader mTofShader;
    private Shader mNaShader;
    private final int mWarnColor;
    private final int mDangerColor;
    @NonNull
    private HSIWidgetModel widgetModel;

    public HSIPerceptionLayer(@NonNull Context context, @Nullable AttributeSet attrs, HSIContract.HSIContainer container, HSIWidgetModel widgetModel) {
        this.mHSIContainer = container;
        this.widgetModel = widgetModel;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AttitudeDashBoard);
        this.mPerceptionLevelColor[2] = typedArray.getColor(R.styleable.HSIView_uxsdk_hsi_avoidance_setting_area_color, context.getResources().getColor(R.color.uxsdk_pfd_hsi_barrier_color));
        this.mPerceptionLevelColor[1] = typedArray.getColor(R.styleable.HSIView_uxsdk_hsi_perception_setting_area_color, context.getResources().getColor(R.color.uxsdk_pfd_hsi_avoidance_color));
        this.mPerceptionLevelColor[0] = typedArray.getColor(R.styleable.HSIView_uxsdk_hsi_max_perception_area_color, context.getResources().getColor(R.color.uxsdk_pfd_hsi_main_color));
        this.mMaxPerceptionStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_max_perception_stroke_width, context.getResources().getDimensionPixelSize(R.dimen.uxsdk_2_dp));
        this.mRadarLevelColor[2] = typedArray.getColor(R.styleable.HSIView_uxsdk_hsi_radar_avoidance_setting_area_color, context.getResources().getColor(R.color.uxsdk_pfd_hsi_radar_barrier_color));
        this.mRadarLevelColor[1] = typedArray.getColor(R.styleable.HSIView_uxsdk_hsi_radar_perception_setting_area_color, context.getResources().getColor(R.color.uxsdk_pfd_hsi_radar_avoidance_color));
        this.mRadarLevelColor[0] = typedArray.getColor(R.styleable.HSIView_uxsdk_hsi_radar_max_perception_area_color, context.getResources().getColor(R.color.uxsdk_pfd_hsi_radar_main_color));
        this.mRadarMaxPerceptionStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_radar_max_perception_stroke_width, context.getResources().getDimensionPixelSize(R.dimen.uxsdk_4_dp));
        typedArray.recycle();
        this.mPerceptionDisabledTextSize = context.getResources().getDimensionPixelSize(R.dimen.uxsdk_6_dp);
        this.mPerceptionAreaDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{Color.parseColor((String)"#29FFFFFF"), Color.parseColor((String)"#0CFFFFFF")});
        this.mPerceptionAreaDrawable.setGradientType(0);
        this.mPerceptionAreaDrawable.setShape(0);
        this.mWarnColor = context.getResources().getColor(R.color.uxsdk_pfd_avoidance_color);
        this.mDangerColor = context.getResources().getColor(R.color.uxsdk_pfd_barrier_color);
        this.mTofDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{ColorUtils.setAlphaComponent((int)this.mWarnColor, (int)64), ColorUtils.setAlphaComponent((int)this.mWarnColor, (int)20)});
        this.mTofDrawable.setGradientType(0);
        this.mTofDrawable.setShape(0);
        this.mNaDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{ColorUtils.setAlphaComponent((int)this.mDangerColor, (int)64), ColorUtils.setAlphaComponent((int)this.mDangerColor, (int)20)});
        this.mNaDrawable.setGradientType(0);
        this.mNaDrawable.setShape(0);
        this.mStrokeConfig = new FpvStrokeConfig(context);
        this.mOmniAbility = IOmniAbility.Companion.getCurrent();
    }

    @Override
    public void onStart() {
        this.mDisposable = new CompositeDisposable();
        this.mDisposable.add(this.widgetModel.getProductTypeDataProcessor().toFlowable().subscribe(productType -> {
            boolean isSupportTof;
            this.isHidePerceptionBg = isSupportTof = productType == ProductType.DJI_MAVIC_3_ENTERPRISE_SERIES || productType == ProductType.DJI_MINI_3 || productType == ProductType.DJI_MINI_3_PRO;
            this.mSupportTof = !isSupportTof;
        }));
        this.mDisposable.add(this.widgetModel.getPerceptionInformationDataProcessor().toFlowable().subscribe((Consumer)new Consumer<PerceptionInfo>(){

            public void accept(PerceptionInfo perceptionInfo) throws Throwable {
                HSIPerceptionLayer.this.mShowVisualPerceptionInfo = perceptionInfo.isHorizontalObstacleAvoidanceEnabled() || perceptionInfo.getObstacleAvoidanceType() == ObstacleAvoidanceType.BYPASS;
                HSIPerceptionLayer.this.mHorizontalBarrierAvoidanceDistance = (float)perceptionInfo.getHorizontalObstacleAvoidanceBrakingDistance();
                HSIPerceptionLayer.this.mHorizontalPerceptionDistance = (float)perceptionInfo.getHorizontalObstacleAvoidanceWarningDistance();
                HSIPerceptionLayer.this.mVisionPerceptionEnableState[0] = perceptionInfo.getForwardObstacleAvoidanceWorking() == Boolean.TRUE;
                HSIPerceptionLayer.this.mVisionPerceptionEnableState[1] = perceptionInfo.getRightSideObstacleAvoidanceWorking() == Boolean.TRUE;
                HSIPerceptionLayer.this.mVisionPerceptionEnableState[2] = perceptionInfo.getBackwardObstacleAvoidanceWorking() == Boolean.TRUE;
                HSIPerceptionLayer.this.mVisionPerceptionEnableState[3] = perceptionInfo.getLeftSideObstacleAvoidanceWorking() == Boolean.TRUE;
            }
        }));
        this.mDisposable.add(this.widgetModel.getRadarInformationDataProcessor().toFlowable().subscribe(information -> {
            this.mShowRadarPerceptionInfo = information.isHorizontalObstacleAvoidanceEnabled();
        }));
        this.mDisposable.add(this.widgetModel.getPerceptionObstacleDataProcessor().toFlowable().throttleLast(200L, TimeUnit.MILLISECONDS).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).map(data -> this.updatePerceptionDrawShape(this.getOptimizationDataIfNeed(data.getHorizontalObstacleDistance()))).subscribe(list -> {
            this.mShapeList.clear();
            this.mShapeList.addAll((Collection<Shape>)list);
            if (this.mHSIContainer != null) {
                this.mHSIContainer.updateWidget();
            }
        }));
        this.mDisposable.add(this.widgetModel.getRadarObstacleDataProcessor().toFlowable().subscribe(data -> {
            this.mRadarHorizontalDistances = data.getHorizontalObstacleDistance();
        }));
        this.mDisposable.add(Flowable.combineLatest(this.widgetModel.getFlightModeProcessor().toFlowable(), this.widgetModel.getMultipleFlightModeEnabledProcessor().toFlowable(), (fcFlightMode, isMultiModeOpen) -> {
            this.mFlightMode = fcFlightMode;
            this.mIsMultiModeOpen = isMultiModeOpen;
            this.mPerceptionNotWorkMode = this.mIsMultiModeOpen && (this.mFlightMode == FCFlightMode.GPS_SPORT || this.mFlightMode == FCFlightMode.ATTI);
            Arrays.fill(this.mToFPerceptionEnableState, !this.mPerceptionNotWorkMode);
            return true;
        }).subscribe());
        this.mDisposable.add(this.getRadarDisposable());
    }

    @NonNull
    private List<Integer> getOptimizationDataIfNeed(List<Integer> data) {
        int size = data.size();
        if (size == 0) {
            return data;
        }
        int sectorLength = 5;
        int sectorCount = size / sectorLength;
        float singleDataAngle = 360.0f / (float)size;
        for (int i = 0; i < sectorCount; ++i) {
            int srcPos = sectorLength * i;
            if (this.posInBlind(srcPos, sectorLength, singleDataAngle)) continue;
            int result = this.minInList(data, srcPos, sectorLength);
            this.fillList(data, srcPos, sectorLength, result);
        }
        return data;
    }

    private boolean posInBlind(int srcPos, int sectorLength, float singleDataAngle) {
        float startAngle = (float)srcPos * singleDataAngle;
        float sweepAngle = (float)sectorLength * singleDataAngle;
        return this.posInBlind(startAngle) || this.posInBlind(startAngle + sweepAngle);
    }

    private boolean posInBlind(float angle) {
        return Math.abs(angle % 90.0f - 45.0f) < (float)this.mOmniAbility.getPerceptionBlindAreaAngle() / 2.0f;
    }

    private int minInList(List<Integer> data, int offset, int size) {
        if (offset >= data.size() || offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = Math.min(offset + size, data.size());
        int result = data.get(last - 1);
        for (int i = last - 2; i >= offset; --i) {
            result = Math.min(result, data.get(i));
        }
        return result;
    }

    private void fillList(List<Integer> data, int offset, int size, int value) {
        if (offset >= data.size() || offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = Math.min(offset + size, data.size());
        for (int i = last - 1; i >= offset; --i) {
            data.set(i, value);
        }
    }

    @Override
    public void onStop() {
        if (this.mDisposable != null) {
            this.mDisposable.dispose();
        }
        this.mHSIContainer = null;
    }

    private Disposable getRadarDisposable() {
        return Observable.interval((long)200L, (TimeUnit)TimeUnit.MILLISECONDS).map(aLong -> this.mRadarHorizontalDistances).observeOn(Schedulers.newThread()).map(this::updateRadarDrawShape).timeout(500L, TimeUnit.MILLISECONDS).retry().observeOn(AndroidSchedulers.mainThread()).subscribe(list -> {
            List<Shape> list2 = this.mRadarShapeList;
            synchronized (list2) {
                this.mRadarShapeList.clear();
                this.mRadarShapeList.addAll((Collection<Shape>)list);
            }
            if (this.mHSIContainer != null) {
                this.mHSIContainer.updateWidget();
            }
        });
    }

    @Override
    public void draw(Canvas canvas, Paint paint, int compassSize) {
        this.mCompassSize = compassSize;
        canvas.save();
        canvas.translate(0.0f, (float)compassSize / 2.0f);
        this.drawRadarBarrier(canvas, paint, compassSize);
        this.drawBarrier(canvas, paint, compassSize);
        this.drawPerception(canvas, paint, compassSize);
        canvas.restore();
    }

    boolean isUserDisable() {
        return !this.mShowVisualPerceptionInfo && !this.mShowRadarPerceptionInfo;
    }

    private void drawPerception(Canvas canvas, Paint paint, int compassSize) {
        if (this.mHSIContainer == null) {
            return;
        }
        this.fixAlpha(paint);
        canvas.save();
        int perceptionAngleTotal = 360 - 4 * this.mOmniAbility.getPerceptionBlindAreaAngle();
        int perceptionAngleEach = perceptionAngleTotal / 4;
        paint.setStyle(Paint.Style.FILL);
        float radius = (float)compassSize / 2.0f - this.mHSIContainer.getCalibrationAreaWidth() - this.mHSIContainer.getCompassBitmapOffset();
        this.mRect.set(-radius, -radius, radius, radius);
        this.mPerceptionAreaDrawable.setSize((int)radius * 2, (int)radius * 2);
        float offsetX = (float)(Math.sin(Math.PI * (double)perceptionAngleEach / 2.0 / 180.0) * (double)radius);
        float offsetY = (float)(Math.cos(Math.PI * (double)perceptionAngleEach / 2.0 / 180.0) * (double)radius);
        this.mPath.reset();
        this.mPath.lineTo(offsetX, -offsetY);
        offsetX = (float)(Math.sin(Math.PI * (double)(360.0f - (float)perceptionAngleEach / 2.0f) / 180.0) * (double)radius);
        offsetY = (float)(Math.cos(Math.PI * (double)(360.0f - (float)perceptionAngleEach / 2.0f) / 180.0) * (double)radius);
        this.mPath.lineTo(offsetX, -offsetY);
        this.mPath.close();
        this.mPath.addArc(this.mRect, 270.0f - (float)perceptionAngleEach / 2.0f, (float)perceptionAngleEach);
        for (int i = 0; i < 4; ++i) {
            canvas.save();
            boolean visionEnable = this.mVisionPerceptionEnableState[i];
            if (!this.isHidePerceptionBg) {
                this.drawPerceptionBg(canvas, paint, i, visionEnable, radius, perceptionAngleEach);
            }
            if (this.isUserDisable() || this.mPerceptionNotWorkMode || !visionEnable && this.mShowVisualPerceptionInfo) {
                boolean isTof = this.mToFPerceptionEnableState[i];
                paint.setTextSize((float)this.mPerceptionDisabledTextSize);
                paint.setTextAlign(Paint.Align.CENTER);
                String text = this.getPerceptionStatusText(isTof);
                paint.getTextBounds(text, 0, text.length(), HSIView.RECT);
                Paint.FontMetrics fontMetrics = paint.getFontMetrics();
                float baselineOffsetY = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
                canvas.save();
                canvas.translate(0.0f, -(radius + (float)this.mHSIContainer.getAircraftSize()) / 2.0f);
                canvas.rotate(-90.0f * (float)i);
                int textColor = this.getPerceptionTextColor(isTof);
                this.drawTextWithStroke(canvas, text, baselineOffsetY, this.mStrokeConfig.getStrokeBoldWidth(), this.mStrokeConfig.getStrokeDeepColor(), textColor, paint);
                canvas.restore();
            }
            canvas.restore();
            canvas.rotate((float)perceptionAngleEach + (float)this.mOmniAbility.getPerceptionBlindAreaAngle() * 1.0f);
        }
        canvas.restore();
    }

    private void drawPerceptionBg(Canvas canvas, Paint paint, int index, boolean visionEnable, float radius, int perceptionAngleEach) {
        if (this.isUserDisable() || !this.mPerceptionNotWorkMode && (visionEnable || !this.mShowVisualPerceptionInfo)) {
            canvas.clipPath(this.mPath);
            this.mPerceptionAreaDrawable.setBounds((int)(-radius), (int)(-radius), (int)radius, 0);
            this.mPerceptionAreaDrawable.draw(canvas);
        } else {
            boolean isTof = this.mToFPerceptionEnableState[index];
            paint.setStyle(Paint.Style.FILL);
            paint.setShader(this.getPerceptionDisabledShader(radius, isTof));
            canvas.drawArc(this.mRect, 270.0f - (float)perceptionAngleEach / 2.0f, (float)perceptionAngleEach, true, paint);
            paint.setStyle(Paint.Style.FILL);
            paint.setShader(null);
        }
    }

    private void fixAlpha(Paint paint) {
        paint.setAlpha(255);
    }

    private int getPerceptionTextColor(boolean isTof) {
        if (!this.isUserDisable() && isTof && this.mSupportTof) {
            return this.mWarnColor;
        }
        return this.mDangerColor;
    }

    @NonNull
    private String getPerceptionStatusText(boolean isTof) {
        if (this.isUserDisable()) {
            return PERCEPTION_USER_DISABLE;
        }
        if (isTof && this.mSupportTof) {
            return PERCEPTION_TOF_ONLY;
        }
        return PERCEPTION_DISABLED;
    }

    protected void drawTextWithStroke(Canvas canvas, String text, float baseline, float strokeWidth, int strokeColor, int textColor, Paint paint) {
        paint.setStrokeWidth(strokeWidth);
        paint.setColor(strokeColor);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawText(text, 0.0f, baseline, paint);
        paint.setColor(textColor);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawText(text, 0.0f, baseline, paint);
    }

    public Shader getPerceptionDisabledShader(float radius, boolean isTof) {
        Shader result;
        if (isTof && this.mSupportTof) {
            if (this.mTofShader == null) {
                this.mTofShader = this.createLinearShader(radius, this.mWarnColor);
            }
            result = this.mTofShader;
        } else {
            if (this.mNaShader == null) {
                this.mNaShader = this.createLinearShader(radius, this.mDangerColor);
            }
            result = this.mNaShader;
        }
        return result;
    }

    @NonNull
    private LinearGradient createLinearShader(float radius, int warnColor) {
        int centerColor = ColorUtils.setAlphaComponent((int)warnColor, (int)20);
        int outerColor = ColorUtils.setAlphaComponent((int)warnColor, (int)64);
        return new LinearGradient(0.0f, 0.0f, 0.0f, -radius, centerColor, outerColor, Shader.TileMode.CLAMP);
    }

    private void drawBarrier(Canvas canvas, Paint paint, int compassSize) {
        if (this.mHSIContainer == null) {
            return;
        }
        if (this.mShapeList.isEmpty()) {
            return;
        }
        float calibrationAreaWidth = this.mHSIContainer.getCalibrationAreaWidth();
        float radius = (float)compassSize / 2.0f - calibrationAreaWidth - this.mHSIContainer.getCompassBitmapOffset();
        int perceptionAngleEach = 90;
        for (Shape shape : this.mShapeList) {
            canvas.save();
            int fromAngle = shape.mFromAngle;
            boolean skip = this.mPerceptionNotWorkMode;
            if (!skip) {
                skip = this.calcSkip(perceptionAngleEach, fromAngle);
            }
            if (!skip) {
                if (shape instanceof PathShape) {
                    canvas.rotate((float)shape.mFromAngle);
                    paint.setStyle(Paint.Style.FILL);
                    paint.setColor(shape.mColor);
                    canvas.drawPath(((PathShape)shape).mPath, paint);
                    mPathPool.recycle(((PathShape)shape).mPath);
                } else if (shape instanceof ArcShape) {
                    canvas.rotate((float)shape.mFromAngle);
                    paint.setColor(shape.mColor);
                    paint.setStyle(Paint.Style.STROKE);
                    float lastStrokeWidth = paint.getStrokeWidth();
                    paint.setStrokeWidth((float)this.mMaxPerceptionStrokeWidth);
                    float arcRadius = radius - (float)this.mMaxPerceptionStrokeWidth / 2.0f;
                    canvas.drawArc(-arcRadius, -arcRadius, arcRadius, arcRadius, 270.0f, (float)((ArcShape)shape).mToAngle * 1.0f - (float)shape.mFromAngle * 1.0f, false, paint);
                    paint.setStrokeWidth(lastStrokeWidth);
                }
            }
            canvas.restore();
        }
    }

    private boolean calcSkip(int perceptionAngleEach, int fromAngle) {
        boolean skip = false;
        if (fromAngle > perceptionAngleEach * 7 / 2 || fromAngle < perceptionAngleEach / 2) {
            skip = !this.mVisionPerceptionEnableState[0] && !this.mToFPerceptionEnableState[0];
        } else if (fromAngle > perceptionAngleEach / 2 && fromAngle < perceptionAngleEach * 3 / 2) {
            skip = !this.mVisionPerceptionEnableState[1] && !this.mToFPerceptionEnableState[1];
        } else if (fromAngle > perceptionAngleEach * 3 / 2 && fromAngle < perceptionAngleEach * 5 / 2) {
            skip = !this.mVisionPerceptionEnableState[2] && !this.mToFPerceptionEnableState[2];
        } else if (fromAngle > perceptionAngleEach * 5 / 2 && fromAngle < perceptionAngleEach * 7 / 2) {
            skip = !this.mVisionPerceptionEnableState[3] && !this.mToFPerceptionEnableState[3];
        }
        return skip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawRadarBarrier(Canvas canvas, Paint paint, int compassSize) {
        if (this.mHSIContainer == null) {
            return;
        }
        if (this.mRadarShapeList.isEmpty()) {
            return;
        }
        float calibrationAreaWidth = this.mHSIContainer.getCalibrationAreaWidth();
        float radius = (float)compassSize / 2.0f - calibrationAreaWidth - this.mHSIContainer.getCompassBitmapOffset();
        List<Shape> list = this.mRadarShapeList;
        synchronized (list) {
            for (Shape shape : this.mRadarShapeList) {
                canvas.save();
                if (shape instanceof PathShape) {
                    canvas.rotate((float)shape.mFromAngle + -15.0f);
                    paint.setStyle(Paint.Style.FILL);
                    paint.setColor(shape.mColor);
                    canvas.drawPath(((PathShape)shape).mPath, paint);
                    mRadarPathPool.recycle(((PathShape)shape).mPath);
                } else if (shape instanceof ArcShape) {
                    canvas.rotate((float)shape.mFromAngle + -15.0f);
                    paint.setColor(shape.mColor);
                    paint.setStyle(Paint.Style.STROKE);
                    float lastStrokeWidth = paint.getStrokeWidth();
                    paint.setStrokeWidth((float)this.mRadarMaxPerceptionStrokeWidth);
                    float arcRadius = radius - (float)this.mRadarMaxPerceptionStrokeWidth / 2.0f;
                    canvas.drawArc(-arcRadius, -arcRadius, arcRadius, arcRadius, 270.0f, (float)((ArcShape)shape).mToAngle - (float)shape.mFromAngle * 1.0f, false, paint);
                    paint.setStrokeWidth(lastStrokeWidth);
                }
                canvas.restore();
            }
        }
    }

    private List<Shape> updatePerceptionDrawShape(List<Integer> horizontalBarrierDistance) {
        if (horizontalBarrierDistance.size() == 0) {
            return new ArrayList<Shape>();
        }
        int perceptionAngleTotal = 360 - 4 * this.mOmniAbility.getPerceptionBlindAreaAngle();
        int perceptionAngleEach = perceptionAngleTotal / 4;
        int rotationOffset = 360 / horizontalBarrierDistance.size();
        int startOffset = -perceptionAngleEach / rotationOffset / 2;
        return this.updateDrawShape(horizontalBarrierDistance, startOffset, this.mPerceptionLevelColor);
    }

    private List<Shape> updateRadarDrawShape(List<Integer> horizontalBarrierDistance) {
        if (horizontalBarrierDistance == null || horizontalBarrierDistance.size() == 0) {
            return new ArrayList<Shape>();
        }
        Thread currentThread = Thread.currentThread();
        LogUtils.d((String)TAG, (Object[])new Object[]{"updateRadarDrawShape " + horizontalBarrierDistance.get(0) + ". Current thread is " + currentThread.getName() + " " + currentThread.getId()});
        long preTime = System.currentTimeMillis();
        List<Shape> result = this.updateDrawShape2(horizontalBarrierDistance, 0, this.mRadarLevelColor);
        LogUtils.d((String)TAG, (Object[])new Object[]{"updateRadarDrawShape take " + (System.currentTimeMillis() - preTime)});
        return result;
    }

    private List<Shape> updateDrawShape2(List<Integer> horizontalBarrierDistance, int startOffset, int[] levelColor) {
        ArrayList<Shape> shapeList = new ArrayList<Shape>();
        if (this.mHSIContainer == null) {
            return shapeList;
        }
        int rotationOffset = 360 / horizontalBarrierDistance.size();
        int offset = this.mHSIContainer.getAircraftSize() / 2;
        int visibleDistanceInHsi = this.mHSIContainer.getVisibleDistanceInHsiInMeters();
        float calibrationAreaWidth = this.mHSIContainer.getCalibrationAreaWidth();
        float radius = (float)this.mCompassSize / 2.0f - calibrationAreaWidth - this.mHSIContainer.getCompassBitmapOffset();
        float minDistanceInMeter = 2.1474836E9f;
        PathShape lastShape = null;
        float barrierRotation = 0.0f;
        Path path1 = (Path)mRadarPathPool.acquire();
        path1.reset();
        for (int i = 0; i < horizontalBarrierDistance.size(); ++i) {
            int angle = i + startOffset;
            angle = angle < 0 ? angle + horizontalBarrierDistance.size() : angle;
            float distanceInMeter = (float)horizontalBarrierDistance.get(angle).intValue() / 1000.0f;
            if (distanceInMeter >= (float)visibleDistanceInHsi) {
                if (distanceInMeter <= (float)this.mOmniAbility.getHorizontalDetectionCapability()) {
                    int color2 = distanceInMeter > this.mHorizontalPerceptionDistance ? levelColor[0] : levelColor[1];
                    ArcShape shape = new ArcShape(angle * rotationOffset);
                    shape.mColor = color2;
                    shape.mToAngle += rotationOffset;
                    shapeList.add(shape);
                }
            } else {
                float c = (float)offset + distanceInMeter / (float)visibleDistanceInHsi * (radius - (float)offset);
                if (barrierRotation == 0.0f) {
                    lastShape = new PathShape(angle * rotationOffset);
                    path1.reset();
                    path1.lineTo(0.0f, -c);
                }
                double sin = Math.sin(Math.PI * (double)(barrierRotation += (float)rotationOffset) / 180.0);
                double cos = Math.cos(Math.PI * (double)barrierRotation / 180.0);
                float offsetX = (float)(sin * (double)c);
                float offsetY = (float)(cos * (double)c);
                path1.lineTo(offsetX, -offsetY);
                if (distanceInMeter < minDistanceInMeter) {
                    minDistanceInMeter = distanceInMeter;
                }
            }
            if (!(distanceInMeter >= (float)visibleDistanceInHsi) && i != horizontalBarrierDistance.size() - 1 || path1.isEmpty() || lastShape == null) continue;
            path1.close();
            Path path2 = (Path)mRadarPathPool.acquire();
            path2.reset();
            path2.addArc(-radius, -radius, radius, radius, 270.0f, barrierRotation);
            path2.lineTo(0.0f, 0.0f);
            path2.close();
            LogUtils.d((String)TAG, (Object[])new Object[]{"updateRadar2 op 1 size=" + shapeList.size() + " " + minDistanceInMeter});
            path2.op(path1, Path.Op.DIFFERENCE);
            LogUtils.d((String)TAG, (Object[])new Object[]{"updateRadar2 op 2"});
            int areaColor = minDistanceInMeter > this.mHorizontalPerceptionDistance ? levelColor[0] : (minDistanceInMeter > this.mHorizontalBarrierAvoidanceDistance + 2.0f ? levelColor[1] : levelColor[2]);
            PathShape pathShape = lastShape;
            pathShape.mColor = areaColor;
            pathShape.mPath = path2;
            barrierRotation = 0.0f;
            shapeList.add(pathShape);
            path1.reset();
            lastShape = null;
            minDistanceInMeter = 2.1474836E9f;
        }
        mRadarPathPool.recycle(path1);
        return shapeList;
    }

    private List<Shape> updateDrawShape(List<Integer> horizontalBarrierDistance, int startOffset, int[] levelColor) {
        ArrayList<Shape> shapeList = new ArrayList<Shape>();
        if (this.mHSIContainer == null) {
            return shapeList;
        }
        int rotationOffset = 360 / horizontalBarrierDistance.size();
        int offset = this.mHSIContainer.getAircraftSize() / 2;
        int visibleDistanceInHsi = this.mHSIContainer.getVisibleDistanceInHsiInMeters();
        float calibrationAreaWidth = this.mHSIContainer.getCalibrationAreaWidth();
        float radius = (float)this.mCompassSize / 2.0f - calibrationAreaWidth - this.mHSIContainer.getCompassBitmapOffset();
        float minDistanceInMeter = 2.1474836E9f;
        PathShape lastShape = null;
        float barrierRotation = 0.0f;
        Path path1 = (Path)mPathPool.acquire();
        path1.reset();
        for (int i = 0; i < horizontalBarrierDistance.size(); ++i) {
            int angle = i + startOffset;
            angle = angle < 0 ? angle + horizontalBarrierDistance.size() : angle;
            float distanceInMeter = (float)horizontalBarrierDistance.get(angle).intValue() / 1000.0f;
            if (distanceInMeter >= (float)visibleDistanceInHsi) {
                if (distanceInMeter <= (float)this.mOmniAbility.getHorizontalDetectionCapability()) {
                    int color2 = distanceInMeter > this.mHorizontalPerceptionDistance ? levelColor[0] : levelColor[1];
                    ArcShape shape = new ArcShape(angle * rotationOffset);
                    shape.mColor = color2;
                    shape.mToAngle += rotationOffset;
                    shapeList.add(shape);
                }
            } else {
                float c = (float)offset + distanceInMeter / (float)visibleDistanceInHsi * (radius - (float)offset);
                if (barrierRotation == 0.0f) {
                    lastShape = new PathShape(angle * rotationOffset);
                    path1.reset();
                    path1.lineTo(0.0f, -c);
                }
                double sin = Math.sin(Math.PI * (double)(barrierRotation += (float)rotationOffset) / 180.0);
                double cos = Math.cos(Math.PI * (double)barrierRotation / 180.0);
                float offsetX = (float)(sin * (double)c);
                float offsetY = (float)(cos * (double)c);
                path1.lineTo(offsetX, -offsetY);
                if (distanceInMeter < minDistanceInMeter) {
                    minDistanceInMeter = distanceInMeter;
                }
            }
            if (!(distanceInMeter >= (float)visibleDistanceInHsi) && i != horizontalBarrierDistance.size() - 1 || path1.isEmpty() || !(lastShape instanceof PathShape)) continue;
            path1.close();
            Path path2 = (Path)mPathPool.acquire();
            path2.reset();
            path2.addArc(-radius, -radius, radius, radius, 270.0f, barrierRotation);
            path2.lineTo(0.0f, 0.0f);
            path2.close();
            path2.op(path1, Path.Op.DIFFERENCE);
            int areaColor = minDistanceInMeter > this.mHorizontalPerceptionDistance ? levelColor[0] : (minDistanceInMeter > this.mHorizontalBarrierAvoidanceDistance + 2.0f ? levelColor[1] : levelColor[2]);
            PathShape pathShape = lastShape;
            pathShape.mColor = areaColor;
            pathShape.mPath = path2;
            barrierRotation = 0.0f;
            shapeList.add(pathShape);
            path1.reset();
            lastShape = null;
            minDistanceInMeter = 2.1474836E9f;
        }
        mPathPool.recycle(path1);
        return shapeList;
    }

    private static class Shape {
        int mFromAngle;
        int mColor;

        public Shape(int fromAngle) {
            this.mFromAngle = fromAngle;
        }
    }

    private static class PathShape
    extends Shape {
        Path mPath;

        public PathShape(int fromAngle) {
            super(fromAngle);
        }

        public String toString() {
            return "PathShape{mFromAngle=" + this.mFromAngle + '}';
        }
    }

    private static class PathPool
    extends RecyclerPool<Path> {
        public PathPool(int maxPoolSize) {
            super(maxPoolSize);
        }

        @Override
        @NonNull
        protected Path create() {
            return new Path();
        }
    }

    private static class ArcShape
    extends Shape {
        int mToAngle;

        public ArcShape(int fromAngle) {
            super(fromAngle);
            this.mToAngle = fromAngle;
        }

        public String toString() {
            return "ArcShape{mFromAngle=" + this.mFromAngle + ", mToAngle=" + this.mToAngle + '}';
        }
    }
}

