/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.communication;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.common.error.IDJIError;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.UXSDKError;
import dji.v5.ux.core.base.UXSDKErrorDescription;
import dji.v5.ux.core.communication.BroadcastValues;
import dji.v5.ux.core.communication.FlatStore;
import dji.v5.ux.core.communication.GlobalPreferenceKeys;
import dji.v5.ux.core.communication.MessagingKeys;
import dji.v5.ux.core.communication.ModelValue;
import dji.v5.ux.core.communication.ObservableKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.processors.PublishProcessor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ObservableInMemoryKeyedStore
implements ObservableKeyedStore {
    private static final int INITIAL_CAPACITY = 100;
    private final ConcurrentHashMap<String, PublishProcessor<BroadcastValues>> keyStringProcessorMap;
    private final FlatStore store;
    private final Lock lock = new ReentrantLock();

    private ObservableInMemoryKeyedStore() {
        this.keyStringProcessorMap = new ConcurrentHashMap(100);
        this.store = FlatStore.getInstance();
        UXKeys.addNewKeyClass(GlobalPreferenceKeys.class);
        UXKeys.addNewKeyClass(MessagingKeys.class);
    }

    public static ObservableInMemoryKeyedStore getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Flowable<BroadcastValues> addObserver(@NonNull UXKey key) {
        this.lock.lock();
        try {
            PublishProcessor processor = this.keyStringProcessorMap.get(key.getKeyPath());
            if (processor == null) {
                processor = PublishProcessor.create();
            }
            this.keyStringProcessorMap.put(key.getKeyPath(), (PublishProcessor<BroadcastValues>)processor);
            Flowable flowable = processor.observeOn(SchedulerProvider.computation()).onBackpressureLatest();
            return flowable;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeObserver(@NonNull Disposable disposable, @NonNull UXKey key) {
        if (!disposable.isDisposed()) {
            disposable.dispose();
        }
    }

    @Override
    public void removeAllObserversForKey(@NonNull UXKey key) {
        this.lock.lock();
        try {
            PublishProcessor<BroadcastValues> removedProcessor = this.keyStringProcessorMap.remove(key.getKeyPath());
            if (removedProcessor != null) {
                removedProcessor.onComplete();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeAllObservers() {
        this.lock.lock();
        try {
            for (PublishProcessor<BroadcastValues> processorToRemove : this.keyStringProcessorMap.values()) {
                processorToRemove.onComplete();
            }
            this.keyStringProcessorMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getValue(@NonNull UXKey key) {
        this.lock.lock();
        try {
            ModelValue value = this.store.getModelValue(key.getKeyPath());
            if (value != null) {
                Object object = value.getData();
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Completable setValue(@NonNull UXKey key, @NonNull Object value) {
        this.lock.lock();
        try {
            Completable completable = Completable.create(emitter -> {
                if (value.getClass().equals(key.getValueType())) {
                    ModelValue previousValue = this.store.getModelValue(key.getKeyPath());
                    if (key.getUpdateType() == UXKeys.UpdateType.ON_EVENT || key.getUpdateType() == UXKeys.UpdateType.ON_CHANGE && (previousValue == null || !previousValue.getData().equals(value))) {
                        PublishProcessor<BroadcastValues> processor;
                        ModelValue currentValue = new ModelValue(value);
                        this.store.setModelValue(currentValue, key.getKeyPath());
                        if (this.keyStringProcessorMap.containsKey(key.getKeyPath()) && (processor = this.keyStringProcessorMap.get(key.getKeyPath())) != null) {
                            processor.onNext((Object)new BroadcastValues(previousValue, currentValue));
                        }
                    }
                    emitter.onComplete();
                } else {
                    emitter.onError((Throwable)new UXSDKError((IDJIError)UXSDKErrorDescription.FACTORY.build("The value type of the object does not match the value type of the key.")));
                }
            }).subscribeOn(SchedulerProvider.computation());
            return completable;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class SingletonHolder {
        private static final ObservableInMemoryKeyedStore instance = new ObservableInMemoryKeyedStore();

        private SingletonHolder() {
        }
    }
}

