/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.sample.util;

import dji.sdk.keyvalue.value.common.LocationCoordinate3D;
import dji.v5.common.utils.GpsUtils;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneInformation;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Ldji/v5/ux/sample/util/FlySafeMapUtil;", "", "<init>", "()V", "sortFlyZonesByDistanceFromAircraft", "", "aircraftLocation", "Ldji/sdk/keyvalue/value/common/LocationCoordinate3D;", "flyZones", "", "Ldji/v5/manager/aircraft/flysafe/info/FlyZoneInformation;", "android-sdk-v5-uxsdk_debug"})
public final class FlySafeMapUtil {
    @NotNull
    public static final FlySafeMapUtil INSTANCE = new FlySafeMapUtil();

    private FlySafeMapUtil() {
    }

    public final void sortFlyZonesByDistanceFromAircraft(@NotNull LocationCoordinate3D aircraftLocation, @NotNull List<FlyZoneInformation> flyZones) {
        Intrinsics.checkNotNullParameter((Object)aircraftLocation, (String)"aircraftLocation");
        Intrinsics.checkNotNullParameter(flyZones, (String)"flyZones");
        Comparator c = (arg_0, arg_1) -> FlySafeMapUtil.sortFlyZonesByDistanceFromAircraft$lambda$0(aircraftLocation, arg_0, arg_1);
        CollectionsKt.sortWith(flyZones, (Comparator)c);
    }

    private static final int sortFlyZonesByDistanceFromAircraft$lambda$0(LocationCoordinate3D $aircraftLocation, FlyZoneInformation o1, FlyZoneInformation o2) {
        Double d = $aircraftLocation.getLatitude();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getLatitude(...)");
        double d2 = ((Number)d).doubleValue();
        Double d3 = $aircraftLocation.getLongitude();
        Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"getLongitude(...)");
        double d4 = ((Number)d3).doubleValue();
        Double d5 = o1.getCircleCenter().getLatitude();
        Intrinsics.checkNotNullExpressionValue((Object)d5, (String)"getLatitude(...)");
        double d6 = ((Number)d5).doubleValue();
        Double d7 = o1.getCircleCenter().getLongitude();
        Intrinsics.checkNotNullExpressionValue((Object)d7, (String)"getLongitude(...)");
        double distanceO1 = (double)GpsUtils.distanceBetween((double)d2, (double)d4, (double)d6, (double)((Number)d7).doubleValue()) - o1.getCircleRadius();
        Double d8 = $aircraftLocation.getLatitude();
        Intrinsics.checkNotNullExpressionValue((Object)d8, (String)"getLatitude(...)");
        double d9 = ((Number)d8).doubleValue();
        Double d10 = $aircraftLocation.getLongitude();
        Intrinsics.checkNotNullExpressionValue((Object)d10, (String)"getLongitude(...)");
        double d11 = ((Number)d10).doubleValue();
        Double d12 = o2.getCircleCenter().getLatitude();
        Intrinsics.checkNotNullExpressionValue((Object)d12, (String)"getLatitude(...)");
        double d13 = ((Number)d12).doubleValue();
        Double d14 = o2.getCircleCenter().getLongitude();
        Intrinsics.checkNotNullExpressionValue((Object)d14, (String)"getLongitude(...)");
        double distanceO2 = (double)GpsUtils.distanceBetween((double)d9, (double)d11, (double)d13, (double)((Number)d14).doubleValue()) - o2.getCircleRadius();
        return Double.compare(distanceO1, distanceO2);
    }
}

