/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.remotecontroller.calibration.stick;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import android.widget.TextView;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.value.remotecontroller.RcCalibrateState;
import dji.sdk.keyvalue.value.remotecontroller.RemoteControllerType;
import dji.v5.manager.KeyManager;
import dji.v5.utils.dpad.DpadProductManager;
import dji.v5.ux.R;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.remotecontroller.RcCalibrationWidgetModel;
import dji.v5.ux.remotecontroller.calibration.IRcCalibrationView;
import dji.v5.ux.remotecontroller.calibration.OnCalibrationListener;
import dji.v5.ux.remotecontroller.calibration.stick.HallStickCalibrationView;
import dji.v5.ux.remotecontroller.calibration.stick.RcCalibrationRollView;
import dji.v5.ux.remotecontroller.calibration.stick.StickState;
import io.reactivex.rxjava3.disposables.CompositeDisposable;

public class StickCalibrationView
extends LinearLayout
implements IRcCalibrationView {
    private static final int ITEM_LEFT = 0;
    private static final int ITEM_RIGHT = 1;
    private static final int MAX_CALIBRATION_STATUS = Short.MAX_VALUE;
    protected RcCalibrationWidgetModel rcCalibrationWidgetModel;
    LinearLayout mSmartControllerLayout;
    HallStickCalibrationView mLeftJoystick;
    HallStickCalibrationView mRightJoystick;
    LinearLayout mRcPlusLayout;
    RcCalibrationRollView mRcPlusLeftJoystick;
    RcCalibrationRollView mRcPlusRightJoystick;
    TextView mRcCalibrationDes;
    private boolean mIsStickCalibrated = false;
    private boolean isDjiRcPlus = false;
    private OnCalibrationListener mListener = null;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();

    public StickCalibrationView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.mSmartControllerLayout = (LinearLayout)this.findViewById(R.id.ll_rc_smart_controller);
        this.mLeftJoystick = (HallStickCalibrationView)this.findViewById(R.id.mavic_rc_calibration_left_joystick_square);
        this.mRightJoystick = (HallStickCalibrationView)this.findViewById(R.id.mavic_rc_calibration_right_joystick_square);
        this.mRcPlusLayout = (LinearLayout)this.findViewById(R.id.ll_rc_puls);
        this.mRcPlusLeftJoystick = (RcCalibrationRollView)this.findViewById(R.id.rc_plus_calibration_left_joystick_square);
        this.mRcPlusRightJoystick = (RcCalibrationRollView)this.findViewById(R.id.rc_plus_calibration_right_joystick_square);
        this.mRcCalibrationDes = (TextView)this.findViewById(R.id.tv_rc_calibration_des);
        if (this.isDjiRcPlus() || this.isDjiRcPro()) {
            this.isDjiRcPlus = true;
        }
        if (this.isDjiRcPlus) {
            this.mRcCalibrationDes.setText(R.string.uxsdk_setting_ui_rc_plus_calibration_1);
            this.mSmartControllerLayout.setVisibility(8);
            this.mRcPlusLayout.setVisibility(0);
        } else {
            this.mSmartControllerLayout.setVisibility(0);
            this.mRcPlusLayout.setVisibility(8);
        }
    }

    private void listenSmartControllerCalibrationState() {
        this.mCompositeDisposable.add(this.rcCalibrationWidgetModel.rcCalibrateStateDataProcessor.toFlowable().subscribeOn(SchedulerProvider.ui()).subscribe(state -> {
            if (this.isDjiRcPlus && state == RcCalibrateState.RECORDCENTER) {
                this.mRcPlusLeftJoystick.resetLimit();
                this.mRcPlusRightJoystick.resetLimit();
                this.mIsStickCalibrated = true;
            }
            if (state == RcCalibrateState.TIMEOUT_EXIT) {
                this.reset();
            }
        }));
        this.mCompositeDisposable.add(this.rcCalibrationWidgetModel.connectDataProcessor.toFlowable().subscribe(connect -> {
            if (connect != null && !connect.booleanValue()) {
                this.reset();
            }
        }));
    }

    private void listenStickState() {
        this.rcCalibrationWidgetModel.stickStateDataProcessor.toFlowableOnUI().subscribe(stickState -> {
            if (stickState.calibrationState == RcCalibrateState.TIMEOUT_EXIT || !stickState.isConnection) {
                this.reset();
                return;
            }
            if (this.isCalibrated()) {
                return;
            }
            this.onStickState((StickState)stickState);
        });
    }

    private void onStickState(StickState state) {
        if (!this.isDjiRcPlus) {
            this.mLeftJoystick.setSegmentNum(state.segmentNum);
            this.mRightJoystick.setSegmentNum(state.segmentNum);
            if (this.mLeftJoystick.hasSegNumSet() && this.mRightJoystick.hasSegNumSet() && state.calibrationState == RcCalibrateState.LIMITVALUE) {
                this.mRightJoystick.setProgress(state.rightLeft, state.rightTop, state.rightRight, state.rightBottom);
                this.mLeftJoystick.setProgress(state.leftLeft, state.leftTop, state.leftRight, state.leftBottom);
            }
        }
        if (state.rightLeft == Short.MAX_VALUE && state.rightTop == Short.MAX_VALUE && state.rightRight == Short.MAX_VALUE && state.rightBottom == Short.MAX_VALUE && state.leftLeft == Short.MAX_VALUE && state.leftTop == Short.MAX_VALUE && state.leftRight == Short.MAX_VALUE && state.leftBottom == Short.MAX_VALUE) {
            this.mIsStickCalibrated = true;
            if (this.isCalibrated() && this.mListener != null) {
                this.mListener.onCalibrationFinished(1);
            }
        }
    }

    private void updateByStop() {
        this.updateStick(0, 0, 0);
        this.updateStick(1, 0, 0);
    }

    private void updateStick(int item, int vertical, int horizontal) {
        int vPgb = this.transformValue(vertical);
        int hPgb = this.transformValue(horizontal);
        if (this.isDjiRcPlus) {
            RcCalibrationRollView stickView = null;
            stickView = 0 == item ? this.mRcPlusLeftJoystick : this.mRcPlusRightJoystick;
            stickView.setProgress(hPgb, vPgb);
            if (this.mRcPlusLeftJoystick.isGetLimit() && this.mRcPlusRightJoystick.isGetLimit()) {
                this.updateViewByMode(RcCalibrateState.LIMITVALUE);
            }
        } else {
            HallStickCalibrationView stickView = null;
            stickView = 0 == item ? this.mLeftJoystick : this.mRightJoystick;
            stickView.setCircleCenter(this.getAbsValue(hPgb), Math.max(vPgb, 0), Math.max(hPgb, 0), this.getAbsValue(vPgb));
        }
    }

    private int getAbsValue(int value) {
        return value < 0 ? -value : 0;
    }

    private int transformValue(int value) {
        return (int)((float)value / 6.6f);
    }

    protected void onDetachedFromWindow() {
        this.updateByStop();
        this.mCompositeDisposable.dispose();
        super.onDetachedFromWindow();
    }

    @Override
    public void updateViewByMode(RcCalibrateState mode) {
        if (this.mIsStickCalibrated && this.mListener != null) {
            this.mIsStickCalibrated = false;
            this.mListener.onCalibrationFinished(1);
        }
    }

    @Override
    public void setListener(OnCalibrationListener listener2) {
        this.mListener = listener2;
    }

    public void setViewModel(RcCalibrationWidgetModel rcCalibrationWidgetModel) {
        this.rcCalibrationWidgetModel = rcCalibrationWidgetModel;
        this.mCompositeDisposable.add(rcCalibrationWidgetModel.leftStickValueDataProcessor.toFlowableOnUI().subscribe(stickValue -> this.updateStick(0, stickValue.vertical, stickValue.horizontal)));
        this.mCompositeDisposable.add(rcCalibrationWidgetModel.rightStickValueDataProcessor.toFlowableOnUI().subscribe(stickValue -> this.updateStick(1, stickValue.vertical, stickValue.horizontal)));
        this.listenSmartControllerCalibrationState();
        this.listenStickState();
    }

    @Override
    public void removeListener() {
        this.mListener = null;
    }

    @Override
    public boolean isCalibrated() {
        return this.mIsStickCalibrated;
    }

    @Override
    public void reset() {
        this.mLeftJoystick.reset();
        this.mRightJoystick.reset();
        this.mIsStickCalibrated = false;
        this.mRcPlusLeftJoystick.resetLimit();
        this.mRcPlusRightJoystick.resetLimit();
        if (this.mListener != null) {
            this.mListener.onCalibrationCanceled(1);
        }
    }

    private boolean isDjiRcPlus() {
        if (DpadProductManager.getInstance().isDjiRcPlus()) {
            return true;
        }
        return KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRemoteControllerType), (Object)RemoteControllerType.UNKNOWN) == RemoteControllerType.DJI_RC_PLUS;
    }

    private boolean isDjiRcPro() {
        if (DpadProductManager.getInstance().isSmartController()) {
            return true;
        }
        return KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRemoteControllerType), (Object)RemoteControllerType.UNKNOWN) == RemoteControllerType.DJI_RC_PRO;
    }
}

