/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.Group;
import androidx.core.content.ContextCompat;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.sdk.keyvalue.value.battery.BatteryConnectionState;
import dji.sdk.keyvalue.value.battery.BatteryException;
import dji.sdk.keyvalue.value.battery.BatteryOverviewValue;
import dji.sdk.keyvalue.value.battery.BatterySelfCheckState;
import dji.sdk.keyvalue.value.battery.IndustryBatteryType;
import dji.v5.common.utils.UnitUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.popover.Popover;
import dji.v5.ux.core.widget.battery.BatteryCellView;
import dji.v5.ux.core.widget.battery.BatteryInfoWidgetModel;
import java.util.List;
import java.util.Locale;

public class BatteryInfoWidget
extends ConstraintLayoutWidget<Object> {
    private static final String SEPARATOR = ",";
    protected BatteryInfoWidgetModel widgetModel = new BatteryInfoWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    protected TextView batteryHighVoltageSave;
    protected ImageView batteryHighVoltageHint;
    protected TextView batteryCycleTime;
    protected TextView batteryVoltage;
    protected TextView batteryTemperature;
    protected TextView batteryChargeRemaining;
    protected TextView batteryStatus;
    protected TextView battery;
    protected TextView serialNumber;
    protected TextView productionDate;
    protected ViewGroup cellsLayout;
    protected ViewGroup batteryBottomLayout;
    protected Group highVoltage;
    protected int temperatureType = 1;
    protected float temperatureValue = 0.0f;
    protected boolean supportHighVoltageHint = false;
    protected boolean isConnected;
    protected int batteryCount;
    protected IndustryBatteryType batteryType;
    protected BatteryConnectionState batteryConnectionState;
    protected BatteryException warningRecord;

    public BatteryInfoWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BatteryInfoWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BatteryInfoWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        BatteryInfoWidget.inflate((Context)context, (int)R.layout.uxsdk_view_battery_info, (ViewGroup)this);
        this.batteryHighVoltageSave = (TextView)this.findViewById(R.id.setting_menu_battery_high_voltage_save_value_tv);
        this.batteryHighVoltageHint = (ImageView)this.findViewById(R.id.icon_high_voltage);
        this.batteryCycleTime = (TextView)this.findViewById(R.id.setting_menu_battery_cycle_time_value_tv);
        this.batteryVoltage = (TextView)this.findViewById(R.id.setting_menu_battery_voltage_value_tv);
        this.batteryTemperature = (TextView)this.findViewById(R.id.setting_menu_battery_temperature_value_tv);
        this.batteryChargeRemaining = (TextView)this.findViewById(R.id.setting_menu_battery_charge_remain_value_tv);
        this.batteryStatus = (TextView)this.findViewById(R.id.setting_menu_battery_status);
        this.battery = (TextView)this.findViewById(R.id.setting_menu_battery_tv);
        this.serialNumber = (TextView)this.findViewById(R.id.setting_menu_battery_sn);
        this.productionDate = (TextView)this.findViewById(R.id.setting_menu_battery_production_date);
        this.highVoltage = (Group)this.findViewById(R.id.group_high_voltage);
        this.cellsLayout = (ViewGroup)this.findViewById(R.id.setting_menu_battery_cells_view_stub);
        this.batteryBottomLayout = (ViewGroup)this.findViewById(R.id.setting_menu_battery_bottom_view);
        this.setBackgroundResource(R.drawable.uxsdk_background_fpv_setting);
        this.showHighVoltage(this.supportHighVoltage());
        this.batteryHighVoltageHint.setOnClickListener(v -> {
            int[] outLocation = new int[2];
            this.batteryHighVoltageHint.getLocationOnScreen(outLocation);
            int heightPixels = this.getResources().getDisplayMetrics().heightPixels;
            Popover.Position pos = outLocation[1] > heightPixels / 2 ? Popover.Position.TOP : Popover.Position.BOTTOM;
            int color2 = ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_fpv_popover_content_background_color);
            new Popover.Builder((View)this.batteryHighVoltageHint).content(this.supportHighVoltageHint ? R.string.uxsdk_hms_carepage_maintenance_highvoltage_info : R.string.uxsdk_hms_carepage_maintenance_highvoltage_need_upgrade_info).textColor(R.color.uxsdk_white).showArrow(true).arrowColor(color2).size(this.getResources().getDimensionPixelSize(R.dimen.uxsdk_240_dp), -2).allScreenMargin(this.getResources().getDimensionPixelSize(R.dimen.uxsdk_8_dp)).backgroundColor(color2).position(pos).focusable(false).align(Popover.Align.CENTER).build().show();
        });
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getBatteryException().subscribe(e -> {
            this.warningRecord = e;
            this.updateStatus();
        }));
        this.addReaction(this.widgetModel.getBatteryTemperature().subscribe(temperature -> {
            this.temperatureValue = temperature.floatValue();
            this.updateTemperature();
        }));
        this.addReaction(this.widgetModel.getBatteryConnection().subscribe(this::updateConnectionState));
        this.addReaction(this.widgetModel.getBatteryIsCommunicationException().subscribe(batteryConnectionStateMsg -> {
            this.batteryConnectionState = batteryConnectionStateMsg.getState();
            this.updateStatus();
        }));
        this.addReaction(this.widgetModel.getBatteryBatteryHighVoltageStorageSec().subscribe(this::updateBatteryBatteryHighVoltageStorage));
        this.addReaction(this.widgetModel.getBatterySerialNumber().subscribe(this::updateSerialNumber));
        this.addReaction(this.widgetModel.getBatteryManufacturedDate().subscribe(date -> {
            String text = this.getContext().getString(R.string.uxsdk_setting_ui_battery_product_date) + date.getYear() + "-" + date.getMonth();
            this.productionDate.setText((CharSequence)text);
        }));
        this.addReaction(this.widgetModel.getBatteryCellVoltages().subscribe(this::updateBatteryCells));
        this.addReaction(this.widgetModel.getBatteryVoltage().subscribe(voltage -> this.batteryVoltage.setText((CharSequence)String.format(Locale.getDefault(), "%.2fV", Float.valueOf((float)voltage.intValue() / 1000.0f)))));
        this.addReaction(this.widgetModel.getBatteryChargeRemaining().subscribe(percent -> this.batteryChargeRemaining.setText((CharSequence)this.getContext().getString(R.string.uxsdk_battery_percent, new Object[]{percent}))));
        this.addReaction(this.widgetModel.getProductType().subscribe(product -> this.showHighVoltage(this.supportHighVoltage())));
        this.addReaction(this.widgetModel.getBatteryNumberOfDischarges().subscribe(number -> this.batteryCycleTime.setText((CharSequence)String.valueOf(number))));
        this.addReaction(this.widgetModel.getBatteryIndustryBatteryType().subscribe(type -> {
            this.batteryType = type;
            this.showHighVoltage(this.supportHighVoltage());
            this.updateBatteryTitle();
        }));
        this.addReaction(this.widgetModel.getBatteryOverview().subscribe(this::updateBatteryOverview));
    }

    private void showHighVoltage(boolean show) {
        int v = show ? 0 : 8;
        this.highVoltage.setVisibility(v);
    }

    private void updateBatteryOverview(List<BatteryOverviewValue> overviewValueList) {
        this.batteryCount = overviewValueList.size();
        this.updateBatteryTitle();
    }

    private void updateConnectionState(boolean connection) {
        if (this.isConnected == connection) {
            return;
        }
        this.isConnected = connection;
        if (!connection) {
            this.widgetModel.reset();
            this.supportHighVoltageHint = false;
            this.batteryHighVoltageSave.setText(R.string.uxsdk_not_a_num);
            this.batteryHighVoltageSave.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_white));
        }
    }

    private void updateSerialNumber(String serial) {
        String text = this.getContext().getString(R.string.uxsdk_setting_ui_battery_serial_number);
        if (serial != null) {
            text = text + serial;
        }
        this.serialNumber.setText((CharSequence)text);
    }

    private void updateBatteryBatteryHighVoltageStorage(long result) {
        if (result > 0L) {
            long sec = result;
            long days = (sec + 43200L) / 86400L;
            int colorRes = days >= 120L ? R.color.uxsdk_tips_danger_in_dark : (days >= 60L ? R.color.uxsdk_warning_state_color : R.color.uxsdk_white);
            this.supportHighVoltageHint = true;
            this.batteryHighVoltageSave.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
            this.batteryHighVoltageSave.setText((CharSequence)String.format(this.getResources().getString(R.string.uxsdk_setting_ui_battery_discharge_day), days));
        } else {
            this.supportHighVoltageHint = false;
            this.batteryHighVoltageSave.setText(R.string.uxsdk_not_a_num);
            this.batteryHighVoltageSave.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_white));
        }
    }

    private void updateStatus() {
        String text = this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_normal_status);
        int textColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_setting_ui_battery_green);
        if (this.batteryConnectionState != null && this.batteryConnectionState != BatteryConnectionState.NORMAL) {
            text = this.batteryConnectionState == BatteryConnectionState.INVALID ? this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_invalid_status) : this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_exception_status);
            textColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_setting_ui_battery_red);
        } else {
            String warning = this.getWarning();
            if (!TextUtils.isEmpty((CharSequence)warning)) {
                text = warning;
                textColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_setting_ui_battery_red);
            }
        }
        this.batteryStatus.setText((CharSequence)text);
        this.batteryStatus.setTextColor(textColor);
    }

    private String getWarning() {
        if (this.warningRecord == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.warningRecord.getFirstLevelOverCurrent().booleanValue() || this.warningRecord.getSecondLevelOverCurrent().booleanValue()) {
            this.appendWarningContent(sb, this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_firstlevel_current));
        }
        if (this.warningRecord.getFirstLevelOverHeating().booleanValue() || this.warningRecord.getSecondLevelOverHeating().booleanValue()) {
            this.appendWarningContent(sb, this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_firstlevel_over_temperature));
        }
        if (this.warningRecord.getFirstLevelLowTemperature().booleanValue() || this.warningRecord.getSecondLevelLowTemperature().booleanValue()) {
            sb.append(this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_firstlevel_low_temperature));
        }
        if (Boolean.TRUE.equals(this.warningRecord.getShortCircuited())) {
            this.appendWarningContent(sb, this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_short_circuit));
        }
        if (this.warningRecord.getLowVoltageCellIndex() > 0) {
            this.appendWarningContent(sb, this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_under_voltage));
        }
        if (this.warningRecord.getBrokenCellIndex() > 0) {
            this.appendWarningContent(sb, this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_invalid));
        }
        if (this.warningRecord.getSelfCheckState() != BatterySelfCheckState.NORMAL && this.warningRecord.getSelfCheckState() != BatterySelfCheckState.UNKNOWN) {
            this.appendWarningContent(sb, this.getContext().getString(R.string.uxsdk_setting_ui_battery_history_discharge));
        }
        return sb.toString();
    }

    private void appendWarningContent(StringBuilder builder, String content) {
        if (builder.length() > 0) {
            builder.append(SEPARATOR);
        }
        builder.append(content);
    }

    private void updateBatteryTitle() {
        if (this.batteryType == null || this.batteryCount <= 0) {
            return;
        }
        int batteryIndex = this.widgetModel.getBatteryIndex();
        this.battery.setText((CharSequence)String.format(Locale.getDefault(), "%s%s", switch (this.batteryCount) {
            case 1 -> this.getResources().getString(R.string.uxsdk_setting_ui_general_battery);
            case 2 -> {
                if (batteryIndex == 0) {
                    yield this.getResources().getString(R.string.uxsdk_fpv_top_bar_battery_left_battery);
                }
                yield this.getResources().getString(R.string.uxsdk_fpv_top_bar_battery_right_battery);
            }
            default -> this.getResources().getString(R.string.uxsdk_setting_ui_general_battery) + " " + (batteryIndex + 1);
        }, switch (this.batteryType) {
            case IndustryBatteryType.TB60 -> "\uff08TB60\uff09";
            case IndustryBatteryType.TB65 -> "\uff08TB65\uff09";
            default -> "";
        }));
    }

    private void updateTemperature() {
        float value;
        String unit;
        if (0 == this.temperatureType) {
            unit = this.getResources().getString(R.string.uxsdk_fahrenheit);
            value = UnitUtils.celsiusToFahrenheit((float)this.temperatureValue);
        } else if (2 == this.temperatureType) {
            unit = this.getResources().getString(R.string.uxsdk_kelvins);
            value = UnitUtils.celsiusToKelvin((float)this.temperatureValue);
        } else {
            value = this.temperatureValue;
            unit = this.getResources().getString(R.string.uxsdk_celsius);
        }
        this.batteryTemperature.setText((CharSequence)String.format(Locale.getDefault(), "%.1f%s", Float.valueOf(value), unit));
    }

    private void updateBatteryCells(List<Integer> cellVoltages) {
        BatteryCellView cellView;
        int i;
        if (cellVoltages == null || cellVoltages.isEmpty()) {
            this.cellsLayout.removeAllViews();
            return;
        }
        int cellNumber = cellVoltages.size();
        int childCount = this.cellsLayout.getChildCount();
        if (childCount < cellNumber) {
            for (i = childCount; i <= cellNumber; ++i) {
                cellView = new BatteryCellView(this.getContext());
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
                params.weight = 1.0f;
                this.cellsLayout.addView((View)cellView, (ViewGroup.LayoutParams)params);
            }
        }
        for (i = 0; i < this.cellsLayout.getChildCount(); ++i) {
            cellView = (BatteryCellView)this.cellsLayout.getChildAt(i);
            if (i >= cellNumber) {
                cellView.setVisibility(8);
                continue;
            }
            cellView.setVisibility(0);
            cellView.setVoltage(1.0f * (float)cellVoltages.get(i).intValue() / 1000.0f);
        }
    }

    public void setEnableBatteryCells(boolean isEnable) {
        this.cellsLayout.setVisibility(isEnable ? 0 : 8);
    }

    public void setEnableSerialNumber(boolean isEnable) {
        this.batteryBottomLayout.setVisibility(isEnable ? 0 : 8);
    }

    private boolean supportHighVoltage() {
        return ProductUtil.isM30Product() || this.batteryType == IndustryBatteryType.TB65;
    }

    public void setBatteryIndex(int index) {
        this.widgetModel.setBatteryIndex(index);
    }

    public void setTemperatureType(@Temperature int temperatureType) {
        this.temperatureType = temperatureType;
        this.updateTemperature();
    }

    public static @interface Temperature {
        public static final int TEMPERATURE_FAHRENHEIT = 0;
        public static final int TEMPERATURE_CELSIUS = 1;
        public static final int TEMPERATURE_KELVIN = 2;
    }
}

